/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph;

import edu.cmu.cs.stage3.alice.scenegraph.Element;
import edu.cmu.cs.stage3.alice.scenegraph.event.BoundEvent;
import edu.cmu.cs.stage3.alice.scenegraph.event.BoundListener;
import edu.cmu.cs.stage3.math.Box;
import edu.cmu.cs.stage3.math.Sphere;
import java.util.Enumeration;
import java.util.Vector;
import javax.vecmath.Matrix4d;

public abstract class Geometry
extends Element {
    protected Box m_boundingBox = null;
    protected Sphere m_boundingSphere = null;
    private Vector m_boundListeners = new Vector();

    public abstract void transform(Matrix4d var1);

    protected abstract void updateBoundingBox();

    protected abstract void updateBoundingSphere();

    public Box getBoundingBox() {
        if (this.m_boundingBox == null) {
            this.updateBoundingBox();
        }
        if (this.m_boundingBox != null) {
            return (Box)this.m_boundingBox.clone();
        }
        return null;
    }

    public Sphere getBoundingSphere() {
        if (this.m_boundingSphere == null) {
            this.updateBoundingSphere();
        }
        if (this.m_boundingSphere != null) {
            return (Sphere)this.m_boundingSphere.clone();
        }
        return null;
    }

    public void addBoundListener(BoundListener boundListener) {
        this.m_boundListeners.addElement(boundListener);
    }

    public void removeBoundListener(BoundListener boundListener) {
        this.m_boundListeners.removeElement(boundListener);
    }

    public BoundListener[] getBoundListeners() {
        Object[] array = new BoundListener[this.m_boundListeners.size()];
        this.m_boundListeners.copyInto(array);
        return array;
    }

    private void onBoundsChange(BoundEvent boundEvent) {
        Enumeration enumeration = this.m_boundListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((BoundListener)enumeration.nextElement()).boundChanged(boundEvent);
        }
    }

    protected void onBoundsChange() {
        this.m_boundingBox = null;
        this.m_boundingSphere = null;
        this.onBoundsChange(new BoundEvent(this));
    }
}

