/*
 * Decompiled with CFR 0.152.
 */
package pattern;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import pattern.DrawPanel;
import pattern.Graphics2;
import pattern.StrokeAnalyzer;
import pattern.Util;
import teddy.Vector2;
import teddy.Vertex2D;
import timer.Timer;
import timer.TimerCaller;

public class TapeDrawing
implements TimerCaller {
    public List stroke = new ArrayList();
    public List corners = new ArrayList();
    public Vertex2D last_point;
    public Vertex2D goal_point;
    public Vertex2D first_point;
    public static final int UNIT_LENGTH = 10;
    public static final int RADIUS = 8;
    public static final double SHARP_COS = 0.8;
    public static final int START_RADIUS = 20;
    DrawPanel drawPanel;
    Timer timer;
    boolean moved;
    int extended;
    Point pressPoint;

    TapeDrawing(DrawPanel dp) {
        this.drawPanel = dp;
    }

    public void paint(Graphics g) {
        g.setColor(Color.red);
        this.paintStroke(this.stroke, g);
        if (this.last_point == null || this.goal_point == null) {
            return;
        }
        int r = 8;
        g.drawOval((int)this.last_point.x - r, (int)this.last_point.y - r, 2 * r, 2 * r);
        g.drawOval((int)this.first_point.x - 20, (int)this.first_point.y - 20, 40, 40);
        g.setColor(Color.green);
        Graphics2.drawWideLine(g, this.last_point.x, this.last_point.y, this.goal_point.x, this.goal_point.y, 3.0);
    }

    public void paintStroke(List stroke, Graphics g) {
        int i = 0;
        while (i < stroke.size() - 1) {
            Vertex2D p = (Vertex2D)stroke.get(i);
            Vertex2D q = (Vertex2D)stroke.get(i + 1);
            g.drawLine((int)p.x, (int)p.y, (int)q.x, (int)q.y);
            Graphics2.drawWideLine(g, p.x, p.y, q.x, q.y, 3.0);
            ++i;
        }
    }

    public List get_strokes() {
        ArrayList strokes = new ArrayList();
        if (this.stroke.size() < 3) {
            return strokes;
        }
        ArrayList<Vertex2D> points = new ArrayList<Vertex2D>();
        int n = 0;
        Vertex2D v = (Vertex2D)this.stroke.get(n++);
        int i = 1;
        while (i < this.corners.size()) {
            points = new ArrayList();
            points.add(v);
            Vertex2D next_corner = (Vertex2D)this.corners.get(i);
            do {
                v = (Vertex2D)this.stroke.get(n++);
                points.add(v);
            } while (v != next_corner);
            strokes.add(points);
            ++i;
        }
        return strokes;
    }

    public void adjust_loop_direction() {
        if (StrokeAnalyzer.calculate_area(this.stroke) > 0.0) {
            return;
        }
        this.stroke = Util.reverse(this.stroke);
        this.corners = Util.reverse(this.corners);
    }

    public void start(Point p) {
        this.last_point = this.drawPanel.snap_vertex != null ? this.drawPanel.snap_vertex : new Vertex2D(p);
        this.stroke.add(this.last_point);
        this.corners.add(this.last_point);
        this.first_point = this.last_point;
        this.goal_point = new Vertex2D(p);
        this.timer = new Timer((TimerCaller)this, 200);
        this.timer.turn_on();
        this.moved = false;
    }

    public void finish() {
        if (this.timer != null) {
            this.timer.turn_off();
        }
        this.stroke = new ArrayList();
        this.corners = new ArrayList();
        this.last_point = null;
        this.goal_point = null;
        this.first_point = null;
    }

    public void extend() {
        Vertex2D v2;
        Vector2 vec1;
        Vertex2D v1;
        Vertex2D v0;
        Vector2 vec0;
        if (Vertex2D.distance((Vertex2D)this.last_point, (Vertex2D)this.goal_point) < 10.0) {
            return;
        }
        ++this.extended;
        Vector2 vector = new Vector2((Vector2)this.last_point, (Vector2)this.goal_point);
        double length = vector.length();
        vector.normalize();
        vector.multiply(length / 5.0);
        this.last_point = Vertex2D.translate((Vertex2D)this.last_point, (Vector2)vector);
        this.stroke.add(this.last_point);
        if (this.stroke.size() > 4 && Vector2.cos((Vector2)(vec0 = new Vector2((Vector2)(v0 = (Vertex2D)this.stroke.get(this.stroke.size() - 3)), (Vector2)(v1 = (Vertex2D)this.stroke.get(this.stroke.size() - 2)))), (Vector2)(vec1 = new Vector2((Vector2)v1, (Vector2)(v2 = (Vertex2D)this.stroke.get(this.stroke.size() - 1))))) < 0.8 && this.corners.get(this.corners.size() - 1) != v1) {
            this.corners.add(v1);
        }
    }

    public void tick() {
        this.extend();
        this.drawPanel.repaint();
    }

    public void mousePressed(Point p) {
        this.extended = 0;
        this.timer.turn_off();
        this.timer = new Timer((TimerCaller)this, 200);
        this.timer.turn_on();
        this.pressPoint = p;
    }

    public boolean mouseReleased(Point p) {
        this.timer.turn_off();
        if (this.pressPoint == null || p == null) {
            return false;
        }
        if (Vertex2D.distance((Point)this.pressPoint, (Point)p) < 10.0) {
            return this.mouseClicked(p);
        }
        return false;
    }

    public void mouseMoved(Point p) {
        if (Vertex2D.distance((Vertex2D)this.last_point, (Point)p) > 8.0) {
            this.moved = true;
        }
        this.goal_point = new Vertex2D(p);
        this.drawPanel.repaint();
    }

    public boolean mouseClicked(Point p) {
        Vertex2D v2;
        Vector2 vec1;
        Vertex2D v1;
        Vertex2D v0;
        Vector2 vec0;
        if (this.moved && Vertex2D.distance((Vertex2D)this.last_point, (Point)p) < 8.0) {
            if (this.corners.get(this.corners.size() - 1) != this.last_point) {
                this.corners.add(this.last_point);
            }
            return true;
        }
        if (this.extended > 1) {
            return false;
        }
        if (!this.moved) {
            this.moved = true;
            return false;
        }
        this.goal_point = this.drawPanel.snap_vertex != null ? this.drawPanel.snap_vertex : new Vertex2D(p);
        if (this.corners.get(this.corners.size() - 1) != this.last_point && this.stroke.size() > 3 && Vector2.cos((Vector2)(vec0 = new Vector2((Vector2)(v0 = (Vertex2D)this.stroke.get(this.stroke.size() - 2)), (Vector2)(v1 = this.last_point))), (Vector2)(vec1 = new Vector2((Vector2)v1, (Vector2)(v2 = this.goal_point)))) < 0.8) {
            this.corners.add(v1);
        }
        double length = Vertex2D.distance((Vertex2D)this.last_point, (Vertex2D)this.goal_point);
        int n = (int)(length / 10.0 + 0.5);
        int i = 1;
        while (i < n) {
            this.stroke.add(Vertex2D.interporate((Vertex2D)this.last_point, (Vertex2D)this.goal_point, (double)(1.0 * (double)i / (double)n)));
            ++i;
        }
        this.last_point = this.goal_point;
        this.stroke.add(this.last_point);
        if (Vertex2D.distance((Vertex2D)this.first_point, (Vertex2D)this.last_point) < 20.0) {
            if (this.corners.get(this.corners.size() - 1) != this.last_point) {
                this.corners.add(this.last_point);
            }
            return true;
        }
        return false;
    }
}

