/*
 * Decompiled with CFR 0.152.
 */
package pattern;

import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import teddy.Vector2;
import teddy.Vertex2D;

public class StrokeAnalyzer {
    public static List get_shifted(List stroke, double d) {
        ArrayList<Vertex2D> shifted = new ArrayList<Vertex2D>();
        int i = 0;
        while (i < stroke.size()) {
            Vertex2D v = (Vertex2D)stroke.get(i);
            Vector2 vec = null;
            if (i == 0) {
                vec = new Vector2((Vector2)v, (Vector2)((Vertex2D)stroke.get(i + 1)));
                vec.normalize();
            } else if (i == stroke.size() - 1) {
                vec = new Vector2((Vector2)((Vertex2D)stroke.get(i - 1)), (Vector2)v);
                vec.normalize();
            } else {
                Vector2 vec0 = new Vector2((Vector2)((Vertex2D)stroke.get(i - 1)), (Vector2)v);
                Vector2 vec1 = new Vector2((Vector2)v, (Vector2)((Vertex2D)stroke.get(i + 1)));
                vec0.normalize();
                vec1.normalize();
                vec = Vector2.add((Vector2)vec0, (Vector2)vec1);
                vec.normalize();
                double cos = Vector2.dot_product((Vector2)vec, (Vector2)vec0);
                vec.multiply(1.0 / cos);
            }
            vec = Vector2.rotate90((Vector2)vec);
            vec.multiply(d);
            shifted.add(Vertex2D.translate((Vertex2D)v, (Vector2)vec));
            ++i;
        }
        return shifted;
    }

    public static void paint_stroke(List points, Graphics g) {
        int i = 0;
        while (i < points.size() - 1) {
            Vertex2D p = (Vertex2D)points.get(i);
            Vertex2D q = (Vertex2D)points.get(i + 1);
            g.drawLine((int)p.x, (int)p.y, (int)q.x, (int)q.y);
            ++i;
        }
    }

    public static void paint_stroke_dotted(Vector points, Graphics g) {
        int i = 0;
        while (i < points.size() - 1) {
            Vertex2D p = (Vertex2D)points.elementAt(i);
            Vertex2D q = (Vertex2D)points.elementAt(i + 1);
            q = Vertex2D.interporate((Vertex2D)p, (Vertex2D)q, (double)0.6);
            g.drawLine((int)p.x, (int)p.y, (int)q.x, (int)q.y);
            ++i;
        }
    }

    public static double distance(List stroke, Vertex2D p) {
        double min = -1.0;
        int i = 0;
        while (i < stroke.size()) {
            Vertex2D v = (Vertex2D)stroke.get(i);
            double d = Vertex2D.distance((Vertex2D)v, (Vertex2D)p);
            if (min == -1.0 || min > d) {
                min = d;
            }
            ++i;
        }
        return min;
    }

    public static double calculate_area(List stroke) {
        Vertex2D p = (Vertex2D)stroke.get(stroke.size() - 1);
        double area = 0.0;
        int i = 0;
        while (i < stroke.size()) {
            Vertex2D q = (Vertex2D)stroke.get(i);
            area += Vector2.cross_product((Vector2)p, (Vector2)q);
            p = q;
            ++i;
        }
        return area;
    }

    public static List resample(List stroke, int UNIT_LENGTH) {
        if (stroke.size() <= 2) {
            return stroke;
        }
        double length = StrokeAnalyzer.get_length(stroke);
        int n = (int)(length / (double)UNIT_LENGTH + 0.5);
        return StrokeAnalyzer.resample_main(stroke, n, length);
    }

    public static List resample_by_number(List stroke, int n) {
        double length = StrokeAnalyzer.get_length(stroke);
        return StrokeAnalyzer.resample_main(stroke, n, length);
    }

    public static List resample_main(List stroke, int n, double length) {
        double unit = length / (double)n;
        Vertex2D v0 = (Vertex2D)stroke.get(0);
        Vertex2D v1 = (Vertex2D)stroke.get(stroke.size() - 1);
        ArrayList<Vertex2D> resampled = new ArrayList<Vertex2D>();
        resampled.add(v0);
        double total = 0.0;
        double prev_total = 0.0;
        Vertex2D prev = v0;
        double next_spot = unit;
        int index = 1;
        int count = 0;
        while (count != n - 1) {
            Vertex2D next = (Vertex2D)stroke.get(index);
            total += Vertex2D.distance((Vertex2D)prev, (Vertex2D)next);
            while (total >= next_spot) {
                Vertex2D new_vertex = Vertex2D.interporate((Vertex2D)prev, (Vertex2D)next, (double)((next_spot - prev_total) / (total - prev_total)));
                resampled.add(new_vertex);
                next_spot += unit;
                if (++count == n - 1) break;
            }
            prev = next;
            prev_total = total;
            ++index;
        }
        resampled.add(v1);
        return resampled;
    }

    public static double get_length(List stroke) {
        double length = 0.0;
        int i = 0;
        while (i < stroke.size() - 1) {
            Vertex2D p = (Vertex2D)stroke.get(i);
            Vertex2D q = (Vertex2D)stroke.get(i + 1);
            length += Vertex2D.distance((Vertex2D)p, (Vertex2D)q);
            ++i;
        }
        return length;
    }

    public static List duplicate_stroke(List stroke) {
        ArrayList<Vertex2D> new_stroke = new ArrayList<Vertex2D>();
        int i = 0;
        while (i < stroke.size()) {
            Vertex2D p = (Vertex2D)stroke.get(i);
            new_stroke.add(new Vertex2D((Vector2)p));
            ++i;
        }
        return new_stroke;
    }
}

