/*
 * Decompiled with CFR 0.152.
 */
package pattern;

import java.util.List;
import pattern.Util;
import teddy.Vector2;
import teddy.Vertex2D;

public class Smoother {
    private List stroke;
    private int prev_index;
    private int prev_direction = 1;
    private int min_index;
    private int max_index;
    private int range;

    Smoother() {
    }

    public Smoother(Vertex2D p, List _stroke) {
        this.stroke = _stroke;
        this.min_index = this.max_index = (this.prev_index = Smoother.find_closest_vertex(p, this.stroke));
    }

    public void smooth(Vertex2D p) {
        int next_index = this.find_closest_vertex(p, this.stroke, this.prev_index);
        if (this.prev_index == next_index) {
            return;
        }
        this.min_index = Math.min(this.min_index, next_index);
        this.max_index = Math.max(this.max_index, next_index);
        this.range = Math.max(2, (this.max_index - this.min_index) / 2);
        if (next_index > this.prev_index) {
            if (this.prev_direction == 1) {
                Smoother.smooth_vertex(this.prev_index, this.stroke, this.range);
            }
            int i = this.prev_index + 1;
            while (i < next_index) {
                Smoother.smooth_vertex(i, this.stroke, this.range);
                ++i;
            }
            this.prev_direction = 1;
        } else {
            if (this.prev_direction == -1) {
                Smoother.smooth_vertex(this.prev_index, this.stroke, this.range);
            }
            int i = this.prev_index - 1;
            while (i > next_index) {
                Smoother.smooth_vertex(i, this.stroke, this.range);
                --i;
            }
            this.prev_direction = -1;
        }
        this.prev_index = next_index;
    }

    public static void smooth_vertex(int i, List stroke, int range) {
        Vertex2D v;
        if (i < 1 || i > stroke.size() - 2) {
            return;
        }
        Vertex2D target = Smoother.find_target_position(i = Util.mod(i, stroke.size()), stroke, range);
        if (Vertex2D.distance((Vertex2D)target, (Vertex2D)(v = (Vertex2D)stroke.get(i))) > 2.0) {
            Vector2 vec = new Vector2((Vector2)v, (Vector2)target);
            vec.normalize();
            vec.multiply(2.0);
            target = Vertex2D.translate((Vertex2D)v, (Vector2)vec);
        }
        v.warp(target);
    }

    public static int find_closest_vertex(Vertex2D v, List stroke) {
        int closest = -1;
        double min = Double.MAX_VALUE;
        int i = 0;
        while (i < stroke.size()) {
            Vertex2D u = (Vertex2D)stroke.get(i);
            double d = Vertex2D.distance((Vertex2D)u, (Vertex2D)v);
            if (d < min) {
                min = d;
                closest = i;
            }
            ++i;
        }
        return closest;
    }

    public int find_closest_vertex(Vertex2D p, List stroke, int index) {
        double d_current = Double.MAX_VALUE;
        double d_prev = Double.MAX_VALUE;
        double d_next = Double.MAX_VALUE;
        int prev_index = index - 1;
        int next_index = index + 1;
        d_current = Vertex2D.distance((Vertex2D)p, (Vertex2D)((Vertex2D)stroke.get(index)));
        if (index > 0) {
            d_prev = Vertex2D.distance((Vertex2D)p, (Vertex2D)((Vertex2D)stroke.get(prev_index)));
        }
        if (index < stroke.size() - 1) {
            d_next = Vertex2D.distance((Vertex2D)p, (Vertex2D)((Vertex2D)stroke.get(next_index)));
        }
        if (d_current <= d_prev && d_current <= d_next) {
            return index;
        }
        if (d_prev <= d_current && d_prev <= d_next) {
            return this.find_closest_vertex(p, stroke, prev_index);
        }
        return this.find_closest_vertex(p, stroke, next_index);
    }

    public static Vertex2D find_target_position(int index, List stroke, int range) {
        int prev_index = index - 1;
        int next_index = index + 1;
        Vertex2D v = (Vertex2D)stroke.get(index);
        Vertex2D p = (Vertex2D)stroke.get(prev_index);
        Vertex2D q = (Vertex2D)stroke.get(next_index);
        Vector2 p_to_q = new Vector2((Vector2)p, (Vector2)q);
        double w = 0.5 * p_to_q.length();
        Vertex2D mid_vertex = Vertex2D.mid_vertex((Vertex2D)p, (Vertex2D)q);
        Vector2 normal = Vector2.rotate90((Vector2)p_to_q);
        normal.normalize();
        double min_x = -w;
        double max_x = w;
        double x = Vector2.cross_product((Vector2)new Vector2((Vector2)mid_vertex, (Vector2)v), (Vector2)normal);
        int i = 0;
        while (i < 10) {
            Vertex2D new_v = Vertex2D.translate((Vertex2D)mid_vertex, (Vector2)Vector2.multiply((Vector2)normal, (double)x));
            boolean too_large = Smoother.x_is_too_large(new_v, index, stroke, range);
            if (too_large) {
                max_x = x;
            } else {
                min_x = x;
            }
            x = 0.5 * (min_x + max_x);
            ++i;
        }
        return new Vertex2D((Vector2)Vertex2D.translate((Vertex2D)mid_vertex, (Vector2)Vector2.multiply((Vector2)normal, (double)x)));
    }

    public static boolean x_is_too_large(Vertex2D v, int i, List stroke, int range) {
        double angle_at_v = Smoother.get_angle_at(stroke, i, v);
        double average_angle = 0.0;
        int count = 0;
        int j = i - range;
        while (j <= i + range) {
            if (j != i && j >= 1 && j <= stroke.size() - 2) {
                average_angle += Smoother.get_angle_at(stroke, j);
                ++count;
            }
            ++j;
        }
        return angle_at_v > (average_angle /= (double)count);
    }

    public static double get_angle_at(List stroke, int index) {
        return Smoother.get_angle_at(stroke, index, (Vertex2D)stroke.get(index));
    }

    public static double get_angle_at(List stroke, int index, Vertex2D current) {
        index = Util.mod(index, stroke.size());
        int prev_index = index - 1;
        int next_index = index + 1;
        if (index == 0) {
            prev_index = stroke.size() - 2;
        }
        if (index == stroke.size() - 1) {
            next_index = 1;
        }
        Vertex2D prev = (Vertex2D)stroke.get(prev_index);
        Vertex2D next = (Vertex2D)stroke.get(next_index);
        return Vector2.sin((Vector2)new Vector2((Vector2)prev, (Vector2)current), (Vector2)new Vector2((Vector2)current, (Vector2)next));
    }
}

