/*
 * Decompiled with CFR 0.152.
 */
package pattern;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import pattern.Connector;
import pattern.DrawPanel;
import pattern.Graphics2;
import pattern.Piece;
import pattern.StrokeAnalyzer;
import teddy.Util;
import teddy.Vector2;
import teddy.Vertex2D;

public class Seam {
    public static final int UNIT_LENGTH = 10;
    public static final int LINE_WIDTH = 3;
    private Connector connector;
    private Piece piece;
    private List points;
    private int sewIndex = 0;
    private List stroke;
    private List stitchPoints = new ArrayList();
    Vertex2D start;
    Vertex2D end;

    public Seam() {
    }

    public Seam(List _stroke) {
        this.stroke = _stroke;
        this.start = (Vertex2D)this.stroke.get(0);
        this.end = (Vertex2D)this.stroke.get(this.stroke.size() - 1);
        Vector2 x_vector = new Vector2((Vector2)this.start, (Vector2)this.end);
        Vector2 y_vector = new Vector2(-x_vector.y, x_vector.x);
        this.set_points();
    }

    public void set_points() {
        Vector2 x_vector = new Vector2((Vector2)this.start, (Vector2)this.end);
        Vector2 y_vector = new Vector2(-x_vector.y, x_vector.x);
        this.points = new ArrayList();
        int i = 1;
        while (i < this.stroke.size() - 1) {
            Vertex2D v = (Vertex2D)this.stroke.get(i);
            Vertex2D u = this.get_relative_coords(v, this.start, x_vector, y_vector);
            this.points.add(u);
            ++i;
        }
    }

    public static List counter_clockwise(List points) {
        double total_area = 0.0;
        Vertex2D prev = (Vertex2D)points.get(points.size() - 1);
        int i = 0;
        while (i < points.size()) {
            Vertex2D next = (Vertex2D)points.get(i);
            total_area += (prev.y + next.y) * (next.x - prev.x);
            prev = next;
            ++i;
        }
        if (total_area < 0.0) {
            return Util.reverse((List)points);
        }
        return points;
    }

    public void translate_vertex(Vertex2D target_vertex, Vector2 move_vec) {
        int i = 0;
        while (i < this.stroke.size()) {
            Vertex2D v = (Vertex2D)this.stroke.get(i);
            if (v.same(target_vertex)) {
                v.add(move_vec);
            }
            ++i;
        }
        this.set_points();
    }

    public void warp_vertex(Vertex2D target_vertex, Vertex2D position) {
        int i = 0;
        while (i < this.stroke.size()) {
            Vertex2D v = (Vertex2D)this.stroke.get(i);
            if (v.same(target_vertex)) {
                v.warp(position);
            }
            ++i;
        }
        this.set_points();
    }

    public void warp_vertex(int target_vertex_index, Vertex2D position) {
        Vertex2D v = (Vertex2D)this.stroke.get(target_vertex_index);
        v.warp(position);
        this.set_points();
    }

    public void move_vertex(Vertex2D target_vertex, Vector2 vec) {
        int i = 0;
        while (i < this.stroke.size()) {
            Vertex2D v = (Vertex2D)this.stroke.get(i);
            if (v.same(target_vertex)) {
                Vertex2D position = new Vertex2D(target_vertex.x + vec.x, target_vertex.y + vec.y);
                v.warp(position);
            }
            ++i;
        }
        this.set_points();
    }

    public Vertex2D get_relative_coords(Vertex2D u, Vertex2D base, Vector2 x_vector, Vector2 y_vector) {
        Vector2 vec = new Vector2((Vector2)base, (Vector2)u);
        double x = Vector2.dot_product((Vector2)vec, (Vector2)x_vector) / Vector2.dot_product((Vector2)x_vector, (Vector2)x_vector);
        double y = Vector2.dot_product((Vector2)vec, (Vector2)y_vector) / Vector2.dot_product((Vector2)y_vector, (Vector2)y_vector);
        return new Vertex2D(x, y);
    }

    public Vertex2D get_absolute_coords(Vertex2D u, Vertex2D base, Vector2 x_vector, Vector2 y_vector) {
        return Vertex2D.translate((Vertex2D)base, (Vector2)Vector2.add((Vector2)Vector2.multiply((Vector2)x_vector, (double)u.x), (Vector2)Vector2.multiply((Vector2)y_vector, (double)u.y)));
    }

    public void paint(Graphics g) {
        this.paint_body(g);
        int r = 5;
        g.fillOval((int)this.start.x - r, (int)this.start.y - r, 2 * r, 2 * r);
        g.fillOval((int)this.end.x - r, (int)this.end.y - r, 2 * r, 2 * r);
        if (this.connector != null) {
            Color color = g.getColor();
            DrawPanel panel = DrawPanel.getInstance();
            if (panel.isConnectorPaintMode()) {
                this.connector.paint(g);
            }
            g.setColor(color);
        }
        if (DrawPanel.getInstance().isStitchRendering()) {
            this.paint_stitchPoints(g);
        }
    }

    void paint_stitchPoints(Graphics g) {
        Color prev_color = g.getColor();
        g.setColor(Color.lightGray);
        int i = 0;
        while (i < this.stitchPoints.size()) {
            Vertex2D v = (Vertex2D)this.stitchPoints.get(i);
            g.fillOval((int)v.x - 2, (int)v.y - 2, 4, 4);
            ++i;
        }
        g.setColor(prev_color);
    }

    public void paint_body(Graphics g) {
        Graphics2.paint_wide_stroke(g, this.stroke, 3.0);
    }

    public void paint_normal(Graphics g) {
        g.setColor(Color.lightGray);
        int i = 0;
        while (i < this.stroke.size()) {
            Vertex2D v = (Vertex2D)this.stroke.get(i);
            Vector2 normal = v.get_normal();
            Graphics2.drawLine(g, (int)v.x, (int)v.y, (int)(v.x + 10.0 * normal.x), (int)(v.y + 10.0 * normal.y));
            ++i;
        }
    }

    public void set_stroke() {
        Vector2 x_vector = new Vector2((Vector2)this.start, (Vector2)this.end);
        Vector2 y_vector = new Vector2(-x_vector.y, x_vector.x);
        this.stroke = new ArrayList();
        this.stroke.add(this.start);
        int i = 0;
        while (i < this.points.size()) {
            Vertex2D u = (Vertex2D)this.points.get(i);
            Vertex2D v = this.get_absolute_coords(u, this.start, x_vector, y_vector);
            this.stroke.add(v);
            ++i;
        }
        this.stroke.add(this.end);
    }

    public int getStitchSize() {
        return this.stitchPoints.size();
    }

    public Seam copy() {
        ArrayList<Vertex2D> clone_stroke = new ArrayList<Vertex2D>(this.stroke.size());
        int i = 0;
        while (i < this.stroke.size()) {
            Vertex2D v = (Vertex2D)this.stroke.get(i);
            clone_stroke.add(v.copy());
            ++i;
        }
        Seam clone = new Seam(clone_stroke);
        return clone;
    }

    public Vertex2D find_closest_Vertex(Point p) {
        Vertex2D find_vertex = null;
        double min = Double.MAX_VALUE;
        int i = 0;
        while (i < this.stroke.size()) {
            Vertex2D vertex2D = (Vertex2D)this.stroke.get(i);
            double distance = vertex2D.distance(new Vertex2D((double)p.x, (double)p.y));
            if (min > distance) {
                min = distance;
                find_vertex = vertex2D;
            }
            ++i;
        }
        return find_vertex;
    }

    public double distance(Point p) {
        return StrokeAnalyzer.distance(this.stroke, new Vertex2D(p));
    }

    public void adjust_length() {
        double current_length = this.get_length();
        double target_length = this.connector.get_opposite_seam(this).get_length();
        Vector2 vector = new Vector2((Vector2)this.start, (Vector2)this.end);
        vector.multiply((target_length / current_length - 1.0) / 2.0);
        this.end.add(vector);
        this.start.subtract(vector);
    }

    public double get_length() {
        if (this.stroke == null) {
            return -1.0;
        }
        double l = 0.0;
        int i = 0;
        while (i < this.stroke.size() - 1) {
            Vertex2D p = (Vertex2D)this.stroke.get(i);
            Vertex2D q = (Vertex2D)this.stroke.get(i + 1);
            l += Vertex2D.distance((Vertex2D)p, (Vertex2D)q);
            ++i;
        }
        return l;
    }

    public Vertex2D get_mid_point() {
        if (this.stroke == null) {
            return this.start;
        }
        if (Util.mod((int)this.stroke.size(), (int)2) == 1) {
            return (Vertex2D)this.stroke.get(this.stroke.size() / 2);
        }
        Vertex2D v0 = (Vertex2D)this.stroke.get(this.stroke.size() / 2 - 1);
        Vertex2D v1 = (Vertex2D)this.stroke.get(this.stroke.size() / 2);
        return Vertex2D.mid_vertex((Vertex2D)v0, (Vertex2D)v1);
    }

    public Vector2 get_mid_point_normal() {
        Vertex2D p = new Vertex2D();
        Vertex2D q = new Vertex2D();
        if (this.stroke == null || this.stroke.size() <= 1) {
            p = this.start;
            q = this.end;
        } else {
            p = (Vertex2D)this.stroke.get(0);
            q = (Vertex2D)this.stroke.get(1);
        }
        Vector2 vec = new Vector2((Vector2)p, (Vector2)q);
        vec = new Vector2(vec.y, -vec.x);
        vec.normalize();
        if (this.piece != null && this.piece.reversed) {
            vec.multiply(-1.0);
        }
        return vec;
    }

    public int get_target_point_index(Vertex2D target_vertex) {
        int i = 0;
        while (i < this.stroke.size()) {
            Vertex2D v = (Vertex2D)this.stroke.get(i);
            if (v.same(target_vertex)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Vector2 get_target_point_normal(Vertex2D target_vertex) {
        int index = this.get_target_point_index(target_vertex);
        Vector2 vec = new Vector2(0.0, 0.0);
        if (index == 0) {
            Vector2 next_vec_normal;
            Vertex2D next_v = (Vertex2D)this.stroke.get(1);
            Vector2 next_vec = new Vector2((Vector2)target_vertex, (Vector2)next_v);
            vec = next_vec_normal = Vector2.rotate((Vector2)next_vec, (double)270.0);
            vec.normalize();
        } else if (index == this.stroke.size() - 1) {
            Vector2 prev_vec_normal;
            Vertex2D prev_v = (Vertex2D)this.stroke.get(this.stroke.size() - 1);
            Vector2 prev_vec = new Vector2((Vector2)target_vertex, (Vector2)prev_v);
            vec = prev_vec_normal = Vector2.rotate((Vector2)prev_vec, (double)90.0);
        } else if (index != -1) {
            Vertex2D prev_v = (Vertex2D)this.stroke.get(index - 1);
            Vertex2D next_v = (Vertex2D)this.stroke.get(index + 1);
            Vector2 prev_vec = new Vector2((Vector2)target_vertex, (Vector2)prev_v);
            Vector2 prev_vec_normal = Vector2.rotate((Vector2)prev_vec, (double)90.0);
            prev_vec_normal.normalize();
            Vector2 next_vec = new Vector2((Vector2)target_vertex, (Vector2)next_v);
            Vector2 next_vec_normal = Vector2.rotate((Vector2)next_vec, (double)270.0);
            next_vec_normal.normalize();
            vec = Vector2.add((Vector2)prev_vec_normal, (Vector2)next_vec_normal);
            vec.normalize();
        }
        return vec;
    }

    public Vertex2D get_opposite_vertex(Vertex2D v) {
        if (this.start == v) {
            return this.end;
        }
        return this.start;
    }

    public Seam get_flipped(int axis_x) {
        ArrayList<Vertex2D> new_stroke = new ArrayList<Vertex2D>();
        int i = this.stroke.size() - 1;
        while (i >= 0) {
            Vertex2D v = (Vertex2D)this.stroke.get(i);
            Vertex2D u = new Vertex2D((double)axis_x + ((double)axis_x - v.x), v.y);
            new_stroke.add(u);
            --i;
        }
        Seam seam = new Seam(new_stroke);
        return seam;
    }

    public void reverse(int axis_x) {
        this.start.x = (double)axis_x + ((double)axis_x - this.start.x);
        int i = 0;
        while (i < this.points.size()) {
            Vertex2D v = (Vertex2D)this.points.get(i);
            v.y = -v.y;
            ++i;
        }
    }

    public void reverse() {
        Vertex2D end_ = this.end;
        this.end = this.start;
        this.start = end_;
        this.points = Util.reverse((List)this.points);
        int i = 0;
        while (i < this.points.size()) {
            Vertex2D v = (Vertex2D)this.points.get(i);
            v.y = -v.y;
            v.x = 1.0 - v.x;
            ++i;
        }
        this.stroke = Util.reverse((List)this.stroke);
    }

    public Seam duplicate() {
        Seam seam = new Seam(this.stroke);
        seam.start = new Vertex2D((Vector2)this.start);
        seam.end = new Vertex2D((Vector2)this.end);
        return seam;
    }

    public void save(BufferedWriter out) throws IOException {
        out.write("seam");
        out.newLine();
        out.write(this.start.x + " " + this.start.y);
        out.newLine();
        out.write(this.end.x + " " + this.end.y);
        out.newLine();
        int i = 0;
        while (i < this.points.size()) {
            Vertex2D v = (Vertex2D)this.points.get(i);
            out.write(v.x + " " + v.y + " ");
            ++i;
        }
        out.newLine();
    }

    Seam(BufferedReader in) throws IOException {
        String line = in.readLine();
        StringTokenizer st = new StringTokenizer(line);
        double x = new Double(st.nextToken());
        double y = new Double(st.nextToken());
        this.start = new Vertex2D(x, y);
        line = in.readLine();
        st = new StringTokenizer(line);
        x = new Double(st.nextToken());
        y = new Double(st.nextToken());
        this.end = new Vertex2D(x, y);
        line = in.readLine();
        st = new StringTokenizer(line);
        this.points = new ArrayList();
        while (st.hasMoreTokens()) {
            x = new Double(st.nextToken());
            y = new Double(st.nextToken());
            this.points.add(new Vertex2D(x, y));
        }
    }

    public static boolean isConnect(Seam seam0, Seam seam1) {
        Connector connector = seam0.connector;
        return connector.getSeam0() == seam1 || connector.getSeam1() == seam1;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public Piece getPiece() {
        return this.piece;
    }

    public void setPiece(Piece piece) {
        this.piece = piece;
    }

    public List getPoints() {
        return this.points;
    }

    public void setPoints(List points) {
        this.points = points;
    }

    public int getSewIndex() {
        return this.sewIndex;
    }

    public void setSewIndex(int index) {
        this.sewIndex = index;
    }

    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    public List getStroke() {
        return this.stroke;
    }

    public void setStroke(List _stroke) {
        System.out.println("setStroke");
        this.stroke = _stroke;
        this.set_points();
    }

    public void setStitchPoints(List _stitchPoints) {
        this.stitchPoints = _stitchPoints;
    }

    public List getStitchPoints() {
        return this.stitchPoints;
    }
}

