/*
 * Decompiled with CFR 0.152.
 */
package pattern;

import java.awt.Dimension;
import java.awt.Graphics;
import pattern.DrawPanel;
import teddy.Vertex2D;

public class Ruler {
    static final int SCALE_LINE = 10;
    static final int SCALE_LINE_LONG = 15;
    static double scale = 20.0;

    static void paint(Graphics g) {
        Ruler.paint_base_line(g);
    }

    private static void paint_base_line(Graphics g) {
        Dimension dimension = DrawPanel.getInstance().getSize();
        Vertex2D start = new Vertex2D(0.0, 0.0);
        Vertex2D end = new Vertex2D(dimension.getWidth(), 0.0);
        Ruler.paint_line(g, start, end);
        int i = 0;
        while (true) {
            start = new Vertex2D(scale * (double)i, 0.0);
            if (start.x > dimension.getWidth()) break;
            end = i % 2 == 0 ? new Vertex2D(start.x, start.y + 15.0) : new Vertex2D(start.x, start.y + 10.0);
            Ruler.paint_line(g, start, end);
            ++i;
        }
        start = new Vertex2D(dimension.getWidth(), 0.0);
        end = new Vertex2D(dimension.getWidth(), dimension.getHeight());
        Ruler.paint_line(g, start, end);
        i = 0;
        while (true) {
            start = new Vertex2D(dimension.getWidth(), scale * (double)i);
            if (start.y > dimension.getHeight()) break;
            end = i % 2 == 0 ? new Vertex2D(start.x - 15.0, start.y) : new Vertex2D(start.x - 10.0, start.y);
            Ruler.paint_line(g, start, end);
            ++i;
        }
    }

    private static void paint_line(Graphics g, Vertex2D start, Vertex2D end) {
        g.drawLine((int)start.x, (int)start.y, (int)end.x, (int)end.y);
    }

    public static void adjustScale(double ratio) {
        scale *= ratio;
    }
}

