/*
 * Decompiled with CFR 0.152.
 */
package pattern;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import pattern.DrawPanel;
import pattern.Graphics2;
import pattern.Piece;
import pattern.RigidCurve;
import pattern.ScaleAdjust;
import pattern.Seam;
import sweater.Cursors;
import sweater.Model;
import sweater.Sweater;
import teddy.Edge2D;
import teddy.Inflate;
import teddy.Vector2;
import teddy.Vertex2D;

public class Pull {
    private static double SCOPE_SCALE = 2.0;
    private List stroke;
    public List locked_vertices = new ArrayList();
    private Seam pickedSeam;
    private RigidCurve rigid;
    private ScaleAdjust scaleAdjust;
    private List original_stroke = new ArrayList();
    private boolean pulling = false;
    public static List pulls = new ArrayList();
    Vector2 x_vec;
    Vector2 y_vec;
    public int index;
    private int index0;
    private int index1;
    private Vertex2D target_v;
    public Piece piece;
    private double max_pull_length;

    Pull(Vertex2D v, Seam _pickedSeam) {
        this.pickedSeam = _pickedSeam;
        this.stroke = this.pickedSeam.getStroke();
        this.index = Pull.find_closest_vertex(v, this.stroke);
        this.pulling = true;
        this.max_pull_length = -1.0;
        this.index1 = 1;
        this.index0 = 1;
        this.original_stroke = new ArrayList();
        int i = 0;
        while (i < this.stroke.size()) {
            Vertex2D vertex2D = (Vertex2D)this.stroke.get(i);
            this.original_stroke.add(vertex2D.copy());
            ++i;
        }
        this.target_v = v;
        this.piece = this.pickedSeam.getPiece();
        this.piece.pull = this;
        DrawPanel.dragged_piece = this.piece;
        pulls.add(this);
        this.x_vec = this.index == 0 ? new Vector2((Vector2)((Vertex2D)this.stroke.get(0)), (Vector2)((Vertex2D)this.stroke.get(1))) : (this.index == this.stroke.size() - 1 ? new Vector2((Vector2)((Vertex2D)this.stroke.get(this.index - 1)), (Vector2)((Vertex2D)this.stroke.get(this.index))) : new Vector2((Vector2)((Vertex2D)this.stroke.get(this.index - 1)), (Vector2)((Vertex2D)this.stroke.get(this.index + 1))));
        this.x_vec.normalize();
        this.y_vec = Vector2.rotate90((Vector2)this.x_vec);
    }

    public static Pull prepare_start_pulling(Vertex2D v, Seam _pickedSeam) {
        if (_pickedSeam == null) {
            return null;
        }
        return new Pull(v, _pickedSeam);
    }

    public static boolean start_pulling(Point p) {
        if (DrawPanel.getInstance().snap_seam == null) {
            return false;
        }
        DrawPanel.getInstance().setCursor(Cursors.pullCursor);
        return true;
    }

    public void pulling(Vector2 vec) {
        boolean scope_adjusted = this.adjust_scope(vec);
        if (Math.abs(this.index0 - this.index1) <= 2) {
            Vertex2D v0 = (Vertex2D)this.original_stroke.get(this.index);
            Vertex2D target = new Vertex2D(v0.x + vec.x, v0.y + vec.y);
            this.pickedSeam.warp_vertex(this.index, target);
            return;
        }
        if (scope_adjusted) {
            this.rigid = new RigidCurve();
            this.scaleAdjust = new ScaleAdjust();
            int i = 0;
            while (i < this.original_stroke.size()) {
                Vertex2D v0 = (Vertex2D)this.original_stroke.get(i);
                this.pickedSeam.warp_vertex(i, v0);
                ++i;
            }
            this.rigid.compile(this.stroke, this.index0, this.index, this.index1);
            this.scaleAdjust.compile(this.stroke, this.index0, this.index, this.index1);
        }
        Vertex2D v0 = (Vertex2D)this.original_stroke.get(this.index);
        Vertex2D target = new Vertex2D(v0.x + vec.x, v0.y + vec.y);
        this.pickedSeam.warp_vertex(this.index, target);
        this.rigid.update();
        this.scaleAdjust.update();
        this.piece.beautify();
        DrawPanel.getInstance().repaint();
    }

    public void pulling(Point p) {
        Vector2 vec = new Vector2((Vector2)this.target_v, (Vector2)new Vertex2D(p));
        boolean scope_adjusted = this.adjust_scope(vec);
        if (Math.abs(this.index0 - this.index1) <= 2) {
            Vertex2D v0 = (Vertex2D)this.original_stroke.get(this.index);
            Vertex2D target = new Vertex2D(v0.x + vec.x, v0.y + vec.y);
            this.pickedSeam.warp_vertex(this.index, target);
            return;
        }
        if (scope_adjusted) {
            this.rigid = new RigidCurve();
            this.scaleAdjust = new ScaleAdjust();
            int i = 0;
            while (i < this.original_stroke.size()) {
                Vertex2D v0 = (Vertex2D)this.original_stroke.get(i);
                this.pickedSeam.warp_vertex(i, v0);
                ++i;
            }
            this.rigid.compile(this.stroke, this.index0, this.index, this.index1);
            this.scaleAdjust.compile(this.stroke, this.index0, this.index, this.index1);
        }
        Vertex2D v0 = (Vertex2D)this.original_stroke.get(this.index);
        Vertex2D target = new Vertex2D(v0.x + vec.x, v0.y + vec.y);
        this.pickedSeam.warp_vertex(this.index, target);
        this.rigid.update();
        this.scaleAdjust.update();
        this.piece.beautify();
        DrawPanel.getInstance().repaint();
    }

    public void finish_pulling() {
        DrawPanel panel = DrawPanel.getInstance();
        panel.setCursor(Cursors.defaultCursor);
        this.pulling = false;
        DrawPanel.dragged_piece = null;
        DrawPanel.dragged_seam = null;
        Model pickedModel = Sweater.sweater.getPickedModel();
        Inflate.update_target_length((Model)pickedModel);
        pickedModel.inflate();
        panel.repaint();
    }

    public static boolean start_pulling_for_vertex(Point p) {
        Vertex2D pulling_vertex = DrawPanel.getInstance().snap_vertex;
        if (pulling_vertex == null) {
            return false;
        }
        DrawPanel.getInstance();
        DrawPanel.dragged_piece = pulling_vertex.prev_seam.getPiece();
        Pull.prepare_start_pulling(pulling_vertex, pulling_vertex.prev_seam);
        Pull.prepare_start_pulling(pulling_vertex, pulling_vertex.next_seam);
        DrawPanel panel = DrawPanel.getInstance();
        panel.setCursor(Cursors.pullCursor);
        return true;
    }

    public static void pulling_for_vertex(Point p) {
        Pull pull0 = (Pull)pulls.get(0);
        Vector2 vec = new Vector2((Vector2)pull0.target_v, (Vector2)new Vertex2D(p));
        int i = 0;
        while (i < pulls.size()) {
            ((Pull)pulls.get(i)).pulling(vec);
            ++i;
        }
    }

    public static void finish_pulling_for_vertex() {
        int i = 0;
        while (i < pulls.size()) {
            ((Pull)pulls.get(i)).finish_pulling();
            ++i;
        }
        pulls = new ArrayList();
        DrawPanel panel = DrawPanel.getInstance();
        panel.setCursor(Cursors.defaultCursor);
    }

    public Vector2 mapping_to_2D_vector(Vector2 vector) {
        return Vector2.multiply((Vector2)this.y_vec, (double)vector.y);
    }

    Vector2 get_normal_of_target_v() {
        if (this.index == 0 || this.index == this.stroke.size() - 1) {
            return null;
        }
        Vertex2D v0 = (Vertex2D)this.stroke.get(this.index - 1);
        Vertex2D v1 = (Vertex2D)this.stroke.get(this.index + 1);
        Vector2 vec0 = Vector2.subtract((Vector2)v0, (Vector2)this.target_v);
        Vector2 vec1 = Vector2.subtract((Vector2)v1, (Vector2)this.target_v);
        Vector2 normal = Vector2.add((Vector2)vec0, (Vector2)vec1);
        Vertex2D temp_v = new Vertex2D(this.target_v.x + normal.x, this.target_v.y + normal.y);
        Point p = new Point((int)temp_v.x, (int)temp_v.y);
        if (this.piece.inside(p)) {
            normal.multiply(-1.0);
        }
        normal.normalize();
        return normal;
    }

    void display(Graphics g) {
        if (this.pulling) {
            this.paint_pulling_stroke(g);
            Pull.paint_pulling_pieces(g);
            this.paint_normal(g);
        }
    }

    private void paint_pulling_stroke(Graphics g) {
        if (this.stroke == null) {
            return;
        }
        Color color = Color.RED;
        Vertex2D prev_vertex = (Vertex2D)this.stroke.get(this.index0);
        int i = this.index0 + 1;
        while (i <= this.index1) {
            Vertex2D next_vertex = (Vertex2D)this.stroke.get(i);
            Edge2D edge = prev_vertex.get_common_edge(next_vertex);
            Pull.draw_edge(edge, g, color);
            prev_vertex = next_vertex;
            ++i;
        }
    }

    private void paint_normal(Graphics g) {
        Vertex2D v = (Vertex2D)this.stroke.get(this.index);
    }

    private static void paint_pulling_pieces(Graphics g) {
        int i = 0;
        while (i < pulls.size()) {
            Pull pull = (Pull)pulls.get(i);
            Piece piece = pull.piece;
            piece.paint(g, true);
            ++i;
        }
    }

    private static void draw_edge(Edge2D edge, Graphics g, Color color) {
        if (edge == null) {
            return;
        }
        double wide = 10.0;
        g.setColor(color);
        Graphics2.drawWideLine(g, edge.start.x, edge.start.y, edge.end.x, edge.end.y, wide);
    }

    boolean adjust_scope(Vector2 vec) {
        double pull_length = vec.length() * SCOPE_SCALE;
        if (pull_length <= this.max_pull_length) {
            return false;
        }
        this.max_pull_length = pull_length;
        if (!this.is_locked(this.index0)) {
            this.index0 = this.adjust_scope_sub(pull_length, -1);
        }
        if (!this.is_locked(this.index1)) {
            this.index1 = this.adjust_scope_sub(pull_length, 1);
        }
        return true;
    }

    private boolean is_locked(int index) {
        Vertex2D v = (Vertex2D)this.stroke.get(index);
        int i = 0;
        while (i < this.locked_vertices.size()) {
            Vertex2D v0 = (Vertex2D)this.locked_vertices.get(i);
            if (v0.same(v)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private int adjust_scope_sub(double pull_length, int step) {
        double total = 0.0;
        int i = this.index;
        Vertex2D prev_v = (Vertex2D)this.original_stroke.get(i);
        i += step;
        while (i >= 0 && i <= this.original_stroke.size() - 1) {
            if (this.is_locked(i)) {
                return i;
            }
            Vertex2D v = (Vertex2D)this.original_stroke.get(i);
            if ((total += Vertex2D.distance((Vertex2D)prev_v, (Vertex2D)v)) > pull_length) {
                return i;
            }
            i += step;
            prev_v = v;
        }
        return i - step;
    }

    static int find_closest_vertex(Vertex2D v, List _stroke) {
        int closest = -1;
        double min = Double.MAX_VALUE;
        int i = 0;
        while (i < _stroke.size()) {
            Vertex2D u = (Vertex2D)_stroke.get(i);
            double d = Vertex2D.distance((Vertex2D)u, (Vertex2D)v);
            if (d < min) {
                min = d;
                closest = i;
            }
            ++i;
        }
        return closest;
    }

    public List getStroke() {
        return this.stroke;
    }

    public void setStroke(List _stroke) {
        this.stroke = _stroke;
    }
}

