/*
 * Decompiled with CFR 0.152.
 */
package pattern;

import java.awt.Graphics;
import java.awt.Panel;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.attribute.HashPrintRequestAttributeSet;

public class Print
implements Printable {
    private final Panel panel;
    private final int margin = 20;

    private Print(Panel panel) {
        this.panel = panel;
    }

    public static void print(Panel panel) throws PrinterException {
        if (panel == null) {
            throw new NullPointerException("Panel is null.");
        }
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(new Print(panel));
        HashPrintRequestAttributeSet attributes = new HashPrintRequestAttributeSet();
        if (printerJob.printDialog(attributes)) {
            System.err.println("PRINT START");
            printerJob.print(attributes);
        }
    }

    public int print(Graphics g, PageFormat format, int pageIndex) throws PrinterException {
        if (pageIndex != 0) {
            return 1;
        }
        double printerWidth = format.getImageableWidth();
        double printerHeight = format.getImageableHeight();
        int panelWidth = this.panel.getWidth();
        int panelHeight = this.panel.getHeight();
        double ratio = Math.min(printerWidth / (double)panelWidth, printerHeight / (double)panelHeight);
        BufferedImage bufferedImage = new BufferedImage(panelWidth, panelHeight, 2);
        Graphics imageGraphics = bufferedImage.getGraphics();
        this.panel.print(imageGraphics);
        imageGraphics.dispose();
        g.drawImage(bufferedImage, (int)format.getImageableX(), (int)format.getImageableY(), (int)((double)panelWidth * ratio), (int)((double)panelHeight * ratio), 0, 0, panelWidth, panelHeight, null);
        return 0;
    }
}

