/*
 * Decompiled with CFR 0.152.
 */
package pattern;

import edu.cmu.cs.stage3.alice.scenegraph.TextureMap;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import pattern.Connector;
import pattern.DrawPanel;
import pattern.Mark;
import pattern.Pull;
import pattern.Rigid;
import pattern.Seam;
import pattern.Smoother;
import pattern.StrokeAnalyzer;
import sweater.PatchGenerater;
import sweater.Sweater;
import teddy.Edge;
import teddy.Edge2D;
import teddy.Face;
import teddy.Face2D;
import teddy.MeshBeautify;
import teddy.Polyhedron;
import teddy.Polyhedron2D;
import teddy.Util;
import teddy.Vector2;
import teddy.Vertex;
import teddy.Vertex2D;

public class Piece {
    private static final Color CLOTH_COLOR = new Color(255, 176, 216);
    static final Color REVERSE_COLOR = new Color(182, 246, 108);
    private static final int LINE_WIDTH = 1;
    public static boolean polyhedronRendering = false;
    public static boolean aroundWeight = false;
    public List seams = new ArrayList();
    public List inner_seams = new ArrayList();
    public List marks = new ArrayList();
    public boolean reversed = false;
    public boolean doughnut = false;
    private List outsideVertices = new ArrayList();
    public static List constraints = new ArrayList();
    public Color color = REVERSE_COLOR;
    private List decorations = new ArrayList();
    public int id = -1;
    private Polyhedron2D polyhedron2D;
    Rigid rigid;
    public Pull pull;
    public static final double scale = 150.0;
    private static final int threshold = 10;
    private Polygon polygon;
    final int margin = 25;
    Hashtable seam_to_stroke_indices;
    double AROUND_WEIGHT = 10.0;

    public Vertex2D get_center() {
        Rectangle rectangle = this.get_bbox();
        return new Vertex2D(rectangle.getCenterX(), rectangle.getCenterY());
    }

    public static Piece create_piece_from_polyhedron(Polyhedron p) {
        Polyhedron2D polyhedron2D = Piece.create_polyhedron2D_from_polyhedron(p);
        boolean[] visited = new boolean[p.edges.size()];
        int i = 0;
        while (i < p.edges.size()) {
            Edge edge = (Edge)p.edges.get(i);
            ++i;
        }
        ArrayList boundaries = new ArrayList();
        Edge start_edge = PatchGenerater.find_seed_edge((Polyhedron)p, (boolean[])visited);
        while (start_edge != null) {
            Edge next_edge;
            Edge e;
            Seam seam;
            Vertex2D v;
            ArrayList<Seam> seams = new ArrayList<Seam>();
            ArrayList<Vertex2D> seam_points = new ArrayList<Vertex2D>();
            Vertex prev_v = start_edge.start;
            Edge prev_edge = start_edge;
            while (true) {
                v = prev_v.getPatternCoord();
                v.fixed = true;
                seam_points.add(v);
                if (seam_points.size() == 2) {
                    prev_edge.include_seam = seam = new Seam(seam_points);
                    e = prev_edge.get_common_edge();
                    if (e != null && e.include_seam != null) {
                        Connector connector = new Connector(seam, e.include_seam);
                    }
                    seams.add(seam);
                    seam_points = new ArrayList();
                    v = prev_v.getPatternCoord();
                    seam_points.add(v);
                }
                if ((next_edge = PatchGenerater.find_next_edge((Edge)prev_edge, (Vertex)prev_v)) == null) {
                    System.out.println("next_edge is null");
                    break;
                }
                if (visited[next_edge.index]) break;
                visited[next_edge.index] = true;
                prev_v = next_edge.get_opposite_vertex(prev_v);
                prev_edge = next_edge;
            }
            if (next_edge == null) {
                System.out.println("next_edge == null at Piece.java");
                return null;
            }
            prev_v = next_edge.get_opposite_vertex(prev_v);
            v = prev_v.getPatternCoord();
            seam_points.add(v);
            seam = new Seam(seam_points);
            prev_edge = next_edge;
            prev_edge.include_seam = seam;
            e = prev_edge.get_common_edge();
            if (e != null && e.include_seam != null) {
                seam.setConnector(new Connector(seam, e.include_seam));
            }
            seams.add(seam);
            boundaries.add(seams);
            start_edge = PatchGenerater.find_seed_edge((Polyhedron)p, (boolean[])visited);
        }
        double max_boundary_length = -1.0;
        List outter_boundary = new ArrayList();
        int i2 = 0;
        while (i2 < boundaries.size()) {
            List boundary = (List)boundaries.get(i2);
            double length = 0.0;
            int j = 0;
            while (j < boundary.size()) {
                Seam seam_of_boundary = (Seam)boundary.get(j);
                length += seam_of_boundary.get_length();
                ++j;
            }
            if (max_boundary_length < length) {
                max_boundary_length = length;
                outter_boundary = boundary;
            }
            ++i2;
        }
        boundaries.remove(outter_boundary);
        if (outter_boundary.size() == 0) {
            System.err.println("outter_boundary.size()==0 in create_piece_from_polyhedron");
            return null;
        }
        return new Piece(outter_boundary, boundaries, polyhedron2D);
    }

    private static Polyhedron2D create_polyhedron2D_from_polyhedron(Polyhedron p) {
        Polyhedron2D polyhedron2D = new Polyhedron2D();
        int i = 0;
        while (i < p.vertices.size()) {
            Vertex vertex = p.vertices(i);
            Vertex2D vertex2D = Piece.set_vertex_with_scale(vertex.u, vertex.v);
            vertex.setPatternCoord(vertex2D);
            vertex2D.setVertex(vertex);
            polyhedron2D.add(vertex2D);
            ++i;
        }
        i = 0;
        while (i < p.edges.size()) {
            Edge edge = p.edges(i);
            Edge2D edge2D = new Edge2D(edge.start.getPatternCoord(), edge.end.getPatternCoord());
            edge2D.common_edge = edge.parent_edge;
            edge.parent_edge.common_edge2D = edge2D;
            edge.common_edge2D = edge2D;
            polyhedron2D.add(edge2D);
            ++i;
        }
        i = 0;
        while (i < p.faces.size()) {
            Face face = p.faces(i);
            Edge edge0 = face.edges(0);
            Edge edge1 = face.edges(1);
            Edge edge2 = face.edges(2);
            Face2D face2D = new Face2D(edge0.common_edge2D, edge1.common_edge2D, edge2.common_edge2D);
            polyhedron2D.add(face2D);
            ++i;
        }
        return polyhedron2D;
    }

    public Piece copy() {
        ArrayList<Seam> clone_seams = new ArrayList<Seam>(this.seams.size());
        int i = 0;
        while (i < this.seams.size()) {
            Seam seam = (Seam)this.seams.get(i);
            clone_seams.add(seam.copy());
            ++i;
        }
        ArrayList<Seam> clone_inner_seams = new ArrayList<Seam>(this.inner_seams.size());
        int i2 = 0;
        while (i2 < this.inner_seams.size()) {
            Seam seam = (Seam)this.inner_seams.get(i2);
            clone_inner_seams.add(seam.copy());
            ++i2;
        }
        Polyhedron2D clone_polyhedron2D = this.polyhedron2D.copy();
        Piece clone = new Piece(clone_seams, clone_inner_seams, clone_polyhedron2D);
        clone.id = this.id;
        clone.doughnut = this.doughnut;
        return clone;
    }

    static Vertex2D set_vertex_with_scale(double u, double v) {
        DrawPanel panel = DrawPanel.getInstance();
        return new Vertex2D(u * 150.0 + 150.0, (double)panel.getHeight() - v * 150.0 - 200.0);
    }

    public static Piece create_piece_from_points(List points) {
        Vertex2D p;
        ArrayList<Vertex2D> newPoints = new ArrayList<Vertex2D>();
        ArrayList<Seam> seams = new ArrayList<Seam>();
        int start_index = 0;
        int i = 0;
        while (i < points.size()) {
            p = (Vertex2D)points.get(i);
            if (p.getStitchPoint()) {
                start_index = i + 1;
            }
            ++i;
        }
        i = start_index;
        while (i < points.size() + start_index) {
            p = (Vertex2D)points.get(i % points.size());
            newPoints.add(p);
            if (p.getStitchPoint() || newPoints.size() > 10) {
                seams.add(new Seam(newPoints));
                newPoints = new ArrayList();
                newPoints.add(p);
            }
            ++i;
        }
        return new Piece(seams);
    }

    public void merge_seams() {
        this.update_network();
        Seam merged_seam = null;
        if (this.seams.size() < 3) {
            return;
        }
        int i = 0;
        while (i < this.seams.size()) {
            if (this.seams.size() < 3) {
                return;
            }
            Seam seam0 = (Seam)this.seams.get(i);
            Connector seam0Connector = seam0.getConnector();
            if (seam0Connector == null) {
                System.out.println("seam0Connector = null");
            } else {
                Seam op_seam0 = seam0Connector.get_opposite_seam(seam0);
                Seam seam1 = seam0.end.next_seam;
                Connector seam1Connector = seam1.getConnector();
                if (seam1Connector == null) {
                    System.out.println("seam1Connector = null");
                } else if (seam0Connector != seam1Connector) {
                    Seam op_merged_seam;
                    Seam op_seam1 = seam1Connector.get_opposite_seam(seam1);
                    if (op_seam0.end.next_seam == op_seam1) {
                        merged_seam = this.merge_two_seam(seam0, seam1, seam0.getPiece());
                        op_merged_seam = this.merge_two_seam(op_seam0, op_seam1, op_seam0.getPiece());
                        merged_seam.setConnector(new Connector(merged_seam, op_merged_seam));
                        seam0Connector.delete();
                        seam1Connector.delete();
                        --i;
                    } else if (op_seam0.start.prev_seam == op_seam1) {
                        merged_seam = this.merge_two_seam(seam0, seam1, seam0.getPiece());
                        op_merged_seam = this.merge_two_seam_reverse(op_seam0, op_seam1, op_seam0.getPiece());
                        merged_seam.setConnector(new Connector(merged_seam, op_merged_seam));
                        seam0Connector.delete();
                        seam1Connector.delete();
                        --i;
                    }
                }
            }
            ++i;
        }
    }

    private Seam merge_two_seam(Seam seam0, Seam seam1, Piece piece) {
        int i;
        List stroke0 = seam0.getStroke();
        List stroke1 = seam1.getStroke();
        if (stroke0 == null || stroke1 == null) {
            return null;
        }
        int i2 = 1;
        while (i2 < stroke1.size()) {
            Vertex2D v = (Vertex2D)stroke1.get(i2);
            stroke0.add(v);
            ++i2;
        }
        Seam merged_seam = new Seam(stroke0);
        merged_seam.setPiece(piece);
        merged_seam.start = seam0.start;
        merged_seam.end = seam1.end;
        seam0.start.next_seam = merged_seam;
        seam1.end.prev_seam = merged_seam;
        if (piece.doughnut) {
            ArrayList inner_new_seams = new ArrayList();
            i = 0;
            while (i < piece.inner_seams.size()) {
                List boundary = (List)piece.inner_seams.get(i);
                ArrayList<Seam> new_boundary = new ArrayList<Seam>();
                int j = 0;
                while (j < boundary.size()) {
                    Seam inner_seam = (Seam)boundary.get(j);
                    if (inner_seam == seam0) {
                        new_boundary.add(merged_seam);
                    } else if (inner_seam != seam1) {
                        new_boundary.add(inner_seam);
                    }
                    ++j;
                }
                inner_new_seams.add(new_boundary);
                ++i;
            }
            piece.inner_seams = inner_new_seams;
        }
        ArrayList<Seam> new_seams = new ArrayList<Seam>();
        i = 0;
        while (i < piece.seams.size()) {
            Seam seam = (Seam)piece.seams.get(i);
            if (seam == seam0) {
                new_seams.add(merged_seam);
            } else if (seam != seam1) {
                new_seams.add(seam);
            }
            ++i;
        }
        piece.seams = new_seams;
        this.update_network();
        return merged_seam;
    }

    private Seam merge_two_seam_reverse(Seam seam0, Seam seam1, Piece piece) {
        int i;
        List stroke0 = seam0.getStroke();
        List stroke1 = seam1.getStroke();
        if (stroke0 == null || stroke1 == null) {
            return null;
        }
        int i2 = 1;
        while (i2 < stroke0.size()) {
            Vertex2D v = (Vertex2D)stroke0.get(i2);
            stroke1.add(v);
            ++i2;
        }
        Seam merged_seam = new Seam(stroke1);
        merged_seam.setPiece(piece);
        merged_seam.start = seam1.start;
        merged_seam.end = seam0.end;
        seam0.start.prev_seam = merged_seam;
        seam1.end.next_seam = merged_seam;
        if (piece.doughnut) {
            ArrayList inner_new_seams = new ArrayList();
            i = 0;
            while (i < piece.inner_seams.size()) {
                List boundary = (List)piece.inner_seams.get(i);
                ArrayList<Seam> new_boundary = new ArrayList<Seam>();
                int j = 0;
                while (j < boundary.size()) {
                    Seam inner_seam = (Seam)boundary.get(j);
                    if (inner_seam == seam1) {
                        new_boundary.add(merged_seam);
                    } else if (inner_seam != seam0) {
                        new_boundary.add(inner_seam);
                    }
                    ++j;
                }
                inner_new_seams.add(new_boundary);
                ++i;
            }
            piece.inner_seams = inner_new_seams;
        }
        ArrayList<Seam> new_seams = new ArrayList<Seam>();
        i = 0;
        while (i < piece.seams.size()) {
            Seam seam = (Seam)piece.seams.get(i);
            if (seam == seam1) {
                new_seams.add(merged_seam);
            } else if (seam != seam0) {
                new_seams.add(seam);
            }
            ++i;
        }
        piece.seams = new_seams;
        this.update_network();
        return merged_seam;
    }

    public Piece(List seams) {
        this.doughnut = false;
        Vertex2D start = ((Seam)seams.get((int)0)).start;
        Vertex2D end = ((Seam)seams.get((int)(seams.size() - 1))).end;
        if (start != end) {
            ((Seam)seams.get((int)(seams.size() - 1))).end = start;
        }
        this.seams = seams;
        this.update_network();
        this.setOutsideVertices();
    }

    public Piece(List seams, List boundaries, Polyhedron2D _polyhedron2D) {
        this.polyhedron2D = _polyhedron2D;
        Vertex2D start = ((Seam)seams.get((int)0)).start;
        Vertex2D end = ((Seam)seams.get((int)(seams.size() - 1))).end;
        if (start != end) {
            ((Seam)seams.get((int)(seams.size() - 1))).end = start;
        }
        this.seams = seams;
        if (boundaries.size() == 0 || boundaries == null) {
            this.doughnut = false;
        } else {
            this.doughnut = true;
            this.inner_seams = new ArrayList();
            int i = 0;
            while (i < boundaries.size()) {
                List boundary = (List)boundaries.get(i);
                start = ((Seam)boundary.get((int)0)).start;
                end = ((Seam)boundary.get((int)(boundary.size() - 1))).end;
                if (start != end) {
                    ((Seam)boundary.get((int)(boundary.size() - 1))).end = start;
                }
                this.inner_seams.add(boundary);
                ++i;
            }
        }
        this.update_network();
        if (aroundWeight) {
            this.set_weight_around();
        }
        this.setOutsideVertices();
    }

    public static List adjust_loop_direction(List seams) {
        List stroke = Piece.get_stroke(seams);
        if (StrokeAnalyzer.calculate_area(stroke) > 0.0) {
            return seams;
        }
        System.out.println("reverse_seams");
        return Piece.reverse_seams(seams);
    }

    public void update_network() {
        if (this.polyhedron2D == null) {
            System.err.println("polyhedron2D == null in update_network");
            return;
        }
        int i = 0;
        while (i < this.polyhedron2D.vertices.size()) {
            Vertex2D v = this.polyhedron2D.vertices(i);
            v.piece = this;
            ++i;
        }
        this.seams = Piece.adjust_loop_direction(this.seams);
        i = 0;
        while (i < this.seams.size()) {
            Seam seam0 = (Seam)this.seams.get(i);
            Seam seam1 = (Seam)this.seams.get(Util.mod((int)(i + 1), (int)this.seams.size()));
            seam0.end.prev_seam = seam0;
            seam0.end.next_seam = seam1;
            seam1.start = seam0.end;
            seam0.setPiece(this);
            ++i;
        }
        if (this.doughnut) {
            i = 0;
            while (i < this.inner_seams.size()) {
                List boundary = (List)this.inner_seams.get(i);
                int j = 0;
                while (j < boundary.size()) {
                    Seam inner_seam0 = (Seam)boundary.get(j);
                    Seam inner_seam1 = (Seam)boundary.get(Util.mod((int)(j + 1), (int)boundary.size()));
                    inner_seam0.end.prev_seam = inner_seam0;
                    inner_seam0.end.next_seam = inner_seam1;
                    inner_seam1.start = inner_seam0.end;
                    inner_seam1.setPiece(this);
                    ++j;
                }
                ++i;
            }
        }
    }

    public void delete() {
        int i = 0;
        while (i < this.seams.size()) {
            Seam seam = (Seam)this.seams.get(i);
            Connector connector = seam.getConnector();
            if (connector != null) {
                connector.delete();
            }
            ++i;
        }
        if (this.doughnut) {
            i = 0;
            while (i < this.inner_seams.size()) {
                List boundary = (List)this.inner_seams.get(i);
                int j = 0;
                while (j < boundary.size()) {
                    Seam inner_seam = (Seam)boundary.get(j);
                    Connector connector = inner_seam.getConnector();
                    if (connector != null) {
                        connector.delete();
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public void prepare_paint() {
        if (this.doughnut) {
            int i = 0;
            while (i < this.inner_seams.size()) {
                List boundary = (List)this.inner_seams.get(i);
                int j = 0;
                while (j < boundary.size()) {
                    ((Seam)boundary.get(j)).set_stroke();
                    ++j;
                }
                ++i;
            }
        }
    }

    public void paint(Graphics g, boolean highlighted) {
        this.paint_inside(g);
        if (this.doughnut) {
            this.paint_inner_hole(g);
        }
        if (polyhedronRendering) {
            this.paint_polyhedron2D(g);
        }
        if (highlighted) {
            g.setColor(Color.red);
        } else {
            g.setColor(Color.black);
        }
        int i = 0;
        while (i < this.seams.size()) {
            ((Seam)this.seams.get(i)).paint(g);
            ++i;
        }
        if (this.doughnut) {
            i = 0;
            while (i < this.inner_seams.size()) {
                List boundary = (List)this.inner_seams.get(i);
                int j = 0;
                while (j < boundary.size()) {
                    ((Seam)boundary.get(j)).paint(g);
                    ++j;
                }
                ++i;
            }
        }
        this.paint_decorations(g);
    }

    private void paint_decorations(Graphics g) {
        int i = 0;
        while (i < this.decorations.size()) {
            Vertex2D v = (Vertex2D)this.decorations.get(i);
            this.draw_pin(v, g, Color.BLACK);
            ++i;
        }
    }

    private void paint_outerVertices(Graphics g) {
        g.setColor(Color.BLACK);
        int i = 0;
        while (i < this.outsideVertices.size()) {
            Vertex2D v = (Vertex2D)this.outsideVertices.get(i);
            g.drawString("" + i, (int)v.x, (int)v.y);
            ++i;
        }
    }

    public void draw_pin(Vertex2D v, Graphics g, Color color) {
        if (v == null) {
            return;
        }
        int r = 5;
        g.setColor(Color.black);
        g.fillOval((int)v.x - r, (int)v.y - r, 2 * r, 2 * r);
        g.setColor(color);
        g.fillOval((int)v.x - r + 2, (int)v.y - r + 2, 2 * (r - 2), 2 * (r - 2));
    }

    public void paint_polyhedron2D(Graphics g) {
        int r = 3;
        g.setColor(Color.BLACK);
        int i = 0;
        while (i < this.polyhedron2D.vertices.size()) {
            Vertex2D vertex2D = this.polyhedron2D.vertices(i);
            g.fillOval((int)vertex2D.x - r, (int)vertex2D.y - r, 2 * r, 2 * r);
            if (vertex2D.fixed) {
                g.setColor(Color.MAGENTA);
                g.fillOval((int)vertex2D.x - r, (int)vertex2D.y - r, 2 * r, 2 * r);
                g.setColor(Color.BLACK);
            }
            ++i;
        }
        i = 0;
        while (i < this.polyhedron2D.edges.size()) {
            Edge2D edge2D = this.polyhedron2D.edges(i);
            g.drawLine((int)edge2D.start.x, (int)edge2D.start.y, (int)edge2D.end.x, (int)edge2D.end.y);
            ++i;
        }
        i = 0;
        while (i < this.polyhedron2D.faces.size()) {
            Face2D face = this.polyhedron2D.faces(i);
            if (face.weight != 1.0) {
                this.draw_hard_triangle(g, face);
            }
            ++i;
        }
    }

    public void draw_hard_triangle(Graphics g, Face2D face) {
        Vertex2D v1;
        Vertex2D v0;
        Vertex2D[] vs = new Vertex2D[3];
        int j = 0;
        while (j < 3) {
            v0 = face.get_vertex(j);
            v1 = face.get_vertex(j + 1);
            Vertex2D v2 = face.get_vertex(j + 2);
            Vector2 v10 = new Vector2((Vector2)v1, (Vector2)v0);
            Vector2 v12 = new Vector2((Vector2)v1, (Vector2)v2);
            v10.normalize();
            v12.normalize();
            Vector2 v1c = Vector2.add((Vector2)v10, (Vector2)v12);
            v1c.normalize();
            double h = Vector2.cross_product((Vector2)v10, (Vector2)v1c);
            vs[j] = Vertex2D.translate((Vertex2D)v1, (Vector2)Vector2.multiply((Vector2)v1c, (double)(2.0 / h)));
            ++j;
        }
        j = 0;
        while (j < 3) {
            v0 = vs[j];
            v1 = vs[(j + 1) % 3];
            g.drawLine((int)v0.x, (int)v0.y, (int)v1.x, (int)v1.y);
            ++j;
        }
    }

    public void paint_inside(Graphics g) {
        int n = 0;
        int i = 0;
        while (i < this.seams.size()) {
            Seam seam = (Seam)this.seams.get(i);
            List points = seam.getPoints();
            n += points.size() + 1;
            ++i;
        }
        int k = 0;
        int[] x = new int[n];
        int[] y = new int[n];
        int i2 = 0;
        while (i2 < this.seams.size()) {
            Seam seam = (Seam)this.seams.get(i2);
            List stroke = seam.getStroke();
            int j = 0;
            while (j < stroke.size() - 1) {
                Vertex2D v = (Vertex2D)stroke.get(j);
                x[k] = (int)v.x;
                y[k] = (int)v.y;
                ++k;
                ++j;
            }
            ++i2;
        }
        g.setColor(this.color);
        g.fillPolygon(x, y, n);
        this.polygon = new Polygon(x, y, n);
    }

    private void paint_bbox(Graphics g) {
        g.setColor(Color.CYAN);
        Rectangle bbox = this.get_bbox();
        g.drawRect((int)bbox.getMinX(), (int)bbox.getMinY(), (int)bbox.getWidth(), (int)bbox.getHeight());
    }

    private void paint_inner_hole(Graphics g) {
        g.setColor(Color.WHITE);
        int l = 0;
        while (l < this.inner_seams.size()) {
            List boundary = (List)this.inner_seams.get(l);
            int n = 0;
            int i = 0;
            while (i < boundary.size()) {
                Seam seam = (Seam)boundary.get(i);
                List points = seam.getPoints();
                n += points.size() + 1;
                ++i;
            }
            int k = 0;
            int[] x = new int[n];
            int[] y = new int[n];
            int i2 = 0;
            while (i2 < boundary.size()) {
                Seam seam = (Seam)boundary.get(i2);
                List stroke = seam.getStroke();
                int j = 0;
                while (j < stroke.size() - 1) {
                    Vertex2D v = (Vertex2D)stroke.get(j);
                    x[k] = (int)v.x;
                    y[k] = (int)v.y;
                    ++k;
                    ++j;
                }
                ++i2;
            }
            g.fillPolygon(x, y, n);
            ++l;
        }
    }

    private void paint_margin(Graphics g) {
        g.setColor(new Color(190, 190, 190));
        this.paint_margin_sub_90(g);
        this.paint_margin_sub_270(g);
    }

    private void paint_margin_sub_oval(Graphics g) {
        int i = 0;
        while (i < this.seams.size()) {
            Seam seam = (Seam)this.seams.get(i);
            Vertex2D v = seam.end;
            g.fillOval((int)v.x, (int)v.y, 25, 25);
            ++i;
        }
    }

    private void paint_margin_sub_90(Graphics g) {
        List stroke = this.get_stroke(3);
        int n = stroke.size() + 1;
        int[] x = new int[n];
        int[] y = new int[n];
        int k = 0;
        Vertex2D v_prev = (Vertex2D)stroke.get(stroke.size() - 1);
        int j = 0;
        while (j < stroke.size() + 1) {
            Vertex2D v = (Vertex2D)stroke.get(j % stroke.size());
            Vector2 normal = Vertex2D.rotate((Vector2)Vertex2D.subtract((Vector2)v, (Vector2)v_prev), (double)90.0);
            normal.normalize();
            Vertex2D new_v = this.translate_with_margin(v, normal, 25.0);
            x[k] = (int)new_v.x;
            y[k] = (int)new_v.y;
            v_prev = v;
            ++k;
            ++j;
        }
        g.fillPolygon(x, y, n);
        this.polygon = new Polygon(x, y, n);
    }

    private void paint_margin_sub_270(Graphics g) {
        List stroke = this.get_stroke(3);
        int n = stroke.size() + 1;
        int[] x = new int[n];
        int[] y = new int[n];
        int k = 0;
        Vertex2D v_prev = (Vertex2D)stroke.get(stroke.size() - 1);
        int j = 0;
        while (j < stroke.size() + 1) {
            Vertex2D v = (Vertex2D)stroke.get(j % stroke.size());
            Vector2 normal = Vertex2D.rotate((Vector2)Vertex2D.subtract((Vector2)v, (Vector2)v_prev), (double)270.0);
            normal.normalize();
            Vertex2D new_v = this.translate_with_margin(v, normal, 25.0);
            x[k] = (int)new_v.x;
            y[k] = (int)new_v.y;
            v_prev = v;
            ++k;
            ++j;
        }
        g.fillPolygon(x, y, n);
    }

    private Vertex2D translate_with_margin(Vertex2D current, Vector2 normal, double val) {
        Vertex2D new_vertex = new Vertex2D(current.x + val * normal.x, current.y + val * normal.y);
        return new_vertex;
    }

    public boolean inside(Point p) {
        return this.polygon.contains(p);
    }

    public void translate(Vector2 vec) {
        int i = 0;
        while (i < this.polyhedron2D.vertices.size()) {
            Vertex2D vertex2D = this.polyhedron2D.vertices(i);
            vertex2D.translate_self(vec);
            ++i;
        }
    }

    public void zoom(Vertex2D center, double ratio) {
        int i = 0;
        while (i < this.polyhedron2D.vertices.size()) {
            Vertex2D v = this.polyhedron2D.vertices(i);
            this.zoom_sub(v, center, ratio);
            ++i;
        }
    }

    private void zoom_sub(Vertex2D v, Vertex2D center, double ratio) {
        v.x = center.x + (v.x - center.x) * ratio;
        v.y = center.y + (v.y - center.y) * ratio;
    }

    public void sliding(Vector2 dv) {
        int i = 0;
        while (i < this.polyhedron2D.vertices.size()) {
            Vertex2D v = this.polyhedron2D.vertices(i);
            this.slide_sub(v, dv);
            ++i;
        }
    }

    private void slide_sub(Vertex2D v, Vector2 dv) {
        v.x += dv.x;
        v.y += dv.y;
    }

    public Seam pick_seam(Point p, double[] d) {
        double min = -1.0;
        Seam closest = null;
        int i = 0;
        while (i < this.seams.size()) {
            Seam seam = (Seam)this.seams.get(i);
            double l = seam.distance(p);
            if (min == -1.0 || l < min) {
                min = l;
                closest = seam;
            }
            ++i;
        }
        d[0] = min;
        return closest;
    }

    public Connector pick_connector(Point p, double[] d) {
        double min = -1.0;
        Connector closest = null;
        int i = 0;
        while (i < this.seams.size()) {
            Seam seam = (Seam)this.seams.get(i);
            Connector connector = seam.getConnector();
            if (connector != null) {
                double l = connector.distance(p);
                if (min == -1.0 || l < min) {
                    min = l;
                    closest = connector;
                }
            }
            ++i;
        }
        d[0] = min;
        return closest;
    }

    public Piece get_flipped() {
        Rectangle bbox = this.get_bbox();
        int axis_x = bbox.x + bbox.width + 20;
        List<Seam> flipped_seams = new ArrayList();
        int i = 0;
        while (i < this.seams.size()) {
            Seam seam = (Seam)this.seams.get(i);
            flipped_seams.add(seam.get_flipped(axis_x));
            ++i;
        }
        flipped_seams = Util.reverse(flipped_seams);
        Seam seam0 = (Seam)flipped_seams.get(this.seams.size() - 1);
        int i2 = 0;
        while (i2 < flipped_seams.size()) {
            Seam seam1 = (Seam)flipped_seams.get(i2);
            seam0.end = seam1.start;
            seam0 = seam1;
            ++i2;
        }
        Piece piece = new Piece(flipped_seams);
        piece.reversed = this.reversed;
        Rectangle bbox0 = this.get_bbox();
        Rectangle bbox1 = piece.get_bbox();
        Vector2 vec = new Vector2((double)(bbox0.x - bbox1.x), (double)(bbox0.y - bbox1.y));
        vec.add(new Vector2(20.0, 0.0));
        piece.translate(vec);
        return piece;
    }

    public Rectangle get_bbox() {
        int min_x = -1;
        int max_x = -1;
        int min_y = -1;
        int max_y = -1;
        int i = 0;
        while (i < this.seams.size()) {
            Seam seam = (Seam)this.seams.get(i);
            List stroke = seam.getStroke();
            int j = 0;
            while (j < stroke.size()) {
                Vertex2D p = (Vertex2D)stroke.get(j);
                if (min_x == -1 || p.x < (double)min_x) {
                    min_x = (int)p.x;
                }
                if (max_x == -1 || p.x > (double)max_x) {
                    max_x = (int)p.x;
                }
                if (min_y == -1 || p.y < (double)min_y) {
                    min_y = (int)p.y;
                }
                if (max_y == -1 || p.y > (double)max_y) {
                    max_y = (int)p.y;
                }
                ++j;
            }
            ++i;
        }
        return new Rectangle(min_x, min_y, max_x - min_x, max_y - min_y);
    }

    public void reverse() {
        this.prepare_paint();
        Rectangle bbox = this.get_bbox();
        int axis_x = bbox.x + bbox.width / 2;
        int i = 0;
        while (i < this.seams.size()) {
            Seam seam = (Seam)this.seams.get(i);
            seam.reverse(axis_x);
            ++i;
        }
        this.reversed = !this.reversed;
        i = 0;
        while (i < this.marks.size()) {
            Mark mark = (Mark)this.marks.get(i);
            mark.reverse(axis_x);
            ++i;
        }
    }

    public void symmetrize() {
        double angle;
        Vertex2D v1;
        Vertex2D v0;
        Seam seam1;
        Seam seam0;
        int i;
        double min_angle = -1.0;
        Object[] pair = new Object[2];
        Vertex2D center = null;
        if (Util.mod((int)this.seams.size(), (int)2) == 0) {
            i = 0;
            while (i < this.seams.size() / 2) {
                seam0 = (Seam)this.seams.get(i);
                seam1 = (Seam)this.seams.get(i + this.seams.size() / 2);
                v0 = seam0.start;
                v1 = seam1.start;
                angle = Math.abs((v0.x - v1.x) / (v0.y - v1.y));
                if (min_angle == -1.0 || min_angle > angle) {
                    min_angle = angle;
                    pair[0] = v0;
                    pair[1] = v1;
                    center = v0;
                }
                v0 = seam0.get_mid_point();
                v1 = seam1.get_mid_point();
                angle = Math.abs((v0.x - v1.x) / (v0.y - v1.y));
                if (min_angle == -1.0 || min_angle > angle) {
                    min_angle = angle;
                    pair[0] = seam0;
                    pair[1] = seam1;
                    center = v0;
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < this.seams.size()) {
                seam0 = (Seam)this.seams.get(i);
                seam1 = (Seam)this.seams.get(Util.mod((int)(i + this.seams.size() / 2), (int)this.seams.size()));
                v0 = seam0.start;
                v1 = seam1.get_mid_point();
                angle = Math.abs((v0.x - v1.x) / (v0.y - v1.y));
                if (min_angle == -1.0 || min_angle > angle) {
                    min_angle = angle;
                    pair[0] = v0;
                    pair[1] = seam1;
                    center = v0;
                }
                ++i;
            }
        }
        int r0 = 0;
        int l0 = 0;
        int i2 = 0;
        while (i2 < this.seams.size()) {
            Seam seam = (Seam)this.seams.get(i2);
            if (seam.start == pair[0]) {
                r0 = i2;
                l0 = i2;
                break;
            }
            if (seam == pair[0]) {
                r0 = i2 + 1;
                l0 = i2;
                break;
            }
            ++i2;
        }
        Vertex2D[] right = new Vertex2D[this.seams.size() / 2 + 1];
        Vertex2D[] left = new Vertex2D[this.seams.size() / 2 + 1];
        int i3 = 0;
        while (i3 < this.seams.size() / 2 + 1) {
            right[i3] = ((Seam)this.seams.get((int)r0)).start;
            left[i3] = ((Seam)this.seams.get((int)l0)).start;
            r0 = Util.mod((int)(r0 + 1), (int)this.seams.size());
            l0 = Util.mod((int)(l0 - 1), (int)this.seams.size());
            ++i3;
        }
        i3 = 0;
        while (i3 < this.seams.size() / 2 + 1) {
            Vertex2D v02 = right[i3];
            Vertex2D v12 = left[i3];
            double y = (v02.y + v12.y) / 2.0;
            double dx = (v02.x - center.x + (center.x - v12.x)) / 2.0;
            v02.x = center.x + dx;
            v12.x = center.x - dx;
            v02.y = y;
            v12.y = y;
            ++i3;
        }
        i3 = 0;
        while (i3 < this.seams.size() / 2) {
            Seam seam02 = right[i3].get_common_seam(right[i3 + 1]);
            Seam seam12 = left[i3].get_common_seam(left[i3 + 1]);
            List seam0Points = seam02.getPoints();
            ArrayList<Vertex2D> seam1Points = new ArrayList<Vertex2D>();
            if (seam02 != seam12) {
                int j = 0;
                while (j < seam0Points.size()) {
                    Vertex2D p = (Vertex2D)seam0Points.get(seam0Points.size() - 1 - j);
                    Vertex2D q = new Vertex2D(1.0 - p.x, p.y);
                    seam1Points.add(q);
                    ++j;
                }
            }
            seam12.setPoints(seam1Points);
            ++i3;
        }
        if (right[0] != left[0]) {
            this.symmetrize_seam(right[0].get_common_seam(left[0]));
        }
        if (right[(this.seams.size() - 1) / 2] != left[(this.seams.size() - 1) / 2]) {
            this.symmetrize_seam(right[(this.seams.size() - 1) / 2].get_common_seam(left[(this.seams.size() - 1) / 2]));
        }
    }

    public void symmetrize_seam(Seam seam) {
        if (seam == null) {
            return;
        }
        List seamPoints = seam.getPoints();
        int i = 0;
        while (i < seamPoints.size() / 2) {
            double x;
            double y;
            Vertex2D p = (Vertex2D)seamPoints.get(i);
            Vertex2D q = (Vertex2D)seamPoints.get(seamPoints.size() - 1 - i);
            p.y = q.y = (y = (p.y + q.y) / 2.0);
            p.x = x = (p.x + (1.0 - q.x)) / 2.0;
            q.x = 1.0 - x;
            ++i;
        }
    }

    public void cut_seam(Seam seam, Vertex2D p) {
        List stroke = seam.getStroke();
        double min = -1.0;
        int index = 0;
        int i = 0;
        while (i < stroke.size()) {
            Vertex2D v = (Vertex2D)stroke.get(i);
            double d = Vertex2D.distance((Vertex2D)v, (Vertex2D)p);
            if (min == -1.0 || min > d) {
                min = d;
                index = i;
            }
            ++i;
        }
        if (index == 0 || index == stroke.size() - 1) {
            return;
        }
        p = (Vertex2D)stroke.get(index);
        ArrayList stroke0 = new ArrayList();
        ArrayList stroke1 = new ArrayList();
        int i2 = 0;
        while (i2 <= index) {
            stroke0.add(stroke.get(i2));
            ++i2;
        }
        i2 = index;
        while (i2 < stroke.size()) {
            stroke1.add(stroke.get(i2));
            ++i2;
        }
        Seam seam0 = new Seam(stroke0);
        Seam seam1 = new Seam(stroke1);
        seam0.setPiece(this);
        seam1.setPiece(this);
        seam0.start = seam.start;
        seam0.end = p;
        seam1.start = p;
        seam1.end = seam.end;
        p.prev_seam = seam0;
        p.next_seam = seam1;
        seam.start.next_seam = seam0;
        seam.end.prev_seam = seam1;
        ArrayList<Seam> new_seams = new ArrayList<Seam>();
        int i3 = 0;
        while (i3 < this.seams.size()) {
            Seam s = (Seam)this.seams.get(i3);
            if (s == seam) {
                new_seams.add(seam0);
                new_seams.add(seam1);
            } else {
                new_seams.add(s);
            }
            ++i3;
        }
        this.seams = new_seams;
    }

    public void merge_seams(Vertex2D p) {
        Seam seam0 = p.prev_seam;
        Seam seam1 = p.next_seam;
        List stroke0 = seam0.getStroke();
        List stroke1 = seam1.getStroke();
        stroke1.remove(0);
        List merged_stroke = Util.connect((List)stroke0, (List)stroke1);
        Seam merged_seam = new Seam(merged_stroke);
        merged_seam.setPiece(this);
        merged_seam.start = seam0.start;
        merged_seam.end = seam1.end;
        seam0.start.next_seam = merged_seam;
        seam1.end.prev_seam = merged_seam;
        ArrayList<Seam> new_seams = new ArrayList<Seam>();
        int i = 0;
        while (i < this.seams.size()) {
            Seam seam = (Seam)this.seams.get(i);
            if (seam == seam0) {
                new_seams.add(merged_seam);
            } else if (seam != seam1) {
                new_seams.add(seam);
            }
            ++i;
        }
        this.seams = new_seams;
    }

    public Piece[] cut_piece(Vertex2D p, Vertex2D q, List inserted_seams) {
        Vertex2D v;
        if (p.prev_seam.getPiece() != q.prev_seam.getPiece()) {
            return null;
        }
        Seam seam = p.get_common_seam(q);
        if (seam != null) {
            this.replace_seam(seam, p, q, inserted_seams);
            return null;
        }
        List seams_p_q = new ArrayList<Seam>();
        List<Seam> seams_q_p = new ArrayList<Seam>();
        Seam next_seam = p.next_seam;
        while (true) {
            seams_p_q.add(next_seam);
            v = next_seam.end;
            if (v == q) break;
            next_seam = v.next_seam;
        }
        next_seam = q.next_seam;
        while (true) {
            seams_q_p.add(next_seam);
            v = next_seam.end;
            if (v == p) break;
            next_seam = v.next_seam;
        }
        seams_q_p = Util.connect(seams_q_p, (List)inserted_seams);
        seams_p_q = Util.connect(seams_p_q, (List)Piece.reverse_seams(this.duplicate_seams(inserted_seams)));
        Vertex2D dp = new Vertex2D((Vector2)p);
        Vertex2D dq = new Vertex2D((Vector2)q);
        int i = 0;
        while (i < seams_p_q.size()) {
            Seam s = (Seam)seams_p_q.get(i);
            if (s.start == p) {
                s.start = dp;
            }
            if (s.end == p) {
                s.end = dp;
            }
            if (s.start == q) {
                s.start = dq;
            }
            if (s.end == q) {
                s.end = dq;
            }
            ++i;
        }
        Piece[] pieces = new Piece[]{new Piece(seams_p_q), new Piece(seams_q_p)};
        return pieces;
    }

    public void replace_seam(Seam old_seam, Vertex2D p, Vertex2D q, List inserted_seams) {
        if (old_seam.start == q) {
            inserted_seams = Piece.reverse_seams(inserted_seams);
        }
        List<Seam> new_seams = new ArrayList<Seam>();
        int i = 0;
        while (i < this.seams.size()) {
            Seam seam = (Seam)this.seams.get(i);
            if (seam == old_seam) {
                new_seams = Util.connect(new_seams, (List)inserted_seams);
            } else {
                new_seams.add(seam);
            }
            ++i;
        }
        this.seams = new_seams;
        this.update_network();
    }

    public static List reverse_seams(List original_seams) {
        ArrayList<Seam> reversed_seams = new ArrayList<Seam>();
        int i = 0;
        while (i < original_seams.size()) {
            Seam seam = (Seam)original_seams.get(original_seams.size() - 1 - i);
            seam.reverse();
            reversed_seams.add(seam);
            ++i;
        }
        return reversed_seams;
    }

    public List duplicate_seams(List original_seams) {
        ArrayList<Seam> duplicated_seams = new ArrayList<Seam>();
        int i = 0;
        while (i < original_seams.size()) {
            Seam seam = (Seam)original_seams.get(i);
            duplicated_seams.add(seam.duplicate());
            ++i;
        }
        return duplicated_seams;
    }

    void outsideVerticesSmoothing() {
        Vertex2D v = (Vertex2D)this.outsideVertices.get(0);
        Smoother smoother = new Smoother(v, this.outsideVertices);
        int i = 0;
        while (i < this.outsideVertices.size()) {
            Smoother.smooth_vertex(i, this.outsideVertices, 2);
            ++i;
        }
    }

    public void save(BufferedWriter out) throws IOException {
        out.write("piece");
        out.newLine();
        out.write("" + this.reversed);
        out.newLine();
        int i = 0;
        while (i < this.seams.size()) {
            ((Seam)this.seams.get(i)).save(out);
            ++i;
        }
        out.write("end piece");
        out.newLine();
    }

    Piece(BufferedReader in) throws IOException {
        String line;
        this.seams = new ArrayList();
        String s = in.readLine();
        this.reversed = new Boolean(s);
        while ((line = in.readLine()) != null && !line.equals("end piece")) {
            if (!line.equals("seam")) continue;
            this.seams.add(new Seam(in));
        }
        this.update_network();
    }

    public void beautify() {
        this.make_constraints();
        MeshBeautify.beautify_for_polyhedron2D((Polyhedron2D)this.polyhedron2D, (List)constraints);
    }

    public void make_constraints() {
        constraints = new ArrayList();
        int i = 0;
        while (i < this.polyhedron2D.vertices.size()) {
            Vertex2D v = this.polyhedron2D.vertices(i);
            if (v.fixed) {
                constraints.add(v);
            }
            ++i;
        }
    }

    public static List get_stroke(List seams) {
        List stroke = new ArrayList();
        int i = 0;
        while (i < seams.size()) {
            Seam seam = (Seam)seams.get(i);
            List seam_stroke = seam.getStroke();
            stroke = Util.connect(stroke, (List)seam.getStroke());
            stroke.remove(stroke.size() - 1);
            ++i;
        }
        return stroke;
    }

    public List get_stroke(int unit_length) {
        this.seam_to_stroke_indices = new Hashtable();
        List stroke = new ArrayList();
        int i = 0;
        while (i < this.seams.size()) {
            Seam seam = (Seam)this.seams.get(i);
            List resampled = StrokeAnalyzer.resample(seam.getStroke(), unit_length);
            int[] indices = new int[resampled.size()];
            int n = stroke.size();
            int j = 0;
            while (j < indices.length) {
                indices[j] = n++;
                ++j;
            }
            this.seam_to_stroke_indices.put(seam, indices);
            stroke = Util.connect(stroke, (List)resampled);
            stroke.remove(stroke.size() - 1);
            ++i;
        }
        int n = stroke.size();
        Enumeration e = this.seam_to_stroke_indices.elements();
        while (e.hasMoreElements()) {
            int[] indices = (int[])e.nextElement();
            if (indices[indices.length - 1] != n) continue;
            indices[indices.length - 1] = 0;
        }
        return stroke;
    }

    public int[] get_stroke_indices(Seam seam) {
        return (int[])this.seam_to_stroke_indices.get(seam);
    }

    public List get_updated_stroke() {
        List stroke = new ArrayList();
        int i = 0;
        while (i < this.seams.size()) {
            Seam seam = (Seam)this.seams.get(i);
            int[] indices = (int[])this.seam_to_stroke_indices.get(seam);
            List resampled = StrokeAnalyzer.resample_by_number(seam.getStroke(), indices.length - 1);
            stroke = Util.connect(stroke, (List)resampled);
            stroke.remove(stroke.size() - 1);
            ++i;
        }
        return stroke;
    }

    public void prepare_start_pulling(Vertex2D p, Seam _pickedSeam) {
        if (_pickedSeam == null) {
            return;
        }
        this.pull = new Pull(p, _pickedSeam);
    }

    public void set_weight_around() {
        int i = 0;
        while (i < this.polyhedron2D.edges.size()) {
            Edge2D edge = this.polyhedron2D.edges(i);
            if (edge.right_face == null) {
                edge.left_face.weight = this.AROUND_WEIGHT;
            } else if (edge.left_face == null) {
                edge.right_face.weight = this.AROUND_WEIGHT;
            }
            ++i;
        }
    }

    private void setOutsideVertices() {
        this.outsideVertices = new ArrayList();
        int i = 0;
        while (i < this.seams.size()) {
            Seam seam = (Seam)this.seams.get(i);
            List stroke = seam.getStroke();
            int j = 0;
            while (j < stroke.size() - 1) {
                this.outsideVertices.add((Vertex2D)stroke.get(j));
                ++j;
            }
            ++i;
        }
    }

    public void initialize_texture() {
        TextureMap modelTextureMap = new TextureMap();
        modelTextureMap.setImage(Sweater.jaliceFrame.getToolkit().getImage("texture\\texture.jpg"));
    }

    public void setPolyhedron(Polyhedron2D p) {
        this.polyhedron2D = p;
    }

    public Polyhedron2D getPolyhedron() {
        return this.polyhedron2D;
    }

    public List getOutsideVertices() {
        if (this.outsideVertices == null || this.outsideVertices.size() == 0) {
            this.setOutsideVertices();
        }
        return this.outsideVertices;
    }

    public List getDecorations() {
        return this.decorations;
    }

    public void setDecorations(List _decorations) {
        this.decorations = _decorations;
    }
}

