/*
 * Decompiled with CFR 0.152.
 */
package pattern;

import java.awt.Color;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import pattern.DrawPanel;
import pattern.Piece;
import pattern.Print;

public class MyMenuBar
extends MenuBar
implements ActionListener {
    DrawPanel target;

    public MyMenuBar(DrawPanel target) {
        this.target = target;
        Menu menu = new Menu("\u30d5\u30a1\u30a4\u30eb");
        menu.add(new MyMenuItem("\u5370\u5237", this));
        menu.add(new MyMenuItem("\u7d42\u4e86", this));
        this.add(menu);
        menu = new Menu("\u8868\u793a");
        menu.add(new MyMenuItem("\u578b\u7d19\u756a\u53f7\u8868\u793a", this));
        menu.add(new MyMenuItem("\u7e2b\u3044\u5408\u308f\u305b\u756a\u53f7\u8868\u793a", this));
        menu.add(new MyMenuItem("\u7e2b\u3044\u5408\u308f\u305b\u3064\u306a\u304c\u308a\u8868\u793a", this));
        menu.add(new MyMenuItem("polyhedron", this));
        this.add(menu);
        menu = new Menu("\u8272");
        menu.add(new MyMenuItem("\u9ed2", this));
        menu.add(new MyMenuItem("\u767d", this));
        menu.add(new MyMenuItem("\u521d\u671f\u8a2d\u5b9a\u8272", this));
        this.add(menu);
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (!(object instanceof MyMenuItem)) {
            return;
        }
        String label = ((MenuItem)object).getLabel();
        if (label.equals("load") || label.equals("\u958b\u304f")) {
            this.target.load();
        } else if (label.equals("save") || label.equals("\u4fdd\u5b58")) {
            this.target.save();
        } else if (label.equals("print") || label.equals("\u5370\u5237")) {
            try {
                Print.print(this.target);
            }
            catch (PrinterException e) {
                e.printStackTrace();
            }
        } else if (label.equals("exit") || label.equals("\u7d42\u4e86")) {
            System.exit(0);
        } else if (label.equals("clear")) {
            this.target.clear();
        } else if (label.equals("delete")) {
            this.target.delete();
        } else if (label.equals("mirror")) {
            this.target.flip();
            this.target.reverse();
        } else if (label.equals("flip")) {
            this.target.flip();
        } else if (label.equals("reverse")) {
            this.target.reverse();
        } else if (label.equals("symmetrize")) {
            this.target.symmetry();
        } else if (label.equals("layout")) {
            this.target.setLayoutMode(!this.target.isLayoutMode());
        } else if (label.equals("piece number") || label.equals("\u578b\u7d19\u756a\u53f7\u8868\u793a")) {
            this.target.setPieceNumberRendering(!this.target.isPieceNumberRendering());
            this.target.repaint();
        } else if (label.equals("sew number") || label.equals("\u7e2b\u3044\u5408\u308f\u305b\u756a\u53f7\u8868\u793a")) {
            this.target.setSewNumberRendering(!this.target.isSewNumberRendering());
            this.target.repaint();
        } else if (label.equals("connector") || label.equals("\u7e2b\u3044\u5408\u308f\u305b\u3064\u306a\u304c\u308a\u8868\u793a")) {
            this.target.setConnectorPaintMode(!this.target.isConnectorPaintMode());
            this.target.repaint();
        } else if (label.equals("polyhedron")) {
            Piece.polyhedronRendering = !Piece.polyhedronRendering;
            this.target.repaint();
        } else if (label.equals("stitch")) {
            this.target.setStitchRendering(!this.target.isStitchRendering());
            this.target.repaint();
        } else if (label.equals("black") || label.equals("\u9ed2")) {
            this.target.setClothColor(Color.black);
        } else if (label.equals("red")) {
            this.target.setClothColor(Color.red);
        } else if (label.equals("blue")) {
            this.target.setClothColor(Color.blue);
        } else if (label.equals("pink")) {
            this.target.setClothColor(Color.pink);
        } else if (label.equals("white") || label.equals("\u767d")) {
            this.target.setClothColor(Color.white);
        } else if (label.equals("yellow")) {
            this.target.setClothColor(Color.yellow);
        } else if (label.equals("default") || label.equals("\u521d\u671f\u8a2d\u5b9a\u8272")) {
            this.target.setClothColor(Piece.REVERSE_COLOR);
        }
    }

    class MyMenuItem
    extends MenuItem {
        MyMenuItem(String label, ActionListener listener) {
            this.setLabel(label);
            this.addActionListener(listener);
        }
    }
}

