/*
 * Decompiled with CFR 0.152.
 */
package pattern;

import java.awt.Color;
import java.awt.Graphics;
import java.util.List;
import pattern.Graphics2;
import pattern.Piece;
import pattern.StrokeAnalyzer;
import teddy.Vector2;
import teddy.Vertex2D;

public class Mark {
    public List points;
    public Piece piece;
    public static final int MARK_WIDTH = 6;

    public Mark(Piece piece, List stroke) {
        this.piece = piece;
        this.points = StrokeAnalyzer.resample(stroke, 10);
    }

    public void paint(Graphics g) {
        g.setColor(Color.red);
        if (!this.piece.reversed) {
            Graphics2.paint_wide_stroke(g, this.points, 6.0);
        } else {
            Graphics2.paint_wide_dotted_stroke(g, this.points, 6.0);
        }
        this.paint_arrow_head((Vertex2D)this.points.get(this.points.size() - 1), new Vector2((Vector2)((Vertex2D)this.points.get(this.points.size() - 1)), (Vector2)((Vertex2D)this.points.get(this.points.size() - 3))), g);
    }

    public void paint_arrow_head(Vertex2D v, Vector2 vec, Graphics g) {
        vec.normalize();
        Vector2 cross = Vector2.rotate90((Vector2)vec);
        Vertex2D base = Vertex2D.translate((Vertex2D)v, (Vector2)Vector2.multiply((Vector2)vec, (double)20.0));
        Vertex2D v0 = Vertex2D.translate((Vertex2D)base, (Vector2)Vector2.multiply((Vector2)cross, (double)10.0));
        Vertex2D v1 = Vertex2D.translate((Vertex2D)base, (Vector2)Vector2.multiply((Vector2)cross, (double)-10.0));
        Graphics2.drawWideLine(g, (int)v.x, (int)v.y, (int)v0.x, (int)v0.y, 6.0);
        Graphics2.drawWideLine(g, (int)v.x, (int)v.y, (int)v1.x, (int)v1.y, 6.0);
    }

    public void slide(Vector2 dv) {
        int i = 0;
        while (i < this.points.size()) {
            Vertex2D v = (Vertex2D)this.points.get(i);
            v.x += dv.x;
            v.y += dv.y;
            ++i;
        }
    }

    public void scale(Vertex2D center, double ratio) {
        int i = 0;
        while (i < this.points.size()) {
            Vertex2D v = (Vertex2D)this.points.get(i);
            v.x = center.x + (v.x - center.x) * ratio;
            v.y = center.y + (v.y - center.y) * ratio;
            ++i;
        }
    }

    public void reverse(int axis_x) {
        int i = 0;
        while (i < this.points.size()) {
            Vertex2D v = (Vertex2D)this.points.get(i);
            v.x = (double)axis_x - (v.x - (double)axis_x);
            ++i;
        }
    }
}

