/*
 * Decompiled with CFR 0.152.
 */
package pattern;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.List;
import teddy.Vector2;
import teddy.Vertex2D;

public class Graphics2 {
    public static void drawRect(Graphics g, Rectangle box) {
        g.draw3DRect(box.x, box.y, box.width, box.height, true);
    }

    public static void drawWideLine(Graphics g, double x1, double y1, double x2, double y2, double w) {
        Graphics2.drawWideLine(g, (int)x1, (int)y1, (int)x2, (int)y2, w);
    }

    public static void drawWideLine(Graphics g, int x1, int y1, int x2, int y2, double w) {
        int x = x2 - x1;
        int y = y2 - y1;
        double length = Math.sqrt(x * x + y * y);
        double nx = (double)x / length * w / 2.0;
        double ny = (double)y / length * w / 2.0;
        Point start = new Point(x1, y1);
        Point end = new Point(x2, y2);
        Vector2 vector = new Vector2(nx, ny);
        Polygon s = new Polygon();
        Graphics2.addPoint(s, start, Vector2.rotate((Vector2)vector, (double)90.0));
        Graphics2.addPoint(s, start, Vector2.rotate((Vector2)vector, (double)135.0));
        Graphics2.addPoint(s, start, Vector2.rotate((Vector2)vector, (double)180.0));
        Graphics2.addPoint(s, start, Vector2.rotate((Vector2)vector, (double)225.0));
        Graphics2.addPoint(s, start, Vector2.rotate((Vector2)vector, (double)270.0));
        Graphics2.addPoint(s, end, Vector2.rotate((Vector2)vector, (double)270.0));
        Graphics2.addPoint(s, end, Vector2.rotate((Vector2)vector, (double)315.0));
        Graphics2.addPoint(s, end, Vector2.rotate((Vector2)vector, (double)0.0));
        Graphics2.addPoint(s, end, Vector2.rotate((Vector2)vector, (double)45.0));
        Graphics2.addPoint(s, end, Vector2.rotate((Vector2)vector, (double)90.0));
        Graphics2.addPoint(s, start, Vector2.rotate((Vector2)vector, (double)90.0));
        g.fillPolygon(s);
    }

    static void addPoint(Polygon s, Point p, Vector2 v) {
        s.addPoint((int)((double)p.x + v.x), (int)((double)p.y + v.y));
    }

    public static void drawWideCircle(Graphics g, int x, int y, int radius, int w) {
        int i = radius - w / 2;
        while (i < radius + w / 2) {
            g.drawOval(x - i, y - i, i * 2 - 1, i * 2 - 1);
            ++i;
        }
    }

    public static void drawLine(Graphics g, int x1, int y1, int x2, int y2) {
        Graphics2.drawWideLine(g, x1, y1, x2, y2, 4.0);
    }

    public static void paint_wide_stroke(Graphics g, List points, double w) {
        int i = 0;
        while (i < points.size() - 1) {
            Vertex2D p = (Vertex2D)points.get(i);
            Vertex2D q = (Vertex2D)points.get(i + 1);
            Graphics2.drawWideLine(g, (int)p.x, (int)p.y, (int)q.x, (int)q.y, w);
            ++i;
        }
    }

    public static void paint_wide_dotted_stroke(Graphics g, List points, double w) {
        int i = 0;
        while (i < points.size() - 1) {
            Vertex2D p = (Vertex2D)points.get(i);
            Vertex2D q = (Vertex2D)points.get(i + 1);
            q = Vertex2D.interporate((Vertex2D)p, (Vertex2D)q, (double)0.6);
            Graphics2.drawWideLine(g, (int)p.x, (int)p.y, (int)q.x, (int)q.y, w);
            ++i;
        }
    }
}

