/*
 * Decompiled with CFR 0.152.
 */
package pattern;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import pattern.Connector;
import pattern.Piece;
import pattern.Seam;

public class File {
    public static void save(Frame frame, List pieces) {
        FileDialog fileDialog = new FileDialog(frame, "Save Model", 1);
        fileDialog.setDirectory(".\\");
        fileDialog.setFile("*.ptn");
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            String filename = String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile();
            File.save(pieces, filename);
        }
        fileDialog.dispose();
    }

    public static List load(Frame frame) {
        List pieces = null;
        FileDialog fileDialog = new FileDialog(frame, "Load Model", 0);
        fileDialog.setDirectory(".\\");
        fileDialog.setFile("shirt.ptn");
        fileDialog.setFile("*.ptn");
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            String filename = String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile();
            pieces = File.load(filename);
        }
        fileDialog.dispose();
        return pieces;
    }

    public static void save(List pieces, String filename) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            int i = 0;
            while (i < pieces.size()) {
                ((Piece)pieces.get(i)).save(out);
                ++i;
            }
            File.save_connectors(pieces, out);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            System.out.print("IO Error " + e);
        }
    }

    public static List load(String filename) {
        ArrayList<Piece> pieces = new ArrayList<Piece>();
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(filename));
            while ((line = in.readLine()) != null && line.equals("piece")) {
                Piece piece = new Piece(in);
                pieces.add(piece);
            }
            File.load_connectors(pieces, in);
            in.close();
        }
        catch (IOException e) {
            System.out.print("IO Error " + e);
        }
        return pieces;
    }

    public static void save_connectors(List pieces, BufferedWriter out) throws IOException {
        Seam seam;
        int j;
        Piece piece;
        out.write("connectors");
        out.newLine();
        Hashtable<Seam, Integer> seam_number = new Hashtable<Seam, Integer>();
        int n = 0;
        int i = 0;
        while (i < pieces.size()) {
            piece = (Piece)pieces.get(i);
            j = 0;
            while (j < piece.seams.size()) {
                seam = (Seam)piece.seams.get(j);
                seam_number.put(seam, new Integer(n++));
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < pieces.size()) {
            piece = (Piece)pieces.get(i);
            j = 0;
            while (j < piece.seams.size()) {
                seam = (Seam)piece.seams.get(j);
                Connector connector = seam.getConnector();
                if (connector != null) {
                    out.write(seam_number.get(seam) + " " + seam_number.get(connector.get_opposite_seam(seam)));
                    out.newLine();
                }
                ++j;
            }
            ++i;
        }
    }

    public static void load_connectors(List pieces, BufferedReader in) throws IOException {
        String line;
        Vector<Seam> seams = new Vector<Seam>();
        int i = 0;
        while (i < pieces.size()) {
            Piece piece = (Piece)pieces.get(i);
            int j = 0;
            while (j < piece.seams.size()) {
                Seam seam = (Seam)piece.seams.get(j);
                seams.addElement(seam);
                ++j;
            }
            ++i;
        }
        while ((line = in.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(line);
            int n0 = new Integer(st.nextToken());
            int n1 = new Integer(st.nextToken());
            Seam seam0 = (Seam)seams.elementAt(n0);
            Seam seam1 = (Seam)seams.elementAt(n1);
            Connector connector = new Connector(seam0, seam1);
        }
    }
}

