/*
 * Decompiled with CFR 0.152.
 */
package pattern;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import pattern.Connector;
import pattern.Cost;
import pattern.File;
import pattern.Geometry;
import pattern.Graphics2;
import pattern.Mark;
import pattern.Piece;
import pattern.Pull;
import pattern.Seam;
import pattern.Smoother;
import pattern.StrokeAnalyzer;
import pattern.TapeDrawing;
import pattern.ZoomControl;
import sweater.Cursors;
import sweater.Model;
import sweater.Sweater;
import teddy.Inflate;
import teddy.Vector2;
import teddy.Vertex;
import teddy.Vertex2D;

public class DrawPanel
extends Panel {
    private Sweater sweater;
    public static List seams;
    public static List connectores;
    private boolean layoutMode = true;
    private boolean sewNumberRendering = false;
    private boolean pieceNumberRendering = false;
    private boolean mergeSeamsMode = true;
    private boolean drawMode = false;
    private boolean connectorPaintMode = false;
    private boolean stitchRendering = false;
    private static final int PANEL_SIZE_X = 512;
    private static final int PANEL_SIZE_Y = 630;
    private static final DrawPanel INSTANCE;
    ZoomControl zoomControl;
    static Vertex2D debug_circle;
    Image buffered_image = null;
    List debug_list = new ArrayList();
    public TapeDrawing tapeDrawing;
    public List marks = new ArrayList();
    public static List pieces;
    public boolean laser = false;
    public Vertex2D snap_vertex;
    public Seam snap_seam;
    public Mark snap_mark;
    public Point prev_p;
    Vertex2D dragged_vertex;
    public static Seam dragged_seam;
    public static int UNIT_LENGTH;
    double travel_length;
    Smoother smoother;
    Pull pull;
    Vertex2D prev_v;
    public static Piece dragged_piece;
    List mark_stroke;
    Point current_p;
    public int status;
    public final int NONE = 0;
    public final int DRAWING = 1;
    public final int TAPEDRAWING = 2;
    public final int DRAGGING = 3;
    public final int PIECE_DRAGGING = 4;
    public final int CONNECTING = 5;
    public final int ZOOMING = 6;
    public final int SLIDING = 7;
    public final int MARK_DRAWING = 8;
    public final int PULLING = 9;
    public final int SMOOTHING = 10;
    public final int DEFORMING = 11;
    public final int PULLING_ON_VERTEX = 12;

    static {
        connectores = new ArrayList();
        INSTANCE = new DrawPanel();
        debug_circle = null;
        pieces = new ArrayList();
        UNIT_LENGTH = 2;
    }

    public static DrawPanel getInstance() {
        return INSTANCE;
    }

    private DrawPanel() {
        MouseDispatcher mouseDispatcher = new MouseDispatcher();
        this.addMouseListener(mouseDispatcher);
        this.addMouseMotionListener(mouseDispatcher);
        this.addKeyListener(mouseDispatcher);
        this.tapeDrawing = new TapeDrawing(this);
        this.zoomControl = new ZoomControl(this);
    }

    void setSweater(Sweater sweater) {
        this.sweater = sweater;
    }

    public Dimension getPreferredSize() {
        return new Dimension(512, 630);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        if (this.buffered_image == null || this.buffered_image.getWidth(null) != this.getSize().width || this.buffered_image.getHeight(null) != this.getSize().height) {
            this.buffered_image = this.createImage(this.getSize().width, this.getSize().height);
        }
        Graphics bg = this.buffered_image.getGraphics();
        bg.setColor(Color.white);
        bg.fillRect(0, 0, this.getSize().width, this.getSize().height);
        this.paintPieces(bg);
        this.tapeDrawing.paint(bg);
        this.paintSnap(bg);
        this.paint_connecting(bg);
        this.paint_mark_drawing(bg);
        this.paint_texts(bg);
        this.paint_making_time(bg);
        if (this.pieceNumberRendering) {
            this.paint_patch_number(bg);
        }
        if (this.sewNumberRendering) {
            this.paintSewNumbers(bg);
        }
        if (debug_circle != null) {
            bg.setColor(Color.red);
            bg.fillOval((int)DrawPanel.debug_circle.x - 10, (int)DrawPanel.debug_circle.y - 10, 20, 20);
        }
        this.zoomControl.paint(bg);
        this.paint_pulling_list(bg);
        bg.dispose();
        g.drawImage(this.buffered_image, 0, 0, this);
    }

    private void paint_pulling_list(Graphics g) {
        int i = 0;
        while (i < Pull.pulls.size()) {
            Pull pull = (Pull)Pull.pulls.get(i);
            pull.display(g);
            ++i;
        }
    }

    private void paint_making_time(Graphics g) {
        int total_time = 0;
        int total_sewing_time = 0;
        double total_length = 0.0;
        int total_stitch = 0;
        if (seams == null) {
            return;
        }
        int count_knot = seams.size();
        int i = 0;
        while (i < seams.size()) {
            Seam seam = (Seam)seams.get(i);
            total_time += Cost.cost(seam);
            total_sewing_time += Cost.sewingCost(seam);
            total_length += seam.get_length();
            total_stitch += seam.getStitchSize();
            ++i;
        }
        Font font = new Font("Helvetica", 0, 24);
        g.setFont(font);
        g.drawString("time:" + total_time * 2 / 60 + "min ", 0, this.getHeight() - 50);
    }

    private void paintSewNumbers(Graphics g) {
        g.setColor(Color.BLUE);
        g.setFont(new Font("Helvetica", 0, 24));
        int i = 0;
        while (i < connectores.size()) {
            Connector connector = (Connector)connectores.get(i);
            Seam seam0 = connector.getSeam0();
            Vertex2D coord = seam0.get_mid_point();
            g.drawString("" + i, (int)coord.x, (int)coord.y);
            Seam seam1 = connector.getSeam1();
            coord = seam1.get_mid_point();
            g.drawString("" + i, (int)coord.x, (int)coord.y);
            ++i;
        }
    }

    private void paint_texts(Graphics g) {
        if (this.laser) {
            g.setColor(Color.red);
            g.setFont(new Font("Helvetica", 0, 16));
            g.drawString("LASER", 10, 36);
        }
    }

    private void paint_patch_number(Graphics g) {
        g.setColor(Color.MAGENTA);
        g.setFont(new Font("Helvetica", 0, 24));
        int i = 0;
        while (i < pieces.size()) {
            Piece piece = (Piece)pieces.get(i);
            piece.id = i++;
            Vertex2D center = piece.get_center();
            g.drawString("" + piece.id, (int)center.x, (int)center.y);
        }
    }

    private void paintPieces(Graphics g) {
        Piece piece;
        int i = 0;
        while (i < pieces.size()) {
            piece = (Piece)pieces.get(i);
            piece.prepare_paint();
            ++i;
        }
        i = 0;
        while (i < pieces.size()) {
            piece.paint(g, (piece = (Piece)pieces.get(i)) == dragged_piece);
            int j = 0;
            while (j < piece.marks.size()) {
                Mark mark = (Mark)piece.marks.get(j);
                mark.paint(g);
                ++j;
            }
            ++i;
        }
    }

    public void clear() {
        this.status = 0;
        this.tapeDrawing.finish();
        if (this.marks.size() != 0) {
            this.clear_marks();
            return;
        }
        this.marks = new ArrayList();
        pieces = new ArrayList();
        connectores = new ArrayList();
        seams = new ArrayList();
        this.repaint();
    }

    public void clear_marks() {
        this.marks = new ArrayList();
        int i = 0;
        while (i < pieces.size()) {
            Piece piece = (Piece)pieces.get(i);
            piece.marks = new ArrayList();
            ++i;
        }
        this.repaint();
    }

    public void mergeSeams() {
        int i = 0;
        while (i < pieces.size()) {
            Piece piece = (Piece)pieces.get(i);
            piece.merge_seams();
            ++i;
        }
    }

    public void layout() {
        Piece piece;
        double margin;
        double layout_size_x = this.getWidth();
        double target_x = margin = 8.0;
        double target_y = margin;
        double target_y_temp = 0.0;
        ArrayList<Piece> pieces_for_layout = new ArrayList<Piece>();
        int i = 0;
        while (i < pieces.size()) {
            pieces_for_layout.add((Piece)pieces.get(i));
            ++i;
        }
        while ((piece = DrawPanel.get_min_height_piece(pieces_for_layout)) != null) {
            Rectangle piece_bbox = piece.get_bbox();
            if (target_x + (double)piece_bbox.x > layout_size_x) {
                target_x = margin;
                target_y = target_y_temp + margin;
            }
            Vector2 move = new Vector2(target_x - (double)piece_bbox.x, target_y - (double)piece_bbox.y);
            piece.translate(move);
            if (target_y_temp < target_y + piece_bbox.getHeight()) {
                target_y_temp = target_y + piece_bbox.getHeight();
            }
            target_x = target_x + piece_bbox.getWidth() + margin;
        }
        this.repaint();
    }

    private static Piece get_min_height_piece(List pieces_for_layout) {
        double min_height = Double.MAX_VALUE;
        Piece min_height_piece = null;
        int i = 0;
        while (i < pieces_for_layout.size()) {
            Piece piece = (Piece)pieces_for_layout.get(i);
            Rectangle bbox = piece.get_bbox();
            if (min_height > (double)bbox.height) {
                min_height = bbox.height;
                min_height_piece = piece;
            }
            ++i;
        }
        pieces_for_layout.remove(min_height_piece);
        return min_height_piece;
    }

    private void sort_pieces() {
        int i = 0;
        while (i < pieces.size()) {
            System.out.println("i=" + i);
            int index = this.piece_of_min_height(i);
            if (index != -1) {
                Piece temp_piece = (Piece)pieces.get(i);
                pieces.add(i, (Piece)pieces.get(index));
                pieces.add(index, temp_piece);
            }
            ++i;
        }
    }

    public void setClothColor(Color col) {
        if (dragged_piece == null) {
            return;
        }
        DrawPanel.dragged_piece.color = col;
        Model model = Sweater.sweater.getPickedModel();
        model.init_patches();
        model.setITA();
        Sweater.sweater.repaint();
        this.repaint();
    }

    private int piece_of_min_height(int index) {
        double min_height = Double.MAX_VALUE;
        int min_piece_index = -1;
        int i = index + 1;
        while (i < pieces.size()) {
            Piece piece = (Piece)pieces.get(i);
            Rectangle bbox = piece.get_bbox();
            if (min_height > (double)bbox.height) {
                min_height = bbox.height;
                min_piece_index = i;
            }
            ++i;
        }
        return min_piece_index;
    }

    public void delete() {
        if (dragged_piece == null) {
            return;
        }
        this.delete_piece(dragged_piece);
        dragged_piece = null;
        this.repaint();
    }

    public void delete_piece(Piece piece) {
        piece.delete();
        pieces.remove(piece);
        int i = 0;
        while (i < piece.marks.size()) {
            Mark mark = (Mark)piece.marks.get(i);
            this.marks.remove(mark);
            ++i;
        }
    }

    public void reverse() {
        if (dragged_piece == null) {
            return;
        }
        dragged_piece.reverse();
        pieces.remove(dragged_piece);
        if (DrawPanel.dragged_piece.reversed) {
            pieces.add(0, dragged_piece);
        } else {
            pieces.add(dragged_piece);
        }
        this.repaint();
    }

    public void flip() {
        if (dragged_piece == null) {
            return;
        }
        Piece piece = dragged_piece.get_flipped();
        this.stitch_corresponding_seams(dragged_piece, piece);
        if (piece.reversed) {
            pieces.add(0, piece);
        } else {
            pieces.add(piece);
        }
        dragged_piece = piece;
        this.repaint();
    }

    public void symmetry() {
        if (dragged_piece == null) {
            return;
        }
        dragged_piece.symmetrize();
        this.repaint();
    }

    public void laser() {
        this.laser = !this.laser;
        this.repaint();
        this.sweater.laser = this.laser;
        this.sweater.repaint();
    }

    public void save() {
        File.save((Frame)this.getParent(), pieces);
    }

    public void load() {
        List loaded_pieces = File.load((Frame)this.getParent());
        if (loaded_pieces != null) {
            pieces = loaded_pieces;
            this.repaint();
        }
    }

    static void makeSeamsList() {
        seams = new ArrayList();
        int i = 0;
        while (i < pieces.size()) {
            Piece piece = (Piece)pieces.get(i);
            int j = 0;
            while (j < piece.seams.size()) {
                Seam seam = (Seam)piece.seams.get(j);
                seams.add(seam);
                ++j;
            }
            ++i;
        }
    }

    private static void setSeamNumbers() {
        int i = 0;
        while (i < seams.size()) {
            Seam seam = (Seam)seams.get(i);
            seam.setSewIndex(i);
            ++i;
        }
    }

    public static void setSewNumbers() {
        DrawPanel.makeSeamsList();
        DrawPanel.setSeamNumbers();
    }

    public void highlight_snap(Point p) {
        Vertex2D prev_snap_vertex = this.snap_vertex;
        Seam prev_snap_seam = this.snap_seam;
        Mark prev_snap_mark = this.snap_mark;
        this.snap_vertex = this.find_snap_vertex(p);
        this.snap_mark = this.snap_vertex == null ? this.pick_mark(p) : null;
        this.snap_seam = this.snap_vertex == null && this.snap_mark == null ? DrawPanel.pick_seam(p) : null;
        if (prev_snap_vertex != this.snap_vertex || prev_snap_seam != this.snap_seam || prev_snap_mark != this.snap_mark) {
            this.repaint();
        }
    }

    public Vertex2D find_snap_vertex(Point p) {
        Vertex2D next_snap_vertex = null;
        int j = 0;
        while (j < pieces.size()) {
            Piece piece = (Piece)pieces.get(j);
            List seams = piece.seams;
            int i = 0;
            while (i < seams.size()) {
                Seam seam = (Seam)seams.get(i);
                next_snap_vertex = this.highlight_snap_sub(seam.start, p);
                if (next_snap_vertex != null || (next_snap_vertex = this.highlight_snap_sub(seam.end, p)) != null) break;
                ++i;
            }
            if (next_snap_vertex != null) break;
            ++j;
        }
        return next_snap_vertex;
    }

    public Vertex2D highlight_snap_sub(Vertex2D v, Point p) {
        if (v == this.dragged_vertex) {
            return null;
        }
        if (Vertex2D.distance((Vertex2D)v, (Point)p) < 8.0) {
            return v;
        }
        return null;
    }

    public void paintSnap(Graphics g) {
        if (this.snap_vertex != null) {
            this.paintSnapVertex(g);
        } else if (this.snap_mark != null) {
            this.paintSnapMark(g);
        } else if (this.snap_seam != null) {
            this.paintSnapSeam(g);
        } else if (this.dragged_vertex != null) {
            this.paintDraggedVertex(g);
        }
    }

    public void paintSnapVertex(Graphics g) {
        g.setColor(Color.red);
        int r = 8;
        g.drawOval((int)this.snap_vertex.x - r, (int)this.snap_vertex.y - r, 2 * r, 2 * r);
    }

    public void paintDraggedVertex(Graphics g) {
        g.setColor(Color.CYAN);
        int r = 8;
        g.drawOval((int)this.dragged_vertex.x - r, (int)this.dragged_vertex.y - r, 2 * r, 2 * r);
    }

    public void paintSnapSeam(Graphics g) {
        g.setColor(Color.red);
        List stroke0 = StrokeAnalyzer.get_shifted(this.snap_seam.getStroke(), 2.0);
        StrokeAnalyzer.paint_stroke(stroke0, g);
        List stroke1 = StrokeAnalyzer.get_shifted(this.snap_seam.getStroke(), -2.0);
        StrokeAnalyzer.paint_stroke(stroke1, g);
    }

    public void paintSnapMark(Graphics g) {
        g.setColor(Color.red);
        List stroke0 = StrokeAnalyzer.get_shifted(this.snap_mark.points, 3.0);
        StrokeAnalyzer.paint_stroke(stroke0, g);
        List stroke1 = StrokeAnalyzer.get_shifted(this.snap_mark.points, -3.0);
        StrokeAnalyzer.paint_stroke(stroke1, g);
    }

    public void reset_snap() {
        this.snap_vertex = null;
        this.snap_seam = null;
        this.snap_mark = null;
    }

    public void startTapeDrawing(Point p) {
        dragged_piece = null;
        this.tapeDrawing.start(p);
        this.repaint();
    }

    public void finishTapeDrawing() {
        List strokes = this.tapeDrawing.get_strokes();
        if (strokes.size() == 0) {
            this.finishTapeDrawing_click();
        } else if (Vertex2D.distance((Vertex2D)this.tapeDrawing.first_point, (Vertex2D)this.tapeDrawing.last_point) > 20.0) {
            this.finishTapeDrawing_line(strokes);
        } else {
            this.finishTapeDrawing_piece(strokes);
        }
        this.tapeDrawing.finish();
        this.repaint();
    }

    public void finishTapeDrawing_piece(List strokes) {
        List seams = this.get_seams(strokes);
        seams = Piece.adjust_loop_direction(seams);
        Piece new_piece = new Piece(seams);
        pieces.add(new_piece);
        dragged_piece = new_piece;
        this.flip();
        this.reverse();
    }

    public List get_seams(List strokes) {
        ArrayList<Seam> seams = new ArrayList<Seam>();
        int i = 0;
        while (i < strokes.size()) {
            List stroke = (List)strokes.get(i);
            stroke = StrokeAnalyzer.resample(stroke, 10);
            seams.add(new Seam(stroke));
            ++i;
        }
        return seams;
    }

    public void finishTapeDrawing_click() {
        Vertex2D v = this.find_snap_vertex(this.tapeDrawing.last_point.point());
        if (v != null) {
            Piece piece = v.prev_seam.getPiece();
            piece.merge_seams(this.snap_vertex);
            return;
        }
        Vertex2D p = this.tapeDrawing.last_point;
        Seam seam = DrawPanel.pick_seam(p.point());
        if (seam != null) {
            Piece piece = seam.getPiece();
            piece.cut_seam(seam, p);
            return;
        }
    }

    public void finishTapeDrawing_line(List strokes) {
        Vertex2D start = this.find_snap_vertex(this.tapeDrawing.first_point.point());
        Vertex2D end = this.find_snap_vertex(this.tapeDrawing.last_point.point());
        if (start == null || end == null) {
            Seam seam0 = DrawPanel.pick_seam(this.tapeDrawing.first_point.point());
            Seam seam1 = DrawPanel.pick_seam(this.tapeDrawing.last_point.point());
            if (seam0 != null && seam1 != null && seam0 != seam1) {
                this.set_connector(seam0, seam1);
            }
            return;
        }
        List seams = this.get_seams(strokes);
        Piece piece = start.prev_seam.getPiece();
        Piece[] new_pieces = piece.cut_piece(start, end, seams);
        if (new_pieces == null) {
            return;
        }
        this.delete_piece(piece);
        pieces.add(new_pieces[0]);
        pieces.add(new_pieces[1]);
    }

    public void set_connector(Seam seam0, Seam seam1) {
        Connector seam0Connector = seam0.getConnector();
        Connector seam1Connector = seam1.getConnector();
        if (seam0Connector != null && seam0Connector == seam1Connector) {
            seam0Connector.delete();
        } else {
            Connector connector = new Connector(seam0, seam1);
        }
    }

    public boolean start_dragging(Point p) {
        if (this.snap_vertex == null) {
            return false;
        }
        this.dragged_vertex = this.snap_vertex;
        this.prev_p = p;
        dragged_piece = this.dragged_vertex.prev_seam.getPiece();
        return true;
    }

    public void dragging(Point p) {
        Vector2 vec = new Vector2(this.prev_p, p);
        this.dragged_vertex.add(vec);
        if (this.snap_vertex != null) {
            this.dragged_vertex.warp(this.snap_vertex);
        }
        this.adjust_length(this.dragged_vertex.prev_seam, true);
        this.repaint();
        this.prev_p = p;
    }

    public void finish_dragging() {
        Vertex v = this.dragged_vertex.getVertex();
        v.setPatternCoord(this.dragged_vertex.x, this.dragged_vertex.y);
        this.dragged_vertex = null;
    }

    public void adjust_length(Seam seam, boolean dragging_start) {
        Connector connector = seam.getConnector();
        if (connector == null) {
            return;
        }
        Seam seam0 = connector.get_opposite_seam(seam);
        Vertex2D v = dragging_start ? seam0.start : seam0.end;
        Seam seam1 = v.get_opposite_seam(seam0);
        double target_length = seam.get_length();
        double current_length = seam0.get_length();
        double length0 = Vertex2D.distance((Vertex2D)seam0.start, (Vertex2D)seam0.end) * target_length / current_length;
        double length1 = Vertex2D.distance((Vertex2D)seam1.start, (Vertex2D)seam1.end);
        Vertex2D base0 = seam0.get_opposite_vertex(v);
        Vertex2D base1 = seam1.get_opposite_vertex(v);
        Vertex2D cross = Geometry.cross_of_two_circles(base0, length0, base1, length1, v);
        v.warp(cross);
    }

    public void meshBeautify() {
        int i = 0;
        while (i < pieces.size()) {
            Piece piece = (Piece)pieces.get(i);
            piece.beautify();
            ++i;
        }
    }

    public void start_smoothing(Point p) {
        Vertex2D v;
        DrawPanel.getInstance().setCursor(Cursors.fingerCursor);
        this.travel_length = 0.0;
        if (this.snap_seam == null) {
            return;
        }
        dragged_seam = this.snap_seam;
        dragged_piece = dragged_seam.getPiece();
        this.prev_v = v = new Vertex2D(p);
        this.pull = Pull.prepare_start_pulling(v, dragged_seam);
        this.smoother = new Smoother(v, this.pull.getStroke());
    }

    public void smoothing(Point p) {
        System.out.println("smoothing");
        Vertex2D v = new Vertex2D(p);
        this.travel_length = Vertex2D.distance((Vertex2D)this.prev_v, (Vertex2D)v);
        this.prev_v = v;
        this.smoother.smooth(v);
        dragged_piece.beautify();
        this.repaint();
    }

    public void finish_smoothing() {
        if (this.pull != null) {
            this.pull.finish_pulling();
            DrawPanel.getInstance().setCursor(Cursors.defaultCursor);
            this.pull = null;
        }
        Model model = Sweater.sweater.getPickedModel();
        Inflate.update_target_length((Model)model);
    }

    public void piecesSmoothing() {
        System.out.println("pieceSmoothing");
        int i = 0;
        while (i < pieces.size()) {
            Piece piece = (Piece)pieces.get(i);
            piece.outsideVerticesSmoothing();
            ++i;
        }
    }

    public boolean start_piece_dragging(Point p) {
        dragged_piece = this.pick_piece(p);
        if (dragged_piece == null) {
            return false;
        }
        this.prev_p = p;
        return true;
    }

    public void piece_dragging(Point p) {
        Vector2 vec = new Vector2(this.prev_p, p);
        dragged_piece.translate(vec);
        int i = 0;
        while (i < DrawPanel.dragged_piece.marks.size()) {
            Mark mark = (Mark)DrawPanel.dragged_piece.marks.get(i);
            mark.slide(vec);
            ++i;
        }
        this.repaint();
        this.prev_p = p;
    }

    public void finish_piece_dragging() {
    }

    public Piece pick_piece(Point p) {
        Piece picked_piece = null;
        int i = 0;
        while (i < pieces.size()) {
            Piece piece = (Piece)pieces.get(i);
            if (piece.inside(p)) {
                picked_piece = piece;
            }
            ++i;
        }
        return picked_piece;
    }

    public Piece pick_reversed_piece(Point p) {
        Piece picked_piece = null;
        int i = 0;
        while (i < pieces.size()) {
            Piece piece = (Piece)pieces.get(i);
            if (piece.reversed && piece.inside(p)) {
                picked_piece = piece;
            }
            ++i;
        }
        return picked_piece;
    }

    public boolean start_zooming(Point p) {
        if (!this.zoomControl.bbox.contains(p)) {
            return false;
        }
        this.prev_p = p;
        this.zoomControl.pressed = true;
        this.repaint();
        return true;
    }

    public void zooming(Point p) {
        int dx = p.x - this.prev_p.x;
        this.prev_p = p;
        double ratio = Math.pow(1.01, dx);
        Vertex2D center = new Vertex2D((double)(this.getSize().width / 2), (double)(this.getSize().height / 2));
        int i = 0;
        while (i < pieces.size()) {
            Piece piece = (Piece)pieces.get(i);
            piece.zoom(center, ratio);
            ++i;
        }
        i = 0;
        while (i < this.marks.size()) {
            Mark mark = (Mark)this.marks.get(i);
            mark.scale(center, ratio);
            ++i;
        }
        this.repaint();
    }

    public void finish_zooming() {
        this.zoomControl.pressed = false;
    }

    public void start_sliding(Point p) {
        this.prev_p = p;
    }

    public void sliding(Point p) {
        Vector2 dv = new Vector2(this.prev_p, p);
        this.prev_p = p;
        int i = 0;
        while (i < pieces.size()) {
            Piece piece = (Piece)pieces.get(i);
            piece.sliding(dv);
            ++i;
        }
        i = 0;
        while (i < this.marks.size()) {
            Mark mark = (Mark)this.marks.get(i);
            mark.slide(dv);
            ++i;
        }
        this.repaint();
    }

    public boolean start_mark_drawing(Point p) {
        if (this.snap_vertex != null || this.snap_seam != null) {
            return false;
        }
        Piece piece = this.pick_piece(p);
        if (piece == null) {
            return false;
        }
        dragged_piece = piece;
        this.mark_stroke = new ArrayList();
        this.mark_stroke.add(new Vertex2D(p));
        return true;
    }

    public void mark_drawing(Point p) {
        this.mark_stroke.add(new Vertex2D(p));
        this.repaint();
    }

    public void paint_mark_drawing(Graphics g) {
        if (this.mark_stroke == null) {
            return;
        }
        g.setColor(Color.red);
        Graphics2.paint_wide_stroke(g, this.mark_stroke, 6.0);
    }

    public void finish_mark_drawing() {
        if (this.mark_stroke.size() < 3 && this.snap_mark != null) {
            this.marks.remove(this.snap_mark);
            this.snap_mark.piece.marks.remove(this.snap_mark);
            this.snap_mark = null;
        } else if (StrokeAnalyzer.get_length(this.mark_stroke) >= 20.0) {
            Piece piece;
            Mark mark = new Mark(dragged_piece, this.mark_stroke);
            this.marks.add(mark);
            DrawPanel.dragged_piece.marks.add(mark);
            if (this.laser && (piece = this.pick_reversed_piece(((Vertex2D)this.mark_stroke.get(0)).point())) != null && piece != dragged_piece) {
                mark = new Mark(piece, StrokeAnalyzer.duplicate_stroke(this.mark_stroke));
                this.marks.add(mark);
                piece.marks.add(mark);
            }
        }
        this.mark_stroke = null;
    }

    public Mark pick_mark(Point p) {
        Vertex2D v = new Vertex2D(p);
        Mark closest = null;
        double min = -1.0;
        int i = 0;
        while (i < this.marks.size()) {
            Mark mark = (Mark)this.marks.get(i);
            double d = StrokeAnalyzer.distance(mark.points, v);
            if (min == -1.0 || d < min) {
                min = d;
                closest = mark;
            }
            ++i;
        }
        if (min < 10.0) {
            return closest;
        }
        return null;
    }

    public void start_connecting(Point p) {
        this.prev_p = this.current_p = p;
    }

    public void connecting(Point p) {
        this.current_p = p;
        this.repaint();
    }

    public void finish_connecting() {
        Point end_p = this.current_p;
        this.current_p = null;
        if (Vertex2D.distance((Point)this.prev_p, (Point)end_p) < 10.0) {
            Piece piece = this.snap_seam.getPiece();
            piece.cut_seam(this.snap_seam, new Vertex2D(end_p));
            return;
        }
        Seam child_seam = DrawPanel.pick_seam(this.prev_p);
        Seam parent_seam = DrawPanel.pick_seam(end_p);
        if (child_seam == null || parent_seam == null || child_seam == parent_seam) {
            return;
        }
        this.set_connector(child_seam, parent_seam);
        this.repaint();
    }

    void stitch_corresponding_seams(Piece piece0, Piece piece1) {
        int i = 0;
        while (i < piece0.seams.size()) {
            this.set_connector((Seam)piece0.seams.get(i), (Seam)piece1.seams.get(piece1.seams.size() - i - 1));
            ++i;
        }
    }

    public void paint_connecting(Graphics g) {
        if (this.current_p == null) {
            return;
        }
        g.setColor(Color.gray);
        Graphics2.drawWideLine(g, this.prev_p.x, this.prev_p.y, this.current_p.x, this.current_p.y, 4.0);
    }

    public static Seam pick_seam(Point p) {
        Seam closest = null;
        double min = -1.0;
        int i = 0;
        while (i < pieces.size()) {
            Piece piece = (Piece)pieces.get(i);
            double[] d = new double[]{-1.0};
            Seam seam = piece.pick_seam(p, d);
            if (min == -1.0 || d[0] < min) {
                min = d[0];
                closest = seam;
            }
            ++i;
        }
        if (min < 10.0) {
            return closest;
        }
        return null;
    }

    public Connector pick_connector(Point p) {
        Connector closest = null;
        double min = -1.0;
        int i = 0;
        while (i < pieces.size()) {
            Piece piece = (Piece)pieces.get(i);
            double[] d = new double[]{-1.0};
            Connector connector = piece.pick_connector(p, d);
            if (min == -1.0 || d[0] < min) {
                min = d[0];
                closest = connector;
            }
            ++i;
        }
        if (min < 20.0) {
            return closest;
        }
        return null;
    }

    public static List sort_connectores() {
        ArrayList<Connector> new_connectores = new ArrayList<Connector>();
        Connector connector = DrawPanel.get_minimum_seam_connector();
        while (connector != null) {
            new_connectores.add(connector);
            connectores.remove(connector);
            connector = DrawPanel.get_minimum_seam_connector();
        }
        return new_connectores;
    }

    private static Connector get_minimum_seam_connector() {
        double min = Double.MAX_VALUE;
        Connector ret_connector = null;
        int i = 0;
        while (i < connectores.size()) {
            Connector connector = (Connector)connectores.get(i);
            double length = connector.getSeamLength();
            if (length < min) {
                ret_connector = connector;
                min = length;
            }
            ++i;
        }
        return ret_connector;
    }

    public void setLayoutMode(boolean flag) {
        this.layoutMode = flag;
    }

    public boolean isLayoutMode() {
        return this.layoutMode;
    }

    public void setSewNumberRendering(boolean flag) {
        this.sewNumberRendering = flag;
    }

    public boolean isSewNumberRendering() {
        return this.sewNumberRendering;
    }

    public void setPieceNumberRendering(boolean flag) {
        this.pieceNumberRendering = flag;
    }

    public boolean isPieceNumberRendering() {
        return this.pieceNumberRendering;
    }

    public boolean isMergeSeamsMode() {
        return this.mergeSeamsMode;
    }

    public void setMergeSeamsMode(boolean flag) {
        this.mergeSeamsMode = flag;
    }

    public boolean isDrawMode() {
        return this.drawMode;
    }

    public void setDrawMode(boolean flag) {
        this.drawMode = flag;
    }

    public void setConnectorPaintMode(boolean flag) {
        this.connectorPaintMode = flag;
    }

    public boolean isConnectorPaintMode() {
        return this.connectorPaintMode;
    }

    public boolean isStitchRendering() {
        return this.stitchRendering;
    }

    public void setStitchRendering(boolean flag) {
        this.stitchRendering = flag;
    }

    private void print_status() {
        switch (this.status) {
            case 0: {
                System.out.println("NONE");
                break;
            }
            case 1: {
                System.out.println("DRAWING");
                break;
            }
            case 2: {
                System.out.println("TAPEDRAWING");
                break;
            }
            case 3: {
                System.out.println("DRAGGING");
                break;
            }
            case 4: {
                System.out.println("PIECE_DRAGGING");
                break;
            }
            case 5: {
                System.out.println("CONNECTING");
                break;
            }
            case 6: {
                System.out.println("ZOOMING");
                break;
            }
            case 7: {
                System.out.println("SLIDING");
                break;
            }
            case 8: {
                System.out.println("MARK_DRAWING");
                break;
            }
            case 9: {
                System.out.println("PULLING");
                break;
            }
            case 10: {
                System.out.println("SMOOTHING");
                break;
            }
            case 11: {
                System.out.println("DEFORMING");
                break;
            }
            case 12: {
                System.out.println("PULLING_ON_VERTEX");
            }
        }
    }

    public class MouseDispatcher
    extends MouseAdapter
    implements MouseMotionListener,
    KeyListener {
        public void mouseClicked(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
            e.consume();
            Point p = e.getPoint();
            if (DrawPanel.this.status == 0 || DrawPanel.this.status == 2) {
                DrawPanel.this.highlight_snap(p);
            } else {
                DrawPanel.this.reset_snap();
            }
            if (DrawPanel.this.status == 2) {
                DrawPanel.this.tapeDrawing.mouseMoved(p);
            }
        }

        public void mouseDragged(MouseEvent e) {
            e.consume();
            Point p = e.getPoint();
            if (DrawPanel.this.status == 5 || DrawPanel.this.status == 2) {
                DrawPanel.this.highlight_snap(p);
            } else {
                DrawPanel.this.reset_snap();
            }
            if (DrawPanel.this.status == 2) {
                DrawPanel.this.tapeDrawing.mouseMoved(p);
            } else if (DrawPanel.this.status == 3) {
                DrawPanel.this.dragging(p);
            } else if (DrawPanel.this.status == 9) {
                DrawPanel.dragged_piece.pull.pulling(p);
            } else if (DrawPanel.this.status == 12) {
                Pull.pulling_for_vertex(p);
            } else if (DrawPanel.this.status == 10) {
                DrawPanel.this.smoothing(p);
            } else if (DrawPanel.this.status == 4) {
                DrawPanel.this.piece_dragging(p);
            } else if (DrawPanel.this.status == 5) {
                DrawPanel.this.connecting(p);
            } else if (DrawPanel.this.status == 6) {
                DrawPanel.this.zooming(p);
            } else if (DrawPanel.this.status == 7) {
                DrawPanel.this.sliding(p);
            } else if (DrawPanel.this.status == 8) {
                DrawPanel.this.mark_drawing(p);
            }
        }

        public void mousePressed(MouseEvent e) {
            e.consume();
            Point p = e.getPoint();
            if (DrawPanel.this.status == 0) {
                if (DrawPanel.this.start_zooming(p)) {
                    DrawPanel.this.status = 6;
                } else if ((e.getModifiers() & 0x10) != 0) {
                    if (DrawPanel.this.snap_seam != null) {
                        DrawPanel.this.start_smoothing(p);
                        DrawPanel.this.status = 10;
                    } else if (DrawPanel.this.drawMode) {
                        if (DrawPanel.this.start_mark_drawing(p)) {
                            DrawPanel.this.status = 8;
                        } else {
                            DrawPanel.this.startTapeDrawing(p);
                            DrawPanel.this.status = 2;
                        }
                    } else if (DrawPanel.this.start_piece_dragging(p)) {
                        DrawPanel.this.status = 4;
                    } else {
                        DrawPanel.this.start_sliding(p);
                        DrawPanel.this.status = 7;
                    }
                } else if (Pull.start_pulling_for_vertex(p)) {
                    DrawPanel.this.status = 12;
                } else if (Pull.start_pulling(p)) {
                    DrawPanel.this.status = 9;
                    DrawPanel.dragged_piece.pull = Pull.prepare_start_pulling(new Vertex2D(p), DrawPanel.this.snap_seam);
                } else if (DrawPanel.this.start_piece_dragging(p)) {
                    DrawPanel.this.status = 4;
                } else {
                    DrawPanel.this.start_sliding(p);
                    DrawPanel.this.status = 7;
                }
            } else if (DrawPanel.this.status == 2) {
                DrawPanel.this.tapeDrawing.mousePressed(e.getPoint());
            }
            DrawPanel.this.print_status();
        }

        public void mouseReleased(MouseEvent e) {
            e.consume();
            Point p = e.getPoint();
            if (DrawPanel.this.status == 2) {
                if (DrawPanel.this.tapeDrawing.mouseReleased(e.getPoint())) {
                    DrawPanel.this.finishTapeDrawing();
                }
            } else if (DrawPanel.this.status == 3) {
                DrawPanel.this.finish_dragging();
            } else if (DrawPanel.this.status == 9) {
                DrawPanel.dragged_piece.pull.finish_pulling();
            } else if (DrawPanel.this.status == 12) {
                Pull.finish_pulling_for_vertex();
            } else if (DrawPanel.this.status == 10) {
                DrawPanel.this.finish_smoothing();
            } else if (DrawPanel.this.status == 4) {
                DrawPanel.this.finish_piece_dragging();
            } else if (DrawPanel.this.status == 5) {
                DrawPanel.this.finish_connecting();
            } else if (DrawPanel.this.status == 6) {
                DrawPanel.this.finish_zooming();
            } else if (DrawPanel.this.status != 7 && DrawPanel.this.status == 8) {
                DrawPanel.this.finish_mark_drawing();
            }
            DrawPanel.this.status = 0;
            DrawPanel.this.repaint();
        }

        public void keyPressed(KeyEvent e) {
            System.out.println("keyPressed");
            if (e.getKeyCode() == 127) {
                DrawPanel.this.delete();
            } else if (e.getKeyCode() == 70) {
                DrawPanel.this.flip();
            } else if (e.getKeyCode() == 82) {
                DrawPanel.this.reverse();
            } else if (e.getKeyCode() == 27) {
                DrawPanel.this.clear();
            } else if (e.getKeyCode() == 83) {
                System.out.println("S");
                DrawPanel.this.piecesSmoothing();
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }
    }
}

