/*
 * Decompiled with CFR 0.152.
 */
package pattern;

import java.util.ArrayList;
import java.util.List;
import pattern.Seam;
import teddy.StrokeAnalyzer;
import teddy.Vertex2D;

public class Cost {
    static final int lmax = 10;
    static final int lmin = 2;
    static final int weight_stitch = 5;
    static final int weight_knot = 15;
    static final double weight_cut_stoit = 3.2;
    static final double weight_cut_curve = 0.11;

    static int calculateCost(Seam seam) {
        List _stroke = seam.getStroke();
        ArrayList<Vertex2D> stroke = new ArrayList<Vertex2D>();
        int i = 0;
        while (i < _stroke.size()) {
            Vertex2D v = ((Vertex2D)_stroke.get(i)).copy();
            v.index = i++;
            stroke.add(v);
        }
        List stitchPoints = StrokeAnalyzer.getResampledVertices(stroke, (double)20.0);
        seam.setStitchPoints(stitchPoints);
        return stitchPoints.size();
    }

    static int sewingCost(Seam seam) {
        return 5 * Cost.calculateCost(seam) / 2 + 15;
    }

    static int cuttingPatternCost(Seam seam) {
        return (int)(0.11 * seam.get_length() + 3.2);
    }

    static int cost(Seam seam) {
        return 3 * Cost.cuttingPatternCost(seam) + Cost.sewingCost(seam);
    }
}

