/*
 * Decompiled with CFR 0.152.
 */
package pattern;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import pattern.DrawPanel;
import pattern.Graphics2;
import pattern.Seam;
import pattern.StrokeAnalyzer;
import teddy.Vector2;
import teddy.Vertex2D;

public class Connector {
    private Seam seam0;
    private Seam seam1;
    private List stroke;
    public static final int CONNECTOR_WIDTH = 4;

    Connector(Seam seam0, Seam seam1) {
        Connector seamConnector1;
        this.seam0 = seam0;
        this.seam1 = seam1;
        Connector seamConnector0 = seam0.getConnector();
        if (seamConnector0 != null) {
            seamConnector0.delete();
        }
        if ((seamConnector1 = seam1.getConnector()) != null) {
            seamConnector1.delete();
        }
        seam0.setConnector(this);
        seam1.setConnector(this);
        DrawPanel.connectores.add(this);
    }

    public void delete() {
        this.seam0.setConnector(null);
        this.seam1.setConnector(null);
        DrawPanel.connectores.remove(this);
    }

    public Seam get_opposite_seam(Seam seam) {
        if (seam == this.seam0) {
            return this.seam1;
        }
        if (seam == this.seam1) {
            return this.seam0;
        }
        return null;
    }

    public void paint(Graphics g) {
        g.setColor(Color.gray);
        Vertex2D p = this.seam0.get_mid_point();
        Vertex2D q = this.seam1.get_mid_point();
        Vector2 m = this.seam0.get_mid_point_normal();
        Vector2 n = this.seam1.get_mid_point_normal();
        this.set_stroke(p, q, m, n, g);
        Graphics2.paint_wide_stroke(g, this.stroke, 4.0);
    }

    public double distance(Point p) {
        return StrokeAnalyzer.distance(this.stroke, new Vertex2D(p));
    }

    public void set_stroke(Vertex2D p, Vertex2D q, Vector2 m, Vector2 n, Graphics g) {
        this.stroke = new ArrayList();
        m.multiply(100.0);
        n.multiply(100.0);
        Vector2 a = new Vector2((Vector2)q);
        Vector2 d = new Vector2((Vector2)p);
        Vector2 b = Vector2.add((Vector2)Vector2.multiply((Vector2)a, (double)3.0), (Vector2)n);
        Vector2 c = Vector2.add((Vector2)Vector2.multiply((Vector2)d, (double)3.0), (Vector2)m);
        this.stroke.add(new Vertex2D((Vector2)p));
        int STEP = 16;
        int i = 1;
        while (i < STEP) {
            double t = 1.0 * (double)i / (double)STEP;
            double t0 = t * t * t;
            double t1 = t * t * (1.0 - t);
            double t2 = t * (1.0 - t) * (1.0 - t);
            double t3 = (1.0 - t) * (1.0 - t) * (1.0 - t);
            Vector2 v = Vector2.add((Vector2)Vector2.add((Vector2)Vector2.multiply((Vector2)a, (double)t0), (Vector2)Vector2.multiply((Vector2)b, (double)t1)), (Vector2)Vector2.add((Vector2)Vector2.multiply((Vector2)c, (double)t2), (Vector2)Vector2.multiply((Vector2)d, (double)t3)));
            this.stroke.add(new Vertex2D(v));
            ++i;
        }
        this.stroke.add(new Vertex2D((Vector2)q));
    }

    public double getSeamLength() {
        return this.seam0.get_length();
    }

    public Seam getSeam0() {
        return this.seam0;
    }

    public void setSeam0(Seam seam0) {
        this.seam0 = seam0;
    }

    public Seam getSeam1() {
        return this.seam1;
    }

    public void setSeam1(Seam seam1) {
        this.seam1 = seam1;
    }

    public List getStroke() {
        return this.stroke;
    }

    public void setStroke(List stroke) {
        this.stroke = stroke;
    }
}

