/*
 * Decompiled with CFR 0.152.
 */
package VisualNumerics.math;

public final class DoubleVector {
    public static double[] add(double d, double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        int n = 0;
        while (n < dArray.length) {
            dArray2[n] = d + dArray[n];
            ++n;
        }
        return dArray2;
    }

    public static double[] add(double[] dArray, double[] dArray2) {
        double[] dArray3;
        if (dArray.length == dArray2.length) {
            dArray3 = new double[dArray.length];
            int n = 0;
            while (n < dArray.length) {
                dArray3[n] = dArray[n] + dArray2[n];
                ++n;
            }
        } else {
            throw new IllegalArgumentException("Vectors must have the same length.");
        }
        return dArray3;
    }

    static double[] copy(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        return dArray2;
    }

    public static double infinityNorm(double[] dArray) {
        double d = Math.abs(dArray[0]);
        int n = 1;
        while (n < dArray.length) {
            double d2 = Math.abs(dArray[n]);
            d = Math.max(d, d2);
            ++n;
        }
        return d;
    }

    public static double innerProduct(double[] dArray, double[] dArray2) {
        double d = 0.0;
        int n = 0;
        while (n < dArray.length) {
            d += dArray[n] * dArray2[n];
            ++n;
        }
        return d;
    }

    public static double[] multiply(double d, double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        int n = 0;
        while (n < dArray.length) {
            dArray2[n] = d * dArray[n];
            ++n;
        }
        return dArray2;
    }

    public static double[] multiply(double[] dArray, double[] dArray2) {
        double[] dArray3;
        if (dArray.length == dArray2.length) {
            dArray3 = new double[dArray.length];
            int n = 0;
            while (n < dArray.length) {
                dArray3[n] = dArray[n] * dArray2[n];
                ++n;
            }
        } else {
            throw new IllegalArgumentException("Vectors must have the same length.");
        }
        return dArray3;
    }

    public static double oneNorm(double[] dArray) {
        double d = 0.0;
        int n = 0;
        while (n < dArray.length) {
            d += Math.abs(dArray[n]);
            ++n;
        }
        return d;
    }

    public static double product(double[] dArray) {
        double d = 1.0;
        int n = 0;
        while (n < dArray.length) {
            d *= dArray[n];
            ++n;
        }
        return d;
    }

    static void scale(double d, double[] dArray) {
        int n = 0;
        while (n < dArray.length) {
            int n2 = n++;
            dArray[n2] = dArray[n2] * d;
        }
    }

    public static double[] subtract(double[] dArray, double[] dArray2) {
        double[] dArray3;
        if (dArray.length == dArray2.length) {
            dArray3 = new double[dArray.length];
            int n = 0;
            while (n < dArray.length) {
                dArray3[n] = dArray[n] - dArray2[n];
                ++n;
            }
        } else {
            throw new IllegalArgumentException("Vectors must have the same length.");
        }
        return dArray3;
    }

    public static double sum(double[] dArray) {
        double d = 0.0;
        int n = 0;
        while (n < dArray.length) {
            d += dArray[n];
            ++n;
        }
        return d;
    }

    public static double twoNorm(double[] dArray) {
        double d;
        double d2 = 0.0;
        double d3 = 1.0;
        double[] dArray2 = new double[]{1.0010415475916E-146, 4.4989137945432E161, 2.2227587494851E-162, 1.9979190722022E146, 5.0104209000224E-293, 1.9958403095347E292};
        double d4 = d2;
        double d5 = 0.0;
        int n = 0;
        while (n < dArray.length) {
            d4 += Math.abs(dArray[n]);
            ++n;
        }
        if (d4 < (double)dArray.length * dArray2[0]) {
            d4 = dArray2[1];
            d = dArray2[2];
        } else if (d4 > dArray2[3]) {
            d4 = dArray2[4];
            d = dArray2[5];
        } else {
            int n2 = 0;
            while (n2 < dArray.length) {
                d5 += dArray[n2] * dArray[n2];
                ++n2;
            }
            return Math.sqrt(d5);
        }
        int n3 = 0;
        while (n3 < dArray.length) {
            d5 += d4 * dArray[n3] * (d4 * dArray[n3]);
            ++n3;
        }
        return Math.sqrt(d5) * d;
    }
}

