/*
 * Decompiled with CFR 0.152.
 */
package VisualNumerics.math;

import VisualNumerics.math.BLAS;
import VisualNumerics.math.Complex;
import VisualNumerics.math.ComplexMatrix;
import VisualNumerics.math.MathException;

public class ComplexCholesky {
    private static Complex[][] fac;
    private static Complex[][] acopy;
    private static final double SMALLEST = 2.2250738585072E-308;
    private static final double LARGEST = 1.7976931348623E308;
    private static final double EPSILON_LARGE = 2.2204460492503E-16;

    /*
     * Unable to fully structure code
     */
    public ComplexCholesky(Complex[][] var1_1) throws IllegalArgumentException, MathException {
        block31: {
            block32: {
                block33: {
                    super();
                    var29_2 = new Complex();
                    var30_3 = new Complex();
                    var33_4 = new Complex(1.0, 0.0);
                    var34_5 = new Complex(-1.0, 0.0);
                    var35_6 = new Complex(0.0, 0.0);
                    var36_7 = new Complex();
                    var25_8 = new Complex();
                    var26_9 = new Complex();
                    var27_10 = new Complex();
                    var28_11 = new Complex();
                    var21_12 = new Complex();
                    var22_13 = new Complex();
                    var23_14 = new Complex();
                    var24_15 = new Complex();
                    var37_16 = new int[1];
                    var38_17 = new int[1];
                    ComplexMatrix.CheckMatrix(var1_1, var37_16, var38_17);
                    var3_18 = var37_16[0];
                    var4_19 = var38_17[0];
                    if (var4_19 != var3_18) {
                        throw new MathException("The input matrix is not square.");
                    }
                    ComplexCholesky.acopy = new Complex[var3_18][var3_18];
                    ComplexCholesky.acopy = ComplexMatrix.transpose(var1_1);
                    var2_21 = 0;
                    while (var2_21 < var3_18 - 1) {
                        var6_22 = 0;
                        while (var6_22 <= var2_21) {
                            var1_1[var2_21 + 1][var6_22].re = var1_1[var6_22][var2_21 + 1].re;
                            var1_1[var2_21 + 1][var6_22].im = -var1_1[var6_22][var2_21 + 1].im;
                            ++var6_22;
                        }
                        ++var2_21;
                    }
                    ComplexCholesky.fac = new Complex[var3_18][var3_18];
                    ComplexCholesky.fac = ComplexMatrix.transpose(var1_1);
                    var10_23 = 2.2204460492503E-15;
                    var2_21 = 0;
                    while (var2_21 < var3_18) {
                        if (Math.abs(ComplexCholesky.fac[var2_21][var2_21].im) != 0.0) {
                            if (Math.abs(ComplexCholesky.fac[var2_21][var2_21].im) > var10_23 * Math.abs(ComplexCholesky.fac[var2_21][var2_21].re)) {
                                throw new MathException("The diagonal of a Hermitian matrix must be real. A(" + var2_21 + "," + var2_21 + ") = " + var1_1[var2_21][var2_21]);
                            }
                            ComplexCholesky.fac[var2_21][var2_21].im = 0.0;
                        }
                        ++var2_21;
                    }
                    var6_22 = 0;
                    while (var6_22 < var3_18 - 1) {
                        var2_21 = var6_22;
                        while (var2_21 < var3_18 - 1) {
                            ComplexCholesky.fac[var6_22][var2_21 + 1].re = ComplexCholesky.fac[var2_21 + 1][var6_22].re;
                            ComplexCholesky.fac[var6_22][var2_21 + 1].im = -ComplexCholesky.fac[var2_21 + 1][var6_22].im;
                            ++var2_21;
                        }
                        ++var6_22;
                    }
                    var5_24 = 0;
                    var9_25 = var3_18 % 4;
                    var6_22 = 0;
                    while (var6_22 < var3_18 - var9_25) {
                        if (ComplexCholesky.fac[var6_22][var6_22].re <= 0.0) {
                            var5_24 = var6_22;
                            break block31;
                        }
                        ComplexCholesky.fac[var6_22][var6_22].re = Math.sqrt(ComplexCholesky.fac[var6_22][var6_22].re);
                        ComplexCholesky.fac[var6_22][var6_22].im = 0.0;
                        var12_28 = Complex.divide((Complex)var33_4, (Complex)ComplexCholesky.fac[var6_22][var6_22]).re;
                        ComplexCholesky.fac[var6_22][var6_22 + 1].multiply(var12_28);
                        ComplexCholesky.fac[var6_22][var6_22 + 2].multiply(var12_28);
                        var25_8.re = -ComplexCholesky.fac[var6_22][var6_22 + 1].re;
                        var25_8.im = ComplexCholesky.fac[var6_22][var6_22 + 1].im;
                        var26_9.re = -ComplexCholesky.fac[var6_22][var6_22 + 2].re;
                        var26_9.im = ComplexCholesky.fac[var6_22][var6_22 + 2].im;
                        var27_10.re = -var12_28 * ComplexCholesky.fac[var6_22][var6_22 + 3].re;
                        var27_10.im = var12_28 * ComplexCholesky.fac[var6_22][var6_22 + 3].im;
                        var29_2 = Complex.multiply(ComplexCholesky.fac[var6_22][var6_22 + 1], var25_8);
                        ComplexCholesky.fac[var6_22 + 1][var6_22 + 1].add(var29_2);
                        var29_2 = Complex.multiply(ComplexCholesky.fac[var6_22][var6_22 + 2], var25_8);
                        ComplexCholesky.fac[var6_22 + 1][var6_22 + 2].add(var29_2);
                        var29_2 = Complex.multiply(ComplexCholesky.fac[var6_22][var6_22 + 2], var26_9);
                        ComplexCholesky.fac[var6_22 + 2][var6_22 + 2].add(var29_2);
                        var2_21 = 3;
                        while (var2_21 <= var3_18 - var6_22 - 1) {
                            ComplexCholesky.fac[var6_22][var6_22 + var2_21].multiply(var12_28);
                            var29_2 = Complex.multiply(ComplexCholesky.fac[var6_22][var6_22 + var2_21], var25_8);
                            ComplexCholesky.fac[var6_22 + 1][var6_22 + var2_21].add(var29_2);
                            var29_2 = Complex.multiply(ComplexCholesky.fac[var6_22][var6_22 + var2_21], var26_9);
                            ComplexCholesky.fac[var6_22 + 2][var6_22 + var2_21].add(var29_2);
                            var29_2 = Complex.multiply(ComplexCholesky.fac[var6_22][var6_22 + var2_21], var27_10);
                            ComplexCholesky.fac[var6_22 + 3][var6_22 + var2_21].add(var29_2);
                            ++var2_21;
                        }
                        if (ComplexCholesky.fac[var6_22 + 1][var6_22 + 1].re <= 0.0) {
                            var5_24 = var6_22 + 1;
                            break block31;
                        }
                        ComplexCholesky.fac[var6_22 + 1][var6_22 + 1].re = Math.sqrt(ComplexCholesky.fac[var6_22 + 1][var6_22 + 1].re);
                        ComplexCholesky.fac[var6_22 + 1][var6_22 + 1].im = 0.0;
                        var14_29 = Complex.divide((Complex)var33_4, (Complex)ComplexCholesky.fac[var6_22 + 1][var6_22 + 1]).re;
                        ComplexCholesky.fac[var6_22 + 1][var6_22 + 2].multiply(var14_29);
                        var26_9.re = -ComplexCholesky.fac[var6_22 + 1][var6_22 + 2].re;
                        var26_9.im = ComplexCholesky.fac[var6_22 + 1][var6_22 + 2].im;
                        var27_10.re = -var14_29 * ComplexCholesky.fac[var6_22 + 1][var6_22 + 3].re;
                        var27_10.im = var14_29 * ComplexCholesky.fac[var6_22 + 1][var6_22 + 3].im;
                        var29_2 = Complex.multiply(ComplexCholesky.fac[var6_22 + 1][var6_22 + 2], var26_9);
                        ComplexCholesky.fac[var6_22 + 2][var6_22 + 2].add(var29_2);
                        var2_21 = 3;
                        while (var2_21 <= var3_18 - var6_22 - 1) {
                            ComplexCholesky.fac[var6_22 + 1][var6_22 + var2_21].multiply(var14_29);
                            var29_2 = Complex.multiply(ComplexCholesky.fac[var6_22 + 1][var6_22 + var2_21], var26_9);
                            ComplexCholesky.fac[var6_22 + 2][var6_22 + var2_21].add(var29_2);
                            var29_2 = Complex.multiply(ComplexCholesky.fac[var6_22 + 1][var6_22 + var2_21], var27_10);
                            ComplexCholesky.fac[var6_22 + 3][var6_22 + var2_21].add(var29_2);
                            ++var2_21;
                        }
                        if (ComplexCholesky.fac[var6_22 + 2][var6_22 + 2].re <= 0.0) {
                            var5_24 = var6_22 + 2;
                            break block31;
                        }
                        ComplexCholesky.fac[var6_22 + 2][var6_22 + 2].re = Math.sqrt(ComplexCholesky.fac[var6_22 + 2][var6_22 + 2].re);
                        ComplexCholesky.fac[var6_22 + 2][var6_22 + 2].im = 0.0;
                        var16_30 = Complex.divide((Complex)var33_4, (Complex)ComplexCholesky.fac[var6_22 + 2][var6_22 + 2]).re;
                        var27_10.re = -var16_30 * ComplexCholesky.fac[var6_22 + 2][var6_22 + 3].re;
                        var27_10.im = var16_30 * ComplexCholesky.fac[var6_22 + 2][var6_22 + 3].im;
                        var2_21 = 3;
                        while (var2_21 <= var3_18 - var6_22 - 1) {
                            ComplexCholesky.fac[var6_22 + 2][var6_22 + var2_21].multiply(var16_30);
                            var29_2 = Complex.multiply(ComplexCholesky.fac[var6_22 + 2][var6_22 + var2_21], var27_10);
                            ComplexCholesky.fac[var6_22 + 3][var6_22 + var2_21].add(var29_2);
                            ++var2_21;
                        }
                        if (ComplexCholesky.fac[var6_22 + 3][var6_22 + 3].re <= 0.0) {
                            var5_24 = var6_22 + 3;
                            break block31;
                        }
                        ComplexCholesky.fac[var6_22 + 3][var6_22 + 3].re = Math.sqrt(ComplexCholesky.fac[var6_22 + 3][var6_22 + 3].re);
                        ComplexCholesky.fac[var6_22 + 3][var6_22 + 3].im = 0.0;
                        var18_31 = Complex.divide((Complex)var33_4, (Complex)ComplexCholesky.fac[var6_22 + 3][var6_22 + 3]).re;
                        var2_21 = 4;
                        while (var2_21 <= var3_18 - var6_22 - 1) {
                            ComplexCholesky.fac[var6_22 + 3][var6_22 + var2_21].multiply(var18_31);
                            ++var2_21;
                        }
                        var8_27 = (var3_18 - var6_22 - 4) % 2;
                        if (var8_27 > 0) {
                            var31_32 = ComplexCholesky.fac[var6_22][var3_18 - 1].re * ComplexCholesky.fac[var6_22][var3_18 - 1].re + ComplexCholesky.fac[var6_22][var3_18 - 1].im * ComplexCholesky.fac[var6_22][var3_18 - 1].im;
                            var31_32 += ComplexCholesky.fac[var6_22 + 1][var3_18 - 1].re * ComplexCholesky.fac[var6_22 + 1][var3_18 - 1].re + ComplexCholesky.fac[var6_22 + 1][var3_18 - 1].im * ComplexCholesky.fac[var6_22 + 1][var3_18 - 1].im;
                            var31_32 += ComplexCholesky.fac[var6_22 + 2][var3_18 - 1].re * ComplexCholesky.fac[var6_22 + 2][var3_18 - 1].re + ComplexCholesky.fac[var6_22 + 2][var3_18 - 1].im * ComplexCholesky.fac[var6_22 + 2][var3_18 - 1].im;
                            ComplexCholesky.fac[var3_18 - 1][var3_18 - 1].subtract(var31_32 += ComplexCholesky.fac[var6_22 + 3][var3_18 - 1].re * ComplexCholesky.fac[var6_22 + 3][var3_18 - 1].re + ComplexCholesky.fac[var6_22 + 3][var3_18 - 1].im * ComplexCholesky.fac[var6_22 + 3][var3_18 - 1].im);
                        }
                        if (var3_18 - var8_27 - 2 >= var6_22 + 4) {
                            var7_26 = var3_18 - var8_27 - 2;
                            while (var7_26 >= var6_22 + 4) {
                                var25_8.re = -ComplexCholesky.fac[var6_22][var7_26].re;
                                var25_8.im = ComplexCholesky.fac[var6_22][var7_26].im;
                                var26_9.re = -ComplexCholesky.fac[var6_22 + 1][var7_26].re;
                                var26_9.im = ComplexCholesky.fac[var6_22 + 1][var7_26].im;
                                var27_10.re = -ComplexCholesky.fac[var6_22 + 2][var7_26].re;
                                var27_10.im = ComplexCholesky.fac[var6_22 + 2][var7_26].im;
                                var28_11.re = -ComplexCholesky.fac[var6_22 + 3][var7_26].re;
                                var28_11.im = ComplexCholesky.fac[var6_22 + 3][var7_26].im;
                                var21_12.re = -ComplexCholesky.fac[var6_22][var7_26 + 1].re;
                                var21_12.im = ComplexCholesky.fac[var6_22][var7_26 + 1].im;
                                var22_13.re = -ComplexCholesky.fac[var6_22 + 1][var7_26 + 1].re;
                                var22_13.im = ComplexCholesky.fac[var6_22 + 1][var7_26 + 1].im;
                                var23_14.re = -ComplexCholesky.fac[var6_22 + 2][var7_26 + 1].re;
                                var23_14.im = ComplexCholesky.fac[var6_22 + 2][var7_26 + 1].im;
                                var24_15.re = -ComplexCholesky.fac[var6_22 + 3][var7_26 + 1].re;
                                var24_15.im = ComplexCholesky.fac[var6_22 + 3][var7_26 + 1].im;
                                var2_21 = var7_26;
                                while (var2_21 < var3_18) {
                                    var30_3 = Complex.multiply(ComplexCholesky.fac[var6_22 + 3][var2_21], var28_11);
                                    var29_2 = Complex.multiply(ComplexCholesky.fac[var6_22 + 2][var2_21], var27_10);
                                    var30_3.add(var29_2);
                                    var29_2 = Complex.multiply(ComplexCholesky.fac[var6_22 + 1][var2_21], var26_9);
                                    var30_3.add(var29_2);
                                    var29_2 = Complex.multiply(ComplexCholesky.fac[var6_22][var2_21], var25_8);
                                    var30_3.add(var29_2);
                                    ComplexCholesky.fac[var7_26][var2_21].add(var30_3);
                                    var30_3 = Complex.multiply(ComplexCholesky.fac[var6_22 + 3][var2_21], var24_15);
                                    var29_2 = Complex.multiply(ComplexCholesky.fac[var6_22 + 2][var2_21], var23_14);
                                    var30_3.add(var29_2);
                                    var29_2 = Complex.multiply(ComplexCholesky.fac[var6_22 + 1][var2_21], var22_13);
                                    var30_3.add(var29_2);
                                    var29_2 = Complex.multiply(ComplexCholesky.fac[var6_22][var2_21], var21_12);
                                    var30_3.add(var29_2);
                                    ComplexCholesky.fac[var7_26 + 1][var2_21].add(var30_3);
                                    ++var2_21;
                                }
                                var7_26 -= 2;
                            }
                        }
                        var6_22 += 4;
                    }
                    var6_22 = var3_18 - var9_25;
                    if (var9_25 < 3) break block32;
                    if (!(ComplexCholesky.fac[var6_22][var6_22].re <= 0.0)) break block33;
                    var5_24 = var6_22;
                    break block31;
                }
                ComplexCholesky.fac[var6_22][var6_22].re = Math.sqrt(ComplexCholesky.fac[var6_22][var6_22].re);
                ComplexCholesky.fac[var6_22][var6_22].im = 0.0;
                var20_33 = Complex.divide(var33_4, ComplexCholesky.fac[var6_22][var6_22]);
                ComplexCholesky.fac[var6_22][var6_22 + 1].multiply(var20_33);
                ComplexCholesky.fac[var6_22][var6_22 + 2].multiply(var20_33);
                var31_32 = ComplexCholesky.fac[var6_22][var6_22 + 1].re * ComplexCholesky.fac[var6_22][var6_22 + 1].re + ComplexCholesky.fac[var6_22][var6_22 + 1].im * ComplexCholesky.fac[var6_22][var6_22 + 1].im;
                ComplexCholesky.fac[var6_22 + 1][var6_22 + 1].subtract(var31_32);
                ComplexCholesky.fac[var6_22 + 1][var6_22 + 2].subtract(Complex.multiply(ComplexCholesky.fac[var6_22][var6_22 + 2], Complex.conjugate(ComplexCholesky.fac[var6_22][var6_22 + 1])));
                var31_32 = ComplexCholesky.fac[var6_22][var6_22 + 2].re * ComplexCholesky.fac[var6_22][var6_22 + 2].re + ComplexCholesky.fac[var6_22][var6_22 + 2].im * ComplexCholesky.fac[var6_22][var6_22 + 2].im;
                ComplexCholesky.fac[var6_22 + 2][var6_22 + 2].subtract(var31_32);
                ++var6_22;
                --var9_25;
            }
            if (var9_25 < 2) ** GOTO lbl256
            if (ComplexCholesky.fac[var6_22][var6_22].re <= 0.0) {
                var5_24 = var6_22;
            } else {
                ComplexCholesky.fac[var6_22][var6_22].re = Math.sqrt(ComplexCholesky.fac[var6_22][var6_22].re);
                ComplexCholesky.fac[var6_22][var6_22].im = 0.0;
                var20_33 = Complex.divide(var33_4, ComplexCholesky.fac[var6_22][var6_22]);
                ComplexCholesky.fac[var6_22][var6_22 + 1].multiply(var20_33);
                var31_32 = ComplexCholesky.fac[var6_22][var6_22 + 1].re * ComplexCholesky.fac[var6_22][var6_22 + 1].re + ComplexCholesky.fac[var6_22][var6_22 + 1].im * ComplexCholesky.fac[var6_22][var6_22 + 1].im;
                ComplexCholesky.fac[var6_22 + 1][var6_22 + 1].subtract(var31_32);
                ++var6_22;
                --var9_25;
lbl256:
                // 2 sources

                if (var9_25 >= 1) {
                    if (ComplexCholesky.fac[var6_22][var6_22].re <= 0.0) {
                        var5_24 = var6_22;
                    } else {
                        ComplexCholesky.fac[var6_22][var6_22].re = Math.sqrt(ComplexCholesky.fac[var6_22][var6_22].re);
                        ComplexCholesky.fac[var6_22][var6_22].im = 0.0;
                    }
                }
            }
        }
        if (var5_24 != 0) {
            throw new MathException("The leading " + var5_24 + " by " + var5_24 + " submatrix of the input matrix is not positive definite.");
        }
        var2_21 = 0;
        while (var2_21 < var3_18 - 1) {
            var6_22 = 0;
            while (var6_22 <= var2_21) {
                ComplexCholesky.fac[var2_21 + 1][var6_22].re = ComplexCholesky.fac[var6_22][var2_21 + 1].re;
                ComplexCholesky.fac[var2_21 + 1][var6_22].im = -ComplexCholesky.fac[var6_22][var2_21 + 1].im;
                ++var6_22;
            }
            ++var2_21;
        }
    }

    public static Complex[][] R() {
        return ComplexMatrix.transpose(fac);
    }

    public static double condition() {
        Complex complex;
        double d;
        Complex complex2;
        double d2 = 1.0;
        int n = acopy[0].length;
        double d3 = BLAS.znr1rr(n, n, acopy);
        Complex complex3 = new Complex(1.0, 0.0);
        Complex[] complexArray = new Complex[n];
        int n2 = 0;
        while (n2 < n) {
            complexArray[n2] = new Complex();
            ++n2;
        }
        int n3 = 0;
        while (n3 < n) {
            Complex complex4 = Complex.negate(complexArray[n3]);
            if (Complex.zabs1(complexArray[n3]) != 0.0) {
                complex2 = new Complex(Complex.zabs1(complex4));
                complex2 = Complex.divide(complex4, complex2);
                complex3 = Complex.multiply(Complex.zabs1(complex3), complex2);
            }
            if (Complex.zabs1(complex2 = Complex.subtract(complex3, complexArray[n3])) > ComplexCholesky.fac[n3][n3].re) {
                d = ComplexCholesky.fac[n3][n3].re;
                BLAS.zdscal(n, d /= Complex.zabs1(complex2), complexArray, 0, 1);
                complex3 = Complex.multiply(d, complex3);
            }
            complex4 = Complex.subtract(complex3, complexArray[n3]);
            Complex complex5 = Complex.negate(complex3);
            complex5 = Complex.subtract(complex5, complexArray[n3]);
            d = Complex.zabs1(complex4);
            double d4 = Complex.zabs1(complex5);
            complex4 = Complex.divide(complex4, fac[n3][n3]);
            complex5 = Complex.divide(complex5, fac[n3][n3]);
            int n4 = n3 + 1;
            if (n4 < n) {
                int n5 = n4;
                while (n5 < n) {
                    complex2 = Complex.conjugate(fac[n5][n3]);
                    complex2 = Complex.multiply(complex5, complex2);
                    d4 += Complex.zabs1(Complex.add(complexArray[n5], complex2));
                    complex2 = Complex.conjugate(fac[n5][n3]);
                    complex2 = Complex.multiply(complex4, complex2);
                    complexArray[n5] = Complex.add(complexArray[n5], complex2);
                    d += Complex.zabs1(complexArray[n5]);
                    ++n5;
                }
                if (d < d4) {
                    complex = Complex.subtract(complex5, complex4);
                    complex4 = new Complex(complex5);
                    n5 = n4;
                    while (n5 < n) {
                        complex2 = Complex.conjugate(fac[n5][n3]);
                        complex2 = Complex.multiply(complex, complex2);
                        complexArray[n5] = Complex.add(complexArray[n5], complex2);
                        ++n5;
                    }
                }
            }
            complexArray[n3] = new Complex(complex4);
            ++n3;
        }
        d = 1.0 / BLAS.dzasum(n, complexArray, 0, 1);
        BLAS.zdscal(n, d, complexArray, 0, 1);
        n3 = n - 1;
        while (n3 >= 0) {
            if (Complex.zabs1(complexArray[n3]) > ComplexCholesky.fac[n3][n3].re) {
                d = ComplexCholesky.fac[n3][n3].re / Complex.zabs1(complexArray[n3]);
                BLAS.zdscal(n, d, complexArray, 0, 1);
            }
            complexArray[n3] = Complex.divide(complexArray[n3], fac[n3][n3]);
            complex = Complex.negate(complexArray[n3]);
            BLAS.zaxpy(n3, complex, fac[n3], 0, 1, complexArray, 0, 1);
            --n3;
        }
        d = 1.0 / BLAS.dzasum(n, complexArray, 0, 1);
        BLAS.zdscal(n, d, complexArray, 0, 1);
        double d5 = 1.0;
        n3 = 0;
        while (n3 < n) {
            complex2 = BLAS.zdotc(n3, fac[n3], 0, 1, complexArray, 0, 1);
            complexArray[n3] = Complex.subtract(complexArray[n3], complex2);
            if (Complex.zabs1(complexArray[n3]) > ComplexCholesky.fac[n3][n3].re) {
                d = ComplexCholesky.fac[n3][n3].re / Complex.zabs1(complexArray[n3]);
                BLAS.zdscal(n, d, complexArray, 0, 1);
                d5 = d * d5;
            }
            complexArray[n3] = Complex.divide(complexArray[n3], fac[n3][n3]);
            ++n3;
        }
        d = 1.0 / BLAS.dzasum(n, complexArray, 0, 1);
        BLAS.zdscal(n, d, complexArray, 0, 1);
        d5 = d * d5;
        n3 = n - 1;
        while (n3 >= 0) {
            if (Complex.zabs1(complexArray[n3]) > ComplexCholesky.fac[n3][n3].re) {
                d = ComplexCholesky.fac[n3][n3].re / Complex.zabs1(complexArray[n3]);
                BLAS.zdscal(n, d, complexArray, 0, 1);
                d5 = d * d5;
            }
            complexArray[n3] = Complex.divide(complexArray[n3], fac[n3][n3]);
            complex = Complex.negate(complexArray[n3]);
            BLAS.zaxpy(n3, complex, fac[n3], 0, 1, complexArray, 0, 1);
            --n3;
        }
        d = 1.0 / BLAS.dzasum(n, complexArray, 0, 1);
        BLAS.zdscal(n, d, complexArray, 0, 1);
        d5 = d * d5;
        if (d3 != 0.0) {
            d2 = d5 / d3;
        }
        return d2;
    }

    public static double determinant() {
        Complex complex = new Complex(1.0, 0.0);
        int n = fac.length;
        int n2 = 0;
        while (n2 < n) {
            complex = Complex.multiply(complex, fac[n2][n2]);
            ++n2;
        }
        return Complex.multiply((Complex)complex, (Complex)complex).re;
    }

    public static Complex[][] inverse() throws MathException {
        int n = fac[0].length;
        Complex[] complexArray = new Complex[n];
        int n2 = 0;
        while (n2 < n) {
            complexArray[n2] = new Complex();
            ++n2;
        }
        Complex[][] complexArray2 = new Complex[n][n];
        n2 = 0;
        while (n2 < n) {
            complexArray[n2] = new Complex(1.0, 0.0);
            complexArray2[n2] = ComplexCholesky.solve(complexArray);
            complexArray[n2] = new Complex();
            ++n2;
        }
        complexArray2 = ComplexMatrix.transpose(complexArray2);
        return complexArray2;
    }

    private static Complex[] lct(Complex[] complexArray, int n) throws MathException {
        int n2 = fac.length;
        double d = 2.2250738585072E-308;
        int n3 = 0;
        while (n3 < n2) {
            if (Complex.zabs1(fac[n3][n3]) < d) {
                throw new MathException("The input triangular matrix is singular. The index of the first zero diagonal element is " + n3);
            }
            ++n3;
        }
        Complex[] complexArray2 = new Complex[n2];
        int n4 = 0;
        while (n4 < n2) {
            complexArray2[n4] = new Complex(complexArray[n4]);
            ++n4;
        }
        if (n == 1) {
            ComplexCholesky.ztrsv('L', 'N', 'N', n2, fac, complexArray2, 1);
        } else if (n == 2) {
            ComplexCholesky.ztrsv('U', 'N', 'N', n2, fac, complexArray2, 1);
        } else if (n == 3) {
            ComplexCholesky.ztrsv('L', 'C', 'N', n2, fac, complexArray2, 1);
        } else if (n == 4) {
            ComplexCholesky.ztrsv('U', 'C', 'N', n2, fac, complexArray2, 1);
        }
        return complexArray2;
    }

    public static Complex[] solve(Complex[] complexArray) throws MathException {
        int n = fac.length;
        Complex[] complexArray2 = new Complex[n];
        complexArray2 = ComplexCholesky.lct(complexArray, 4);
        return ComplexCholesky.lct(complexArray2, 2);
    }

    private static final void ztrsv(char c, char c2, char c3, int n, Complex[][] complexArray, Complex[] complexArray2, int n2) {
        block9: {
            boolean bl;
            block10: {
                boolean bl2 = false;
                bl = false;
                boolean bl3 = false;
                if (c == 'U' || c == 'u') {
                    bl3 = true;
                }
                if (c3 == 'N' || c3 == 'n') {
                    bl = true;
                }
                if (c2 == 'C' || c2 == 'c') {
                    bl2 = true;
                }
                if (n == 0 || !bl3) break block9;
                if (!bl2) break block10;
                if (n2 <= 0) break block9;
                int n3 = 0;
                int n4 = 0;
                while (n4 < n) {
                    complexArray2[n3] = Complex.subtract(complexArray2[n3], BLAS.zdotc(n4, complexArray[n4], 0, 1, complexArray2, 0, n2));
                    if (bl) {
                        complexArray2[n3] = Complex.divide(complexArray2[n3], Complex.conjugate(complexArray[n4][n4]));
                    }
                    n3 += n2;
                    ++n4;
                }
                break block9;
            }
            if (n2 > 0) {
                Complex[][] complexArray3 = new Complex[n][n];
                complexArray3 = ComplexMatrix.transpose(complexArray);
                int n5 = (n - 1) * n2;
                int n6 = n - 1;
                while (n6 >= 0) {
                    if (n6 < n - 1) {
                        complexArray2[n5] = Complex.subtract(complexArray2[n5], BLAS.zdotu(n - n6 - 1, complexArray3[n6], n6 + 1, 1, complexArray2, n5 + n2, n2));
                    }
                    if (bl) {
                        complexArray2[n5] = Complex.divide(complexArray2[n5], complexArray[n6][n6]);
                    }
                    n5 -= n2;
                    --n6;
                }
            }
        }
    }
}

