/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import pattern.Piece;
import pattern.Seam;
import teddy.Def;
import teddy.Edge2D;
import teddy.Line2D;
import teddy.Vector2;
import teddy.Vertex;

public class Vertex2D
extends Vector2 {
    public int index;
    public boolean fixed;
    public List edges = new ArrayList();
    public transient Vertex2D child = this;
    private boolean stitchPoint = false;
    private Vertex vertex;
    public Seam prev_seam;
    public Seam next_seam;
    public Piece piece;
    public double depth = 0.0;

    public Vertex2D() {
    }

    public Vertex2D(double _x, double _y) {
        this.x = _x;
        this.y = _y;
    }

    public Vertex2D(Point p, int i) {
        this.x = p.x;
        this.y = p.y;
        this.index = i;
    }

    public Vertex2D(Point p) {
        this.x = p.x;
        this.y = p.y;
    }

    public Vertex2D(Vector2 p) {
        this.x = p.x;
        this.y = p.y;
    }

    Vertex2D(Vertex v) {
        this.x = v.x;
        this.y = v.y;
    }

    public Vertex2D(double[] p) {
        this.x = p[0];
        this.y = p[1];
    }

    public Vertex2D copy() {
        Vertex2D v = new Vertex2D(this.x, this.y);
        return v;
    }

    public boolean same_position(Vertex2D v) {
        return this.x == v.x && this.y == v.y;
    }

    public Edge2D get_common_edge(Vertex2D v) {
        int i = 0;
        while (i < this.edges.size()) {
            Edge2D edge = (Edge2D)this.edges.get(i);
            if (edge.contains(v)) {
                return edge;
            }
            ++i;
        }
        return null;
    }

    public Vector2 get_normal() {
        Vector2 normal = new Vector2(0.0, 0.0);
        Vector2 _normal = new Vector2(0.0, 0.0);
        int i = 0;
        while (i < this.edges.size()) {
            Edge2D edge = (Edge2D)this.edges.get(i);
            if (edge.left_face == null || edge.right_face == null) {
                Vertex2D v1;
                Vertex2D v0;
                if (edge.start == this && edge.left_face == null || edge.end == this && edge.left_face == null) {
                    v0 = edge.end;
                    v1 = edge.start;
                } else {
                    v0 = edge.start;
                    v1 = edge.end;
                }
                _normal = new Vector2(v0, v1);
                _normal.normalize();
                normal.add(Vector2.rotate90(_normal));
            }
            ++i;
        }
        normal.normalize();
        return normal;
    }

    public List get_surrounding_vertices() {
        ArrayList<Vertex2D> vertices = new ArrayList<Vertex2D>();
        int i = 0;
        while (i < this.edges.size()) {
            Edge2D edge = (Edge2D)this.edges.get(i);
            vertices.add(edge.get_opposite_vertex(this));
            ++i;
        }
        return vertices;
    }

    public static Vertex2D mid_vertex(Vertex2D a, Vertex2D b) {
        return new Vertex2D((a.x + b.x) / 2.0, (a.y + b.y) / 2.0);
    }

    public void remove_edge(Edge2D edge) {
        this.edges.remove(edge);
    }

    public static Vertex2D translate(Vertex2D u, Vector2 v) {
        return new Vertex2D(u.x + v.x, u.y + v.y);
    }

    public void translate_self(Vector2 v) {
        this.x += v.x;
        this.y += v.y;
    }

    public void warp(Vertex2D v) {
        this.x = v.x;
        this.y = v.y;
    }

    public void warp(Vector2 v) {
        this.x = v.x;
        this.y = v.y;
    }

    public boolean same(Vertex2D node) {
        return Def.equal(node.x, this.x) && Def.equal(node.y, this.y);
    }

    public double distance(Vertex2D node) {
        return Math.sqrt((node.x - this.x) * (node.x - this.x) + (node.y - this.y) * (node.y - this.y));
    }

    public static double distance(Vertex2D n1, Vertex2D n2) {
        return Math.sqrt((n1.x - n2.x) * (n1.x - n2.x) + (n1.y - n2.y) * (n1.y - n2.y));
    }

    public static double distance(Vertex2D n1, Point n2) {
        return Math.sqrt((n1.x - (double)n2.x) * (n1.x - (double)n2.x) + (n1.y - (double)n2.y) * (n1.y - (double)n2.y));
    }

    public static Vertex2D interporate(Vertex2D start, Vertex2D end, double t) {
        return new Vertex2D(start.x * (1.0 - t) + end.x * t, start.y * (1.0 - t) + end.y * t);
    }

    public double distance(Line2D line) {
        double m = line.direction.y / line.direction.x;
        double n = m * (line.base.y - line.base.x);
        return (line.base.y - m * line.base.x - n) / Math.sqrt(1.0 + m * m);
    }

    public Seam get_common_seam(Vertex2D v) {
        if (v.next_seam == this.next_seam || v.prev_seam == this.next_seam) {
            return this.next_seam;
        }
        if (v.next_seam == this.prev_seam || v.prev_seam == this.prev_seam) {
            return this.prev_seam;
        }
        return null;
    }

    public Seam get_opposite_seam(Seam seam) {
        if (seam == this.prev_seam) {
            return this.next_seam;
        }
        return this.prev_seam;
    }

    public void setStitchPoint(boolean flag) {
        this.stitchPoint = flag;
    }

    public boolean getStitchPoint() {
        return this.stitchPoint;
    }

    public void setVertex(Vertex v) {
        this.vertex = v;
    }

    public Vertex getVertex() {
        return this.vertex;
    }
}

