/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import teddy.Edge;
import teddy.Face;
import teddy.Vector3;
import teddy.Vertex2D;

public class Vertex
extends Vector3 {
    public double u;
    public double v;
    private Vertex2D patternCoord;
    public List edges = new ArrayList();
    public int index;
    public boolean fixed = false;
    public Vector3 normal;
    public boolean stitchPoint = false;
    private Vertex inputVertex = null;
    public int index_for_setITA;
    public transient Vertex child = this;
    public boolean disposed = false;
    public List child_vertices = new ArrayList();
    Vertex duplicated_child;
    Vertex body_vertex;
    Object body_element;

    public Vertex() {
    }

    public Vertex(double x, double y, double z) {
        super(x, y, z);
    }

    public Vertex(Vector3 v) {
        this(v.x, v.y, v.z);
    }

    public void set_position(Vertex v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public void set_position(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Edge get_common_edge(Vertex v) {
        int i = 0;
        while (i < this.edges.size()) {
            Edge edge = (Edge)this.edges.get(i);
            if (edge.contains(v)) {
                return edge;
            }
            ++i;
        }
        return null;
    }

    public static Vertex translate(Vertex v, Vector3 u) {
        return new Vertex(v.x + u.x, v.y + u.y, v.z + u.z);
    }

    public void translate_self(Vector3 v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
    }

    public void set_normal() {
        this.normal = this.get_normal();
    }

    public Vector3 get_normal() {
        List faces = this.get_faces();
        Vector3 normal = new Vector3();
        int i = 0;
        while (i < faces.size()) {
            normal.add(((Face)faces.get((int)i)).normal);
            ++i;
        }
        normal.normalize();
        return normal;
    }

    public List get_faces() {
        ArrayList<Face> faces = new ArrayList<Face>();
        int i = 0;
        while (i < this.edges.size()) {
            Edge edge = (Edge)this.edges.get(i);
            if (edge.left_face != null && !faces.contains(edge.left_face)) {
                faces.add(edge.left_face);
            }
            if (edge.right_face != null && !faces.contains(edge.right_face)) {
                faces.add(edge.right_face);
            }
            ++i;
        }
        return faces;
    }

    public List get_edges_sorted_clockwise(Edge base_edge) {
        ArrayList<Edge> sorted_edges = new ArrayList<Edge>();
        Edge prev_edge = base_edge;
        int i = 0;
        while (i < this.edges.size()) {
            if ((prev_edge = this.get_next_edge(prev_edge)) == null) break;
            sorted_edges.add(prev_edge);
            ++i;
        }
        return sorted_edges;
    }

    public Edge get_prev_edge(Edge edge) {
        Face face = null;
        face = edge.start == this ? edge.right_face : edge.left_face;
        if (face == null) {
            return null;
        }
        return face.get_next_edge(edge);
    }

    public Edge get_next_edge(Edge edge) {
        Face face = null;
        face = edge.start == this ? edge.left_face : edge.right_face;
        if (face == null) {
            return null;
        }
        return face.get_prev_edge(edge);
    }

    public static Vertex mid_vertex(Vertex u, Vertex v) {
        Vertex vertex = new Vertex((u.x + v.x) / 2.0, (u.y + v.y) / 2.0, (u.z + v.z) / 2.0);
        vertex.u = (u.u + v.u) / 2.0;
        vertex.v = (u.v + v.v) / 2.0;
        return vertex;
    }

    public void remove_edge(Edge edge) {
        this.edges.remove(edge);
    }

    public boolean same_position(Vertex vec) {
        return this.x == vec.x || this.y == vec.y || this.z == vec.z;
    }

    public boolean on_seam() {
        int i = 0;
        while (i < this.edges.size()) {
            Edge edge = (Edge)this.edges.get(i);
            if (edge.seam) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public List get_surrounding_edges() {
        ArrayList<Edge> surrounding_edges = new ArrayList<Edge>();
        List faces = this.get_faces();
        int i = 0;
        while (i < faces.size()) {
            Face face = (Face)faces.get(i);
            surrounding_edges.add(face.get_opposite_edge(this));
            ++i;
        }
        return surrounding_edges;
    }

    public Vector get_sorrounding_vertices_on_seam() {
        Vector<Vertex> vertices = new Vector<Vertex>();
        int i = 0;
        while (i < this.edges.size()) {
            Edge edge = (Edge)this.edges.get(i);
            if (edge.seam) {
                vertices.addElement(edge.get_opposite_vertex(this));
            }
            ++i;
        }
        return vertices;
    }

    public List get_surrounding_vertices() {
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        int i = 0;
        while (i < this.edges.size()) {
            Edge edge = (Edge)this.edges.get(i);
            vertices.add(edge.get_opposite_vertex(this));
            ++i;
        }
        return vertices;
    }

    public static double distance(Vertex u, Vertex v) {
        return Vector3.subtract(u, v).length();
    }

    public static Vertex interpolate(Vertex start, Vertex end, double t) {
        return new Vertex(start.x * (1.0 - t) + end.x * t, start.y * (1.0 - t) + end.y * t, start.z * (1.0 - t) + end.z * t);
    }

    public boolean on_sharp() {
        int count = 0;
        int i = 0;
        while (i < this.edges.size()) {
            Edge edge = (Edge)this.edges.get(i);
            if (edge.sharp) {
                ++count;
            }
            ++i;
        }
        return count >= 2;
    }

    public Vector3 get_sharp_normal(Face polygon) {
        if (!this.on_sharp()) {
            return this.normal;
        }
        Vector<Face> polygons = new Vector<Face>();
        polygons.addElement(polygon);
        int i = 0;
        while (i < 3) {
            if (polygon.edges[i].contains(this)) {
                this.get_sharp_normal_sub(polygon.edges[i], polygon, polygons, polygon);
            }
            ++i;
        }
        Vector3 vector = new Vector3();
        int i2 = 0;
        while (i2 < polygons.size()) {
            vector.add(((Face)polygons.elementAt((int)i2)).normal);
            ++i2;
        }
        vector.normalize();
        return vector;
    }

    public void get_sharp_normal_sub(Edge edge, Face polygon, Vector polygons, Face start_polygon) {
        if (edge.sharp) {
            return;
        }
        Face next_polygon = edge.get_opposite_face(polygon);
        if (next_polygon == null || next_polygon == start_polygon) {
            return;
        }
        int i = 0;
        while (i < 3) {
            Edge next_edge = next_polygon.edges[i];
            if (next_edge.contains(this) && next_edge != edge) {
                polygons.addElement(next_polygon);
                this.get_sharp_normal_sub(next_edge, next_polygon, polygons, start_polygon);
            }
            ++i;
        }
    }

    public Vertex copy() {
        Vertex v = new Vertex(this.x, this.y, this.z);
        v.edges = this.edges;
        if (this.normal != null) {
            v.normal = new Vector3(this.normal);
        }
        v.fixed = this.fixed;
        this.child = v;
        v.body_element = this.body_element;
        v.body_vertex = this.body_vertex;
        v.child_vertices = this.child_vertices;
        v.index = this.index;
        return v;
    }

    public void renew_network() {
        ArrayList<Edge> new_edges = new ArrayList<Edge>();
        int i = 0;
        while (i < this.edges.size()) {
            Edge edge = (Edge)this.edges.get(i);
            new_edges.add(edge.child);
            ++i;
        }
        this.edges = new_edges;
    }

    public void setPatternCoord(Vertex2D v) {
        this.patternCoord = v;
    }

    public void setPatternCoord(double _u, double _v) {
        this.patternCoord = new Vertex2D(_u, _v);
    }

    public Vertex2D getPatternCoord() {
        return this.patternCoord;
    }

    public void setTextureCoord(double _u, double _v) {
        this.u = _u;
        this.v = _v;
    }

    public void setInputVertex(Vertex _v) {
        this.inputVertex = _v;
    }

    public Vertex getInputVertex() {
        return this.inputVertex;
    }
}

