/*
 * Decompiled with CFR 0.152.
 */
package teddy;

public class Vector3 {
    public double x;
    public double y;
    public double z;

    public Vector3() {
    }

    public Vector3(double _x, double _y, double _z) {
        this.x = _x;
        this.y = _y;
        this.z = _z;
    }

    public Vector3(Vector3 v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public Vector3(Vector3 v0, Vector3 v1) {
        this.x = v1.x - v0.x;
        this.y = v1.y - v0.y;
        this.z = v1.z - v0.z;
    }

    public String toString() {
        return "(" + this.x + "," + this.y + "," + this.z + ")";
    }

    public static Vector3 normalize(Vector3 v) {
        double l = v.length();
        if (l == 0.0) {
            return new Vector3();
        }
        return new Vector3(v.x / l, v.y / l, v.z / l);
    }

    public void normalize() {
        double l = this.length();
        if (l == 0.0) {
            return;
        }
        this.x /= l;
        this.y /= l;
        this.z /= l;
    }

    public void negate() {
        this.x *= -1.0;
        this.y *= -1.0;
        this.z *= -1.0;
    }

    public static Vector3 negate(Vector3 v) {
        return new Vector3(-v.x, -v.y, -v.z);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public static Vector3 add(Vector3 u, Vector3 v) {
        return new Vector3(u.x + v.x, u.y + v.y, u.z + v.z);
    }

    public static Vector3 add(Vector3 u, Vector3 v, Vector3 w) {
        return new Vector3(u.x + v.x + w.x, u.y + v.y + w.y, u.z + v.z + w.z);
    }

    public void add(Vector3 v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
    }

    public Vector3 add2(Vector3 v) {
        return new Vector3(this.x + v.x, this.y + v.y, this.z + v.z);
    }

    public static Vector3 subtract(Vector3 u, Vector3 v) {
        return new Vector3(u.x - v.x, u.y - v.y, u.z - v.z);
    }

    public void subtract(Vector3 v) {
        this.x -= v.x;
        this.y -= v.y;
        this.z -= v.z;
    }

    public Vector3 subtract2(Vector3 v) {
        return new Vector3(this.x - v.x, this.y - v.y, this.z - v.z);
    }

    public static Vector3 multiply(Vector3 v, double m) {
        return new Vector3(v.x * m, v.y * m, v.z * m);
    }

    public void multiply(double m) {
        this.x *= m;
        this.y *= m;
        this.z *= m;
    }

    public Vector3 multiple(double m) {
        return new Vector3(this.x * m, this.y * m, this.z * m);
    }

    public static double dot_product(Vector3 u, Vector3 v) {
        return u.x * v.x + u.y * v.y + u.z * v.z;
    }

    public double dot_product(Vector3 vec) {
        return Vector3.dot_product(this, vec);
    }

    public static double cos(Vector3 u, Vector3 v) {
        double length = u.length() * v.length();
        if (length > 0.0) {
            return Vector3.dot_product(u, v) / length;
        }
        return 0.0;
    }

    public double cos(Vector3 vec) {
        return Vector3.cos(this, vec);
    }

    public static Vector3 cross_product(Vector3 u, Vector3 v) {
        double _x = u.y * v.z - u.z * v.y;
        double _y = u.z * v.x - u.x * v.z;
        double _z = u.x * v.y - u.y * v.x;
        return new Vector3(_x, _y, _z);
    }

    public Vector3 cross_product(Vector3 vec) {
        return Vector3.cross_product(this, vec);
    }

    public static double sin(Vector3 u, Vector3 v) {
        double length = u.length() * v.length();
        if (length > 0.0) {
            return Vector3.cross_product(u, v).length() / length;
        }
        return 0.0;
    }

    public double sin(Vector3 vec) {
        return Vector3.sin(this, vec);
    }

    public static double get_angle_PI(Vector3 u, Vector3 v) {
        double cosine = Vector3.cos(u, v);
        if (cosine <= -1.0) {
            return Math.PI;
        }
        if (cosine >= 1.0) {
            return 0.0;
        }
        return Math.acos(cosine);
    }

    public double get_relative_angle(Vector3 vec) {
        return Vector3.get_angle_PI(this, vec);
    }

    public static double get_angle_360(Vector3 u, Vector3 v, Vector3 normal) {
        double cos = Vector3.cos(u, v);
        double sin = Vector3.sin(u, v);
        if (Vector3.dot_product(Vector3.cross_product(u, v), normal) < 0.0) {
            sin *= -1.0;
        }
        if (cos == 0.0) {
            if (sin > 0.0) {
                return 90.0;
            }
            return 270.0;
        }
        if (sin == 0.0) {
            if (cos > 0.0) {
                return 0.0;
            }
            return 180.0;
        }
        double angle = 180.0 * Math.atan(sin / cos) / Math.PI;
        if (cos < 0.0) {
            angle += 180.0;
        }
        if (angle < 0.0) {
            angle += 360.0;
        }
        return angle;
    }

    public static double get_angle_signed_180(Vector3 u, Vector3 v, Vector3 normal) {
        double angle = Vector3.get_angle_360(u, v, normal);
        if (angle > 180.0) {
            return angle - 360.0;
        }
        return angle;
    }

    public static Vector3 interpolate(Vector3 start, Vector3 end, double t) {
        return new Vector3(start.x * (1.0 - t) + end.x * t, start.y * (1.0 - t) + end.y * t, start.z * (1.0 - t) + end.z * t);
    }

    public static double distance(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1) + (z2 - z1) * (z2 - z1));
    }

    public static Vector3 rotate(Vector3 vec, Vector3 normal, double radian) {
        Vector3 vx = vec;
        Vector3 vy = Vector3.cross_product(normal, vx);
        return Vector3.add(Vector3.multiply(vx, Math.cos(radian)), Vector3.multiply(vy, Math.sin(radian)));
    }

    public static Vector3 rotate(Vector3 vec, Vector3 normal, double cos, double sin) {
        Vector3 vx = vec;
        Vector3 vy = Vector3.cross_product(normal, vx);
        return Vector3.add(Vector3.multiply(vx, cos), Vector3.multiply(vy, sin));
    }

    public static double get_angle_2PI(Vector3 u, Vector3 v, Vector3 normal) {
        double cos = Vector3.cos(u, v);
        double sin = Vector3.sin(u, v);
        if (Vector3.dot_product(Vector3.cross_product(u, v), normal) < 0.0) {
            sin *= -1.0;
        }
        if (cos == 0.0) {
            if (sin > 0.0) {
                return 1.5707963267948966;
            }
            return 4.71238898038469;
        }
        if (sin == 0.0) {
            if (cos > 0.0) {
                return 0.0;
            }
            return Math.PI;
        }
        double angle = Math.atan(sin / cos);
        if (cos < 0.0) {
            angle += Math.PI;
        }
        if (angle < 0.0) {
            angle += Math.PI * 2;
        }
        return angle;
    }

    public boolean parallel(Vector3 v) {
        double sine = this.sin(v);
        return sine < 0.01 && sine > -0.01;
    }
}

