/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.awt.Point;
import teddy.Vertex2D;

public class Vector2 {
    public double x;
    public double y;

    public Vector2(Point start, Point end) {
        this.x = end.x - start.x;
        this.y = end.y - start.y;
    }

    public Vector2(Vector2 start, Vector2 end) {
        this.x = end.x - start.x;
        this.y = end.y - start.y;
    }

    Vector2(Point p) {
        this.x = p.x;
        this.y = p.y;
    }

    public Vector2() {
    }

    public Vector2(double _x, double _y) {
        this.x = _x;
        this.y = _y;
    }

    public Vector2(Vector2 v) {
        this.x = v.x;
        this.y = v.y;
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }

    public Vector2 duplicate() {
        return new Vector2(this.x, this.y);
    }

    public static Vector2 normalize(Vector2 v) {
        double l = v.length();
        return new Vector2(v.x / l, v.y / l);
    }

    public void normalize() {
        double l = this.length();
        this.x /= l;
        this.y /= l;
    }

    public void negate() {
        this.x *= -1.0;
        this.y *= -1.0;
    }

    public static Vector2 negate(Vector2 v) {
        return new Vector2(-v.x, -v.y);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public static Vector2 add(Vector2 u, Vector2 v) {
        return new Vector2(u.x + v.x, u.y + v.y);
    }

    public void add(Vector2 v) {
        this.x += v.x;
        this.y += v.y;
    }

    public static Vector2 add(Vector2 u, Vector2 v, Vector2 w) {
        return new Vector2(u.x + v.x + w.x, u.y + v.y + w.y);
    }

    public static Vector2 subtract(Vector2 u, Vector2 v) {
        return new Vector2(u.x - v.x, u.y - v.y);
    }

    public void subtract(Vector2 v) {
        this.x -= v.x;
        this.y -= v.y;
    }

    public static Vector2 multiply(Vector2 v, double m) {
        return new Vector2(v.x * m, v.y * m);
    }

    public void multiply(double m) {
        this.x *= m;
        this.y *= m;
    }

    public static double dot_product(Vector2 u, Vector2 v) {
        return u.x * v.x + u.y * v.y;
    }

    public static double cos(Vector2 u, Vector2 v) {
        double length = u.length() * v.length();
        if (length > 0.0) {
            return Vector2.dot_product(u, v) / length;
        }
        return 0.0;
    }

    public static double cross_product(Vector2 u, Vector2 v) {
        return u.x * v.y - u.y * v.x;
    }

    public static double sin(Vector2 u, Vector2 v) {
        double length = u.length() * v.length();
        if (length > 0.0) {
            return Vector2.cross_product(u, v) / length;
        }
        return 0.0;
    }

    public static double get_angle_PI(Vector2 u, Vector2 v) {
        double cosine = Vector2.cos(u, v);
        if (cosine <= -1.0) {
            return Math.PI;
        }
        if (cosine >= 1.0) {
            return 0.0;
        }
        return Math.acos(cosine);
    }

    public double get_angle_PI(Vector2 vec) {
        return Vector2.get_angle_PI(this, vec);
    }

    public static double get_angle_360(Vector2 u, Vector2 v) {
        double cos = Vector2.cos(u, v);
        double sin = Vector2.sin(u, v);
        if (cos == 0.0) {
            if (sin > 0.0) {
                return 90.0;
            }
            return 270.0;
        }
        if (sin == 0.0) {
            if (cos > 0.0) {
                return 0.0;
            }
            return 180.0;
        }
        double angle = 180.0 * Math.atan(sin / cos) / Math.PI;
        if (cos < 0.0) {
            angle += 180.0;
        }
        if (angle < 0.0) {
            angle += 360.0;
        }
        return angle;
    }

    public static Vector2 rotate90(Vector2 vec) {
        return new Vector2(vec.y, -vec.x);
    }

    public static Vector2 rotate(Vector2 v, double degree) {
        if (degree == 90.0) {
            return new Vector2(-v.y, v.x);
        }
        if (degree == 180.0) {
            return new Vector2(-v.x, -v.y);
        }
        if (degree == 270.0) {
            return new Vector2(v.y, -v.x);
        }
        double radian = degree * Math.PI / 180.0;
        double cos = Math.cos(radian);
        double sin = Math.sin(radian);
        return new Vector2(v.x * cos - v.y * sin, v.x * sin + v.y * cos);
    }

    public static Vector2 interporate(Vector2 start, Vector2 end, double t) {
        return new Vector2(start.x * (1.0 - t) + end.x * t, start.y * (1.0 - t) + end.y * t);
    }

    public static double distance(int x1, int y1, int x2, int y2) {
        return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
    }

    public static double distance(Point start, Point end) {
        return Vector2.distance(start.x, start.y, end.x, end.y);
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
    }

    public static Vector2 interporate(Point start, Point end, double t) {
        return new Vector2((double)start.x * (1.0 - t) + (double)end.x * t, (double)start.y * (1.0 - t) + (double)end.y * t);
    }

    public Point point() {
        return new Point((int)this.x, (int)this.y);
    }

    public static double distance(Vertex2D start, Vertex2D end) {
        return Vector2.distance(start.x, start.y, end.x, end.y);
    }

    public Vertex2D vertex2D() {
        return new Vertex2D(this.x, this.y);
    }
}

