/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.util.List;
import java.util.Vector;
import teddy.Util;
import teddy.Vector2;
import teddy.Vertex2D;

public class Triangulation2 {
    Vector triangles;

    static Vector triangulate(List boundary) {
        return new Triangulation2().triangulate_main(boundary);
    }

    Vector triangulate_main(List boundary) {
        Object v;
        int n = boundary.size();
        Vertex[] vertices = new Vertex[n];
        int i = 0;
        while (i < n) {
            v = (Vertex2D)boundary.get(i);
            vertices[i] = new Vertex(i, (Vertex2D)v);
            ++i;
        }
        i = 0;
        while (i < n) {
            v = vertices[i];
            Vertex prev = vertices[Util.mod(i - 1, n)];
            Vertex next = vertices[Util.mod(i + 1, n)];
            ((Vertex)v).angle = this.get_angle(prev, (Vertex)v, next);
            ++i;
        }
        this.triangles = new Vector();
        this.recursive_ear_cut(vertices);
        return this.triangles;
    }

    boolean is_concave(Vertex prev, Vertex v, Vertex next) {
        Vector2 vec0 = new Vector2(v.v, prev.v);
        Vector2 vec1 = new Vector2(v.v, next.v);
        return Vector2.get_angle_360(vec0, vec1) < 180.0;
    }

    double get_angle(Vertex prev, Vertex v, Vertex next) {
        Vector2 vec0 = new Vector2(v.v, prev.v);
        Vector2 vec1 = new Vector2(v.v, next.v);
        return Vector2.get_angle_360(vec0, vec1);
    }

    void recursive_ear_cut(Vertex[] polygon) {
        if (polygon.length == 3) {
            int[] triangle = new int[]{polygon[0].index, polygon[1].index, polygon[2].index};
            this.triangles.addElement(triangle);
            return;
        }
        int n = polygon.length;
        int index = this.find_convex_index(polygon);
        if (index == -1) {
            System.out.println("no convex index");
            return;
        }
        Vertex v = polygon[index];
        Vertex prev = polygon[Util.mod(index - 1, n)];
        Vertex next = polygon[Util.mod(index + 1, n)];
        int i = index + 2;
        while (i <= n + index - 2) {
            Vertex w = polygon[Util.mod(i, n)];
            if (w.angle < 180.0 && this.is_inside(prev.v, v.v, next.v, w.v)) {
                i = this.find_diagonal(polygon, index, i, prev, v, next);
                this.recursive_ear_cut(this.sub_polygon(polygon, index, i));
                this.recursive_ear_cut(this.sub_polygon(polygon, i, n + index));
                return;
            }
            ++i;
        }
        int[] triangle = new int[]{v.index, next.index, prev.index};
        this.triangles.addElement(triangle);
        this.recursive_ear_cut(this.sub_polygon(polygon, index + 1, n + index - 1));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int find_convex_index(Vertex[] polygon) {
        int index = -1;
        double angle = Double.MIN_VALUE;
        int i = 0;
        while (i < polygon.length) {
            if (polygon[i].angle >= 180.0) {
                if (index != -1 && !(polygon[i].angle > angle)) return index;
                index = i;
                angle = polygon[i].angle;
            } else if (index != -1) {
                return index;
            }
            ++i;
        }
        if (index != -1) {
            return index;
        }
        System.out.println("error in Triangulation2.find_concave_index() ");
        return -1;
    }

    int find_diagonal(Vertex[] polygon, int index, int i, Vertex prev, Vertex v, Vertex next) {
        int n = polygon.length;
        Vertex w = polygon[i];
        double min = Vertex2D.distance(v.v, w.v);
        int min_index = i++;
        while (i < index + n - 1) {
            Vertex u = polygon[Util.mod(i, n)];
            if (u.angle < 180.0 && this.is_inside(prev.v, v.v, next.v, u.v)) {
                double d;
                double d2 = Vertex2D.distance(v.v, u.v);
                if (d < min) {
                    min = d2;
                    min_index = i;
                }
            }
            ++i;
        }
        return min_index;
    }

    Vertex[] sub_polygon(Vertex[] polygon, int index0, int index1) {
        int n = index1 - index0 + 1;
        Vertex[] new_polygon = new Vertex[n];
        new_polygon[0] = polygon[Util.mod(index1, polygon.length)];
        int i = index0;
        while (i < index1) {
            new_polygon[1 + i - index0] = polygon[Util.mod(i, polygon.length)];
            ++i;
        }
        new_polygon[0] = new_polygon[0].duplicate();
        new_polygon[1] = new_polygon[1].duplicate();
        new_polygon[0].angle = this.get_angle(new_polygon[n - 1], new_polygon[0], new_polygon[1]);
        new_polygon[1].angle = this.get_angle(new_polygon[0], new_polygon[1], new_polygon[2]);
        return new_polygon;
    }

    boolean is_inside(Vertex2D v0, Vertex2D v1, Vertex2D v2, Vertex2D p) {
        Vector2 vector2 = new Vector2(v0, v1);
        Vector2 vector22 = new Vector2(v0, p);
        if (Vector2.cross_product(vector2, vector22) <= 0.0) {
            return false;
        }
        Vector2 vector23 = new Vector2(v1, v2);
        Vector2 vector24 = new Vector2(v1, p);
        if (Vector2.cross_product(vector23, vector24) <= 0.0) {
            return false;
        }
        Vector2 vector25 = new Vector2(v2, v0);
        Vector2 vector26 = new Vector2(v2, p);
        return !(Vector2.cross_product(vector25, vector26) <= 0.0);
    }

    class Vertex {
        Vertex2D v;
        double angle;
        int index;

        Vertex(int _index, Vertex2D _v) {
            this.index = _index;
            this.v = _v;
        }

        Vertex duplicate() {
            Vertex vertex = new Vertex(this.index, this.v);
            vertex.angle = this.angle;
            return vertex;
        }
    }
}

