/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.util.ArrayList;
import java.util.List;
import teddy.Edge;
import teddy.Face;
import teddy.Polyhedron;
import teddy.Util;
import teddy.Vector3;
import teddy.Vertex;

class Tessellation {
    public static Polyhedron h;

    Tessellation() {
    }

    public static int refine_mesh_connectivity(Polyhedron _h) {
        h = _h;
        ArrayList<Edge> edges = new ArrayList<Edge>();
        int i = 0;
        while (i < Tessellation.h.edges.size()) {
            if (h.edges(i) != null) {
                edges.add(h.edges(i));
            }
            ++i;
        }
        int count = 0;
        ArrayList _edges = new ArrayList();
        int max_count = edges.size() * 4;
        int i2 = 0;
        while (i2 < edges.size()) {
            Edge edge = (Edge)edges.get(i2);
            if (!edge.disposed) {
                if (Tessellation.swap_valence_test(edge)) {
                    Tessellation.swap_edge(edge, edges);
                    ++count;
                } else if (Tessellation.split_valence_test(edge)) {
                    Tessellation.split_edge(edge, edges);
                    ++count;
                } else if (Tessellation.collapse_valence_test(edge)) {
                    Tessellation.collapse_edge(edge, edges);
                    ++count;
                }
            }
            if (count >= max_count) break;
            ++i2;
        }
        return count;
    }

    public static boolean split_valence_test(Edge edge) {
        if (edge.left_face == null || edge.right_face == null) {
            return false;
        }
        double target_length = Tessellation.h.unit_length;
        if (edge.length() < target_length * 1.25) {
            return false;
        }
        if (edge.length() > target_length * 1.5) {
            return true;
        }
        int v0_edges = 0;
        int v1_edges = 0;
        if (edge.left_face != null) {
            v0_edges = edge.left_face.get_opposite_vertex((Edge)edge).edges.size();
        }
        if (edge.right_face != null) {
            v1_edges = edge.right_face.get_opposite_vertex((Edge)edge).edges.size();
        }
        return v0_edges < 6 && v1_edges < 6;
    }

    public static boolean collapse_valence_test(Edge edge) {
        Vertex p;
        if (edge.start.fixed || edge.end.fixed) {
            return false;
        }
        if (!edge.seam && edge.start.on_seam() && edge.end.on_seam()) {
            return false;
        }
        double target_length = Tessellation.h.unit_length;
        if (edge.length() > target_length * 0.75) {
            return false;
        }
        Vertex v0 = null;
        Vertex v1 = null;
        if (edge.left_face != null) {
            v0 = edge.left_face.get_opposite_vertex(edge);
        }
        if (edge.right_face != null) {
            v1 = edge.right_face.get_opposite_vertex(edge);
        }
        ArrayList<Vertex> around_start = new ArrayList<Vertex>();
        List start_surrounding_vertices = edge.start.get_surrounding_vertices();
        int i = 0;
        while (i < start_surrounding_vertices.size()) {
            Vertex p2 = (Vertex)start_surrounding_vertices.get(i);
            if (p2 != v0 && p2 != v1 && p2 != edge.end) {
                around_start.add(p2);
            }
            ++i;
        }
        ArrayList<Vertex> around_end = new ArrayList<Vertex>();
        List end_surrounding_vertices = edge.end.get_surrounding_vertices();
        int i2 = 0;
        while (i2 < end_surrounding_vertices.size()) {
            p = (Vertex)end_surrounding_vertices.get(i2);
            if (p != v0 && p != v1 && p != edge.start) {
                around_end.add(p);
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < around_start.size()) {
            p = (Vertex)around_start.get(i2);
            int j = 0;
            while (j < around_end.size()) {
                Vertex q = (Vertex)around_end.get(j);
                if (p == q || p.get_common_edge(q) != null) {
                    return false;
                }
                ++j;
            }
            ++i2;
        }
        if (!edge.seam && edge.start.on_seam() && Tessellation.collapse_causes_flip(edge.start, edge.end)) {
            return false;
        }
        if (!edge.seam && edge.end.on_seam() && Tessellation.collapse_causes_flip(edge.end, edge.start)) {
            return false;
        }
        if (edge.length() < target_length * 0.5) {
            return true;
        }
        int v0_edges = 0;
        int v1_edges = 0;
        if (v0 != null) {
            v0_edges = v0.edges.size();
        }
        if (v1 != null) {
            v1_edges = v1.edges.size();
        }
        int before = Math.abs(v0_edges - 6) + Math.abs(v1_edges - 6) + Math.abs(edge.start.edges.size() - 6) + Math.abs(edge.end.edges.size() - 6);
        int after = Math.abs(v0_edges - 7) + Math.abs(v1_edges - 7) + Math.abs(edge.start.edges.size() + edge.end.edges.size() - 4 - 6);
        return after < before;
    }

    private static boolean collapse_causes_flip(Vertex base, Vertex v) {
        List edges = v.get_surrounding_edges();
        int i = 0;
        while (i < edges.size()) {
            Vector3 target_normal;
            Vector3 current_normal;
            Edge edge = (Edge)edges.get(i);
            if (!edge.contains(base) && Vector3.cos(current_normal = Vector3.cross_product(new Vector3(v, edge.start), new Vector3(v, edge.end)), target_normal = Vector3.cross_product(new Vector3(base, edge.start), new Vector3(base, edge.end))) <= 0.0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean swap_valence_test(Edge edge) {
        Vector3 target_normal1;
        Vector3 current_normal1;
        Vertex v1;
        if (edge.left_face == null || edge.right_face == null) {
            return false;
        }
        if (edge.start.fixed || edge.end.fixed) {
            return false;
        }
        if (edge.seam) {
            return false;
        }
        Vertex v0 = edge.left_face.get_opposite_vertex(edge);
        if (v0.get_common_edge(v1 = edge.right_face.get_opposite_vertex(edge)) != null) {
            return false;
        }
        if (Tessellation.get_angle(v0, edge.start, edge.end) >= 1.5707963267948966 || Tessellation.get_angle(v0, edge.end, edge.start) >= 1.5707963267948966 || Tessellation.get_angle(v1, edge.start, edge.end) >= 1.5707963267948966 || Tessellation.get_angle(v1, edge.end, edge.start) >= 1.5707963267948966) {
            return false;
        }
        Vector3 current_normal0 = Tessellation.get_normal(v0, edge.start, edge.end);
        if (Vector3.cos(current_normal0, current_normal1 = Tessellation.get_normal(v1, edge.end, edge.start)) < 0.7) {
            return false;
        }
        Vector3 target_normal0 = Tessellation.get_normal(edge.start, v0, v1);
        if (Vector3.cos(target_normal0, target_normal1 = Tessellation.get_normal(edge.end, v1, v0)) < 0.7) {
            return false;
        }
        double current_min_angle = Tessellation.min(Tessellation.get_angle(v0, edge.start, edge.end), Tessellation.get_angle(v0, edge.end, edge.start), Tessellation.get_angle(v1, edge.start, edge.end), Tessellation.get_angle(v1, edge.end, edge.start));
        double target_min_angle = Tessellation.min(Tessellation.get_angle(v0, v1, edge.end), Tessellation.get_angle(v0, v1, edge.start), Tessellation.get_angle(v1, v0, edge.end), Tessellation.get_angle(v1, v0, edge.start));
        if (target_min_angle > current_min_angle * 1.25) {
            return true;
        }
        if (target_min_angle < current_min_angle * 0.8) {
            return false;
        }
        int before = Math.abs(v0.edges.size() - 6) + Math.abs(v1.edges.size() - 6) + Math.abs(edge.start.edges.size() - 6) + Math.abs(edge.end.edges.size() - 6);
        int after = Math.abs(v0.edges.size() - 5) + Math.abs(v1.edges.size() - 5) + Math.abs(edge.start.edges.size() - 7) + Math.abs(edge.end.edges.size() - 7);
        return after < before;
    }

    private static double min(double a, double b, double c, double d) {
        return Math.min(Math.min(a, b), Math.min(c, d));
    }

    private static double get_angle(Vertex v0, Vertex v1, Vertex v2) {
        Vector3 vec0 = new Vector3(v1, v0);
        Vector3 vec1 = new Vector3(v1, v2);
        return Vector3.get_angle_PI(vec0, vec1);
    }

    private static Vector3 get_normal(Vertex v0, Vertex v1, Vertex v2) {
        Vector3 vec0 = new Vector3(v1, v0);
        Vector3 vec1 = new Vector3(v1, v2);
        return Vector3.cross_product(vec0, vec1);
    }

    private static void split_edge(Edge edge, List dirty_edges) {
        Vertex mid_vertex = edge.mid_vertex();
        Edge edge0 = new Edge(edge.start, mid_vertex);
        Edge edge1 = new Edge(mid_vertex, edge.end);
        edge0.seam = edge1.seam = edge.seam;
        h.add(mid_vertex);
        h.add(edge0);
        h.add(edge1);
        dirty_edges.add(edge0);
        dirty_edges.add(edge1);
        if (edge.left_face != null) {
            Tessellation.split_edge_sub(edge.left_face, edge, edge0, edge1, mid_vertex, dirty_edges);
        }
        if (edge.right_face != null) {
            Tessellation.split_edge_sub(edge.right_face, edge, edge1, edge0, mid_vertex, dirty_edges);
        }
    }

    private static void split_edge_sub(Face old_face, Edge edge, Edge edge0, Edge edge1, Vertex mid_vertex, List dirty_edges) {
        int n = old_face.get_edge_index(edge);
        Edge mid_edge = new Edge(old_face.get_vertex(n + 2), mid_vertex);
        Face new_face0 = new Face(old_face.edges(n + 1), mid_edge, edge1);
        Face new_face1 = new Face(old_face.edges(n + 2), edge0, mid_edge);
        h.add(mid_edge);
        h.add(new_face0);
        h.add(new_face1);
        h.remove(old_face);
        dirty_edges.add(mid_edge);
    }

    private static void collapse_edge(Edge short_edge, List dirty_edges) {
        boolean on_seam_start = short_edge.start.on_seam();
        boolean on_seam_end = short_edge.end.on_seam();
        if (short_edge.start.fixed && short_edge.end.fixed || short_edge.start.fixed && on_seam_end || on_seam_start && short_edge.end.fixed) {
            return;
        }
        if (short_edge.start.fixed) {
            Tessellation.remove_a_short_edge(short_edge, short_edge.end, short_edge.start, dirty_edges);
        } else if (short_edge.end.fixed) {
            Tessellation.remove_a_short_edge(short_edge, short_edge.start, short_edge.end, dirty_edges);
        } else if (on_seam_start && on_seam_end) {
            Tessellation.collapse_edge_center(short_edge, dirty_edges);
        } else if (on_seam_start) {
            Tessellation.remove_a_short_edge(short_edge, short_edge.end, short_edge.start, dirty_edges);
        } else if (on_seam_end) {
            Tessellation.remove_a_short_edge(short_edge, short_edge.start, short_edge.end, dirty_edges);
        } else {
            Tessellation.collapse_edge_center(short_edge, dirty_edges);
        }
    }

    private static void collapse_edge_center(Edge short_edge, List dirty_edges) {
        Face face;
        Vertex the_other_vertex;
        Edge edge;
        Face left_face = short_edge.left_face;
        Face right_face = short_edge.right_face;
        List start_faces = Util.duplicate(short_edge.start.get_faces());
        List end_faces = Util.duplicate(short_edge.end.get_faces());
        Vertex new_vertex = short_edge.mid_vertex();
        new_vertex.fixed = short_edge.start.fixed;
        h.add(new_vertex);
        ArrayList edge_replace_list = new ArrayList();
        int i = 0;
        while (i < short_edge.start.edges.size()) {
            edge = (Edge)short_edge.start.edges.get(i);
            if (edge != short_edge) {
                the_other_vertex = edge.get_opposite_vertex(short_edge.start);
                Tessellation.register_replacement(edge_replace_list, edge, new_vertex, the_other_vertex, dirty_edges);
            }
            ++i;
        }
        i = 0;
        while (i < short_edge.end.edges.size()) {
            edge = (Edge)short_edge.end.edges.get(i);
            if (edge != short_edge) {
                the_other_vertex = edge.get_opposite_vertex(short_edge.end);
                Tessellation.register_replacement(edge_replace_list, edge, new_vertex, the_other_vertex, dirty_edges);
            }
            ++i;
        }
        i = 0;
        while (i < start_faces.size()) {
            face = (Face)start_faces.get(i);
            if (face != left_face && face != right_face) {
                h.add(Tessellation.replaced_face(face, edge_replace_list));
                h.remove(face);
            }
            ++i;
        }
        i = 0;
        while (i < end_faces.size()) {
            face = (Face)end_faces.get(i);
            if (face != left_face && face != right_face) {
                h.add(Tessellation.replaced_face(face, edge_replace_list));
                h.remove(face);
            }
            ++i;
        }
        if (left_face != null) {
            h.remove(left_face);
        }
        if (right_face != null) {
            h.remove(right_face);
        }
    }

    private static void swap_edge(Edge edge, List dirty_edges) {
        Vertex v0 = edge.left_face.get_opposite_vertex(edge);
        Vertex v1 = edge.right_face.get_opposite_vertex(edge);
        Edge start_v0 = edge.left_face.get_opposite_edge(edge.end);
        Edge end_v0 = edge.left_face.get_opposite_edge(edge.start);
        Edge start_v1 = edge.right_face.get_opposite_edge(edge.end);
        Edge end_v1 = edge.right_face.get_opposite_edge(edge.start);
        Face left_face = edge.left_face;
        Face right_face = edge.right_face;
        Edge new_edge = new Edge(v0, v1);
        Face new_face0 = new Face(start_v1, new_edge, start_v0);
        Face new_face1 = new Face(end_v0, new_edge, end_v1);
        h.add(new_edge);
        h.add(new_face0);
        h.add(new_face1);
        h.remove(left_face);
        h.remove(right_face);
        dirty_edges.add(new_edge);
    }

    public static void remove_a_short_edge(Edge short_edge, Vertex deleted_vertex, Vertex base_vertex, List dirty_edges) {
        Face left_face = short_edge.left_face;
        Face right_face = short_edge.right_face;
        List deleted_faces = Util.duplicate(deleted_vertex.get_faces());
        Vertex new_vertex = base_vertex;
        ArrayList edge_replace_list = new ArrayList();
        Tessellation.init_replacement(edge_replace_list, base_vertex);
        int i = 0;
        while (i < deleted_vertex.edges.size()) {
            Edge edge = (Edge)deleted_vertex.edges.get(i);
            if (edge != short_edge) {
                Vertex the_other_vertex = edge.get_opposite_vertex(deleted_vertex);
                Tessellation.register_replacement(edge_replace_list, edge, new_vertex, the_other_vertex, dirty_edges);
            }
            ++i;
        }
        i = 0;
        while (i < deleted_faces.size()) {
            Face face = (Face)deleted_faces.get(i);
            if (face != left_face && face != right_face) {
                h.add(Tessellation.replaced_face(face, edge_replace_list));
                h.remove(face);
            }
            ++i;
        }
        h.remove(left_face);
        h.remove(right_face);
    }

    private static Face replaced_face_special(Face face, List edge_replace_list, Edge short_edge) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        int i = 0;
        while (i < face.edges.length) {
            Edge edge = face.edges[i];
            if (edge != short_edge) {
                edges.add(Tessellation.get_corresponding_edge(edge, edge_replace_list));
            }
            ++i;
        }
        return new Face(edges);
    }

    private static Face replaced_face(Face face, List edge_replace_list) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        int i = 0;
        while (i < face.edges.length) {
            Edge edge = face.edges(i);
            edges.add(Tessellation.get_corresponding_edge(edge, edge_replace_list));
            ++i;
        }
        return new Face(edges);
    }

    private static Edge get_corresponding_edge(Edge edge, List edge_replace_list) {
        int i = 0;
        while (i < edge_replace_list.size()) {
            Object[] objects = (Object[])edge_replace_list.get(i);
            Edge registered_edge = (Edge)objects[0];
            if (edge == registered_edge) {
                return (Edge)objects[1];
            }
            ++i;
        }
        return edge;
    }

    private static void init_replacement(List edge_replace_list, Vertex base_vertex) {
        int i = 0;
        while (i < base_vertex.edges.size()) {
            Edge edge = (Edge)base_vertex.edges.get(i);
            Object[] new_objects = new Object[]{edge, edge};
            edge_replace_list.add(new_objects);
            ++i;
        }
    }

    private static void register_replacement(List edge_replace_list, Edge edge, Vertex start, Vertex end, List dirty_edges) {
        Object[] objects;
        int i = 0;
        while (i < edge_replace_list.size()) {
            objects = (Object[])edge_replace_list.get(i);
            Edge new_edge = (Edge)objects[1];
            if (new_edge.contains(start) && new_edge.contains(end)) {
                Object[] new_objects = new Object[]{edge, new_edge};
                edge_replace_list.add(new_objects);
                if (edge.seam) {
                    new_edge.seam = true;
                }
                return;
            }
            ++i;
        }
        Edge new_edge = new Edge(start, end);
        h.add(new_edge);
        new_edge.seam = edge.seam;
        objects = new Object[]{edge, new_edge};
        edge_replace_list.add(objects);
        dirty_edges.add(new_edge);
    }
}

