/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.util.List;
import teddy.Util;
import teddy.Vector2;
import teddy.Vertex2D;

public class TaubinFairing2D {
    public static void smooth(List points, int n) {
        int i = 0;
        while (i < n) {
            TaubinFairing2D.smooth_sub(points, 0.63139836);
            TaubinFairing2D.smooth_sub(points, -0.6739516);
            ++i;
        }
    }

    public static void smooth_sub(List vertices, double direction) {
        Vertex2D v;
        Vertex2D[] new_positions = new Vertex2D[vertices.size()];
        int i = 0;
        while (i < vertices.size()) {
            v = (Vertex2D)vertices.get(i);
            Vertex2D prev = (Vertex2D)vertices.get(Util.mod(i - 1, vertices.size()));
            Vertex2D next = (Vertex2D)vertices.get(Util.mod(i + 1, vertices.size()));
            new_positions[i] = TaubinFairing2D.to_sum_of_vectors(v, prev, next, direction);
            ++i;
        }
        i = 0;
        while (i < vertices.size()) {
            v = (Vertex2D)vertices.get(i);
            if (!v.fixed) {
                v.warp(new_positions[i]);
            }
            ++i;
        }
    }

    public static Vertex2D to_sum_of_vectors(Vertex2D vertex, Vertex2D prev, Vertex2D next, double direction) {
        Vector2 gross_vector = new Vector2();
        double gross_weight = 0.0;
        Vector2 vec = new Vector2(vertex, prev);
        double weight = 1.0 / vec.length();
        vec.multiply(weight);
        gross_vector.add(vec);
        gross_weight += weight;
        vec = new Vector2(vertex, next);
        weight = 1.0 / vec.length();
        vec.multiply(weight);
        gross_vector.add(vec);
        gross_vector.multiply(1.0 / (gross_weight += weight));
        gross_vector.multiply(direction);
        vertex.add(gross_vector);
        Vertex2D new_v = new Vertex2D(vertex);
        return new_v;
    }
}

