/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import teddy.CameraInterface;
import teddy.Edge;
import teddy.Edge2D;
import teddy.Face;
import teddy.Line;
import teddy.PNsubdivision;
import teddy.Plane;
import teddy.Polyhedron;
import teddy.Util;
import teddy.Vector2;
import teddy.Vector3;
import teddy.Vertex;
import teddy.Vertex2D;

public class SurfacePath {
    CameraInterface camera;
    Polyhedron h;
    List path = new ArrayList();
    public boolean loop;
    Hashtable crosssection = new Hashtable();
    Vertex2D[] projected_vertices;

    public SurfacePath() {
    }

    public static Vertex pickVertex(Polyhedron h, Point point, CameraInterface camera) {
        SurfacePath surfacePath = new SurfacePath(h, camera);
        Vertex2D p = new Vertex2D(point);
        Face face = surfacePath.pick_front_facing_polygon(p);
        if (face == null) {
            return null;
        }
        double min = -1.0;
        Vertex closest = null;
        int i = 0;
        while (i < 3) {
            Vertex v = face.get_vertex(i);
            Vertex2D u = camera.local_coords_to_screen_coords(v);
            double d = Vertex2D.distance(u, p);
            if (min == -1.0 || d < min) {
                closest = v;
                min = d;
            }
            ++i;
        }
        return closest;
    }

    public static Vertex getVertex_onFace(Polyhedron h, Point point, CameraInterface camera) {
        SurfacePath surfacePath = new SurfacePath(h, camera);
        Vertex2D p = new Vertex2D(point);
        Face face = surfacePath.pick_front_facing_polygon(p);
        if (face == null) {
            return null;
        }
        Vertex local_coord = camera.screen_coords_to_local_coords(p);
        Vector3 line = camera.get_camera_lay(p);
        line.normalize();
        double d0 = Vector3.dot_product(face.normal, face.get_vertex(0));
        double d1 = Vector3.dot_product(face.normal, local_coord);
        double d2 = Vector3.dot_product(face.normal, line);
        double t = (d0 - d1) / d2;
        Vertex retVertex = new Vertex(local_coord.x + t * line.x, local_coord.y + t * line.y, local_coord.z + t * line.z);
        return retVertex;
    }

    public SurfacePath(Polyhedron h, CameraInterface camera) {
        this.h = h;
        this.camera = camera;
    }

    public SurfacePath(Polyhedron h, List stroke, CameraInterface camera, boolean loop) {
        this.h = h;
        this.camera = camera;
        this.loop = loop;
        if (this.pick_front_facing_polygon((Vertex2D)stroke.get(0)) == null) {
            this.cut(stroke);
            return;
        }
        int i = 0;
        while (i < stroke.size()) {
            ((Vertex2D)stroke.get((int)i)).index = i;
            ++i;
        }
        Vertex2D prev_p = (Vertex2D)stroke.get(0);
        Vertex2D last_p = (Vertex2D)stroke.get(stroke.size() - 1);
        int n = 1;
        if (loop) {
            prev_p = (Vertex2D)stroke.get(stroke.size() - 1);
            n = 0;
            last_p = prev_p;
        }
        Face polygon = this.pick_front_facing_polygon(prev_p);
        Face end_polygon = this.pick_front_facing_polygon(last_p);
        while (true) {
            if (n >= stroke.size() || n < 0) {
                System.err.println("array index out of bounds exception in SurfacePath");
                return;
            }
            Vertex2D next_p = (Vertex2D)stroke.get(n);
            Vertex v = this.project_onto_polygon(prev_p, polygon);
            if (v != null) {
                this.path.add(new PathElement(polygon, v));
            }
            boolean[] forward = new boolean[1];
            polygon = this.extend_path(prev_p, next_p, polygon, forward, false);
            if (!forward[0]) {
                next_p = prev_p;
            }
            if (next_p == last_p && polygon == end_polygon) break;
            n = this.front_facing(polygon) ? next_p.index + 1 : next_p.index - 1;
            prev_p = next_p;
        }
        this.path.add(new PathElement(polygon, this.project_onto_polygon(last_p, polygon)));
        this.adjust_to_PNsurface();
    }

    public SurfacePath(Polyhedron h, List stroke, CameraInterface camera, boolean loop, boolean snap, Vertex startV, Vertex endV) {
        this.h = h;
        this.camera = camera;
        this.loop = loop;
        if (snap) {
            List faces = startV.get_faces();
            this.path.add(new PathElement(faces.get(0), startV));
        }
        if (this.pick_front_facing_polygon((Vertex2D)stroke.get(0)) == null) {
            this.cut(stroke);
            return;
        }
        int i = 0;
        while (i < stroke.size()) {
            ((Vertex2D)stroke.get((int)i)).index = i;
            ++i;
        }
        Vertex2D prev_p = (Vertex2D)stroke.get(0);
        Vertex2D last_p = (Vertex2D)stroke.get(stroke.size() - 1);
        int n = 1;
        if (loop) {
            prev_p = (Vertex2D)stroke.get(stroke.size() - 1);
            n = 0;
            last_p = prev_p;
        }
        Face polygon = this.pick_front_facing_polygon(prev_p);
        Face end_polygon = this.pick_front_facing_polygon(last_p);
        while (true) {
            if (n >= stroke.size() || n < 0) {
                System.err.println("array index out of bounds exception in SurfacePath");
                return;
            }
            Vertex2D next_p = (Vertex2D)stroke.get(n);
            this.path.add(new PathElement(polygon, this.project_onto_polygon(prev_p, polygon)));
            boolean[] forward = new boolean[1];
            polygon = this.extend_path(prev_p, next_p, polygon, forward, false);
            if (!forward[0]) {
                next_p = prev_p;
            }
            if (next_p == last_p && polygon == end_polygon) break;
            n = this.front_facing(polygon) ? next_p.index + 1 : next_p.index - 1;
            prev_p = next_p;
        }
        this.path.add(new PathElement(polygon, this.project_onto_polygon(last_p, polygon)));
        if (snap) {
            List faces = endV.get_faces();
            this.path.add(new PathElement(faces.get(0), endV));
        }
        this.adjust_to_PNsurface();
    }

    private Face extend_path(Vertex2D prev_p, Vertex2D next_p, Face face, boolean[] forward, boolean front_facing_only) {
        Edge edge = null;
        Vertex prev_v = this.camera.screen_coords_to_local_coords(prev_p);
        Vertex next_v = this.camera.screen_coords_to_local_coords(next_p);
        Vertex third_v = Vertex.translate(prev_v, this.camera.get_camera_lay(prev_p));
        Plane cutPlane = new Plane(third_v, prev_v, next_v);
        Edge2D strokeEdge = new Edge2D(prev_p, next_p);
        int count = 0;
        do {
            if (this.is_projected_inside(next_p, face)) {
                forward[0] = true;
                return face;
            }
            if (++count > 1000) {
                System.out.println("infinite loop in Surfacepath.extend");
                return null;
            }
            if ((edge = this.find_next_edge(strokeEdge, edge, face)) == null) {
                return null;
            }
            Vertex v = cutPlane.cross_point(edge);
            this.path.add(new PathElement(edge, v));
            face = edge.get_opposite_face(face);
            if (!front_facing_only || this.front_facing(face)) continue;
            return null;
        } while (!this.is_projected_inside(prev_p, face));
        forward[0] = false;
        return face;
    }

    private void adjust_to_PNsurface() {
        int i = 0;
        while (i < this.path.size()) {
            Vertex v = this.getVertex(i);
            Object parent = this.getParent(i);
            v.set_position(PNsubdivision.calculate_position(v, parent));
            ++i;
        }
    }

    private void cut(List stroke) {
        Vertex2D prev_p;
        int i = 0;
        while (i < stroke.size()) {
            ((Vertex2D)stroke.get((int)i)).index = i;
            ++i;
        }
        Face polygon = null;
        int n = 0;
        int i2 = 1;
        while (i2 < stroke.size()) {
            Vertex2D p = (Vertex2D)stroke.get(i2);
            polygon = this.pick_front_facing_polygon(p);
            if (polygon != null) {
                n = i2;
                break;
            }
            ++i2;
        }
        if (n == 0) {
            return;
        }
        int min_n = n;
        int max_n = 0;
        Vertex2D start_p = prev_p = (Vertex2D)stroke.get(n);
        Face start_polygon = polygon;
        ++n;
        while (true) {
            if (n >= stroke.size()) {
                return;
            }
            Vertex2D next_p = (Vertex2D)stroke.get(n);
            if (n > max_n) {
                max_n = n;
            }
            Vertex v = this.project_onto_polygon(prev_p, polygon);
            this.path.add(new PathElement(polygon, v));
            this.register_crosssection(prev_p, v);
            boolean[] forward = new boolean[1];
            polygon = this.extend_path(prev_p, next_p, polygon, forward, false);
            if (!forward[0]) {
                next_p = prev_p;
            }
            if (next_p == start_p && polygon == start_polygon) break;
            n = this.front_facing(polygon) ? next_p.index + 1 : next_p.index - 1;
            prev_p = next_p;
        }
        this.adjust_to_PNsurface();
    }

    private void register_crosssection(Vertex2D p, Vertex v) {
        List<Vector3> vertices = new ArrayList();
        if (this.crosssection.containsKey(p)) {
            vertices = (List)this.crosssection.get(p);
        } else {
            this.crosssection.put(p, vertices);
            vertices.add(this.camera.get_camera_lay(p));
        }
        vertices.add(v);
    }

    private Edge find_next_edge(Edge2D strokeEdge, Edge prev_edge, Face face) {
        int i = 0;
        while (i < 3) {
            Edge2D edge2D;
            Edge edge = face.edges[i];
            if (edge != prev_edge && strokeEdge.cross(edge2D = new Edge2D(this.camera.local_coords_to_screen_coords(edge.start), this.camera.local_coords_to_screen_coords(edge.end)))) {
                return edge;
            }
            ++i;
        }
        System.out.println("ERROR in SurfacePath.find_next_edge()");
        return null;
    }

    private void set_projected_vertices() {
        this.projected_vertices = new Vertex2D[this.h.vertices.size()];
        int i = 0;
        while (i < this.h.vertices.size()) {
            Vertex v = (Vertex)this.h.vertices.get(i);
            this.projected_vertices[i] = this.camera.local_coords_to_screen_coords(v);
            ++i;
        }
    }

    private Face pick_front_facing_polygon(Vertex2D p) {
        return this.pick_front_facing_polygon(p, false);
    }

    private Face pick_front_facing_polygon(Vertex2D p, boolean on_back) {
        if (this.projected_vertices == null) {
            this.set_projected_vertices();
        }
        double min = -1.0;
        Face closest = null;
        int i = 0;
        while (i < this.h.faces.size()) {
            Face polygon = (Face)this.h.faces.get(i);
            Vertex2D v0 = this.projected_vertices[polygon.get_vertex((int)0).index];
            Vertex2D v1 = this.projected_vertices[polygon.get_vertex((int)1).index];
            Vertex2D v2 = this.projected_vertices[polygon.get_vertex((int)2).index];
            if (!(v0.x < p.x && v1.x < p.x && v2.x < p.x || v0.x > p.x && v1.x > p.x && v2.x > p.x || v0.y < p.y && v1.y < p.y && v2.y < p.y || v0.y > p.y && v1.y > p.y && v2.y > p.y || !this.front_facing(polygon, on_back) || !this.is_projected_inside(p, polygon))) {
                double d = this.camera.get_screen_depth(polygon.get_vertex(0));
                if (min == -1.0 || d < min) {
                    min = d;
                    closest = polygon;
                }
            }
            ++i;
        }
        return closest;
    }

    private boolean is_projected_inside(Vertex2D v, Face face) {
        if (face == null) {
            return false;
        }
        int sign = 1;
        if (!this.front_facing(face)) {
            sign = -1;
        }
        int i = 0;
        while (i < 3) {
            Vertex2D end;
            Vector2 vec1;
            Vertex2D start = this.camera.local_coords_to_screen_coords(face.get_vertex(i));
            Vector2 vec0 = new Vector2(start, v);
            if (Vector2.cross_product(vec0, vec1 = new Vector2(start, end = this.camera.local_coords_to_screen_coords(face.get_vertex(i + 1)))) * (double)sign > 0.0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean front_facing(Face face) {
        if (this.camera == null || face == null) {
            return false;
        }
        if (face.get_vertex(0) == null) {
            return false;
        }
        return this.camera.front_facing(face.get_vertex(0), face.normal);
    }

    private boolean front_facing(Face polygon, boolean on_back) {
        if (on_back) {
            return !this.front_facing(polygon);
        }
        return this.front_facing(polygon);
    }

    private Vertex project_onto_polygon(Vertex2D v, Face face) {
        if (face == null) {
            return null;
        }
        Plane plane = new Plane(face.get_vertex(0), face.normal);
        Line line = new Line(this.camera.screen_coords_to_local_coords(v), this.camera.get_camera_lay(v));
        return plane.cross_point(line);
    }

    public SurfacePath(Polyhedron h) {
        this.h = h;
    }

    public void add(Vertex vertex, Edge edge) {
        this.path.add(new PathElement(edge, vertex));
    }

    public void add(Vertex vertex, Face polygon) {
        this.path.add(new PathElement(polygon, vertex));
    }

    public void add(Vertex vertex, Vertex parent_vertex) {
        this.path.add(new PathElement(parent_vertex, vertex));
    }

    public void bring_PolygonVertex_first() {
        PathElement pe;
        ArrayList<PathElement> lead_path = new ArrayList<PathElement>();
        ArrayList<PathElement> new_path = new ArrayList<PathElement>();
        int i = 0;
        i = 0;
        while (i < this.path.size()) {
            pe = (PathElement)this.path.get(i);
            if (!pe.onEdge()) break;
            lead_path.add(pe);
            ++i;
        }
        while (i < this.path.size()) {
            pe = (PathElement)this.path.get(i);
            new_path.add(pe);
            ++i;
        }
        this.path = Util.connect(new_path, lead_path);
    }

    public boolean inside(Point point, CameraInterface camera) {
        Vertex2D p = new Vertex2D(point);
        double angle = 0.0;
        Vertex2D prev = camera.local_coords_to_screen_coords(this.getVertex(this.path.size() - 1));
        int i = 0;
        while (i < this.path.size()) {
            Vector2 vec0 = new Vector2(p, prev);
            Vertex2D next = camera.local_coords_to_screen_coords(this.getVertex(i));
            Vector2 vec1 = new Vector2(p, next);
            double da = Vector2.get_angle_360(vec0, vec1);
            if (da > 180.0) {
                da -= 360.0;
            }
            angle += da;
            prev = next;
            ++i;
        }
        return angle < -180.0 || angle > 180.0;
    }

    public Vector3 getTangent(int i) {
        Vector3 vector = null;
        if (i == 0) {
            vector = new Vector3(this.getVertex(i), this.getVertex(i + 1));
        } else if (i == this.size() - 1) {
            vector = new Vector3(this.getVertex(i - 1), this.getVertex(i));
        } else {
            Vector3 vector0 = new Vector3(this.getVertex(i - 1), this.getVertex(i));
            Vector3 vector1 = new Vector3(this.getVertex(i), this.getVertex(i + 1));
            vector0.normalize();
            vector1.normalize();
            vector = Vector3.add(vector0, vector1);
        }
        vector.normalize();
        return vector;
    }

    public Vector3 getNormal(int i) {
        if (this.onFace(i)) {
            return this.getFace((int)i).normal;
        }
        Edge edge = this.getEdge(i);
        if (edge.left_face == null) {
            return edge.right_face.normal;
        }
        if (edge.right_face == null) {
            return edge.left_face.normal;
        }
        Vector3 normal = Vector3.add(edge.left_face.normal, edge.right_face.normal);
        return Vector3.normalize(normal);
    }

    public boolean onEdge(int i) {
        return ((PathElement)this.path.get(i)).onEdge();
    }

    public boolean onFace(int i) {
        return ((PathElement)this.path.get(i)).onFace();
    }

    public boolean onVertex(int i) {
        return ((PathElement)this.path.get(i)).onVertex();
    }

    public Edge getEdge(int i) {
        return ((PathElement)this.path.get(i)).getEdge();
    }

    public Face getFace(int i) {
        return ((PathElement)this.path.get(i)).getFace();
    }

    public Object getParent(int i) {
        return ((PathElement)this.path.get(i)).getParent();
    }

    public Vertex getVertex(int i) {
        return ((PathElement)this.path.get(i)).getVertex();
    }

    public Vertex getParentVertex(int i) {
        return ((PathElement)this.path.get(i)).getParentVertex();
    }

    public void replaceEdge(Edge edge, int i) {
        PathElement pe = (PathElement)this.path.get(i);
        pe.parent = edge;
    }

    public void replaceFace(Face face, int i) {
        PathElement pe = (PathElement)this.path.get(i);
        pe.parent = face;
    }

    public List getPath() {
        return this.path;
    }

    public void setPath(List _path) {
        this.path = _path;
    }

    public int size() {
        return this.path.size();
    }

    public static SurfacePath extend_and_get_surfacePath(Edge edge, boolean[] visited) {
        List forward = SurfacePath.extend_and_get_surfacePath_sub(edge, edge.end, visited);
        List backward = SurfacePath.extend_and_get_surfacePath_sub(edge, edge.start, visited);
        List vs = Util.reverse(backward);
        vs.addAll(forward);
        SurfacePath path = new SurfacePath();
        int i = 0;
        while (i < vs.size()) {
            Vertex v = (Vertex)vs.get(i);
            path.add(v, v);
            ++i;
        }
        if (path.getVertex(0) == path.getVertex(path.size() - 1)) {
            path.loop = true;
        }
        return path;
    }

    static List extend_and_get_surfacePath_sub(Edge edge, Vertex v, boolean[] visited) {
        ArrayList<Vertex> vs = new ArrayList<Vertex>();
        try {
            while (true) {
                vs.add(v);
                visited[edge.index] = true;
                Edge next_edge = null;
                int i = 0;
                while (i < v.edges.size()) {
                    Edge _edge = (Edge)v.edges.get(i);
                    if (_edge.seam == edge.seam && !visited[_edge.index]) {
                        next_edge = _edge;
                        break;
                    }
                    ++i;
                }
                if (next_edge == null) {
                    return vs;
                }
                v = next_edge.get_opposite_vertex(v);
                edge = next_edge;
            }
        }
        catch (Exception e) {
            System.err.println("extend_and_get_surfacePath_sub in SurfacePath.java" + e);
            return null;
        }
    }

    class PathElement {
        Object parent;
        Vertex vertex;

        PathElement(Object parent, Vertex vertex) {
            this.parent = parent;
            this.vertex = vertex;
        }

        boolean onEdge() {
            return this.parent instanceof Edge;
        }

        boolean onFace() {
            return this.parent instanceof Face;
        }

        boolean onVertex() {
            return this.parent instanceof Vertex;
        }

        Edge getEdge() {
            return (Edge)this.parent;
        }

        Face getFace() {
            return (Face)this.parent;
        }

        Object getParent() {
            return this.parent;
        }

        Vertex getParentVertex() {
            return (Vertex)this.parent;
        }

        Vertex getVertex() {
            return this.vertex;
        }
    }
}

