/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import teddy.Util;
import teddy.Vector2;
import teddy.Vertex2D;
import teddy._Line2D;

public class StrokeAnalyzer {
    public static double unit_length = 0.2;
    public static double margin_for_sharp_angle = unit_length / 2.0;
    public static double corner_threshold = unit_length / 2.0;

    public static void setParameters(double l) {
        unit_length = l;
        margin_for_sharp_angle = l;
        corner_threshold = l / 2.0;
    }

    public static double getLength_Points(List stroke, boolean loop) {
        double length = 0.0;
        Point prev = (Point)stroke.get(0);
        int i = 1;
        while (i < stroke.size()) {
            Point next = (Point)stroke.get(i);
            length += Vertex2D.distance(prev, next);
            prev = next;
            ++i;
        }
        if (loop) {
            Point next = (Point)stroke.get(0);
            length += Vertex2D.distance(prev, next);
        }
        return length;
    }

    public static List getSharpCorners(List vertices) {
        List corners = StrokeAnalyzer.getCorners(vertices);
        ArrayList<Vertex2D> sharp_corners = new ArrayList<Vertex2D>();
        int i = 0;
        while (i < corners.size()) {
            Vertex2D v1;
            Vector2 q;
            Vertex2D v = (Vertex2D)corners.get(i);
            Vertex2D v0 = StrokeAnalyzer.get_next_vertex_with_margin(vertices, v, margin_for_sharp_angle, -1);
            Vector2 p = new Vector2(v0, v);
            double cos = Vector2.cos(p, q = new Vector2(v, v1 = StrokeAnalyzer.get_next_vertex_with_margin(vertices, v, margin_for_sharp_angle, 1)));
            if (cos < 0.5) {
                sharp_corners.add(v);
            }
            ++i;
        }
        return sharp_corners;
    }

    public static Vertex2D get_next_vertex_with_margin(List vertices, Vertex2D v, double margin, int step) {
        double d = 0.0;
        int index = v.index;
        Vertex2D prev_vertex = v;
        Vertex2D vertex = v;
        while (true) {
            if ((index += step) == vertices.size()) {
                index = 0;
            } else if (index == -1) {
                index = vertices.size() - 1;
            }
            vertex = (Vertex2D)vertices.get(index);
            if ((d += Vertex2D.distance(prev_vertex, vertex)) > margin) break;
            prev_vertex = vertex;
        }
        double t = (d - margin) / Vertex2D.distance(prev_vertex, vertex);
        return Vertex2D.interporate(vertex, prev_vertex, t);
    }

    public static List getResampledPoints(List stroke, double unit_length) {
        StrokeAnalyzer.setParameters(unit_length);
        List vertices = StrokeAnalyzer.points_to_vertex2Ds(stroke);
        return StrokeAnalyzer.getResampledVertices(vertices);
    }

    public static List getResampledPoints_noLoop(List stroke, double l) {
        StrokeAnalyzer.setParameters(l);
        List vertices = StrokeAnalyzer.points_to_vertex2Ds(stroke);
        return StrokeAnalyzer.getResampledVertices_noLoop(vertices);
    }

    public static double getLoopLengthPoints(List stroke) {
        double length = 0.0;
        Point prev = (Point)stroke.get(stroke.size() - 1);
        int i = 0;
        while (i < stroke.size()) {
            Point next = (Point)stroke.get(i);
            length += Vertex2D.distance(prev, next);
            prev = next;
            ++i;
        }
        return length;
    }

    public static double getLengthPoints(List stroke) {
        double length = 0.0;
        Point prev = (Point)stroke.get(0);
        int i = 1;
        while (i < stroke.size()) {
            Point next = (Point)stroke.get(i);
            length += Vertex2D.distance(prev, next);
            prev = next;
            ++i;
        }
        return length;
    }

    public static List getResampledVertices(List vertices, double _unit_length) {
        unit_length = _unit_length;
        return StrokeAnalyzer.getResampledVertices(vertices);
    }

    public static List getResampledVertices(List vertices) {
        List corners = StrokeAnalyzer.getCorners(vertices);
        int i = 0;
        while (i < corners.size()) {
            ((Vertex2D)corners.get((int)i)).fixed = true;
            ++i;
        }
        if (corners.size() <= 1) {
            corners = StrokeAnalyzer.getExtremes(vertices);
        }
        List resampled = new ArrayList();
        int v0_index = ((Vertex2D)corners.get((int)(corners.size() - 1))).index;
        int i2 = 0;
        while (i2 < corners.size()) {
            int v1_index = ((Vertex2D)corners.get((int)i2)).index;
            List sub_vertices = StrokeAnalyzer.get_sub_vertices(vertices, v0_index, v1_index);
            List resampled_sub = StrokeAnalyzer.resample(sub_vertices);
            resampled_sub.remove(0);
            resampled = StrokeAnalyzer.connect_vector(resampled, resampled_sub);
            v0_index = v1_index;
            ++i2;
        }
        return resampled;
    }

    public static List getResampledVertices_noLoop(List vertices) {
        List corners = StrokeAnalyzer.getCorners_noLoop(vertices);
        List resampled = new ArrayList();
        int v0_index = ((Vertex2D)corners.get((int)0)).index;
        int i = 1;
        while (i < corners.size()) {
            int v1_index = ((Vertex2D)corners.get((int)i)).index;
            List sub_vertices = StrokeAnalyzer.get_sub_vertices(vertices, v0_index, v1_index);
            List resampled_sub = StrokeAnalyzer.resample(sub_vertices);
            if (i != 1) {
                resampled_sub.remove(0);
            }
            resampled = StrokeAnalyzer.connect_vector(resampled, resampled_sub);
            v0_index = v1_index;
            ++i;
        }
        return resampled;
    }

    public static List connect_vector(List main, List sub) {
        int i = 0;
        while (i < sub.size()) {
            main.add(sub.get(i));
            ++i;
        }
        return main;
    }

    public static double getLength(List vertices) {
        double l = 0.0;
        int i = 0;
        while (i < vertices.size() - 1) {
            Vertex2D v0 = (Vertex2D)vertices.get(i);
            Vertex2D v1 = (Vertex2D)vertices.get(i + 1);
            l += Vertex2D.distance(v0, v1);
            ++i;
        }
        return l;
    }

    public static List get_sub_vertices(List vertices, int index_v0, int index_v1) {
        ArrayList vertices_v0_to_v1 = new ArrayList();
        int i = index_v0;
        while (i != index_v1) {
            vertices_v0_to_v1.add(vertices.get(i));
            if (++i != vertices.size()) continue;
            i = 0;
        }
        vertices_v0_to_v1.add(vertices.get(index_v1));
        return vertices_v0_to_v1;
    }

    public static List resample(List vertices) {
        Vertex2D v0 = (Vertex2D)vertices.get(0);
        Vertex2D v1 = (Vertex2D)vertices.get(vertices.size() - 1);
        ArrayList<Vertex2D> resampled = new ArrayList<Vertex2D>();
        resampled.add(v0);
        double l = StrokeAnalyzer.getLength(vertices);
        int n = (int)(l / unit_length + 0.5);
        if (n <= 1) {
            resampled.add(v1);
            return resampled;
        }
        double unit = l / (double)n;
        double total = 0.0;
        double prev_total = 0.0;
        Vertex2D prev = v0;
        double next_spot = unit;
        int index = 1;
        int count = 0;
        while (true) {
            Vertex2D next = (Vertex2D)vertices.get(index);
            total += Vertex2D.distance(prev, next);
            while (total >= next_spot) {
                Vertex2D new_vertex = Vertex2D.interporate(prev, next, (next_spot - prev_total) / (total - prev_total));
                resampled.add(new_vertex);
                next_spot += unit;
                if (++count == n - 1) break;
            }
            if (count == n - 1) break;
            prev = next;
            prev_total = total;
            ++index;
        }
        resampled.add(v1);
        return resampled;
    }

    public static List getExtremes(List vertices) {
        Vertex2D center = StrokeAnalyzer.get_center(vertices);
        Vertex2D v0 = null;
        int index_v0 = 0;
        double max = 0.0;
        int i = 0;
        while (i < vertices.size()) {
            Vertex2D v = (Vertex2D)vertices.get(i);
            double d = Vertex2D.distance(center, v);
            if (d > max) {
                v0 = v;
                max = d;
                index_v0 = i;
            }
            ++i;
        }
        Vertex2D v1 = null;
        max = 0.0;
        int index_v1 = 0;
        int i2 = 0;
        while (i2 < vertices.size()) {
            Vertex2D v = (Vertex2D)vertices.get(i2);
            double d = Vertex2D.distance(v0, v);
            if (d > max) {
                v1 = v;
                max = d;
                index_v1 = i2;
            }
            ++i2;
        }
        ArrayList<Vertex2D> extremes = new ArrayList<Vertex2D>();
        extremes.add(v0);
        extremes.add(v1);
        return extremes;
    }

    public static List getCorners(List vertices) {
        List extremes = StrokeAnalyzer.getExtremes(vertices);
        Vertex2D v0 = (Vertex2D)extremes.get(0);
        int index_v0 = v0.index;
        Vertex2D v1 = (Vertex2D)extremes.get(1);
        int index_v1 = v1.index;
        ArrayList vertices_v0_to_v1 = new ArrayList();
        int i = index_v0;
        while (i != index_v1) {
            vertices_v0_to_v1.add(vertices.get(i));
            if (++i != vertices.size()) continue;
            i = 0;
        }
        ArrayList vertices_v1_to_v0 = new ArrayList();
        int i2 = index_v1;
        while (i2 != index_v0) {
            vertices_v1_to_v0.add(vertices.get(i2));
            if (++i2 != vertices.size()) continue;
            i2 = 0;
        }
        List corners_v0_to_v1 = StrokeAnalyzer.get_corners_sub(vertices_v0_to_v1);
        List corners_v1_to_v0 = StrokeAnalyzer.get_corners_sub(vertices_v1_to_v0);
        ArrayList<Vertex2D> corners = new ArrayList<Vertex2D>();
        corners.add(v0);
        int i3 = 0;
        while (i3 < corners_v0_to_v1.size()) {
            corners.add((Vertex2D)corners_v0_to_v1.get(i3));
            ++i3;
        }
        corners.add(v1);
        i3 = 0;
        while (i3 < corners_v1_to_v0.size()) {
            corners.add((Vertex2D)corners_v1_to_v0.get(i3));
            ++i3;
        }
        return corners;
    }

    public static List getCorners_noLoop(List vertices) {
        List middle_corners = StrokeAnalyzer.get_corners_sub(vertices);
        List corners = new ArrayList();
        corners.add(vertices.get(0));
        corners = StrokeAnalyzer.connect_vector(corners, middle_corners);
        corners.add(vertices.get(vertices.size() - 1));
        return corners;
    }

    public static List get_corners_sub(List vertices) {
        Vertex2D v1;
        Vertex2D v0 = (Vertex2D)vertices.get(0);
        if (v0.same_position(v1 = (Vertex2D)vertices.get(vertices.size() - 1))) {
            return new ArrayList();
        }
        _Line2D line = new _Line2D(v0, v1);
        Vertex2D cv = null;
        double max = corner_threshold;
        int index_cv = -1;
        int i = 0;
        while (i < vertices.size()) {
            Vertex2D v = (Vertex2D)vertices.get(i);
            double d = Math.abs(line.distance(v));
            if (d > max) {
                cv = v;
                max = d;
                index_cv = i;
            }
            ++i;
        }
        if (cv == null) {
            return new ArrayList();
        }
        ArrayList vertices0 = new ArrayList();
        int i2 = 0;
        while (i2 <= index_cv) {
            vertices0.add(vertices.get(i2));
            ++i2;
        }
        List corners0 = StrokeAnalyzer.get_corners_sub(vertices0);
        ArrayList vertices1 = new ArrayList();
        int i3 = index_cv;
        while (i3 < vertices.size()) {
            vertices1.add(vertices.get(i3));
            ++i3;
        }
        List corners1 = StrokeAnalyzer.get_corners_sub(vertices1);
        ArrayList corners = new ArrayList();
        int i4 = 0;
        while (i4 < corners0.size()) {
            corners.add(corners0.get(i4));
            ++i4;
        }
        corners.add(cv);
        i4 = 0;
        while (i4 < corners1.size()) {
            corners.add(corners1.get(i4));
            ++i4;
        }
        return corners;
    }

    public static List points_to_vertex2Ds(List points) {
        ArrayList<Vertex2D> vertices = new ArrayList<Vertex2D>();
        int i = 0;
        while (i < points.size()) {
            Point p = (Point)points.get(i);
            vertices.add(new Vertex2D(p.x, (double)p.y));
            ++i;
        }
        return vertices;
    }

    public static Vertex2D get_center(List vertices) {
        Vertex2D center = new Vertex2D();
        int i = 0;
        while (i < vertices.size()) {
            center.add((Vertex2D)vertices.get(i));
            ++i;
        }
        center.multiply(1.0 / (double)vertices.size());
        return center;
    }

    public static double getLoopLength(List stroke) {
        double length = 0.0;
        Vertex2D prev = (Vertex2D)stroke.get(stroke.size() - 1);
        int i = 0;
        while (i < stroke.size()) {
            Vertex2D next = (Vertex2D)stroke.get(i);
            length += Vertex2D.distance(prev, next);
            prev = next;
            ++i;
        }
        return length;
    }

    public static List adjust_loop_direction(List stroke) {
        double total_area = 0.0;
        Point prev = (Point)stroke.get(stroke.size() - 1);
        int i = 0;
        while (i < stroke.size()) {
            Point next = (Point)stroke.get(i);
            total_area += (double)((prev.y + next.y) * (next.x - prev.x));
            prev = next;
            ++i;
        }
        if (total_area > 0.0) {
            return Util.reverse(stroke);
        }
        return stroke;
    }

    public static List translate(List stroke, Vector2 vec) {
        ArrayList<Vertex2D> new_stroke = new ArrayList<Vertex2D>();
        int i = 0;
        while (i < stroke.size()) {
            Vertex2D v = (Vertex2D)stroke.get(i);
            Vertex2D u = Vertex2D.translate(v, vec);
            u.fixed = v.fixed;
            new_stroke.add(u);
            ++i;
        }
        return new_stroke;
    }
}

