/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import teddy.Cell;
import umfpack.Umfpack;

public class SparseMatrix {
    List[] columns;
    int n_columns;
    int n_rows;
    static double value;
    static int index0;
    static int index1;
    static int n0;
    static int n1;
    static Cell cell0;
    static Cell cell1;

    public SparseMatrix(int n_columns, int n_rows) {
        this.n_columns = n_columns;
        this.n_rows = n_rows;
        this.columns = new ArrayList[n_columns];
        int i = 0;
        while (i < n_columns) {
            this.columns[i] = new ArrayList();
            ++i;
        }
    }

    public void add(int column_number, int row_number, double value) {
        ArrayList column = (ArrayList)this.columns[column_number];
        int i = 0;
        while (i < column.size()) {
            Cell cell = (Cell)column.get(i);
            if (cell.index == row_number) {
                cell.value += value;
                return;
            }
            if (cell.index > row_number) {
                cell = new Cell(row_number, value);
                column.add(i, cell);
                return;
            }
            ++i;
        }
        Cell cell = new Cell(row_number, value);
        column.add(cell);
    }

    public static SparseMatrix transpose(SparseMatrix matrix) {
        SparseMatrix new_matrix = new SparseMatrix(matrix.n_rows, matrix.n_columns);
        int i = 0;
        while (i < matrix.n_columns) {
            List column = matrix.columns[i];
            int j = 0;
            while (j < column.size()) {
                Cell cell = (Cell)column.get(j);
                Cell new_cell = new Cell(i, cell.value);
                new_matrix.columns[cell.index].add(new_cell);
                ++j;
            }
            ++i;
        }
        return new_matrix;
    }

    public static double[] multiply(SparseMatrix matrix, double[] vector) {
        double[] result = new double[matrix.n_columns];
        int i = 0;
        while (i < matrix.n_columns) {
            List column = matrix.columns[i];
            int j = 0;
            while (j < column.size()) {
                Cell cell = (Cell)column.get(j);
                int n = i;
                result[n] = result[n] + cell.value * vector[cell.index];
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static SparseMatrix tranpose_and_multiply(SparseMatrix matrix) {
        matrix = SparseMatrix.transpose(matrix);
        SparseMatrix new_matrix = new SparseMatrix(matrix.n_columns, matrix.n_columns);
        int i = 0;
        while (i < new_matrix.n_columns) {
            new_matrix.columns[i] = new ArrayList();
            int j = 0;
            while (j < new_matrix.n_columns) {
                double value = SparseMatrix.multiply(matrix.columns[i], matrix.columns[j], matrix.n_rows);
                if (value != 0.0) {
                    new_matrix.columns[i].add(new Cell(j, value));
                }
                ++j;
            }
            ++i;
        }
        return new_matrix;
    }

    public static double multiply(List column0, List column1, int n) {
        value = 0.0;
        index0 = 1;
        index1 = 1;
        cell0 = (Cell)column0.get(0);
        cell1 = (Cell)column1.get(0);
        n0 = column0.size();
        n1 = column1.size();
        while (true) {
            if (SparseMatrix.cell0.index < SparseMatrix.cell1.index) {
                if (index0 == n0) {
                    return value;
                }
                cell0 = (Cell)column0.get(index0++);
                continue;
            }
            while (SparseMatrix.cell1.index < SparseMatrix.cell0.index) {
                if (index1 == n1) {
                    return value;
                }
                cell1 = (Cell)column1.get(index1++);
            }
            if (SparseMatrix.cell0.index != SparseMatrix.cell1.index) continue;
            value += SparseMatrix.cell0.value * SparseMatrix.cell1.value;
            if (index0 == n0) {
                return value;
            }
            cell0 = (Cell)column0.get(index0++);
            if (index1 == n1) {
                return value;
            }
            cell1 = (Cell)column1.get(index1++);
        }
    }

    public static void factorize(Umfpack umfpack, SparseMatrix A) {
        int i;
        int n = A.n_columns;
        int[] Ap = new int[n + 1];
        Vector<Integer> _Ai = new Vector<Integer>();
        Vector<Double> _Ax = new Vector<Double>();
        int j = 0;
        while (j < n) {
            Ap[j] = _Ai.size();
            i = 0;
            while (i < A.columns[j].size()) {
                Cell cell = (Cell)A.columns[j].get(i);
                _Ai.addElement(new Integer(cell.index));
                _Ax.addElement(new Double(cell.value));
                ++i;
            }
            ++j;
        }
        Ap[n] = _Ai.size();
        int[] Ai = new int[_Ai.size()];
        i = 0;
        while (i < _Ai.size()) {
            Ai[i] = (Integer)_Ai.elementAt(i);
            ++i;
        }
        double[] Ax = new double[_Ax.size()];
        int i2 = 0;
        while (i2 < _Ax.size()) {
            Ax[i2] = (Double)_Ax.elementAt(i2);
            ++i2;
        }
        umfpack.factorize(n, Ap, Ai, Ax);
    }
}

