/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import teddy.Edge;
import teddy.Face;
import teddy.Polyhedron;
import teddy.Tessellation;
import teddy.Vector3;
import teddy.Vertex;

public class Skin {
    public static void subdivide(Polyhedron h) {
        Edge edge;
        ArrayList vertices = new ArrayList();
        ArrayList<Edge> edges = new ArrayList<Edge>();
        ArrayList<Face> faces = new ArrayList<Face>();
        Vertex[] mid_vertex = new Vertex[h.edges.size()];
        int i = 0;
        while (i < h.vertices.size()) {
            vertices.add(h.vertices.get(i));
            ++i;
        }
        i = 0;
        while (i < h.edges.size()) {
            edge = (Edge)h.edges.get(i);
            mid_vertex[i] = edge.mid_vertex();
            vertices.add(mid_vertex[i]);
            edges.add(new Edge(edge.start, mid_vertex[i]));
            edges.add(new Edge(mid_vertex[i], edge.end));
            ++i;
        }
        i = 0;
        while (i < h.faces.size()) {
            Face face = (Face)h.faces.get(i);
            Vertex v0 = face.get_vertex(0);
            Vertex v1 = mid_vertex[face.edges[0].index];
            Vertex v2 = face.get_vertex(1);
            Vertex v3 = mid_vertex[face.edges[1].index];
            Vertex v4 = face.get_vertex(2);
            Vertex v5 = mid_vertex[face.edges[2].index];
            Edge edge13 = new Edge(v1, v3);
            Edge edge35 = new Edge(v3, v5);
            Edge edge51 = new Edge(v5, v1);
            Edge edge01 = v0.get_common_edge(v1);
            Edge edge12 = v1.get_common_edge(v2);
            Edge edge23 = v2.get_common_edge(v3);
            Edge edge34 = v3.get_common_edge(v4);
            Edge edge45 = v4.get_common_edge(v5);
            Edge edge50 = v5.get_common_edge(v0);
            edge01.seam = edge12.seam = face.edges[0].seam;
            edge23.seam = edge34.seam = face.edges[1].seam;
            edge45.seam = edge50.seam = face.edges[2].seam;
            faces.add(new Face(edge13, edge35, edge51));
            faces.add(new Face(edge01, edge51, edge50));
            faces.add(new Face(edge12, edge23, edge13));
            faces.add(new Face(edge34, edge45, edge35));
            edges.add(edge13);
            edges.add(edge35);
            edges.add(edge51);
            ++i;
        }
        i = 0;
        while (i < h.edges.size()) {
            edge = (Edge)h.edges.get(i);
            edge.start.remove_edge(edge);
            edge.end.remove_edge(edge);
            ++i;
        }
        h.vertices = vertices;
        h.edges = edges;
        h.faces = faces;
        h.set_parameters();
    }

    public static void refine(Polyhedron polyhedron) {
        int i = 0;
        while (i < 5) {
            Skin.refine_mesh_connectivity(polyhedron);
            ++i;
        }
        i = 0;
        while (i < 5) {
            Skin.drift(polyhedron);
            ++i;
        }
        Skin.refine_mesh_connectivity(polyhedron);
        i = 0;
        while (i < 5) {
            Skin.drift(polyhedron);
            ++i;
        }
    }

    private static void refine_mesh_connectivity(Polyhedron h) {
        int c = Tessellation.refine_mesh_connectivity(h);
        h.set_parameters();
    }

    public static void drift(Polyhedron h) {
        int i = 0;
        while (i < h.vertices.size()) {
            Vertex v = (Vertex)h.vertices.get(i);
            if (!v.fixed) {
                Skin.drift(h, v);
            }
            ++i;
        }
        h.set_parameters();
    }

    public static void drift(Polyhedron h, Vertex v) {
        Vector3 dv = Skin.get_vector_to_isosurface(v);
        Vector3 cv = Skin.get_vector_to_centroid(v);
        if (Double.isNaN(dv.x)) {
            System.out.println("dv = Nan");
        }
        if (Double.isNaN(cv.x)) {
            System.out.println("cv = Nan");
        }
        Vector3 vec = Vector3.add(dv, cv);
        if (!Double.isNaN(vec.x)) {
            v.add(vec);
        }
    }

    static Vector3 get_vector_to_centroid(Vertex v) {
        if (v.on_seam()) {
            return Skin.get_vector_to_centroid_on_seam(v);
        }
        Vertex center = new Vertex();
        List edges = v.get_surrounding_edges();
        double length = 0.0;
        int i = 0;
        while (i < edges.size()) {
            Edge edge = (Edge)edges.get(i);
            double l = edge.length();
            center.add(Vector3.multiply(edge.mid_vertex(), l));
            length += l;
            ++i;
        }
        center.multiply(1.0 / length);
        Vector3 vector = new Vector3(v, center);
        vector = Vector3.subtract(vector, Vector3.multiply(v.normal, Vector3.dot_product(v.normal, vector)));
        double weight = 0.3;
        return Vector3.multiply(vector, weight);
    }

    static Vector3 get_vector_to_centroid_on_seam(Vertex v) {
        Vertex center = new Vertex();
        Vector vertices = v.get_sorrounding_vertices_on_seam();
        if (vertices.size() != 2) {
            return new Vector3(0.0, 0.0, 0.0);
        }
        int i = 0;
        while (i < vertices.size()) {
            center.add((Vertex)vertices.elementAt(i));
            ++i;
        }
        center.multiply(1.0 / (double)vertices.size());
        Vector3 normal = new Vector3((Vertex)vertices.elementAt(vertices.size() - 1), (Vertex)vertices.elementAt(0));
        normal.normalize();
        Vector3 vector = new Vector3(v, center);
        vector = Vector3.multiply(normal, Vector3.dot_product(normal, vector));
        double weight = 0.3;
        return Vector3.multiply(vector, weight);
    }

    static Vector3 get_vector_to_isosurface(Vertex v) {
        return new Vector3();
    }

    public static void init_bodyPolygon_and_bodyVertex(Polyhedron h, Polyhedron body) {
        if (h.vertices.size() != body.vertices.size()) {
            System.out.println("error in Skin.init_bodyPolygon_and_bodyVertex()");
        }
        int i = 0;
        while (i < h.vertices.size()) {
            Vertex v = h.vertices(i);
            v.body_vertex = body.vertices(i);
            v.body_element = body.vertices(i);
            ++i;
        }
    }
}

