/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import teddy.Edge;
import teddy.Face;
import teddy.Polyhedron;
import teddy.Sort;
import teddy.SurfacePath;
import teddy.Triangulation2;
import teddy.Util;
import teddy.Vector3;
import teddy.Vertex;
import teddy.Vertex2D;

public class Remesh {
    public static void remesh_no_loop(Polyhedron h, SurfacePath surfacePath) {
        ArrayList<Edge> dead_edges = new ArrayList<Edge>();
        Hashtable vertices_on_edge = new Hashtable();
        int i = 0;
        while (i < surfacePath.size()) {
            if (surfacePath.onEdge(i)) {
                Edge edge = surfacePath.getEdge(i);
                Vertex vertex = surfacePath.getVertex(i);
                List<Vertex> vs = new ArrayList();
                if (vertices_on_edge.containsKey(edge)) {
                    vs = (List)vertices_on_edge.get(edge);
                } else {
                    vertices_on_edge.put(edge, vs);
                    dead_edges.add(edge);
                }
                vs.add(vertex);
            }
            ++i;
        }
        ArrayList<Vertex> fixed_vertices = new ArrayList<Vertex>();
        ArrayList<Face> faces = new ArrayList<Face>();
        Face face = surfacePath.getFace(0);
        ArrayList<Edge> boundary_edges = new ArrayList<Edge>();
        Vertex prev_vertex = surfacePath.getVertex(0);
        faces.add(face);
        h.add(prev_vertex);
        Hashtable edges_on_face = new Hashtable();
        int i2 = 1;
        while (i2 < surfacePath.size()) {
            Vertex vertex = surfacePath.getVertex(i2);
            h.add(vertex);
            Edge edge = new Edge(prev_vertex, vertex);
            edge.seam = true;
            h.add(edge);
            List<Edge> vs = new ArrayList();
            if (edges_on_face.containsKey(face)) {
                vs = (List)edges_on_face.get(face);
            } else {
                edges_on_face.put(face, vs);
            }
            vs.add(edge);
            if (surfacePath.onEdge(i2)) {
                face = surfacePath.getEdge(i2).get_opposite_face(face);
                if (!faces.contains(face)) {
                    faces.add(face);
                }
                if (surfacePath.getEdge((int)i2).seam) {
                    fixed_vertices.add(vertex);
                }
            }
            boundary_edges.add(edge);
            prev_vertex = vertex;
            ++i2;
        }
        Enumeration e = vertices_on_edge.keys();
        while (e.hasMoreElements()) {
            Edge edge = (Edge)e.nextElement();
            List vs = (List)vertices_on_edge.get(edge);
            vs = Remesh.sort_vertices_on_edge(vs, edge.start);
            vs.add(edge.end);
            prev_vertex = edge.start;
            ArrayList<Edge> newEdges = new ArrayList<Edge>();
            int j = 0;
            while (j < vs.size()) {
                Vertex next_vertex = (Vertex)vs.get(j);
                Edge newEdge = new Edge(prev_vertex, next_vertex);
                newEdges.add(newEdge);
                newEdge.seam = edge.seam;
                newEdge.sharp = edge.sharp;
                h.add(newEdge);
                prev_vertex = next_vertex;
                ++j;
            }
            vertices_on_edge.put(edge, newEdges);
        }
        i = 0;
        while (i < faces.size()) {
            face = (Face)faces.get(i);
            List newEdges = new ArrayList<Edge>();
            int j = 0;
            while (j < 3) {
                Edge edge = face.edges[j];
                if (vertices_on_edge.containsKey(edge)) {
                    List vs = (List)vertices_on_edge.get(edge);
                    if (edge.left_face != face) {
                        vs = Util.reverse(vs);
                    }
                    newEdges = Util.connect(newEdges, vs);
                } else {
                    newEdges.add(edge);
                }
                ++j;
            }
            List possibleEdges = (List)edges_on_face.get(face);
            possibleEdges = Util.connect(possibleEdges, possibleEdges);
            possibleEdges = Util.connect(possibleEdges, newEdges);
            ArrayList<List> loops = new ArrayList<List>();
            ArrayList visited = new ArrayList();
            int j2 = 0;
            while (j2 < newEdges.size()) {
                Edge edge = (Edge)newEdges.get(j2);
                Edge nextEdge = (Edge)newEdges.get(Util.mod(j2 + 1, newEdges.size()));
                if (!visited.contains(edge)) {
                    loops.add(Remesh.find_loop(edge, edge.get_common_vertex(nextEdge), face.normal, visited, dead_edges, possibleEdges, newEdges));
                }
                ++j2;
            }
            j2 = 0;
            while (j2 < loops.size()) {
                List loop = (List)loops.get(j2);
                int k = 0;
                while (k < loop.size()) {
                    Edge edge = (Edge)loop.get(k);
                    ++k;
                }
                if (loop == null) {
                    System.out.println("loop null");
                }
                if (loop.size() == 3) {
                    Edge e0 = (Edge)loop.get(0);
                    Edge e1 = (Edge)loop.get(1);
                    Edge e2 = (Edge)loop.get(2);
                    if (e0 == null || e1 == null || e2 == null) {
                        System.err.println("edge == null");
                        return;
                    }
                    h.add(new Face(e0, e1, e2));
                } else {
                    Remesh.triangulate(h, loop, face);
                }
                ++j2;
            }
            h.remove(face);
            ++i;
        }
        h.set_parameters();
        h.check_edges();
    }

    static List sort_vertices_on_edge(List vs, Vertex base) {
        ArrayList<Double> values = new ArrayList<Double>();
        int i = 0;
        while (i < vs.size()) {
            Vertex v = (Vertex)vs.get(i);
            values.add(new Double(Vertex.distance(base, v)));
            ++i;
        }
        return Sort.sort(vs, values);
    }

    static List find_loop(Edge base_edge, Vertex vertex, Vector3 normal, List visited, List dead_edges, List possibleEdges, List outside_edges) {
        ArrayList<Edge> loop = new ArrayList<Edge>();
        Edge edge = base_edge;
        while (true) {
            loop.add(edge);
            visited.add(edge);
            possibleEdges.remove(edge);
            edge = Remesh.find_next_edge(edge, vertex, normal, dead_edges, possibleEdges, outside_edges);
            if (edge == base_edge) {
                return loop;
            }
            if (edge == null) {
                return loop;
            }
            vertex = edge.get_opposite_vertex(vertex);
        }
    }

    static Edge find_next_edge(Edge prev_edge, Vertex vertex, Vector3 normal, List dead_edges, List possibleEdges, List outside_edges) {
        ArrayList<Edge> outlets = new ArrayList<Edge>();
        int i = 0;
        while (i < vertex.edges.size()) {
            Edge edge = (Edge)vertex.edges.get(i);
            if (edge != prev_edge && !dead_edges.contains(edge) && possibleEdges.contains(edge)) {
                outlets.add(edge);
            }
            ++i;
        }
        if (outlets.size() == 0 && possibleEdges.contains(prev_edge)) {
            return prev_edge;
        }
        if (outlets.size() == 0) {
            return null;
        }
        if (outlets.size() == 1) {
            return (Edge)outlets.get(0);
        }
        if (outlets.size() > 2) {
            System.err.println("too many outlets in Pop.find_next_edge");
        }
        Edge edge0 = (Edge)outlets.get(0);
        Edge edge1 = (Edge)outlets.get(1);
        if (outside_edges.contains(prev_edge)) {
            if (outside_edges.contains(edge0)) {
                return edge1;
            }
            return edge0;
        }
        if (outside_edges.indexOf(edge1) == Util.mod(outside_edges.indexOf(edge0) + 1, outside_edges.size())) {
            return edge1;
        }
        return edge0;
    }

    static void triangulate(Polyhedron h, List loop, Face face) {
        Vector3 normal = face.normal;
        Vector3 y_axis = new Vector3(normal.y, normal.z, normal.x);
        Vector3 x_axis = y_axis.cross_product(normal);
        y_axis = normal.cross_product(x_axis);
        x_axis.normalize();
        y_axis.normalize();
        Edge prev_edge = (Edge)loop.get(loop.size() - 1);
        Vertex prev_vertex = prev_edge.get_common_vertex((Edge)loop.get(loop.size() - 2));
        ArrayList<Vertex> vertices3D = new ArrayList<Vertex>();
        ArrayList<Vertex2D> vertices2D = new ArrayList<Vertex2D>();
        int i = 0;
        while (i < loop.size()) {
            Edge next_edge = (Edge)loop.get(i);
            Vertex vertex = prev_edge.get_opposite_vertex(prev_vertex);
            vertices3D.add(vertex);
            Vertex2D v = new Vertex2D(x_axis.dot_product(vertex), y_axis.dot_product(vertex));
            v.index = i++;
            vertices2D.add(v);
            prev_edge = next_edge;
            prev_vertex = vertex;
        }
        Vector triangles = Triangulation2.triangulate(vertices2D);
        int i2 = 0;
        while (i2 < triangles.size()) {
            int[] triangle = (int[])triangles.get(i2);
            Vertex v0 = (Vertex)vertices3D.get(triangle[0]);
            Vertex v1 = (Vertex)vertices3D.get(triangle[1]);
            Vertex v2 = (Vertex)vertices3D.get(triangle[2]);
            Edge edge0 = Remesh.get_edge(v0, v1, h);
            Edge edge1 = Remesh.get_edge(v1, v2, h);
            Edge edge2 = Remesh.get_edge(v2, v0, h);
            Face f = new Face(edge0, edge1, edge2);
            h.add(f);
            ++i2;
        }
        h.set_parameters();
    }

    static Edge get_edge(Vertex v0, Vertex v1, Polyhedron h) {
        Edge edge = v0.get_common_edge(v1);
        if (edge == null) {
            edge = new Edge(v0, v1);
            h.add(edge);
        }
        return edge;
    }
}

