/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.util.ArrayList;
import java.util.List;
import pattern.Piece;
import teddy.Edge;
import teddy.Edge2D;
import teddy.Face;
import teddy.Face2D;
import teddy.LinkedList;
import teddy.Vertex;
import teddy.Vertex2D;

public class Polyhedron2D {
    public List vertices = new ArrayList();
    public List edges = new ArrayList();
    public List faces = new ArrayList();
    public List patches = new ArrayList();
    public Piece piece = null;
    double unit_length;
    protected transient LinkedList tmp_polygons;
    protected transient LinkedList _vertices;
    protected transient LinkedList _edges;
    protected transient LinkedList _polygons;

    public Vertex2D vertices(int i) {
        return (Vertex2D)this.vertices.get(i);
    }

    public Edge2D edges(int i) {
        return (Edge2D)this.edges.get(i);
    }

    public Face2D faces(int i) {
        return (Face2D)this.faces.get(i);
    }

    public void add(Vertex2D vertex) {
        this.vertices.add(vertex);
        vertex.index = this.vertices.size();
    }

    public void add(Edge2D edge) {
        this.edges.add(edge);
        edge.index = this.edges.size();
    }

    public void add(Face2D face) {
        this.faces.add(face);
        face.index = this.faces.size();
    }

    public void remove(Vertex2D vertex) {
        this.vertices.remove(vertex);
    }

    public void remove(Edge2D edge) {
        this.edges.remove(edge);
        edge.disposed = true;
        edge.start.remove_edge(edge);
        if (edge.start.edges.size() == 0) {
            this.remove(edge.start);
        }
        edge.end.remove_edge(edge);
        if (edge.end.edges.size() == 0) {
            this.remove(edge.end);
        }
    }

    public void remove(Face2D face) {
        this.faces.remove(face);
        face.disposed = true;
        int i = 0;
        while (i < face.edges.length) {
            Edge2D edge = face.edges[i];
            edge.remove_face(face);
            if (edge.left_face == null && edge.right_face == null) {
                this.remove(edge);
            }
            ++i;
        }
    }

    public Polyhedron2D() {
    }

    public Polyhedron2D(double[][] vs, int[] indices) {
        this();
        int i = 0;
        while (i < vs.length) {
            this.vertices.add(new Vertex2D(vs[i][0], vs[i][1]));
            ++i;
        }
        i = 0;
        while (i < indices.length / 3) {
            Edge2D edge0 = this.get_edge(indices[i * 3 + 0], indices[i * 3 + 1]);
            Edge2D edge1 = this.get_edge(indices[i * 3 + 1], indices[i * 3 + 2]);
            Edge2D edge2 = this.get_edge(indices[i * 3 + 2], indices[i * 3 + 0]);
            this.faces.add(new Face2D(edge0, edge1, edge2));
            ++i;
        }
        this.set_parameters();
    }

    public Edge2D get_edge(int n0, int n1) {
        Vertex2D v1;
        Vertex2D v0 = (Vertex2D)this.vertices.get(n0);
        Edge2D edge = v0.get_common_edge(v1 = (Vertex2D)this.vertices.get(n1));
        if (edge != null) {
            return edge;
        }
        edge = new Edge2D(v0, v1);
        this.edges.add(edge);
        return edge;
    }

    public Edge2D get_edge(Vertex2D v0, Vertex2D v1) {
        int i = 0;
        while (i < this.edges.size()) {
            Edge2D edge = this.edges(i);
            if (edge.contains(v0) && edge.contains(v1)) {
                return edge;
            }
            ++i;
        }
        Edge2D new_edge = new Edge2D(v0, v1);
        this.add(new_edge);
        return new_edge;
    }

    public void set_indices() {
        int i = 0;
        while (i < this.vertices.size()) {
            ((Vertex2D)this.vertices.get((int)i)).index = i;
            ++i;
        }
        i = 0;
        while (i < this.edges.size()) {
            ((Edge2D)this.edges.get((int)i)).index = i;
            ++i;
        }
        i = 0;
        while (i < this.faces.size()) {
            ((Face2D)this.faces.get((int)i)).index = i;
            ++i;
        }
    }

    public Object[] stitch(double[][] vertices, int[] indices) {
        ArrayList<double[]> new_vertices = new ArrayList<double[]>();
        int[] old_to_new = new int[vertices.length];
        int i = 0;
        while (i < vertices.length) {
            double[] v = vertices[i];
            int index = -1;
            int j = 0;
            while (j < new_vertices.size()) {
                double[] u = (double[])new_vertices.get(j);
                if (v[0] == u[0] && v[1] == u[1] && v[2] == u[2]) {
                    index = j;
                    break;
                }
                ++j;
            }
            if (index == -1) {
                index = new_vertices.size();
                new_vertices.add(v);
            }
            old_to_new[i] = index;
            ++i;
        }
        vertices = new double[new_vertices.size()][3];
        i = 0;
        while (i < new_vertices.size()) {
            vertices[i] = (double[])new_vertices.get(i);
            ++i;
        }
        int[] new_indices = new int[indices.length];
        int i2 = 0;
        while (i2 < indices.length) {
            new_indices[i2] = old_to_new[indices[i2]];
            ++i2;
        }
        indices = new_indices;
        Object[] result = new Object[]{vertices, indices};
        return result;
    }

    public int get_seams_size() {
        int size = 0;
        int i = 0;
        while (i < this.edges.size()) {
            Edge2D edge = (Edge2D)this.edges.get(i);
            if (edge.seam) {
                ++size;
            }
            ++i;
        }
        return size;
    }

    public boolean include_vertex(Vertex2D v) {
        int i = 0;
        while (i < this.vertices.size()) {
            Vertex2D vertex = (Vertex2D)this.vertices.get(i);
            if (vertex.x == v.x && vertex.y == v.y) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean contains(Face2D face) {
        int i = 0;
        while (i < this.faces.size()) {
            if (this.faces(i) == face) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Vertex2D get_center_vertex() {
        Vertex2D center = new Vertex2D(0.0, 0.0);
        int i = 0;
        while (i < this.vertices.size()) {
            Vertex2D vertex = (Vertex2D)this.vertices.get(i);
            center.add(vertex);
            ++i;
        }
        center.multiply(1.0 / (double)this.vertices.size());
        return center;
    }

    public Face2D get_center_face() {
        Vertex2D center = new Vertex2D(0.0, 0.0);
        Face2D returnFace = new Face2D();
        int i = 0;
        while (i < this.vertices.size()) {
            Vertex2D vertex = (Vertex2D)this.vertices.get(i);
            center.add(vertex);
            ++i;
        }
        center.multiply(1.0 / (double)this.vertices.size());
        double min = Double.MAX_VALUE;
        int i2 = 0;
        while (i2 < this.faces.size()) {
            Face2D face = (Face2D)this.faces.get(i2);
            Vertex2D face_center = face.get_center();
            double d = Vertex2D.distance(center, face_center);
            if (d < min) {
                min = d;
                returnFace = face;
            }
            ++i2;
        }
        return returnFace;
    }

    public void set_parameters() {
        this.set_indices();
    }

    public void check_edges() {
        int i = 0;
        while (i < this.edges.size()) {
            Edge2D edge = (Edge2D)this.edges.get(i);
            if (edge.left_face == null || edge.right_face == null) {
                System.out.println("edge does not have two polygons");
            }
            ++i;
        }
    }

    protected void postprocess_list_to_array() {
        this.vertices = new ArrayList();
        this.edges = new ArrayList();
        this.faces = new ArrayList();
        int i = 0;
        while (i < this._vertices.size()) {
            this.vertices.add((Vertex2D)this._vertices.get(i));
            ++i;
        }
        i = 0;
        while (i < this._edges.size()) {
            this.edges.add((Edge2D)this._edges.get(i));
            ++i;
        }
        i = 0;
        while (i < this._polygons.size()) {
            this.faces.add((Face2D)this._polygons.get(i));
            ++i;
        }
        this.set_parameters();
    }

    public Polyhedron2D copy() {
        Polyhedron2D clone = new Polyhedron2D();
        clone.vertices = new ArrayList();
        int i = 0;
        while (i < this.vertices.size()) {
            clone.vertices.add(((Vertex2D)this.vertices.get(i)).copy());
            ++i;
        }
        clone.edges = new ArrayList();
        i = 0;
        while (i < this.edges.size()) {
            clone.edges.add(((Edge2D)this.edges.get(i)).copy());
            ++i;
        }
        clone.faces = new ArrayList();
        i = 0;
        while (i < this.faces.size()) {
            clone.faces.add(((Face2D)this.faces.get(i)).copy());
            ++i;
        }
        i = 0;
        while (i < this.vertices.size()) {
            ((Vertex)clone.vertices.get(i)).renew_network();
            ++i;
        }
        i = 0;
        while (i < this.edges.size()) {
            ((Edge)clone.edges.get(i)).renew_network();
            ++i;
        }
        i = 0;
        while (i < this.faces.size()) {
            ((Face)clone.faces.get(i)).renew_network();
            ++i;
        }
        clone.set_parameters();
        return clone;
    }

    Polyhedron2D(List _vertices, List _edges, List _polygons) {
        this();
        int i = 0;
        while (i < _vertices.size()) {
            this.vertices.add((Vertex2D)_vertices.get(i));
            ++i;
        }
        i = 0;
        while (i < _edges.size()) {
            this.edges.add((Edge2D)_edges.get(i));
            ++i;
        }
        i = 0;
        while (i < _polygons.size()) {
            this.faces.add((Face2D)_polygons.get(i));
            ++i;
        }
    }
}

