/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import pattern.Piece;
import sweater.TmpCamera;
import teddy.Edge;
import teddy.Face;
import teddy.LinkedList;
import teddy.PatchVertex;
import teddy.Vector3;
import teddy.Vertex;
import teddy.Vertex2D;

public class Polyhedron {
    public List vertices = new ArrayList();
    public List edges = new ArrayList();
    public List faces = new ArrayList();
    public Piece piece = null;
    public List child_polyhedrons = new ArrayList();
    public Polyhedron parent;
    double unit_length;
    public boolean reversed = false;
    protected transient LinkedList tmp_polygons;
    protected transient LinkedList _vertices;
    protected transient LinkedList _edges;
    protected transient LinkedList _polygons;
    public List connections = new ArrayList();

    public Vertex vertices(int i) {
        return (Vertex)this.vertices.get(i);
    }

    public Edge edges(int i) {
        return (Edge)this.edges.get(i);
    }

    public Face faces(int i) {
        return (Face)this.faces.get(i);
    }

    public void add(Vertex vertex) {
        this.vertices.add(vertex);
        vertex.index = this.vertices.size();
    }

    public void add(Edge edge) {
        this.edges.add(edge);
        edge.index = this.edges.size();
    }

    public void add(Face face) {
        this.faces.add(face);
        face.index = this.faces.size();
    }

    public void addAll(Polyhedron p) {
        this.faces.addAll(p.faces);
        this.edges.addAll(p.edges);
        this.vertices.addAll(p.vertices);
    }

    public void removeAll() {
        int i = this.vertices.size() - 1;
        while (i >= 0) {
            this.vertices.remove(i);
            --i;
        }
        i = this.edges.size() - 1;
        while (i >= 0) {
            this.edges.remove(i);
            --i;
        }
        i = this.faces.size() - 1;
        while (i >= 0) {
            this.faces.remove(i);
            --i;
        }
    }

    public void remove(Vertex vertex) {
        this.vertices.remove(vertex);
        vertex.disposed = true;
    }

    public void remove(Edge edge) {
        this.edges.remove(edge);
        edge.disposed = true;
        edge.start.remove_edge(edge);
        if (edge.start.edges.size() == 0) {
            this.remove(edge.start);
        }
        edge.end.remove_edge(edge);
        if (edge.end.edges.size() == 0) {
            this.remove(edge.end);
        }
    }

    public void remove(Face face) {
        this.faces.remove(face);
        face.disposed = true;
        int i = 0;
        while (i < face.edges.length) {
            Edge edge = face.edges[i];
            edge.remove_face(face);
            if (edge.left_face == null && edge.right_face == null) {
                this.remove(edge);
            }
            ++i;
        }
    }

    public Polyhedron() {
    }

    public Polyhedron(double[][] vs, int[] indices) {
        this();
        int i = 0;
        while (i < vs.length) {
            this.vertices.add(new Vertex(vs[i][0], vs[i][1], vs[i][2]));
            ++i;
        }
        i = 0;
        while (i < indices.length / 3) {
            Edge edge0 = this.get_edge(indices[i * 3 + 0], indices[i * 3 + 1]);
            Edge edge1 = this.get_edge(indices[i * 3 + 1], indices[i * 3 + 2]);
            Edge edge2 = this.get_edge(indices[i * 3 + 2], indices[i * 3 + 0]);
            this.faces.add(new Face(edge0, edge1, edge2));
            ++i;
        }
        this.set_parameters();
    }

    public Edge get_edge(int n0, int n1) {
        Vertex v1;
        Vertex v0 = (Vertex)this.vertices.get(n0);
        Edge edge = v0.get_common_edge(v1 = (Vertex)this.vertices.get(n1));
        if (edge != null) {
            return edge;
        }
        edge = new Edge(v0, v1);
        this.edges.add(edge);
        return edge;
    }

    public Edge get_edge(Vertex v0, Vertex v1) {
        int i = 0;
        while (i < this.edges.size()) {
            Edge edge = this.edges(i);
            if (edge.contains(v0) && edge.contains(v1)) {
                return edge;
            }
            ++i;
        }
        Edge new_edge = new Edge(v0, v1);
        this.add(new_edge);
        return new_edge;
    }

    public void set_indices() {
        int i = 0;
        while (i < this.vertices.size()) {
            ((Vertex)this.vertices.get((int)i)).index = i;
            ++i;
        }
        i = 0;
        while (i < this.edges.size()) {
            ((Edge)this.edges.get((int)i)).index = i;
            ++i;
        }
        i = 0;
        while (i < this.faces.size()) {
            ((Face)this.faces.get((int)i)).index = i;
            ++i;
        }
    }

    public Object[] stitch(double[][] vertices, int[] indices) {
        ArrayList<double[]> new_vertices = new ArrayList<double[]>();
        int[] old_to_new = new int[vertices.length];
        int i = 0;
        while (i < vertices.length) {
            double[] v = vertices[i];
            int index = -1;
            int j = 0;
            while (j < new_vertices.size()) {
                double[] u = (double[])new_vertices.get(j);
                if (v[0] == u[0] && v[1] == u[1] && v[2] == u[2]) {
                    index = j;
                    break;
                }
                ++j;
            }
            if (index == -1) {
                index = new_vertices.size();
                new_vertices.add(v);
            }
            old_to_new[i] = index;
            ++i;
        }
        vertices = new double[new_vertices.size()][3];
        i = 0;
        while (i < new_vertices.size()) {
            vertices[i] = (double[])new_vertices.get(i);
            ++i;
        }
        int[] new_indices = new int[indices.length];
        int i2 = 0;
        while (i2 < indices.length) {
            new_indices[i2] = old_to_new[indices[i2]];
            ++i2;
        }
        indices = new_indices;
        Object[] result = new Object[]{vertices, indices};
        return result;
    }

    public int get_seams_size() {
        int size = 0;
        int i = 0;
        while (i < this.edges.size()) {
            Edge edge = (Edge)this.edges.get(i);
            if (edge.seam) {
                ++size;
            }
            ++i;
        }
        return size;
    }

    public boolean include_vertex(Vertex v) {
        int i = 0;
        while (i < this.vertices.size()) {
            Vertex vertex = (Vertex)this.vertices.get(i);
            if (vertex.x == v.x && vertex.y == v.y && vertex.z == v.z) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean contains(Face face) {
        int i = 0;
        while (i < this.faces.size()) {
            if (this.faces(i) == face) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Vertex get_center_vertex() {
        Vertex center = new Vertex(0.0, 0.0, 0.0);
        int i = 0;
        while (i < this.vertices.size()) {
            Vertex vertex = (Vertex)this.vertices.get(i);
            center.add(vertex);
            ++i;
        }
        center.multiply(1.0 / (double)this.vertices.size());
        return center;
    }

    private Vertex get_nearist_vertex(Vertex v) {
        double min = Double.MAX_VALUE;
        Vertex nearist_vertex = new Vertex();
        int i = 0;
        while (i < this.vertices.size()) {
            Vertex vertex = (Vertex)this.vertices.get(i);
            double d = Vertex.distance(vertex, v);
            if (d < min) {
                min = d;
                nearist_vertex = vertex;
            }
            ++i;
        }
        return nearist_vertex;
    }

    public int get_center_index_of_vertex() {
        Vertex center = new Vertex(0.0, 0.0, 0.0);
        int i = 0;
        while (i < this.vertices.size()) {
            Vertex vertex = (Vertex)this.vertices.get(i);
            center.add(vertex);
            ++i;
        }
        center.multiply(1.0 / (double)this.vertices.size());
        int center_index = this.get_nearist_index_of_vertex(center);
        return center_index;
    }

    private int get_nearist_index_of_vertex(Vertex v) {
        double min = Double.MAX_VALUE;
        int nearist_index = -1;
        int i = 0;
        while (i < this.vertices.size()) {
            Vertex vertex = (Vertex)this.vertices.get(i);
            double d = Vertex.distance(vertex, v);
            if (d < min) {
                min = d;
                nearist_index = i;
            }
            ++i;
        }
        return nearist_index;
    }

    public Vertex get_center() {
        Vertex center = new Vertex(0.0, 0.0, 0.0);
        int i = 0;
        while (i < this.vertices.size()) {
            Vertex vertex = (Vertex)this.vertices.get(i);
            center.add(vertex);
            ++i;
        }
        center.multiply(1.0 / (double)this.vertices.size());
        return center;
    }

    public void move_all(Vector3 vec) {
        int i = 0;
        while (i < this.vertices.size()) {
            this.vertices(i).add(vec);
            ++i;
        }
    }

    public Face get_center_face() {
        Vertex center = new Vertex(0.0, 0.0, 0.0);
        Face returnFace = new Face();
        int i = 0;
        while (i < this.vertices.size()) {
            Vertex vertex = (Vertex)this.vertices.get(i);
            center.add(vertex);
            ++i;
        }
        center.multiply(1.0 / (double)this.vertices.size());
        double min = Double.MAX_VALUE;
        int i2 = 0;
        while (i2 < this.faces.size()) {
            Face face = (Face)this.faces.get(i2);
            Vertex face_center = face.get_center();
            double d = Vertex.distance(center, face_center);
            if (d < min) {
                min = d;
                returnFace = face;
            }
            ++i2;
        }
        return returnFace;
    }

    public void set_parameters() {
        this.set_indices();
        this.set_parameters_fast();
    }

    public void set_parameters_fast() {
        int i = 0;
        while (i < this.faces.size()) {
            this.faces(i).set_normal();
            ++i;
        }
        i = 0;
        while (i < this.vertices.size()) {
            this.vertices(i).set_normal();
            ++i;
        }
    }

    void check_edges() {
        int i = 0;
        while (i < this.edges.size()) {
            Edge edge = (Edge)this.edges.get(i);
            if (edge.left_face == null || edge.right_face == null) {
                System.err.println("edge does not have two polygons");
            }
            if (!edge.left_face.contains(edge) || !edge.right_face.contains(edge)) {
                System.err.println("edge is not consistent 0");
            }
            if (!edge.start.edges.contains(edge) || !edge.end.edges.contains(edge)) {
                System.err.println("edge is not consistent 1");
            }
            ++i;
        }
    }

    private void check_faces() {
        System.out.println("check_faces");
        int i = 0;
        while (i < this.faces.size()) {
            Face face = (Face)this.faces.get(i);
            if (face.edges.length != 3) {
                System.err.println("check face");
            }
            int j = 0;
            while (j < 3) {
                Edge edge = face.edges[j];
                if (edge.left_face != face && edge.right_face != face) {
                    System.err.println("face is not consistent");
                }
                ++j;
            }
            ++i;
        }
    }

    public void check_consistent() {
        this.check_edges();
        this.check_faces();
    }

    public void apply_texture_coord(TmpCamera camera) {
        Vertex v = (Vertex)this.vertices.get(0);
        boolean front_facing = camera.front_facing(v, v.normal);
        this.apply_texture_coord(camera, front_facing);
    }

    public void apply_texture_coord(TmpCamera camera, boolean front_facing) {
        int i = 0;
        while (i < this.vertices.size()) {
            Vertex v = (Vertex)this.vertices.get(i);
            Vertex2D texcoord = camera.local_coords_to_screen_coords(v);
            if (front_facing) {
                v.setTextureCoord(texcoord.x, -texcoord.y);
            } else {
                v.setTextureCoord(512.0 - texcoord.x, -texcoord.y);
            }
            ++i;
        }
    }

    protected void postprocess_list_to_array() {
        this.vertices = new ArrayList();
        this.edges = new ArrayList();
        this.faces = new ArrayList();
        int i = 0;
        while (i < this._vertices.size()) {
            this.vertices.add((Vertex)this._vertices.get(i));
            ++i;
        }
        i = 0;
        while (i < this._edges.size()) {
            this.edges.add((Edge)this._edges.get(i));
            ++i;
        }
        i = 0;
        while (i < this._polygons.size()) {
            this.faces.add((Face)this._polygons.get(i));
            ++i;
        }
        this.set_parameters();
    }

    public Polyhedron copy() {
        Polyhedron clone = new Polyhedron();
        clone.vertices = new ArrayList();
        int i = 0;
        while (i < this.vertices.size()) {
            clone.vertices.add(((Vertex)this.vertices.get(i)).copy());
            ++i;
        }
        clone.edges = new ArrayList();
        i = 0;
        while (i < this.edges.size()) {
            clone.edges.add(((Edge)this.edges.get(i)).copy());
            ++i;
        }
        clone.faces = new ArrayList();
        i = 0;
        while (i < this.faces.size()) {
            clone.faces.add(((Face)this.faces.get(i)).copy());
            ++i;
        }
        i = 0;
        while (i < this.vertices.size()) {
            ((Vertex)clone.vertices.get(i)).renew_network();
            ++i;
        }
        i = 0;
        while (i < this.edges.size()) {
            ((Edge)clone.edges.get(i)).renew_network();
            ++i;
        }
        i = 0;
        while (i < this.faces.size()) {
            ((Face)clone.faces.get(i)).renew_network();
            ++i;
        }
        i = 0;
        while (i < this.child_polyhedrons.size()) {
            Polyhedron child = ((Polyhedron)this.child_polyhedrons.get(i)).copy();
            clone.child_polyhedrons.add(child);
            ++i;
        }
        clone.set_parameters();
        return clone;
    }

    public Polyhedron copy(HashMap vertices_old_and_new, HashMap edges_old_and_new, HashMap faces_old_and_new) {
        Polyhedron clone = new Polyhedron();
        clone.vertices = new ArrayList();
        int i = 0;
        while (i < this.vertices.size()) {
            Vertex old_vertex = this.vertices(i);
            Vertex new_vertex = old_vertex.copy();
            new_vertex.child_vertices = new ArrayList();
            clone.vertices.add(new_vertex);
            vertices_old_and_new.put(old_vertex, new_vertex);
            ++i;
        }
        clone.edges = new ArrayList();
        i = 0;
        while (i < this.edges.size()) {
            Edge old_edge = this.edges(i);
            Edge new_edge = old_edge.copy();
            new_edge.child_edges = new ArrayList();
            clone.edges.add(new_edge);
            edges_old_and_new.put(old_edge, new_edge);
            ++i;
        }
        clone.faces = new ArrayList();
        i = 0;
        while (i < this.faces.size()) {
            Face old_face = this.faces(i);
            Face new_face = old_face.copy();
            clone.faces.add(new_face);
            faces_old_and_new.put(old_face, new_face);
            ++i;
        }
        i = 0;
        while (i < this.vertices.size()) {
            ((Vertex)clone.vertices.get(i)).renew_network();
            ++i;
        }
        i = 0;
        while (i < this.edges.size()) {
            ((Edge)clone.edges.get(i)).renew_network();
            ++i;
        }
        i = 0;
        while (i < this.faces.size()) {
            ((Face)clone.faces.get(i)).renew_network();
            ++i;
        }
        clone.set_parameters();
        i = 0;
        while (i < this.child_polyhedrons.size()) {
            Polyhedron child = ((Polyhedron)this.child_polyhedrons.get(i)).copy();
            clone.child_polyhedrons.add(child.copy(vertices_old_and_new, edges_old_and_new, faces_old_and_new));
            ++i;
        }
        return clone;
    }

    public Polyhedron copy_for_patch(HashMap vertices_old_and_new, HashMap edges_old_and_new, HashMap faces_old_and_new) {
        Polyhedron clone = new Polyhedron();
        clone.vertices = new ArrayList();
        int i = 0;
        while (i < this.vertices.size()) {
            PatchVertex patchVertex = (PatchVertex)this.vertices.get(i);
            Vertex new_vertex = (Vertex)vertices_old_and_new.get(patchVertex.position);
            PatchVertex new_patchVertex = new PatchVertex(new_vertex, clone);
            new_patchVertex.position = new_vertex;
            new_patchVertex.edges = patchVertex.edges;
            new_patchVertex.u = patchVertex.u;
            new_patchVertex.v = patchVertex.v;
            new_patchVertex.normal = patchVertex.normal;
            new_patchVertex.patch = clone;
            new_vertex.child_vertices.add(new_patchVertex);
            patchVertex.child = new_patchVertex;
            clone.vertices.add(new_patchVertex);
            ++i;
        }
        clone.edges = new ArrayList();
        i = 0;
        while (i < this.edges.size()) {
            Edge new_patch_edge = this.edges(i).copy();
            new_patch_edge.parent_edge = (Edge)edges_old_and_new.get(new_patch_edge.parent_edge);
            new_patch_edge.parent_edge.child_edges.add(new_patch_edge);
            clone.edges.add(new_patch_edge);
            ++i;
        }
        clone.faces = new ArrayList();
        i = 0;
        while (i < this.faces.size()) {
            Face new_patch_face = this.faces(i).copy();
            new_patch_face.parent_face = (Face)faces_old_and_new.get(new_patch_face.parent_face);
            new_patch_face.patch = clone;
            clone.faces.add(new_patch_face);
            ++i;
        }
        i = 0;
        while (i < this.vertices.size()) {
            ((Vertex)clone.vertices.get(i)).renew_network();
            ++i;
        }
        i = 0;
        while (i < this.edges.size()) {
            ((Edge)clone.edges.get(i)).renew_network();
            ++i;
        }
        i = 0;
        while (i < this.faces.size()) {
            ((Face)clone.faces.get(i)).renew_network();
            ++i;
        }
        clone.set_parameters();
        return clone;
    }

    Polyhedron(List _vertices, List _edges, List _polygons) {
        this();
        int i = 0;
        while (i < _vertices.size()) {
            this.vertices.add((Vertex)_vertices.get(i));
            ++i;
        }
        i = 0;
        while (i < _edges.size()) {
            this.edges.add((Edge)_edges.get(i));
            ++i;
        }
        i = 0;
        while (i < _polygons.size()) {
            this.faces.add((Face)_polygons.get(i));
            ++i;
        }
    }

    public void enforce_connections() {
        int i = 0;
        while (i < this.connections.size()) {
            Vertex[] pair = (Vertex[])this.connections.get(i);
            pair[0].set_position(pair[1]);
            ++i;
        }
    }
}

