/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import edu.cmu.cs.stage3.alice.scenegraph.Appearance;
import edu.cmu.cs.stage3.alice.scenegraph.Color;
import edu.cmu.cs.stage3.alice.scenegraph.Container;
import edu.cmu.cs.stage3.alice.scenegraph.FillingStyle;
import edu.cmu.cs.stage3.alice.scenegraph.Geometry;
import edu.cmu.cs.stage3.alice.scenegraph.IndexedTriangleArray;
import edu.cmu.cs.stage3.alice.scenegraph.OrthographicCamera;
import edu.cmu.cs.stage3.alice.scenegraph.ReferenceFrame;
import edu.cmu.cs.stage3.alice.scenegraph.Scene;
import edu.cmu.cs.stage3.alice.scenegraph.ShadingStyle;
import edu.cmu.cs.stage3.alice.scenegraph.Transformable;
import edu.cmu.cs.stage3.alice.scenegraph.Vertex3d;
import edu.cmu.cs.stage3.alice.scenegraph.Visual;
import java.awt.Point;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Vector3d;
import sweater.PlaneVisual;
import sweater.Sweater;
import teddy.Edge;
import teddy.Line;
import teddy.Vector3;
import teddy.Vertex;

public class Plane {
    Vertex base;
    public Vector3 normal;
    ReferenceFrame reference;
    public final Color GROUND_COLOR = new Color(0.55, 0.93, 0.55);
    public final Color DRAWING_PLANE_COLOR = new Color(1.0, 1.0, 1.0, 0.2);
    private static final double ERROR = 0.001;
    Vector lines = new Vector();
    Vector3 x_axis;
    Vector3 y_axis;
    Transformable planeVehicle;
    Visual planeVisual;
    Appearance planeAppearance;
    int[][] plane_data;
    static IndexedTriangleArray ground_planeITA;
    static IndexedTriangleArray planeITA;
    Transformable gridVehicle;
    Visual gridVisual;
    Appearance gridAppearance;
    int[][] grid_data;
    static IndexedTriangleArray ground_gridITA;
    static IndexedTriangleArray gridITA;

    Plane() {
        int[][] nArrayArray = new int[6][];
        int[] nArray = new int[3];
        nArray[0] = -1;
        nArray[2] = -1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = -1;
        nArray2[2] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[0] = 1;
        nArray3[2] = -1;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[3];
        nArray4[0] = -1;
        nArray4[2] = 1;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[3];
        nArray5[0] = 1;
        nArray5[2] = 1;
        nArrayArray[4] = nArray5;
        int[] nArray6 = new int[3];
        nArray6[0] = 1;
        nArray6[2] = -1;
        nArrayArray[5] = nArray6;
        this.plane_data = nArrayArray;
        int[][] nArrayArray2 = new int[6][];
        nArrayArray2[0] = new int[3];
        int[] nArray7 = new int[3];
        nArray7[2] = 1;
        nArrayArray2[1] = nArray7;
        int[] nArray8 = new int[3];
        nArray8[0] = 1;
        nArrayArray2[2] = nArray8;
        int[] nArray9 = new int[3];
        nArray9[2] = 1;
        nArrayArray2[3] = nArray9;
        int[] nArray10 = new int[3];
        nArray10[0] = 1;
        nArray10[2] = 1;
        nArrayArray2[4] = nArray10;
        int[] nArray11 = new int[3];
        nArray11[0] = 1;
        nArrayArray2[5] = nArray11;
        this.grid_data = nArrayArray2;
    }

    public Plane(Vertex v0, Vertex v1, Vertex v2) {
        int[][] nArrayArray = new int[6][];
        int[] nArray = new int[3];
        nArray[0] = -1;
        nArray[2] = -1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = -1;
        nArray2[2] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[0] = 1;
        nArray3[2] = -1;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[3];
        nArray4[0] = -1;
        nArray4[2] = 1;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[3];
        nArray5[0] = 1;
        nArray5[2] = 1;
        nArrayArray[4] = nArray5;
        int[] nArray6 = new int[3];
        nArray6[0] = 1;
        nArray6[2] = -1;
        nArrayArray[5] = nArray6;
        this.plane_data = nArrayArray;
        int[][] nArrayArray2 = new int[6][];
        nArrayArray2[0] = new int[3];
        int[] nArray7 = new int[3];
        nArray7[2] = 1;
        nArrayArray2[1] = nArray7;
        int[] nArray8 = new int[3];
        nArray8[0] = 1;
        nArrayArray2[2] = nArray8;
        int[] nArray9 = new int[3];
        nArray9[2] = 1;
        nArrayArray2[3] = nArray9;
        int[] nArray10 = new int[3];
        nArray10[0] = 1;
        nArray10[2] = 1;
        nArrayArray2[4] = nArray10;
        int[] nArray11 = new int[3];
        nArray11[0] = 1;
        nArrayArray2[5] = nArray11;
        this.grid_data = nArrayArray2;
        Vector3 vec0 = new Vector3(v0, v1);
        Vector3 vec1 = new Vector3(v0, v2);
        this.normal = Vector3.cross_product(vec0, vec1);
        this.base = v0;
        this.normal.normalize();
        this.reference = null;
    }

    public Plane(Vertex _base, Vector3 _normal) {
        int[][] nArrayArray = new int[6][];
        int[] nArray = new int[3];
        nArray[0] = -1;
        nArray[2] = -1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = -1;
        nArray2[2] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[0] = 1;
        nArray3[2] = -1;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[3];
        nArray4[0] = -1;
        nArray4[2] = 1;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[3];
        nArray5[0] = 1;
        nArray5[2] = 1;
        nArrayArray[4] = nArray5;
        int[] nArray6 = new int[3];
        nArray6[0] = 1;
        nArray6[2] = -1;
        nArrayArray[5] = nArray6;
        this.plane_data = nArrayArray;
        int[][] nArrayArray2 = new int[6][];
        nArrayArray2[0] = new int[3];
        int[] nArray7 = new int[3];
        nArray7[2] = 1;
        nArrayArray2[1] = nArray7;
        int[] nArray8 = new int[3];
        nArray8[0] = 1;
        nArrayArray2[2] = nArray8;
        int[] nArray9 = new int[3];
        nArray9[2] = 1;
        nArrayArray2[3] = nArray9;
        int[] nArray10 = new int[3];
        nArray10[0] = 1;
        nArray10[2] = 1;
        nArrayArray2[4] = nArray10;
        int[] nArray11 = new int[3];
        nArray11[0] = 1;
        nArrayArray2[5] = nArray11;
        this.grid_data = nArrayArray2;
        this.base = _base;
        this.normal = _normal;
        this.normal.normalize();
        this.reference = null;
    }

    Plane(Vertex _base, Vector3 _normal, ReferenceFrame reference) {
        int[][] nArrayArray = new int[6][];
        int[] nArray = new int[3];
        nArray[0] = -1;
        nArray[2] = -1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = -1;
        nArray2[2] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[0] = 1;
        nArray3[2] = -1;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[3];
        nArray4[0] = -1;
        nArray4[2] = 1;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[3];
        nArray5[0] = 1;
        nArray5[2] = 1;
        nArrayArray[4] = nArray5;
        int[] nArray6 = new int[3];
        nArray6[0] = 1;
        nArray6[2] = -1;
        nArrayArray[5] = nArray6;
        this.plane_data = nArrayArray;
        int[][] nArrayArray2 = new int[6][];
        nArrayArray2[0] = new int[3];
        int[] nArray7 = new int[3];
        nArray7[2] = 1;
        nArrayArray2[1] = nArray7;
        int[] nArray8 = new int[3];
        nArray8[0] = 1;
        nArrayArray2[2] = nArray8;
        int[] nArray9 = new int[3];
        nArray9[2] = 1;
        nArrayArray2[3] = nArray9;
        int[] nArray10 = new int[3];
        nArray10[0] = 1;
        nArray10[2] = 1;
        nArrayArray2[4] = nArray10;
        int[] nArray11 = new int[3];
        nArray11[0] = 1;
        nArrayArray2[5] = nArray11;
        this.grid_data = nArrayArray2;
        this.base = _base;
        this.normal = _normal;
        this.normal.normalize();
        this.reference = reference;
    }

    Plane(Vertex _base, Vector3 _normal, Vector3 _up_vec, ReferenceFrame _reference) {
        int[][] nArrayArray = new int[6][];
        int[] nArray = new int[3];
        nArray[0] = -1;
        nArray[2] = -1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = -1;
        nArray2[2] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[0] = 1;
        nArray3[2] = -1;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[3];
        nArray4[0] = -1;
        nArray4[2] = 1;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[3];
        nArray5[0] = 1;
        nArray5[2] = 1;
        nArrayArray[4] = nArray5;
        int[] nArray6 = new int[3];
        nArray6[0] = 1;
        nArray6[2] = -1;
        nArrayArray[5] = nArray6;
        this.plane_data = nArrayArray;
        int[][] nArrayArray2 = new int[6][];
        nArrayArray2[0] = new int[3];
        int[] nArray7 = new int[3];
        nArray7[2] = 1;
        nArrayArray2[1] = nArray7;
        int[] nArray8 = new int[3];
        nArray8[0] = 1;
        nArrayArray2[2] = nArray8;
        int[] nArray9 = new int[3];
        nArray9[2] = 1;
        nArrayArray2[3] = nArray9;
        int[] nArray10 = new int[3];
        nArray10[0] = 1;
        nArray10[2] = 1;
        nArrayArray2[4] = nArray10;
        int[] nArray11 = new int[3];
        nArray11[0] = 1;
        nArrayArray2[5] = nArray11;
        this.grid_data = nArrayArray2;
        this.base = _base;
        this.normal = _normal;
        this.reference = _reference;
        this.x_axis = Vector3.cross_product(_up_vec, _normal);
        this.y_axis = _up_vec;
    }

    public edu.cmu.cs.stage3.math.Vector3 project_coords(Point p) {
        Vector3 pos = this.project(p);
        pos = Vector3.subtract(pos, this.base);
        double x = Vector3.dot_product(this.x_axis, pos);
        double y = Vector3.dot_product(this.y_axis, pos);
        return new edu.cmu.cs.stage3.math.Vector3(x, y, 0.0);
    }

    public void refresh_network(Hashtable hash) {
        Vector<Line> revised_lines = new Vector<Line>();
        int i = 0;
        while (i < this.lines.size()) {
            Line original_line = (Line)this.lines.elementAt(i);
            Line line = (Line)hash.get(original_line);
            revised_lines.addElement(line);
            ++i;
        }
        this.lines = revised_lines;
    }

    public Plane duplicate() {
        Plane plane = new Plane();
        plane.base = this.base;
        plane.normal = this.normal;
        plane.lines = this.lines;
        plane.planeVehicle = this.planeVehicle;
        plane.gridVehicle = this.gridVehicle;
        plane.planeVisual = this.planeVisual;
        plane.gridVisual = this.gridVisual;
        return plane;
    }

    public boolean parallel(Plane plane) {
        return Math.abs(Vector3.cross_product(this.normal, plane.normal).length()) < 0.001;
    }

    public boolean perpendicular(Vector3 vec) {
        return Math.abs(Vector3.cross_product(this.normal, vec).length() / vec.length()) < 0.001;
    }

    public boolean equivalent(Plane plane) {
        Vector3 vec;
        return Math.abs(Vector3.cross_product(this.normal, plane.normal).length()) < 0.001 && Math.abs(Vector3.dot_product(this.normal, vec = Vertex.subtract(plane.base, this.base))) < 0.001;
    }

    public boolean contains(Vector3 v) {
        Vector3 vec = Vector3.subtract(v, this.base);
        return Math.abs(Vector3.dot_product(this.normal, vec)) < 0.001;
    }

    public Vertex cross_point(Edge edge) {
        double start_to_surface = this.signed_distance(edge.start);
        double end_to_surface = this.signed_distance(edge.end);
        double start_to_end = start_to_surface - end_to_surface;
        Vector3 vec = Vector3.multiply(edge.vector3(), start_to_surface / start_to_end);
        return Vertex.translate(edge.start, vec);
    }

    public Vertex cross_point(Line line) {
        double plane_to_linebase = this.signed_distance(line.base);
        double cos = -Vector3.cos(this.normal, line.direction);
        Vector3 vec = Vector3.multiply(line.direction, plane_to_linebase / cos);
        return Vertex.translate(line.base, vec);
    }

    public double signed_distance(Vector3 p) {
        return Vector3.dot_product(this.normal, Vector3.subtract(p, this.base));
    }

    public double distance(Vector3 p) {
        return Math.abs(this.signed_distance(p));
    }

    public void show() {
        if (this.planeVehicle != null) {
            this.planeVisual.setParent((Container)this.planeVehicle);
        }
    }

    public void delete() {
        if (this.planeVehicle != null) {
            this.planeVehicle.setParent(null);
        }
    }

    public void addToScenegraph(Scene parent) {
        if (this.planeVehicle == null) {
            this.createPlaneVisual();
            this.planeVehicle = new Transformable();
            this.planeVehicle.setParent((Container)parent);
            this.setPosition((ReferenceFrame)parent);
        } else {
            this.planeVehicle.setParent((Container)parent);
        }
    }

    public void removeFromScenegraph() {
        if (this.planeVehicle != null) {
            this.planeVehicle.setParent(null);
        }
    }

    public Transformable getVehicle() {
        return this.planeVehicle;
    }

    public void addToScenegraph(Transformable parent) {
        this.planeVehicle.setParent((Container)parent);
        this.setPosition((ReferenceFrame)parent);
    }

    public void setPosition(ReferenceFrame parent) {
        edu.cmu.cs.stage3.math.Vector3 _base = new edu.cmu.cs.stage3.math.Vector3(this.base.x, this.base.y, this.base.z);
        this.planeVehicle.setPosition((Vector3d)_base, parent);
        Vector3 head = this.getHead();
        edu.cmu.cs.stage3.math.Vector3 _head = new edu.cmu.cs.stage3.math.Vector3(head.x, head.y, head.z);
        edu.cmu.cs.stage3.math.Vector3 _normal = new edu.cmu.cs.stage3.math.Vector3(this.normal.x, this.normal.y, this.normal.z);
        this.planeVehicle.setOrientation((Vector3d)_head, (Vector3d)_normal, parent);
    }

    public Vector3 getHead() {
        Vector3 x_axis = new Vector3(edu.cmu.cs.stage3.math.Vector3.X_AXIS.x, edu.cmu.cs.stage3.math.Vector3.X_AXIS.y, edu.cmu.cs.stage3.math.Vector3.X_AXIS.z);
        Vector3 y_axis = new Vector3(edu.cmu.cs.stage3.math.Vector3.Y_AXIS.x, edu.cmu.cs.stage3.math.Vector3.Y_AXIS.y, edu.cmu.cs.stage3.math.Vector3.Y_AXIS.z);
        Vector3 head0 = Vector3.cross_product(this.normal, y_axis);
        Vector3 head1 = Vector3.cross_product(this.normal, x_axis);
        Vector3 head = head0.length() > head1.length() ? head0 : head1;
        return head;
    }

    private void createPlaneVisual() {
        this.planeVisual = new Visual();
        this.planeAppearance = new Appearance();
        this.planeVisual.setFrontFacingAppearance(this.planeAppearance);
        this.planeAppearance.setDiffuseColor(this.DRAWING_PLANE_COLOR);
        this.planeAppearance.setFillingStyle(FillingStyle.SOLID);
        this.planeAppearance.setShadingStyle(ShadingStyle.SMOOTH);
        this.planeAppearance.setOpacity(0.5);
        if (planeITA == null) {
            planeITA = this.create_planeITA(8);
        }
        this.planeVisual.setGeometry((Geometry)planeITA);
        this.createGrid();
    }

    public IndexedTriangleArray create_planeITA(int size) {
        IndexedTriangleArray planeITA = new IndexedTriangleArray();
        edu.cmu.cs.stage3.alice.scenegraph.Vertex[] planeVertices = new edu.cmu.cs.stage3.alice.scenegraph.Vertex[12];
        int i = 0;
        while (i < 6) {
            planeVertices[i] = new edu.cmu.cs.stage3.alice.scenegraph.Vertex(19);
            double vx = this.plane_data[i][0] * size;
            double vy = this.plane_data[i][1] * size;
            double vz = this.plane_data[i][2] * size;
            planeVertices[i].setXYZ(new edu.cmu.cs.stage3.math.Vector3(vx, vy, vz));
            planeVertices[i].setIJK(new edu.cmu.cs.stage3.math.Vector3(0.0, 1.0, 0.0));
            planeVertices[i].setU(0.0);
            planeVertices[i].setV(0.0);
            planeVertices[i + 6] = new edu.cmu.cs.stage3.alice.scenegraph.Vertex(19);
            planeVertices[i + 6].setXYZ(new edu.cmu.cs.stage3.math.Vector3(vx, vy, vz));
            planeVertices[i + 6].setIJK(new edu.cmu.cs.stage3.math.Vector3(0.0, -1.0, 0.0));
            planeVertices[i + 6].setU(0.0);
            planeVertices[i + 6].setV(0.0);
            ++i;
        }
        int[] nArray = new int[12];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 8;
        nArray[8] = 7;
        nArray[9] = 9;
        nArray[10] = 11;
        nArray[11] = 10;
        int[] planeIndices = nArray;
        planeITA.setVertices((Vertex3d[])planeVertices);
        planeITA.setIndices(planeIndices);
        return planeITA;
    }

    private void createGrid() {
        this.gridVehicle = new Transformable();
        this.gridVisual = new Visual();
        this.gridVisual.setParent((Container)this.gridVehicle);
        this.gridAppearance = new Appearance();
        this.gridVisual.setFrontFacingAppearance(this.gridAppearance);
        this.gridAppearance.setDiffuseColor(this.DRAWING_PLANE_COLOR);
        this.gridAppearance.setFillingStyle(FillingStyle.SOLID);
        this.gridAppearance.setShadingStyle(ShadingStyle.SMOOTH);
        if (gridITA == null) {
            gridITA = this.create_gridITA(8);
        }
        this.gridVisual.setGeometry((Geometry)gridITA);
    }

    public IndexedTriangleArray create_gridITA(int size) {
        IndexedTriangleArray gridITA = new IndexedTriangleArray();
        edu.cmu.cs.stage3.alice.scenegraph.Vertex[] gridVertices = new edu.cmu.cs.stage3.alice.scenegraph.Vertex[12 * size * 2 * size * 2 / 2];
        int[] gridIndices = new int[12 * size * 2 * size * 2 / 2];
        int[] nArray = new int[12];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 8;
        nArray[8] = 7;
        nArray[9] = 9;
        nArray[10] = 11;
        nArray[11] = 10;
        int[] gridIndicesSub = nArray;
        int index = 0;
        int x = -size;
        while (x < size) {
            int y = -size;
            while (y < size) {
                if ((x + y) / 2 * 2 == x + y) {
                    int base_index = index;
                    int j = 0;
                    while (j < 2) {
                        int i = 0;
                        while (i < 6) {
                            gridVertices[index] = new edu.cmu.cs.stage3.alice.scenegraph.Vertex(19);
                            double vx = this.grid_data[i][0] + x;
                            double vy = (double)this.grid_data[i][1] + 0.001 - 0.002 * (double)j;
                            double vz = this.grid_data[i][2] + y;
                            gridVertices[index].setXYZ(new edu.cmu.cs.stage3.math.Vector3(vx, vy, vz));
                            gridVertices[index].setIJK(new edu.cmu.cs.stage3.math.Vector3(0.0, 1.0, 0.0));
                            gridVertices[index].setU(0.0);
                            gridVertices[index].setV(0.0);
                            gridIndices[index] = base_index + gridIndicesSub[index - base_index];
                            ++index;
                            ++i;
                        }
                        ++j;
                    }
                }
                ++y;
            }
            ++x;
        }
        gridITA.setVertices((Vertex3d[])gridVertices);
        gridITA.setIndices(gridIndices);
        return gridITA;
    }

    public PlaneVisual convert_PlaneVisual_from_teddyPlane() {
        edu.cmu.cs.stage3.math.Vector3 _base = new edu.cmu.cs.stage3.math.Vector3(this.base.x, this.base.y, this.base.z);
        edu.cmu.cs.stage3.math.Vector3 _normal = new edu.cmu.cs.stage3.math.Vector3(this.normal.x, this.normal.y, this.normal.z);
        return new PlaneVisual(_base, _normal);
    }

    public Vector3 project(Point p) {
        return this.project(p.x, p.y);
    }

    public Vector3 project(double x, double y) {
        if (Sweater.jaliceFrame.camera instanceof OrthographicCamera) {
            return this.project_parallel(x, y);
        }
        edu.cmu.cs.stage3.math.Vector3 _cameraPt = Sweater.jaliceFrame.cameraVehicle.getPosition(this.reference);
        Vector3 cameraPt = new Vector3(_cameraPt.x, _cameraPt.y, _cameraPt.z);
        edu.cmu.cs.stage3.math.Vector3 _screenPt = Sweater.jaliceFrame.screen_coords_to_local_coords(x, y, this.reference);
        Vector3 screenPt = new Vector3(_screenPt.x, _screenPt.y, _screenPt.z);
        Vector3 cameraToBase = this.base.subtract2(cameraPt);
        Vector3 cameraToScreen = Vector3.subtract(screenPt, cameraPt);
        double t = Vector3.dot_product(cameraToBase, this.normal) / Vector3.dot_product(cameraToScreen, this.normal);
        Vector3 result = cameraPt.add2(cameraToScreen.multiple(t));
        return result;
    }

    public Vector3 project_parallel(double x, double y) {
        edu.cmu.cs.stage3.math.Vector3 _cameraDirection = Sweater.jaliceFrame.getCameraDirection(this.reference);
        Vector3 cameraDirection = new Vector3(_cameraDirection.x, _cameraDirection.y, _cameraDirection.z);
        edu.cmu.cs.stage3.math.Vector3 _screenPt = Sweater.jaliceFrame.screen_coords_to_local_coords(x, y, this.reference);
        Vector3 screenPt = new Vector3(_screenPt.x, _screenPt.y, _screenPt.z);
        Vector3 screenToBase = this.base.subtract2(screenPt);
        double t = Vector3.dot_product(screenToBase, this.normal) / Vector3.dot_product(cameraDirection, this.normal);
        Vector3 result = screenPt.add2(cameraDirection.multiple(t));
        return result;
    }
}

