/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.util.Enumeration;
import teddy.Edge;
import teddy.Face;
import teddy.LinkedList;
import teddy.Polyhedron;
import teddy.Vertex;

public class Modify {
    protected static Polyhedron h;
    public static LinkedList temp_polygons;
    public static PolygonReplaceManager polygon_replace_manager;
    public static boolean section_is_sharp;

    public static void init(Polyhedron _h) {
        h = _h;
        temp_polygons = new LinkedList();
        polygon_replace_manager = new Modify().new PolygonReplaceManager();
    }

    public static void remove_broken_polygons() {
        Edge broken_edge;
        while ((broken_edge = Modify.find_broken_edge()) != null) {
            Face broken_polygon = broken_edge.left_face != null ? broken_edge.left_face : broken_edge.right_face;
            Modify.remove_broken_polygons(broken_edge, broken_polygon);
        }
        return;
    }

    protected static Edge find_broken_edge() {
        int i = 0;
        while (i < Modify.h.edges.size()) {
            Edge edge = h.edges(i);
            if (edge.left_face == null && edge.right_face == null) {
                System.out.println("edge without polygons (Cutting.find_broken_edge())");
            }
            if (edge.left_face == null || edge.right_face == null) {
                return edge;
            }
            ++i;
        }
        System.out.println("no broken edge (Cutting.find_broken_edge())");
        return null;
    }

    protected static void remove_broken_polygons(Edge base_edge, Face face) {
        h.remove(face);
        int i = 0;
        while (i < face.edges.length) {
            Face next_face;
            Edge edge = face.edges[i];
            if (edge != base_edge && (next_face = edge.get_opposite_face(null)) != null) {
                Modify.remove_broken_polygons(edge, next_face);
            }
            ++i;
        }
    }

    public static void delete_temp_polygons() {
        Enumeration e = temp_polygons.elements();
        while (e.hasMoreElements()) {
            Face temp_polygon = (Face)e.nextElement();
            if (!h.contains(temp_polygon)) continue;
            h.remove(temp_polygon);
        }
    }

    public static void divide_knot_polygon(Face face, Vertex head_vertex, Edge head_edge, LinkedList head_vertex_list, Vertex tail_vertex, Edge tail_edge, LinkedList tail_vertex_list) {
        LinkedList l = tail_vertex_list.reverse();
        LinkedList dividing_vertex_list = head_vertex_list.copy();
        dividing_vertex_list.connect(l.cdr());
        System.out.println("divide knot polygon--");
        PolygonReplace pr = polygon_replace_manager.replaced(face);
        if (pr != null) {
            face = polygon_replace_manager.get_corresponding_polygon(pr, head_vertex);
            head_edge = Modify.find_corresponding_edge(face, head_edge);
            tail_edge = Modify.find_corresponding_edge(face, tail_edge);
        }
        if (!face.contains(head_edge)) {
            head_edge = polygon_replace_manager.get_parent_edge(head_edge);
            System.out.println("head_edge not contained");
        }
        if (!face.contains(tail_edge)) {
            tail_edge = polygon_replace_manager.get_parent_edge(tail_edge);
            System.out.println("tail_edge not contained");
        }
        Modify.divide_a_polygon(face, dividing_vertex_list, head_vertex, head_edge, tail_vertex, tail_edge);
    }

    public static Edge find_corresponding_edge(Face face, Edge next_edge) {
        int i = 0;
        while (i < face.edges.length) {
            Edge edge = face.edges[i];
            if (next_edge.on_edge(edge.start) && next_edge.on_edge(edge.end)) {
                return edge;
            }
            ++i;
        }
        System.out.print("no corresponding edge (Cutting.find_corresponding_edge)");
        return null;
    }

    public static void divide_a_polygon(Face face, LinkedList dividing_vertex_list, Vertex prev_vertex, Edge prev_edge, Vertex next_vertex, Edge next_edge) {
        Edge edge;
        Vertex v1;
        LinkedList dividing_edges = new LinkedList();
        Enumeration e = dividing_vertex_list.elements();
        Vertex v0 = (Vertex)e.nextElement();
        int n = 0;
        while (n < dividing_vertex_list.size() - 2) {
            v1 = (Vertex)e.nextElement();
            h.add(v1);
            edge = new Edge(v0, v1);
            dividing_edges.append(edge);
            h.add(edge);
            edge.set_sharp(section_is_sharp);
            v0 = v1;
            ++n;
        }
        v1 = (Vertex)dividing_vertex_list.tail();
        edge = new Edge(v0, v1);
        dividing_edges.append(edge);
        h.add(edge);
        edge.set_sharp(section_is_sharp);
        LinkedList right_edges = new LinkedList();
        LinkedList left_edges = new LinkedList();
        if (prev_edge == next_edge) {
            Vertex v = face.get_vertex(face.get_edge_index(prev_edge));
            if (Vertex.distance(v, prev_vertex) < Vertex.distance(v, next_vertex)) {
                right_edges.append(h.get_edge(prev_vertex, next_vertex));
                left_edges = Modify.divide_a_polygon_around(face, next_vertex, next_edge, prev_vertex, prev_edge);
                polygon_replace_manager.edge_replaced(prev_edge, (Edge)left_edges.tail(), (Edge)right_edges.head(), (Edge)left_edges.head());
            } else {
                left_edges.append(h.get_edge(next_vertex, prev_vertex));
                right_edges = Modify.divide_a_polygon_around(face, prev_vertex, prev_edge, next_vertex, next_edge);
                polygon_replace_manager.edge_replaced(prev_edge, (Edge)right_edges.tail(), (Edge)left_edges.head(), (Edge)right_edges.head());
            }
        } else {
            right_edges = Modify.divide_a_polygon_around(face, prev_vertex, prev_edge, next_vertex, next_edge);
            left_edges = Modify.divide_a_polygon_around(face, next_vertex, next_edge, prev_vertex, prev_edge);
            polygon_replace_manager.edge_replaced(prev_edge, (Edge)left_edges.tail(), (Edge)right_edges.head());
            polygon_replace_manager.edge_replaced(next_edge, (Edge)right_edges.tail(), (Edge)left_edges.head());
        }
        right_edges.connect(dividing_edges.reverse());
        Face right_face = new Face(right_edges);
        h.add(right_face);
        left_edges.connect(dividing_edges);
        Face left_face = new Face(left_edges);
        h.add(left_face);
        temp_polygons.append(left_face);
        polygon_replace_manager.polygon_replaced(face, right_face, left_face);
        if (h.contains(face)) {
            h.remove(face);
        }
    }

    public static LinkedList divide_a_polygon_around(Face face, Vertex prev_vertex, Edge prev_edge, Vertex next_vertex, Edge next_edge) {
        LinkedList edges = new LinkedList();
        if (!face.contains(prev_edge)) {
            System.out.println("prev_edge not contained (dividing_a_polygon_around)");
            return edges;
        }
        if (!face.contains(next_edge)) {
            return edges;
        }
        int i = face.get_edge_index(prev_edge) + 1;
        Edge edge = h.get_edge(prev_vertex, face.get_vertex(i));
        edges.append(edge);
        while (next_edge != face.edges(i)) {
            edges.append(face.edges(i));
            ++i;
        }
        edge = h.get_edge(next_vertex, face.get_vertex(i));
        edges.append(edge);
        return edges;
    }

    class PolygonReplaceManager {
        protected LinkedList polygon_replace_list = new LinkedList();
        protected LinkedList edge_replace_list = new LinkedList();

        PolygonReplaceManager() {
        }

        public PolygonReplace replaced(Face face) {
            Enumeration e = this.polygon_replace_list.elements();
            while (e.hasMoreElements()) {
                PolygonReplace pr = (PolygonReplace)e.nextElement();
                if (pr.parent != face) continue;
                return pr;
            }
            return null;
        }

        public Face get_corresponding_polygon(PolygonReplace pr, Vertex v) {
            Face face = pr.child0.on_polygon(v) ? pr.child0 : pr.child1;
            pr = this.replaced(face);
            if (pr == null) {
                return face;
            }
            return this.get_corresponding_polygon(pr, v);
        }

        public void polygon_replaced(Face parent, Face child0, Face child1) {
            this.polygon_replace_list.append(new PolygonReplace(parent, child0, child1));
        }

        public Edge get_corresponding_edge(Edge original, Vertex vertex) {
            EdgeReplace edge_replace = null;
            Enumeration e = this.edge_replace_list.elements();
            while (e.hasMoreElements()) {
                EdgeReplace er = (EdgeReplace)e.nextElement();
                if (er.parent != original) continue;
                edge_replace = er;
                break;
            }
            if (edge_replace == null) {
                return original;
            }
            Edge edge = null;
            if (edge_replace.child0.on_edge(vertex)) {
                edge = edge_replace.child0;
            } else if (edge_replace.child1.on_edge(vertex)) {
                edge = edge_replace.child1;
            } else if (edge_replace.child2.on_edge(vertex)) {
                edge = edge_replace.child2;
            } else {
                System.out.println("no corresponding edge (Cutting.get_corresponding_edge)");
            }
            return this.get_corresponding_edge(edge, vertex);
        }

        public Edge get_parent_edge(Edge child) {
            Object edge_replace = null;
            Enumeration e = this.edge_replace_list.elements();
            while (e.hasMoreElements()) {
                EdgeReplace er = (EdgeReplace)e.nextElement();
                if (!er.is_child(child)) continue;
                return er.parent;
            }
            System.out.println("no parent (Cutting.get_parent_replace)");
            return child;
        }

        public void edge_replaced(Edge parent, Edge child0, Edge child1) {
            this.edge_replace_list.append(new EdgeReplace(parent, child0, child1));
        }

        public void edge_replaced(Edge parent, Edge child0, Edge child1, Edge child2) {
            this.edge_replace_list.append(new EdgeReplace(parent, child0, child1, child2));
        }
    }

    class PolygonReplace {
        Face parent;
        Face child0;
        Face child1;

        PolygonReplace(Face _parent, Face _child0, Face _child1) {
            this.parent = _parent;
            this.child0 = _child0;
            this.child1 = _child1;
        }
    }

    class EdgeReplace {
        Edge parent;
        Edge child0;
        Edge child1;
        Edge child2;

        EdgeReplace(Edge _parent, Edge _child0, Edge _child1) {
            this.parent = _parent;
            this.child0 = _child0;
            this.child1 = _child1;
            this.child2 = null;
        }

        EdgeReplace(Edge _parent, Edge _child0, Edge _child1, Edge _child2) {
            this.parent = _parent;
            this.child0 = _child0;
            this.child1 = _child1;
            this.child2 = _child2;
        }

        public boolean is_child(Edge edge) {
            return edge == this.child0 || edge == this.child1 || edge == this.child2;
        }
    }
}

