/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.util.List;
import teddy.Polyhedron2D;
import teddy.SparseMatrix;
import teddy.Vertex2D;
import umfpack.Umfpack;

public class MeshBeautify {
    public static void beautify_for_polyhedron2D(Polyhedron2D mesh, List constraints) {
        mesh.set_indices();
        int n_vertices = mesh.vertices.size();
        int n_constraints = constraints.size();
        SparseMatrix A = new SparseMatrix(n_vertices + n_constraints, n_vertices);
        int i = 0;
        while (i < mesh.vertices.size()) {
            Vertex2D v = (Vertex2D)mesh.vertices.get(i);
            List vs = v.get_surrounding_vertices();
            double weight = v.fixed ? 0.001 : 1.0;
            int j = 0;
            while (j < vs.size()) {
                Vertex2D u = (Vertex2D)vs.get(j);
                A.add(v.index, u.index, -weight);
                A.add(v.index, v.index, weight);
                ++j;
            }
            ++i;
        }
        int index = 0;
        int i2 = 0;
        while (i2 < mesh.vertices.size()) {
            Vertex2D v = (Vertex2D)mesh.vertices.get(i2);
            if (v.fixed) {
                A.add(n_vertices + index++, v.index, 1.0);
            }
            ++i2;
        }
        double[] Bx = new double[n_vertices + n_constraints];
        double[] By = new double[n_vertices + n_constraints];
        int i3 = 0;
        while (i3 < n_constraints) {
            Vertex2D u = (Vertex2D)constraints.get(i3);
            Bx[n_vertices + i3] = u.x;
            By[n_vertices + i3] = u.y;
            ++i3;
        }
        SparseMatrix AT = SparseMatrix.transpose(A);
        SparseMatrix ATA = SparseMatrix.tranpose_and_multiply(A);
        double[] xm = new double[mesh.vertices.size()];
        double[] ym = new double[mesh.vertices.size()];
        Umfpack umfpack = new Umfpack();
        SparseMatrix.factorize(umfpack, ATA);
        umfpack.solve(SparseMatrix.multiply(AT, Bx), xm);
        umfpack.solve(SparseMatrix.multiply(AT, By), ym);
        umfpack.release();
        int i4 = 0;
        while (i4 < mesh.vertices.size()) {
            Vertex2D v = (Vertex2D)mesh.vertices.get(i4);
            v.x = xm[i4];
            v.y = ym[i4];
            ++i4;
        }
    }
}

