/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.util.ArrayList;
import java.util.List;
import pattern.Seam;
import teddy.CleanStroke3D;
import teddy.Edge;
import teddy.Face;
import teddy.Polyhedron;
import teddy.SurfacePath;
import teddy.Util;
import teddy.Vertex;

public class LaplacianRemesh {
    static boolean is_front_loop = true;
    static boolean remove_inside_faces = true;

    public static List remesh_extrusion(Polyhedron h, SurfacePath path) {
        is_front_loop = true;
        remove_inside_faces = true;
        return LaplacianRemesh.remesh(h, path);
    }

    public static List remesh_cut(Polyhedron h, SurfacePath path) {
        is_front_loop = false;
        remove_inside_faces = true;
        return LaplacianRemesh.remesh(h, path);
    }

    public static List remesh_no_hole_extrusion(Polyhedron h, SurfacePath path) {
        System.out.println("test");
        is_front_loop = true;
        remove_inside_faces = false;
        List boundary_vertices = LaplacianRemesh.remesh(h, path);
        System.out.println("boundary_vertices" + boundary_vertices);
        LaplacianRemesh.set_boudnary_seam(boundary_vertices);
        return boundary_vertices;
    }

    public static List remesh_no_hole_cut(Polyhedron h, SurfacePath path) {
        is_front_loop = false;
        remove_inside_faces = false;
        List boundary_vertices = LaplacianRemesh.remesh(h, path);
        return boundary_vertices;
    }

    public static List remesh(Polyhedron h, SurfacePath path) {
        Edge edge;
        double unit_length;
        boolean[] dirty_face = new boolean[h.faces.size()];
        int[] dirty_vertices = new int[h.vertices.size()];
        Face face = null;
        int i = 0;
        while (i < path.size()) {
            if (path.onFace(i)) {
                face = path.getFace(i);
            } else {
                Edge edge2 = path.getEdge(i);
                if (edge2.left_face == face) {
                    int n = edge2.start.index;
                    dirty_vertices[n] = dirty_vertices[n] + 1;
                    int n2 = edge2.end.index;
                    dirty_vertices[n2] = dirty_vertices[n2] - 1;
                } else {
                    int n = edge2.end.index;
                    dirty_vertices[n] = dirty_vertices[n] + 1;
                    int n3 = edge2.start.index;
                    dirty_vertices[n3] = dirty_vertices[n3] - 1;
                }
                face = edge2.get_opposite_face(face);
            }
            ++i;
        }
        List<Vertex> outer_boundary_vertices = new ArrayList<Vertex>();
        List<Vertex> inner_boundary_vertices = new ArrayList<Vertex>();
        int i2 = 0;
        while (i2 < h.vertices.size()) {
            if (dirty_vertices[i2] > 0) {
                inner_boundary_vertices.add(h.vertices(i2));
            } else if (dirty_vertices[i2] < 0) {
                outer_boundary_vertices.add(h.vertices(i2));
            }
            ++i2;
        }
        System.out.println("outer_bondary_vertices" + outer_boundary_vertices);
        System.out.println("inner_boundary_vertices" + inner_boundary_vertices);
        i2 = 0;
        while (i2 < path.size()) {
            if (path.onEdge(i2)) {
                Edge edge3 = path.getEdge(i2);
                dirty_face[edge3.left_face.index] = true;
                dirty_face[edge3.right_face.index] = true;
            }
            ++i2;
        }
        if (remove_inside_faces) {
            i2 = 0;
            while (i2 < h.vertices.size()) {
                if (dirty_vertices[i2] > 0) {
                    Vertex v = h.vertices(i2);
                    List faces = v.get_faces();
                    int j = 0;
                    while (j < faces.size()) {
                        Face face2 = (Face)faces.get(j);
                        if (!dirty_face[face2.index]) {
                            LaplacianRemesh.propagate_dirty_faces(face2, dirty_face);
                        }
                        ++j;
                    }
                }
                ++i2;
            }
        }
        if (outer_boundary_vertices == null || outer_boundary_vertices.size() == 0) {
            System.out.println("outer_boundary_vertices == null");
            return null;
        }
        ArrayList<Face> dirty_faces = new ArrayList<Face>();
        int i3 = 0;
        while (i3 < h.faces.size()) {
            if (dirty_face[i3]) {
                dirty_faces.add(h.faces(i3));
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < dirty_faces.size()) {
            Face face3 = (Face)dirty_faces.get(i3);
            h.remove(face3);
            ++i3;
        }
        outer_boundary_vertices = LaplacianRemesh.sort_boundary_vertices(path.getVertex(0), outer_boundary_vertices);
        if (!remove_inside_faces) {
            inner_boundary_vertices = LaplacianRemesh.sort_boundary_vertices(path.getVertex(0), inner_boundary_vertices);
        }
        List path_vertices = new ArrayList<Vertex>();
        ArrayList<Object[]> deleted_seam_or_sharp_edges = new ArrayList<Object[]>();
        int i4 = 0;
        while (i4 < path.size()) {
            Vertex v = path.getVertex(i4);
            path_vertices.add(v);
            if (path.onEdge(i4) && (path.getEdge((int)i4).sharp || path.getEdge((int)i4).seam)) {
                v.fixed = true;
                Object[] vertex_edge = new Object[]{v, path.getEdge(i4)};
                deleted_seam_or_sharp_edges.add(vertex_edge);
            } else {
                v.fixed = false;
            }
            ++i4;
        }
        double d = unit_length = is_front_loop ? LaplacianRemesh.compute_average_distance_between_onPolygon_vertices(path) : LaplacianRemesh.compute_minimum_distance_between_onPolygon_vertices(path);
        if (!path.getVertex(0).same_position(path.getVertex(path.size() - 1))) {
            path_vertices.add(path.getVertex(0));
        }
        path_vertices = CleanStroke3D.resample_by_length_with_fixes(path_vertices, unit_length);
        path_vertices.remove(path_vertices.get(path_vertices.size() - 1));
        int i5 = 0;
        while (i5 < path_vertices.size()) {
            Vertex v = (Vertex)path_vertices.get(i5);
            v.fixed = true;
            h.add(v);
            ++i5;
        }
        i5 = 0;
        while (i5 < path_vertices.size()) {
            Vertex v0 = (Vertex)path_vertices.get(i5);
            Vertex v1 = (Vertex)path_vertices.get(Util.mod(i5 + 1, path_vertices.size()));
            edge = new Edge(v0, v1);
            edge.seam = true;
            h.add(edge);
            ++i5;
        }
        LaplacianRemesh.stitch(path_vertices, outer_boundary_vertices, h);
        if (!remove_inside_faces) {
            LaplacianRemesh.stitch(LaplacianRemesh.reverse(path_vertices), inner_boundary_vertices, h);
        }
        i5 = 0;
        while (i5 < deleted_seam_or_sharp_edges.size()) {
            Edge edge1;
            Object[] vertex_edge = (Object[])deleted_seam_or_sharp_edges.get(i5);
            Vertex vertex = (Vertex)vertex_edge[0];
            edge = (Edge)vertex_edge[1];
            Edge edge0 = vertex.get_common_edge(edge.start);
            if (edge0 != null) {
                edge0.sharp = edge.sharp;
                edge0.seam = edge.seam;
                System.out.println("seam_or_sharp s " + vertex);
            }
            if ((edge1 = vertex.get_common_edge(edge.end)) != null) {
                edge1.sharp = edge.sharp;
                edge1.seam = edge.seam;
                System.out.println("seam_or_sharp e " + vertex);
            }
            ++i5;
        }
        h.set_parameters();
        return path_vertices;
    }

    public static List sort_boundary_vertices(Vertex base, List boundary_vertices) {
        Vertex start_v;
        ArrayList<Vertex> sorted_boundary_vertices = new ArrayList<Vertex>();
        Vertex v = start_v = LaplacianRemesh.find_closest(boundary_vertices, base);
        block0: do {
            sorted_boundary_vertices.add(v);
            int i = 0;
            while (i < v.edges.size()) {
                Edge edge = (Edge)v.edges.get(i);
                if (edge.start == v && edge.right_face == null || edge.end == v && edge.left_face == null) {
                    v = edge.get_opposite_vertex(v);
                    continue block0;
                }
                ++i;
            }
        } while (v != start_v);
        return sorted_boundary_vertices;
    }

    public static void stitch(List path_vertices, List boundary_vertices, Polyhedron h) {
        Edge start_edge;
        int path_index = 0;
        int outer_index = 0;
        Vertex start_path_vertex = (Vertex)path_vertices.get(0);
        Vertex start_outer_vertex = (Vertex)boundary_vertices.get(0);
        Vertex path_vertex = start_path_vertex;
        Vertex outer_vertex = start_outer_vertex;
        Edge prev_edge = start_edge = new Edge(path_vertex, outer_vertex);
        h.add(prev_edge);
        do {
            Face face;
            Edge mid_edge;
            Edge next_edge;
            Vertex next_path_vertex = (Vertex)path_vertices.get(Util.mod(path_index + 1, path_vertices.size()));
            Vertex next_outer_vertex = (Vertex)boundary_vertices.get(Util.mod(outer_index + 1, boundary_vertices.size()));
            if (outer_index != boundary_vertices.size() && Vertex.distance(path_vertex, next_outer_vertex) < Vertex.distance(outer_vertex, next_path_vertex) || path_index == path_vertices.size()) {
                next_edge = null;
                if (path_vertex == start_path_vertex && next_outer_vertex == start_outer_vertex) {
                    next_edge = start_edge;
                } else {
                    next_edge = new Edge(path_vertex, next_outer_vertex);
                    h.add(next_edge);
                }
                mid_edge = outer_vertex.get_common_edge(next_outer_vertex);
                face = new Face(prev_edge, next_edge, mid_edge);
                h.add(face);
                outer_vertex = next_outer_vertex;
                prev_edge = next_edge;
                ++outer_index;
                continue;
            }
            next_edge = null;
            if (next_path_vertex == start_path_vertex && outer_vertex == start_outer_vertex) {
                next_edge = start_edge;
            } else {
                next_edge = new Edge(next_path_vertex, outer_vertex);
                h.add(next_edge);
            }
            mid_edge = path_vertex.get_common_edge(next_path_vertex);
            face = new Face(prev_edge, mid_edge, next_edge);
            h.add(face);
            path_vertex = next_path_vertex;
            prev_edge = next_edge;
            ++path_index;
        } while (path_index != path_vertices.size() || outer_index != boundary_vertices.size());
    }

    static List reverse(List path_vertices) {
        List reversed = Util.reverse(path_vertices);
        Vertex v = (Vertex)reversed.get(reversed.size() - 1);
        reversed.remove(reversed.size() - 1);
        reversed.add(0, v);
        return reversed;
    }

    public static List _remesh(Polyhedron h, SurfacePath path) {
        Edge start_edge;
        Edge edge;
        int i;
        Vertex start_v;
        boolean[] dirty_face = new boolean[h.faces.size()];
        int[] dirty_vertices = new int[h.vertices.size()];
        Face face = null;
        int i2 = 0;
        while (i2 < path.size()) {
            if (path.onFace(i2)) {
                face = path.getFace(i2);
            } else {
                Edge edge2 = path.getEdge(i2);
                if (edge2.left_face == face) {
                    int n = edge2.start.index;
                    dirty_vertices[n] = dirty_vertices[n] + 1;
                    int n2 = edge2.end.index;
                    dirty_vertices[n2] = dirty_vertices[n2] - 1;
                } else {
                    int n = edge2.end.index;
                    dirty_vertices[n] = dirty_vertices[n] + 1;
                    int n3 = edge2.start.index;
                    dirty_vertices[n3] = dirty_vertices[n3] - 1;
                }
                face = edge2.get_opposite_face(face);
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < path.size()) {
            if (path.onEdge(i3)) {
                Edge edge3 = path.getEdge(i3);
                dirty_face[edge3.left_face.index] = true;
                dirty_face[edge3.right_face.index] = true;
            }
            ++i3;
        }
        ArrayList<Vertex> boundary_vertices = new ArrayList<Vertex>();
        i = 0;
        while (i < h.vertices.size()) {
            if (dirty_vertices[i] > 0) {
                Vertex v = h.vertices(i);
                List faces = v.get_faces();
                int j = 0;
                while (j < faces.size()) {
                    Face face2 = (Face)faces.get(j);
                    if (!dirty_face[face2.index]) {
                        LaplacianRemesh.propagate_dirty_faces(face2, dirty_face);
                    }
                    ++j;
                }
            } else if (dirty_vertices[i] < 0) {
                boundary_vertices.add(h.vertices(i));
            }
            ++i;
        }
        ArrayList<Face> dirty_faces = new ArrayList<Face>();
        int i4 = 0;
        while (i4 < h.faces.size()) {
            if (dirty_face[i4]) {
                dirty_faces.add(h.faces(i4));
            }
            ++i4;
        }
        i4 = 0;
        while (i4 < dirty_faces.size()) {
            Face face3 = (Face)dirty_faces.get(i4);
            h.remove(face3);
            ++i4;
        }
        ArrayList<Vertex> sorted_boundary_vertices = new ArrayList<Vertex>();
        Vertex v = start_v = LaplacianRemesh.find_closest(boundary_vertices, path.getVertex(0));
        block6: do {
            sorted_boundary_vertices.add(v);
            i = 0;
            while (i < v.edges.size()) {
                edge = (Edge)v.edges.get(i);
                if (edge.start == v && edge.right_face == null || edge.end == v && edge.left_face == null) {
                    v = edge.get_opposite_vertex(v);
                    continue block6;
                }
                ++i;
            }
        } while (v != start_v);
        boundary_vertices = sorted_boundary_vertices;
        List<Vertex> inner_vertices = new ArrayList();
        if (is_front_loop) {
            int i5 = 0;
            while (i5 < path.size() - 1) {
                if (path.onFace(i5)) {
                    v = path.getVertex(i5);
                    v.fixed = true;
                    inner_vertices.add(v);
                    h.add(v);
                }
                ++i5;
            }
        } else {
            int i6 = 0;
            while (i6 < path.size()) {
                v = path.getVertex(i6);
                inner_vertices.add(v);
                ++i6;
            }
            inner_vertices = CleanStroke3D.resample_loop(inner_vertices, 20);
            double unit_length = LaplacianRemesh.compute_average_length_of_crossing_edges(path);
            inner_vertices = CleanStroke3D.resample_by_length_loop(inner_vertices, unit_length);
            i = 0;
            while (i < inner_vertices.size()) {
                Vertex v2 = (Vertex)inner_vertices.get(i);
                v2.fixed = true;
                h.add(v2);
                ++i;
            }
        }
        int i7 = 0;
        while (i7 < inner_vertices.size()) {
            Vertex v0 = (Vertex)inner_vertices.get(i7);
            Vertex v1 = (Vertex)inner_vertices.get(Util.mod(i7 + 1, inner_vertices.size()));
            edge = new Edge(v0, v1);
            h.add(edge);
            ++i7;
        }
        int inner_index = 0;
        int outer_index = 0;
        Vertex start_inner_vertex = (Vertex)inner_vertices.get(0);
        Vertex start_outer_vertex = (Vertex)boundary_vertices.get(0);
        Vertex inner_vertex = start_inner_vertex;
        Vertex outer_vertex = start_outer_vertex;
        Edge prev_edge = start_edge = new Edge(inner_vertex, outer_vertex);
        h.add(prev_edge);
        do {
            Face face4;
            Edge mid_edge;
            Edge next_edge;
            Vertex next_inner_vertex = (Vertex)inner_vertices.get(Util.mod(inner_index + 1, inner_vertices.size()));
            Vertex next_outer_vertex = (Vertex)boundary_vertices.get(Util.mod(outer_index + 1, boundary_vertices.size()));
            if (Vertex.distance(inner_vertex, next_outer_vertex) < Vertex.distance(outer_vertex, next_inner_vertex)) {
                next_edge = null;
                if (inner_vertex == start_inner_vertex && next_outer_vertex == start_outer_vertex) {
                    next_edge = start_edge;
                } else {
                    next_edge = new Edge(inner_vertex, next_outer_vertex);
                    h.add(next_edge);
                }
                mid_edge = outer_vertex.get_common_edge(next_outer_vertex);
                face4 = new Face(prev_edge, next_edge, mid_edge);
                h.add(face4);
                outer_vertex = next_outer_vertex;
                prev_edge = next_edge;
                ++outer_index;
                continue;
            }
            next_edge = null;
            if (next_inner_vertex == start_inner_vertex && outer_vertex == start_outer_vertex) {
                next_edge = start_edge;
            } else {
                next_edge = new Edge(next_inner_vertex, outer_vertex);
                h.add(next_edge);
            }
            mid_edge = inner_vertex.get_common_edge(next_inner_vertex);
            face4 = new Face(prev_edge, mid_edge, next_edge);
            h.add(face4);
            inner_vertex = next_inner_vertex;
            prev_edge = next_edge;
            ++inner_index;
        } while (inner_index != inner_vertices.size() || outer_index != boundary_vertices.size());
        h.set_parameters();
        return inner_vertices;
    }

    static double compute_average_length_of_crossing_edges(SurfacePath path) {
        double total = 0.0;
        int count = 0;
        int i = 0;
        while (i < path.size()) {
            if (path.onEdge(i)) {
                total += path.getEdge(i).length();
                ++count;
            }
            ++i;
        }
        return total / (double)count;
    }

    static double compute_minimum_distance_between_onPolygon_vertices(SurfacePath path) {
        ArrayList<Vertex> vs = new ArrayList<Vertex>();
        int i = 0;
        while (i < path.size()) {
            if (path.onFace(i)) {
                vs.add(path.getVertex(i));
            }
            ++i;
        }
        double min = Double.MAX_VALUE;
        int i2 = 0;
        while (i2 < vs.size() - 1) {
            Vertex v1;
            Vertex v0 = (Vertex)vs.get(i2);
            double d = Vertex.distance(v0, v1 = (Vertex)vs.get(i2 + 1));
            if (d < min) {
                min = d;
            }
            ++i2;
        }
        return min;
    }

    static double compute_average_distance_between_onPolygon_vertices(SurfacePath path) {
        ArrayList<Vertex> vs = new ArrayList<Vertex>();
        int i = 0;
        while (i < path.size()) {
            if (path.onFace(i)) {
                vs.add(path.getVertex(i));
            }
            ++i;
        }
        double total = 0.0;
        int i2 = 0;
        while (i2 < vs.size() - 1) {
            Vertex v0 = (Vertex)vs.get(i2);
            Vertex v1 = (Vertex)vs.get(i2 + 1);
            total += Vertex.distance(v0, v1);
            ++i2;
        }
        return total / (double)(vs.size() - 1);
    }

    static Vertex find_closest(List vertices, Vertex base) {
        if (vertices == null) {
            return null;
        }
        if (vertices.size() == 0) {
            return null;
        }
        Vertex closest = (Vertex)vertices.get(0);
        double min = Vertex.distance(closest, base);
        int i = 1;
        while (i < vertices.size()) {
            Vertex v = (Vertex)vertices.get(i);
            double d = Vertex.distance(v, base);
            if (d < min) {
                min = d;
                closest = v;
            }
            ++i;
        }
        return closest;
    }

    static void propagate_dirty_faces(Face face, boolean[] dirty_face) {
        dirty_face[face.index] = true;
        try {
            int i = 0;
            while (i < 3) {
                Face next_face = face.edges[i].get_opposite_face(face);
                if (!dirty_face[next_face.index]) {
                    LaplacianRemesh.propagate_dirty_faces(next_face, dirty_face);
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.err.println("prpagate_dirty_faces in LaplacianRemesh.java");
        }
    }

    static List resample(SurfacePath path, int n) {
        ArrayList<Vertex> vs = new ArrayList<Vertex>();
        int i = 0;
        while (i < path.size()) {
            if (path.onFace(i)) {
                vs.add(path.getVertex(i));
            }
            ++i;
        }
        double length = 0.0;
        int i2 = 0;
        while (i2 < vs.size()) {
            length += Vertex.distance((Vertex)vs.get(i2), (Vertex)vs.get(Util.mod(i2 + 1, vs.size())));
            ++i2;
        }
        ArrayList<Vertex> resampled = new ArrayList<Vertex>();
        Vertex v = (Vertex)vs.get(0);
        resampled.add(v);
        int index = 1;
        double sum = 0.0;
        int i3 = 1;
        while (i3 < n) {
            Vertex next_v;
            double d;
            while (true) {
                if (sum + (d = Vertex.distance(v, next_v = (Vertex)vs.get(index))) > length * (double)i3 / (double)n) break;
                ++index;
                v = next_v;
                sum += d;
            }
            double sd = length * (double)i3 / (double)n - sum;
            Vertex p = Vertex.interpolate(v, next_v, sd / d);
            resampled.add(p);
            ++i3;
        }
        return resampled;
    }

    public static SurfacePath getSurfacePath(List boundary_vertices) {
        SurfacePath path = new SurfacePath();
        int i = 0;
        while (i < boundary_vertices.size()) {
            Vertex p = (Vertex)boundary_vertices.get(i);
            path.add(p, p);
            ++i;
        }
        path.loop = true;
        return path;
    }

    public static void set_boudnary_seam(List boundary_vertices) {
        System.out.println("set boundary seam");
        Seam seam = new Seam();
        System.out.println("boundary_vertices" + boundary_vertices);
    }
}

