/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.util.ArrayList;
import java.util.List;
import teddy.CameraInterface;
import teddy.CleanStroke3D;
import teddy.Edge;
import teddy.Face;
import teddy.GridMesh;
import teddy.Inflation;
import teddy.LaplacianRemesh;
import teddy.Line;
import teddy.Plane;
import teddy.Polyhedron;
import teddy.SurfacePath;
import teddy.Util;
import teddy.Vector3;
import teddy.Vertex;
import teddy.Vertex2D;

public class LaplacianExtrusion {
    public static int extrude(Polyhedron h, SurfacePath path, List stroke, CameraInterface camera) {
        stroke = Inflation.counter_clockwise(stroke);
        List boundary_vertices = LaplacianRemesh.remesh_extrusion(h, path);
        if (boundary_vertices == null) {
            System.err.println("boundary_vertices == null");
            return -1;
        }
        Vertex center = new Vertex();
        int i = 0;
        while (i < boundary_vertices.size()) {
            Vertex v = (Vertex)boundary_vertices.get(i);
            center.add(v);
            ++i;
        }
        center.multiply(1.0 / (double)boundary_vertices.size());
        Vector3 normal = new Vector3();
        int i2 = 0;
        while (i2 < boundary_vertices.size()) {
            Vertex v0 = (Vertex)boundary_vertices.get(i2);
            Vertex v1 = (Vertex)boundary_vertices.get((i2 + 1) % boundary_vertices.size());
            Vector3 vec0 = new Vector3(center, v0);
            Vector3 vec1 = new Vector3(center, v1);
            Vector3 vec = Vector3.cross_product(vec1, vec0);
            normal.add(vec);
            ++i2;
        }
        normal.normalize();
        Vector3 camera_to_center = new Vector3(camera.get_camera_position(), center);
        Vector3 normal2 = normal.cross_product(camera_to_center);
        Vertex vertex = (Vertex)boundary_vertices.get(0);
        Vector3 center_to_vertex = new Vector3(center, vertex);
        double dot_product = normal2.dot_product(center_to_vertex);
        Vertex most_left_vertex = vertex;
        Vertex most_right_vertex = vertex;
        double max = dot_product;
        double min = dot_product;
        int most_left_vertex_index = 0;
        int most_right_vertex_index = 0;
        int i3 = 1;
        while (i3 < boundary_vertices.size()) {
            vertex = (Vertex)boundary_vertices.get(i3);
            center_to_vertex = new Vector3(center, vertex);
            dot_product = normal2.dot_product(center_to_vertex);
            if (dot_product > max) {
                max = dot_product;
                most_left_vertex = vertex;
                most_left_vertex_index = i3;
            }
            if (dot_product < min) {
                min = dot_product;
                most_right_vertex = vertex;
                most_right_vertex_index = i3;
            }
            ++i3;
        }
        Plane pop_surface = new Plane(most_left_vertex, Vector3.cross_product(normal, new Vector3(most_left_vertex, most_right_vertex)));
        List<Vertex> silhouette_vertices = new ArrayList<Vertex>();
        int i4 = 0;
        while (i4 < stroke.size()) {
            Vertex2D p = (Vertex2D)stroke.get(i4);
            Vertex v = camera.screen_coords_to_local_coords(p);
            v = pop_surface.cross_point(new Line(v, camera.get_camera_lay(p)));
            silhouette_vertices.add(v);
            ++i4;
        }
        if (Vertex.distance(most_left_vertex, (Vertex)silhouette_vertices.get(0)) > Vertex.distance(most_right_vertex, (Vertex)silhouette_vertices.get(0))) {
            System.out.println("reverse");
            silhouette_vertices = Util.reverse(silhouette_vertices);
        }
        silhouette_vertices.add(0, most_left_vertex);
        silhouette_vertices.add(most_right_vertex);
        silhouette_vertices = CleanStroke3D.resample(silhouette_vertices);
        silhouette_vertices.remove(0);
        silhouette_vertices.remove(silhouette_vertices.size() - 1);
        i4 = 0;
        while (i4 < silhouette_vertices.size()) {
            Vertex v = (Vertex)silhouette_vertices.get(i4);
            v.fixed = true;
            h.add(v);
            ++i4;
        }
        ArrayList<Vertex> front_loop3D = new ArrayList<Vertex>();
        front_loop3D.addAll(silhouette_vertices);
        int i5 = most_right_vertex_index;
        while (true) {
            front_loop3D.add((Vertex)boundary_vertices.get(i5));
            if (i5 == most_left_vertex_index) break;
            if (++i5 != boundary_vertices.size()) continue;
            i5 = 0;
        }
        ArrayList<Vertex> back_loop3D = new ArrayList<Vertex>();
        back_loop3D.addAll(Util.reverse(silhouette_vertices));
        int i6 = most_left_vertex_index;
        while (true) {
            back_loop3D.add((Vertex)boundary_vertices.get(i6));
            if (i6 == most_right_vertex_index) break;
            if (++i6 != boundary_vertices.size()) continue;
            i6 = 0;
        }
        Vector3 x_vec = new Vector3(most_left_vertex, most_right_vertex);
        x_vec.normalize();
        Vector3 y_vec = normal;
        Vector3 offset = Vector3.cross_product(x_vec, y_vec);
        offset.multiply(0.05);
        int flag = LaplacianExtrusion.mesh_generate_sub(h, front_loop3D, center, x_vec, y_vec, offset);
        if (flag == -1) {
            System.err.println("front mesh : not mesh_generate_sub");
            return -1;
        }
        offset.multiply(-1.0);
        x_vec.multiply(-1.0);
        flag = LaplacianExtrusion.mesh_generate_sub(h, back_loop3D, center, x_vec, y_vec, offset);
        if (flag == -1) {
            System.err.println("back mesh : not mesh_generate_sub");
            return -1;
        }
        int i7 = 0;
        while (i7 < boundary_vertices.size()) {
            Vertex v0 = (Vertex)boundary_vertices.get(i7);
            Vertex v1 = (Vertex)boundary_vertices.get(Util.mod(i7 + 1, boundary_vertices.size()));
            Edge edge = v0.get_common_edge(v1);
            edge.sharp = true;
            ++i7;
        }
        h.set_parameters();
        return 1;
    }

    public static int mesh_generate_sub(Polyhedron h, List loop3D, Vertex center, Vector3 x_vec, Vector3 y_vec, Vector3 offset) {
        ArrayList<double[]> loop2D = new ArrayList<double[]>();
        int i = 0;
        while (i < loop3D.size()) {
            Vertex v = (Vertex)loop3D.get(i);
            Vector3 vec = new Vector3(center, v);
            double[] u = new double[]{Vector3.dot_product(vec, x_vec), Vector3.dot_product(vec, y_vec)};
            loop2D.add(u);
            ++i;
        }
        ArrayList<String> lines = new ArrayList<String>();
        int i2 = 0;
        while (i2 < loop2D.size()) {
            double[] v = (double[])loop2D.get(i2);
            lines.add(v[0] + " " + v[1]);
            ++i2;
        }
        List mesh2D = GridMesh.create_mesh(loop2D, 0.1);
        if (mesh2D == null) {
            System.err.println("mesh2D == null at LaplacianExtrusion.java");
            return -1;
        }
        List vertices2D = (List)mesh2D.get(0);
        List edges2D = (List)mesh2D.get(1);
        List faces2D = (List)mesh2D.get(2);
        ArrayList<Vertex> vertices3D = new ArrayList<Vertex>();
        int i3 = 0;
        while (i3 < vertices2D.size()) {
            Vertex v = null;
            if (i3 < loop2D.size()) {
                v = (Vertex)loop3D.get(i3);
            } else {
                double[] u = (double[])vertices2D.get(i3);
                v = new Vertex(center);
                v.add(Vector3.multiply(x_vec, u[0]));
                v.add(Vector3.multiply(y_vec, u[1]));
                h.add(v);
            }
            vertices3D.add(v);
            ++i3;
        }
        ArrayList faces3D = new ArrayList();
        int i4 = 0;
        while (i4 < faces2D.size()) {
            int[] f = (int[])faces2D.get(i4);
            Vertex v0 = (Vertex)vertices3D.get(f[0]);
            Vertex v1 = (Vertex)vertices3D.get(f[1]);
            Vertex v2 = (Vertex)vertices3D.get(f[2]);
            Face face = new Face(LaplacianExtrusion.get_edge(v0, v1, h), LaplacianExtrusion.get_edge(v1, v2, h), LaplacianExtrusion.get_edge(v2, v0, h));
            h.add(face);
            ++i4;
        }
        Vertex v_prev = (Vertex)loop3D.get(0);
        int i5 = 1;
        while (i5 < loop3D.size()) {
            Vertex v = (Vertex)loop3D.get(i5);
            Edge edge = v.get_common_edge(v_prev);
            edge.seam = true;
            v_prev = v;
            ++i5;
        }
        return 1;
    }

    static Edge get_edge(Vertex v0, Vertex v1, Polyhedron h) {
        Edge edge = v0.get_common_edge(v1);
        if (edge == null) {
            edge = new Edge(v0, v1);
            h.add(edge);
        }
        return edge;
    }
}

