/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.util.ArrayList;
import java.util.List;
import teddy.Edge;
import teddy.Face;
import teddy.GridMesh;
import teddy.LaplacianRemesh;
import teddy.Polyhedron;
import teddy.SurfacePath;
import teddy.Util;
import teddy.Vector3;
import teddy.Vertex;

public class LaplacianCut {
    public static void cut(Polyhedron h, SurfacePath path) {
        Vector3 vec;
        System.out.println("cut in LaplacianCut.java");
        List boundary_vertices = LaplacianRemesh.remesh_cut(h, path);
        Vertex center = new Vertex();
        int i = 0;
        while (i < boundary_vertices.size()) {
            Vertex v = (Vertex)boundary_vertices.get(i);
            center.add(v);
            ++i;
        }
        center.multiply(1.0 / (double)boundary_vertices.size());
        Vector3 normal = new Vector3();
        int i2 = 0;
        while (i2 < boundary_vertices.size()) {
            Vertex v0 = (Vertex)boundary_vertices.get(i2);
            Vertex v1 = (Vertex)boundary_vertices.get((i2 + 1) % boundary_vertices.size());
            Vector3 vec0 = new Vector3(center, v0);
            Vector3 vec1 = new Vector3(center, v1);
            vec = Vector3.cross_product(vec1, vec0);
            normal.add(vec);
            ++i2;
        }
        normal.normalize();
        Vector3 x_vec = new Vector3(center, (Vertex)boundary_vertices.get(0));
        x_vec.normalize();
        Vector3 y_vec = Vector3.cross_product(normal, x_vec);
        ArrayList<double[]> boundary_vertices_2d = new ArrayList<double[]>();
        int i3 = 0;
        while (i3 < boundary_vertices.size()) {
            Vertex v = (Vertex)boundary_vertices.get(i3);
            vec = new Vector3(center, v);
            double[] u = new double[]{Vector3.dot_product(vec, x_vec), Vector3.dot_product(vec, y_vec)};
            boundary_vertices_2d.add(u);
            ++i3;
        }
        List mesh2D = GridMesh.create_mesh(boundary_vertices_2d, 0.1);
        if (mesh2D == null) {
            System.err.println("mesh2D is null in cut at LaplacianCut.java");
            return;
        }
        List vertices2D = (List)mesh2D.get(0);
        List edges2D = (List)mesh2D.get(1);
        List faces2D = (List)mesh2D.get(2);
        ArrayList<Vertex> vertices3D = new ArrayList<Vertex>();
        int i4 = 0;
        while (i4 < vertices2D.size()) {
            Vertex v = null;
            if (i4 < boundary_vertices.size()) {
                v = (Vertex)boundary_vertices.get(i4);
            } else {
                double[] u = (double[])vertices2D.get(i4);
                v = new Vertex(center);
                v.add(Vector3.multiply(x_vec, u[0]));
                v.add(Vector3.multiply(y_vec, u[1]));
                h.add(v);
            }
            vertices3D.add(v);
            ++i4;
        }
        ArrayList faces3D = new ArrayList();
        int i5 = 0;
        while (i5 < faces2D.size()) {
            int[] f = (int[])faces2D.get(i5);
            Vertex v0 = (Vertex)vertices3D.get(f[0]);
            Vertex v1 = (Vertex)vertices3D.get(f[1]);
            Vertex v2 = (Vertex)vertices3D.get(f[2]);
            Face face = new Face(LaplacianCut.get_edge(v0, v1, h), LaplacianCut.get_edge(v1, v2, h), LaplacianCut.get_edge(v2, v0, h));
            h.add(face);
            ++i5;
        }
        i5 = 0;
        while (i5 < boundary_vertices.size()) {
            Vertex v0 = (Vertex)boundary_vertices.get(i5);
            Vertex v1 = (Vertex)boundary_vertices.get(Util.mod(i5 + 1, boundary_vertices.size()));
            Edge edge = v0.get_common_edge(v1);
            edge.sharp = true;
            edge.seam = true;
            ++i5;
        }
        h.set_parameters();
    }

    static Edge get_edge(Vertex v0, Vertex v1, Polyhedron h) {
        Edge edge = v0.get_common_edge(v1);
        if (edge == null) {
            edge = new Edge(v0, v1);
            h.add(edge);
        }
        return edge;
    }
}

