/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import VisualNumerics.math.DoubleLU;
import VisualNumerics.math.DoubleMatrix;
import java.util.ArrayList;
import teddy.SurfacePath;
import teddy.Vertex;

public class LaplacianCurveEdit {
    static int CONSTRAINT_WEIGHT = 10000;
    int n_laplacians;
    int n_involved;
    int index_low_involved;
    int index_high_involved;
    ArrayList fixed_vertices;
    Vertex[] vs;
    double[][] A;
    double[][] AT;
    DoubleLU doubleLU;
    double[] Bx;
    double[] By;
    double[] Bz;

    public void compile(SurfacePath path, int index_low, int index_handle, int index_high) {
        this.index_low_involved = index_low - 1;
        this.index_high_involved = index_high + 1;
        if (!path.loop) {
            if (index_low == 0) {
                index_low = 0;
                this.index_low_involved = 0;
            }
            if (index_high == path.size() - 1) {
                this.index_high_involved = index_high = path.size() - 1;
            }
        }
        this.n_involved = this.index_high_involved - this.index_low_involved + 1;
        this.n_laplacians = this.n_involved - 2;
        this.vs = new Vertex[this.n_involved];
        int i = this.index_low_involved;
        while (i <= this.index_high_involved) {
            Vertex v;
            this.vs[i - this.index_low_involved] = v = path.getVertex(i);
            ++i;
        }
        this.fixed_vertices = new ArrayList();
        this.fixed_vertices.add(new Integer(this.index_low_involved));
        if (index_low != this.index_low_involved) {
            this.fixed_vertices.add(new Integer(index_low));
        }
        if (index_handle > index_low && index_handle < index_high) {
            this.fixed_vertices.add(new Integer(index_handle));
        }
        if (index_high != this.index_high_involved) {
            this.fixed_vertices.add(new Integer(index_high));
        }
        this.fixed_vertices.add(new Integer(this.index_high_involved));
        this.A = new double[this.n_laplacians + this.fixed_vertices.size()][this.n_involved];
        i = 0;
        while (i < this.n_laplacians) {
            this.A[i][i] = -0.5;
            this.A[i][i + 1] = 1.0;
            this.A[i][i + 2] = -0.5;
            ++i;
        }
        i = 0;
        while (i < this.fixed_vertices.size()) {
            int j = (Integer)this.fixed_vertices.get(i);
            this.A[this.n_laplacians + i][j - this.index_low_involved] = CONSTRAINT_WEIGHT;
            ++i;
        }
        this.AT = DoubleMatrix.transpose((double[][])this.A);
        double[][] ATA = DoubleMatrix.multiply((double[][])this.AT, (double[][])this.A);
        this.doubleLU = this.construct_doubleLU(ATA);
        double[] xs = new double[this.n_involved];
        double[] ys = new double[this.n_involved];
        double[] zs = new double[this.n_involved];
        int i2 = 0;
        while (i2 < this.n_involved) {
            xs[i2] = this.vs[i2].x;
            ys[i2] = this.vs[i2].y;
            zs[i2] = this.vs[i2].z;
            ++i2;
        }
        this.Bx = this.multiply(this.A, xs);
        this.By = this.multiply(this.A, ys);
        this.Bz = this.multiply(this.A, zs);
    }

    double[][] multiply(double[][] A, double[][] B) {
        return DoubleMatrix.multiply((double[][])A, (double[][])B);
    }

    double[][] transpose(double[][] A) {
        return DoubleMatrix.transpose((double[][])A);
    }

    public double[][] inverse(double[][] A) {
        double[][] _A = null;
        try {
            _A = DoubleMatrix.inverse((double[][])A);
        }
        catch (Exception e) {
            System.out.println("Solve failed! " + e);
        }
        return _A;
    }

    public void update() {
        int i = 0;
        while (i < this.fixed_vertices.size()) {
            Vertex v = this.vs[(Integer)this.fixed_vertices.get(i) - this.index_low_involved];
            this.Bx[this.n_laplacians + i] = v.x * (double)CONSTRAINT_WEIGHT;
            this.By[this.n_laplacians + i] = v.y * (double)CONSTRAINT_WEIGHT;
            this.Bz[this.n_laplacians + i] = v.z * (double)CONSTRAINT_WEIGHT;
            ++i;
        }
        double[] x = this.doubleLU.solve(this.multiply(this.AT, this.Bx));
        double[] y = this.doubleLU.solve(this.multiply(this.AT, this.By));
        double[] z = this.doubleLU.solve(this.multiply(this.AT, this.Bz));
        int i2 = 0;
        while (i2 < this.n_involved) {
            if (!this.fixed_vertices.contains(this.vs[i2])) {
                this.vs[i2].x = x[i2];
                this.vs[i2].y = y[i2];
                this.vs[i2].z = z[i2];
            }
            ++i2;
        }
    }

    public double[] multiply(double[][] A, double[] x) {
        return DoubleMatrix.multiply((double[][])A, (double[])x);
    }

    public DoubleLU construct_doubleLU(double[][] A) {
        DoubleLU doubleLU = null;
        try {
            doubleLU = new DoubleLU(A);
        }
        catch (Exception e) {
            System.out.println("Solve failed! " + e);
        }
        return doubleLU;
    }
}

