/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import teddy.Edge;
import teddy.Face;
import teddy.GridMesh;
import teddy.Polyhedron;
import teddy.SurfacePath;
import teddy.Util;
import teddy.Vector3;
import teddy.Vertex;
import teddy.Vertex2D;

public class Inflation {
    private static List boundary_vertices;

    public static Polyhedron generate(List stroke) {
        stroke = Inflation.counter_clockwise(stroke);
        ArrayList<double[]> points = new ArrayList<double[]>();
        int i = 0;
        while (i < stroke.size()) {
            Vertex2D v = (Vertex2D)stroke.get(i);
            double[] p = new double[]{v.x, v.y};
            points.add(p);
            ++i;
        }
        Polyhedron polyhedron = Inflation.generate_single_disk(points);
        List boundary_edges = Inflation.getBoundaryEdges();
        int i2 = 0;
        while (i2 < boundary_edges.size()) {
            Edge edge = (Edge)boundary_edges.get(i2);
            edge.seam = true;
            ++i2;
        }
        return polyhedron;
    }

    public static SurfacePath getSurfacePath() {
        SurfacePath path = new SurfacePath();
        int i = 0;
        while (i < boundary_vertices.size()) {
            Vertex p = (Vertex)boundary_vertices.get(i);
            Vertex q = (Vertex)boundary_vertices.get((i + 1) % boundary_vertices.size());
            path.add(p, p.get_common_edge(q));
            ++i;
        }
        return path;
    }

    public static List getBoundaryEdges() {
        ArrayList<Edge> boundary_edges = new ArrayList<Edge>();
        int i = 0;
        while (i < boundary_vertices.size()) {
            Vertex p = (Vertex)boundary_vertices.get(i);
            Vertex q = (Vertex)boundary_vertices.get((i + 1) % boundary_vertices.size());
            boundary_edges.add(p.get_common_edge(q));
            ++i;
        }
        return boundary_edges;
    }

    public static Polyhedron generate_disk(List points) {
        int n_boundary = points.size();
        List mesh2D = GridMesh.create_mesh((ArrayList)points, 0.1);
        if (mesh2D == null) {
            return null;
        }
        List vertices2D = (List)mesh2D.get(0);
        List edges2D = (List)mesh2D.get(1);
        List faces2D = (List)mesh2D.get(2);
        List[] front = Inflation.create_one_side(vertices2D, edges2D, faces2D, 1);
        List front_vertices = front[0];
        List front_edges = front[1];
        List front_faces = front[2];
        List[] back = Inflation.create_one_side(vertices2D, edges2D, faces2D, -1);
        List back_vertices = back[0];
        List back_edges = back[1];
        List back_faces = back[2];
        Hashtable<Vertex, Vertex> vertex_map = new Hashtable<Vertex, Vertex>();
        Hashtable<Edge, Edge> edge_map = new Hashtable<Edge, Edge>();
        int i = 0;
        while (i < n_boundary) {
            Vertex back_vertex = (Vertex)back_vertices.get(i);
            Vertex front_vertex = (Vertex)front_vertices.get(i);
            vertex_map.put(back_vertex, front_vertex);
            Edge back_edge = back_vertex.get_common_edge((Vertex)back_vertices.get(Util.mod(i + 1, n_boundary)));
            Edge front_edge = front_vertex.get_common_edge((Vertex)front_vertices.get(Util.mod(i + 1, n_boundary)));
            edge_map.put(back_edge, front_edge);
            ++i;
        }
        List vertices = front_vertices;
        List edges = front_edges;
        List faces = front_faces;
        int i2 = 0;
        while (i2 < back_vertices.size()) {
            Vertex v = (Vertex)back_vertices.get(i2);
            Vertex new_v = (Vertex)vertex_map.get(v);
            if (new_v == null) {
                new_v = new Vertex(v);
                vertex_map.put(v, new_v);
                vertices.add(new_v);
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < back_edges.size()) {
            Edge back_edge = (Edge)back_edges.get(i2);
            Edge new_back_edge = (Edge)edge_map.get(back_edge);
            if (new_back_edge == null) {
                Vertex new_start = (Vertex)vertex_map.get(back_edge.start);
                Vertex new_end = (Vertex)vertex_map.get(back_edge.end);
                new_back_edge = new Edge(new_start, new_end);
                edge_map.put(back_edge, new_back_edge);
                edges.add(new_back_edge);
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < back_faces.size()) {
            Face back_face = (Face)back_faces.get(i2);
            Edge edge0 = (Edge)edge_map.get(back_face.edges[0]);
            Edge edge1 = (Edge)edge_map.get(back_face.edges[1]);
            Edge edge2 = (Edge)edge_map.get(back_face.edges[2]);
            faces.add(new Face(edge0, edge1, edge2));
            ++i2;
        }
        boundary_vertices = new ArrayList();
        i2 = 0;
        while (i2 < n_boundary) {
            boundary_vertices.add((Vertex)vertices.get(i2));
            ++i2;
        }
        Polyhedron polyhedron = new Polyhedron(vertices, edges, faces);
        polyhedron.set_parameters();
        return polyhedron;
    }

    public static Polyhedron generate_single_disk(List points) {
        Vertex v;
        int n_boundary = points.size();
        List mesh2D = GridMesh.create_mesh((ArrayList)points, 0.1);
        List vertices2D = (List)mesh2D.get(0);
        List edges2D = (List)mesh2D.get(1);
        List faces2D = (List)mesh2D.get(2);
        List[] front = Inflation.create_one_side(vertices2D, edges2D, faces2D, 1);
        List front_vertices = front[0];
        List front_edges = front[1];
        List front_faces = front[2];
        List[] back = Inflation.create_one_side(vertices2D, edges2D, faces2D, -1);
        List back_vertices = back[0];
        List back_edges = back[1];
        List back_faces = back[2];
        Hashtable<Vertex, Vertex> vertex_map = new Hashtable<Vertex, Vertex>();
        Hashtable<Edge, Edge> edge_map = new Hashtable<Edge, Edge>();
        int i = 0;
        while (i < n_boundary) {
            Vertex back_vertex = (Vertex)back_vertices.get(i);
            Vertex front_vertex = (Vertex)front_vertices.get(i);
            vertex_map.put(back_vertex, front_vertex);
            Edge back_edge = back_vertex.get_common_edge((Vertex)back_vertices.get(Util.mod(i + 1, n_boundary)));
            Edge front_edge = front_vertex.get_common_edge((Vertex)front_vertices.get(Util.mod(i + 1, n_boundary)));
            try {
                edge_map.put(back_edge, front_edge);
            }
            catch (Exception e) {
                System.err.println("not generate single disk in Inflation.java");
            }
            ++i;
        }
        List vertices = front_vertices;
        List edges = front_edges;
        List faces = front_faces;
        int i2 = 0;
        while (i2 < back_vertices.size()) {
            v = (Vertex)back_vertices.get(i2);
            Vertex new_v = (Vertex)vertex_map.get(v);
            if (new_v == null) {
                new_v = new Vertex(v);
                vertex_map.put(v, new_v);
                vertices.add(new_v);
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < back_edges.size()) {
            Edge back_edge = (Edge)back_edges.get(i2);
            Edge new_back_edge = (Edge)edge_map.get(back_edge);
            if (new_back_edge == null) {
                Vertex new_start = (Vertex)vertex_map.get(back_edge.start);
                Vertex new_end = (Vertex)vertex_map.get(back_edge.end);
                new_back_edge = new Edge(new_start, new_end);
                edge_map.put(back_edge, new_back_edge);
                edges.add(new_back_edge);
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < back_faces.size()) {
            Face back_face = (Face)back_faces.get(i2);
            Edge edge0 = (Edge)edge_map.get(back_face.edges[0]);
            Edge edge1 = (Edge)edge_map.get(back_face.edges[1]);
            Edge edge2 = (Edge)edge_map.get(back_face.edges[2]);
            faces.add(new Face(edge0, edge1, edge2));
            ++i2;
        }
        i2 = 0;
        while (i2 < n_boundary) {
            ((Vertex)vertices.get((int)i2)).fixed = true;
            ++i2;
        }
        i2 = 0;
        while (i2 < faces.size()) {
            ((Face)faces.get(i2)).set_normal();
            ++i2;
        }
        i2 = 0;
        while (i2 < vertices.size()) {
            v = (Vertex)vertices.get(i2);
            v.set_normal();
            ++i2;
        }
        boundary_vertices = new ArrayList();
        i2 = 0;
        while (i2 < n_boundary) {
            boundary_vertices.add((Vertex)vertices.get(i2));
            ++i2;
        }
        Polyhedron polyhedron = new Polyhedron(vertices, edges, faces);
        polyhedron.set_parameters();
        return polyhedron;
    }

    public static Polyhedron generate_double_disk(List points) {
        Vertex v;
        int n_boundary = points.size();
        List mesh2D = GridMesh.create_mesh((ArrayList)points, 0.1);
        List vertices2D = (List)mesh2D.get(0);
        List edges2D = (List)mesh2D.get(1);
        List faces2D = (List)mesh2D.get(2);
        List[] front = Inflation.create_one_side(vertices2D, edges2D, faces2D, 1);
        List front_vertices = front[0];
        List front_edges = front[1];
        List front_faces = front[2];
        List[] back = Inflation.create_one_side(vertices2D, edges2D, faces2D, -1);
        List back_vertices = back[0];
        List back_edges = back[1];
        List back_faces = back[2];
        List vertices = Util.append(front_vertices, back_vertices);
        List edges = Util.append(front_edges, back_edges);
        List faces = Util.append(front_faces, back_faces);
        int i = 0;
        while (i < front_vertices.size()) {
            v = (Vertex)front_vertices.get(i);
            v.translate_self(new Vector3(0.0, 0.0, 0.1));
            ++i;
        }
        i = 0;
        while (i < back_vertices.size()) {
            v = (Vertex)back_vertices.get(i);
            v.translate_self(new Vector3(0.0, 0.0, -0.1));
            ++i;
        }
        i = 0;
        while (i < n_boundary) {
            ((Vertex)front_vertices.get((int)i)).fixed = true;
            ((Vertex)back_vertices.get((int)i)).fixed = true;
            ++i;
        }
        Edge[] side_edges = new Edge[n_boundary];
        Edge[] cross_edges = new Edge[n_boundary];
        int i2 = 0;
        while (i2 < n_boundary) {
            Vertex front_v = (Vertex)front_vertices.get(i2);
            Vertex back_v = (Vertex)back_vertices.get(i2);
            Vertex next_back_v = (Vertex)back_vertices.get(Util.mod(i2 + 1, n_boundary));
            Edge side_edge = new Edge(front_v, back_v);
            Edge cross_edge = new Edge(front_v, next_back_v);
            Edge back_edge = (Edge)back_edges.get(i2);
            side_edges[i2] = side_edge;
            cross_edges[i2] = cross_edge;
            edges.add(side_edge);
            edges.add(cross_edge);
            ++i2;
        }
        Vector side_faces = new Vector();
        int i3 = 0;
        while (i3 < n_boundary) {
            Edge side_edge = side_edges[i3];
            Edge cross_edge = cross_edges[i3];
            Edge next_side_edge = side_edges[Util.mod(i3 + 1, n_boundary)];
            Vertex back_v0 = (Vertex)back_vertices.get(i3);
            Vertex back_v1 = (Vertex)back_vertices.get(Util.mod(i3 + 1, n_boundary));
            Edge back_edge = back_v0.get_common_edge(back_v1);
            Vertex front_v0 = (Vertex)front_vertices.get(i3);
            Vertex front_v1 = (Vertex)front_vertices.get(Util.mod(i3 + 1, n_boundary));
            Edge front_edge = front_v0.get_common_edge(front_v1);
            Face face0 = new Face(side_edge, cross_edge, back_edge);
            Face face1 = new Face(cross_edge, front_edge, next_side_edge);
            faces.add(face0);
            faces.add(face1);
            ++i3;
        }
        Polyhedron polyhedron = new Polyhedron(vertices, edges, faces);
        polyhedron.set_parameters();
        return polyhedron;
    }

    static List[] create_one_side(List vertices2D, List edges2D, List faces2D, int sign) {
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        ArrayList<Edge> edges = new ArrayList<Edge>();
        ArrayList<Face> faces = new ArrayList<Face>();
        int i = 0;
        while (i < vertices2D.size()) {
            double[] v = (double[])vertices2D.get(i);
            Vertex vertex = new Vertex(v[0], v[1], 0.0);
            vertices.add(vertex);
            ++i;
        }
        i = 0;
        while (i < edges2D.size()) {
            int[] e = (int[])edges2D.get(i);
            Vertex start = (Vertex)vertices.get(e[0]);
            Vertex end = (Vertex)vertices.get(e[1]);
            Edge edge = new Edge(start, end);
            edges.add(edge);
            ++i;
        }
        i = 0;
        while (i < faces2D.size()) {
            int[] f = (int[])faces2D.get(i);
            Vertex v0 = (Vertex)vertices.get(f[0]);
            Vertex v1 = (Vertex)vertices.get(f[1]);
            Vertex v2 = (Vertex)vertices.get(f[2]);
            Edge edge0 = v0.get_common_edge(v1);
            Edge edge1 = v1.get_common_edge(v2);
            Edge edge2 = v2.get_common_edge(v0);
            Face face = sign > 0 ? new Face(edge0, edge1, edge2) : new Face(edge2, edge1, edge0);
            faces.add(face);
            ++i;
        }
        List[] result = new List[]{vertices, edges, faces};
        return result;
    }

    public static List counter_clockwise(List points) {
        double total_area = 0.0;
        Vertex2D prev = (Vertex2D)points.get(points.size() - 1);
        int i = 0;
        while (i < points.size()) {
            Vertex2D next = (Vertex2D)points.get(i);
            total_area += (prev.y + next.y) * (next.x - prev.x);
            prev = next;
            ++i;
        }
        if (total_area < 0.0) {
            return Util.reverse(points);
        }
        return points;
    }
}

