/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.util.List;
import sweater.Model;
import teddy.Edge;
import teddy.Edge2D;
import teddy.Face;
import teddy.Polyhedron;
import teddy.Vector3;
import teddy.Vertex;
import teddy.Vertex2D;

public class Inflate {
    public static boolean pressure = true;

    public static void init(Polyhedron cloth) {
        int i = 0;
        while (i < cloth.edges.size()) {
            Edge edge = (Edge)cloth.edges.get(i);
            edge.target_length = edge.length();
            ++i;
        }
        i = 0;
        while (i < cloth.faces.size()) {
            Face face = cloth.faces(i);
            face.original_area = face.get_area();
            ++i;
        }
    }

    public static void set_target_length(Polyhedron h) {
        int i = 0;
        while (i < h.edges.size()) {
            Edge edge = (Edge)h.edges.get(i);
            edge.target_length = edge.length();
            ++i;
        }
        i = 0;
        while (i < h.faces.size()) {
            Face face = h.faces(i);
            face.original_area = face.get_area();
            ++i;
        }
    }

    public static void update_target_length(Model model) {
        Polyhedron h = model.getPolyhedron();
        Inflate.update_target_length(h);
        Inflate.update_uv(model.patches);
    }

    private static void update_target_length(Polyhedron h) {
        if (h == null) {
            System.err.println("update_original_length: polyhedron == null");
        }
        int i = 0;
        while (i < h.edges.size()) {
            Edge edge = (Edge)h.edges.get(i);
            Edge2D edge2D = edge.common_edge2D;
            if (edge2D != null) {
                edge.target_length = edge2D.length_from_pattern_to_3D();
            }
            ++i;
        }
        i = 0;
        while (i < h.faces.size()) {
            Face face = h.faces(i);
            if (face.original_area == 0.0) {
                face.original_area = face.get_area();
            }
            ++i;
        }
        i = 0;
        while (i < h.child_polyhedrons.size()) {
            Inflate.update_target_length((Polyhedron)h.child_polyhedrons.get(i));
            ++i;
        }
    }

    public static void update_target_length(Model model, int base_shape) {
        if (model == null) {
            System.err.println("update_target_length: model is null");
        }
        Polyhedron h = model.getPolyhedron();
        int i = 0;
        while (i < h.edges.size()) {
            Edge edge = (Edge)h.edges.get(i);
            Edge2D edge2D = edge.common_edge2D;
            edge.target_length = edge2D.length_from_pattern_to_3D();
            ++i;
        }
        i = 0;
        while (i < h.faces.size()) {
            Face face = h.faces(i);
            if (face.original_area == 0.0) {
                face.original_area = face.get_area();
            }
            ++i;
        }
    }

    static void update_uv(List patches) {
        int i = 0;
        while (i < patches.size()) {
            Polyhedron patch = (Polyhedron)patches.get(i);
            int j = 0;
            while (j < patch.vertices.size()) {
                Vertex v = patch.vertices(j);
                Vertex2D pattern_v = v.getPatternCoord();
                v.setTextureCoord(pattern_v.x / 150.0, pattern_v.y / 150.0);
                ++j;
            }
            ++i;
        }
    }

    public static void inflate(Polyhedron cloth) {
        int j;
        double total_area;
        Vertex v;
        cloth.enforce_connections();
        double[] areas = new double[cloth.faces.size()];
        int i = 0;
        while (i < cloth.faces.size()) {
            Face face = (Face)cloth.faces.get(i);
            areas[i] = face.area();
            ++i;
        }
        Vector3[] target_vertices = new Vector3[cloth.vertices.size()];
        int i2 = 0;
        while (i2 < cloth.vertices.size()) {
            v = (Vertex)cloth.vertices.get(i2);
            Vector3 vec = new Vector3();
            List faces = v.get_faces();
            total_area = 0.0;
            j = 0;
            while (j < faces.size()) {
                Face face = (Face)faces.get(j);
                vec.add(Vector3.multiply(face.normal, areas[face.index]));
                total_area += areas[face.index];
                ++j;
            }
            vec.multiply(1.0 / total_area * 0.002);
            target_vertices[i2] = vec;
            ++i2;
        }
        i2 = 0;
        while (i2 < cloth.vertices.size()) {
            v = (Vertex)cloth.vertices.get(i2);
            v.set_position(Vertex.translate(v, Vector3.multiply(v.normal, 0.01)));
            ++i2;
        }
        cloth.enforce_connections();
        int k = 0;
        while (k < 10) {
            Vertex v2;
            target_vertices = new Vector3[cloth.vertices.size()];
            int i3 = 0;
            while (i3 < cloth.vertices.size()) {
                v2 = (Vertex)cloth.vertices.get(i3);
                Vector3 vec = new Vector3();
                total_area = 0.0;
                j = 0;
                while (j < v2.edges.size()) {
                    Vertex ideal_v;
                    Edge edge = (Edge)v2.edges.get(j);
                    Vertex u = edge.get_opposite_vertex(v2);
                    Vector3 uv = new Vector3(u, v2);
                    if (uv.length() < edge.target_length) {
                        ideal_v = v2;
                    } else {
                        Vector3 uv2 = Vector3.multiply(Vector3.normalize(uv), edge.target_length);
                        ideal_v = Vertex.translate(u, uv2);
                    }
                    Vector3 dvec = new Vector3(v2, ideal_v);
                    if (edge.left_face != null && edge.right_face != null) {
                        double area = areas[edge.left_face.index] + areas[edge.right_face.index];
                        dvec.multiply(area);
                        total_area += area;
                        vec.add(dvec);
                    }
                    ++j;
                }
                vec.multiply(1.0 / total_area);
                target_vertices[i3] = vec;
                ++i3;
            }
            i3 = 0;
            while (i3 < cloth.vertices.size()) {
                v2 = (Vertex)cloth.vertices.get(i3);
                v2.set_position(Vertex.translate(v2, target_vertices[i3]));
                ++i3;
            }
            cloth.enforce_connections();
            ++k;
        }
        cloth.set_parameters();
        i2 = 0;
        while (i2 < cloth.child_polyhedrons.size()) {
            Inflate.inflate((Polyhedron)cloth.child_polyhedrons.get(i2));
            ++i2;
        }
    }
}

