/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.util.ArrayList;
import java.util.List;
import triangle.Triangle;

public class GridMesh {
    public static List create_mesh(ArrayList boundary_points, double unit_length) {
        ArrayList<Object> inner_points = GridMesh.generate_grid_vertices_in_bbox(boundary_points, unit_length);
        inner_points = GridMesh.remove_nearby_points(inner_points, boundary_points, unit_length / 2.0);
        ArrayList[] result = null;
        try {
            result = Triangle.triangulate_polygon_with_inner_vertices((ArrayList)boundary_points, (ArrayList)inner_points);
        }
        catch (Exception e) {
            System.err.println("can not trianglate");
            return null;
        }
        ArrayList vertices = result[0];
        ArrayList vertex_faces = result[1];
        ArrayList edges = new ArrayList();
        int i = 0;
        while (i < vertex_faces.size()) {
            int[] vertex_face = (int[])vertex_faces.get(i);
            int v0 = vertex_face[0];
            int v1 = vertex_face[1];
            int v2 = vertex_face[2];
            int e0 = GridMesh.find_edge(v0, v1, edges);
            int e1 = GridMesh.find_edge(v1, v2, edges);
            int n = GridMesh.find_edge(v2, v0, edges);
            ++i;
        }
        int n_boundary_points = boundary_points.size();
        inner_points = new ArrayList<Object>();
        int i2 = n_boundary_points;
        while (i2 < vertices.size()) {
            inner_points.add(vertices.get(i2));
            ++i2;
        }
        i2 = 0;
        while (i2 < edges.size()) {
            int[] edge = (int[])edges.get(i2);
            if (edge[0] < n_boundary_points && edge[1] < n_boundary_points && Math.abs(edge[1] - edge[0]) != 1 && Math.abs(edge[1] - edge[0]) != n_boundary_points - 1) {
                double[] v0 = (double[])vertices.get(edge[0]);
                double[] v1 = (double[])vertices.get(edge[1]);
                double[] mid_vertex = new double[]{(v0[0] + v1[0]) / 2.0, (v0[1] + v1[1]) / 2.0};
                inner_points.add(mid_vertex);
            }
            ++i2;
        }
        try {
            result = Triangle.triangulate_polygon_with_inner_vertices((ArrayList)boundary_points, inner_points);
        }
        catch (Exception e) {
            System.err.println("can not trianglate");
            return null;
        }
        vertices = result[0];
        vertex_faces = result[1];
        edges = new ArrayList();
        i2 = 0;
        while (i2 < vertex_faces.size()) {
            int[] vertex_face = (int[])vertex_faces.get(i2);
            int v0 = vertex_face[0];
            int v1 = vertex_face[1];
            int v2 = vertex_face[2];
            int e0 = GridMesh.find_edge(v0, v1, edges);
            int e1 = GridMesh.find_edge(v1, v2, edges);
            int n = GridMesh.find_edge(v2, v0, edges);
            ++i2;
        }
        ArrayList<ArrayList> result2 = new ArrayList<ArrayList>();
        result2.add(vertices);
        result2.add(edges);
        result2.add(vertex_faces);
        return result2;
    }

    static int find_edge(int v0, int v1, List edges) {
        int i = 0;
        while (i < edges.size()) {
            int[] edge = (int[])edges.get(i);
            if (edge[0] == v0 && edge[1] == v1 || edge[0] == v1 && edge[1] == v0) {
                return i;
            }
            ++i;
        }
        int[] edge = new int[]{v0, v1};
        edges.add(edge);
        return edges.size() - 1;
    }

    static ArrayList generate_grid_vertices_in_bbox(ArrayList converted_points, double grid_size) {
        double min_x = Double.MAX_VALUE;
        double min_y = Double.MAX_VALUE;
        double max_x = -1.7976931348623157E308;
        double max_y = -1.7976931348623157E308;
        int i = 0;
        while (i < converted_points.size()) {
            double[] p = (double[])converted_points.get(i);
            if (p[0] < min_x) {
                min_x = p[0];
            }
            if (p[1] < min_y) {
                min_y = p[1];
            }
            if (p[0] > max_x) {
                max_x = p[0];
            }
            if (p[1] > max_y) {
                max_y = p[1];
            }
            ++i;
        }
        System.out.println("min_x" + min_x + "min_y" + min_y + "max_x" + max_x + "max_y" + max_y);
        double lx = grid_size;
        double ly = lx * 1.7320508 / 2.0;
        ArrayList<double[]> grid_points = new ArrayList<double[]>();
        int sign = 1;
        System.out.println("max_y-min_y=" + (max_y - min_y) / ly);
        System.out.println("max_x-min_x=" + (max_x - min_x) / lx);
        int y = 0;
        while ((double)y < (max_y - min_y) / ly) {
            int x = 0;
            while ((double)x < (max_x - min_x) / lx) {
                double[] p = new double[]{min_x + (double)x * lx + lx / 4.0 * (double)sign, min_y + (double)y * ly};
                grid_points.add(p);
                ++x;
            }
            sign *= -1;
            ++y;
        }
        return grid_points;
    }

    static ArrayList remove_nearby_points(ArrayList inner_points, ArrayList converted_points, double threshold) {
        ArrayList<double[]> remaining_points = new ArrayList<double[]>();
        int i = 0;
        while (i < inner_points.size()) {
            double[] p = (double[])inner_points.get(i);
            if (GridMesh.far_enough(p, converted_points, threshold)) {
                remaining_points.add(p);
            }
            ++i;
        }
        return remaining_points;
    }

    static boolean far_enough(double[] p, ArrayList converted_points, double threshold) {
        double threshold_squared = threshold * threshold;
        int i = 0;
        while (i < converted_points.size()) {
            double[] q = (double[])converted_points.get(i);
            if ((p[0] - q[0]) * (p[0] - q[0]) + (p[1] - q[1]) * (p[1] - q[1]) < threshold_squared) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

