/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.util.ArrayList;
import teddy.Edge2D;
import teddy.Face;
import teddy.LinkedList;
import teddy.Polyhedron;
import teddy.Util;
import teddy.Vector2;
import teddy.Vector3;
import teddy.Vertex2D;

public class Face2D {
    public int index;
    public Polyhedron patch;
    public Face2D parent_face;
    public Edge2D[] edges;
    public Vector3 normal;
    public int n_edges;
    public LinkedList surface_lines;
    boolean front_facing;
    Face duplicated_child;
    double radius;
    public boolean disposed;
    public transient Face2D child;
    public double weight = 1.0;
    public double target_edge_length;
    public double area;
    public double original_area;

    Face2D() {
    }

    public Face2D(Edge2D edge0, Edge2D edge1, Edge2D edge2) {
        this.edges = new Edge2D[3];
        this.add_edge(0, edge0, edge1);
        this.add_edge(1, edge1, edge2);
        this.add_edge(2, edge2, edge0);
    }

    Face2D(ArrayList _edges) {
        this.edges = new Edge2D[_edges.size()];
        int i = 0;
        while (i < _edges.size()) {
            this.add_edge(i, (Edge2D)_edges.get(i), (Edge2D)_edges.get(Util.mod(i + 1, _edges.size())));
            ++i;
        }
    }

    Face2D(LinkedList _edges) {
        this.edges = new Edge2D[_edges.size()];
        int i = 0;
        while (i < _edges.size()) {
            this.add_edge(i, (Edge2D)_edges.nextElement(), (Edge2D)_edges.nextElement());
            ++i;
        }
    }

    public Face2D(Edge2D edge0, Edge2D edge1, Edge2D edge2, Polyhedron _patch) {
        this.edges = new Edge2D[3];
        this.add_edge(0, edge0, edge1);
        this.add_edge(1, edge1, edge2);
        this.add_edge(2, edge2, edge0);
        this.patch = _patch;
    }

    public Face2D copy() {
        Face2D face = new Face2D();
        face.edges = (Edge2D[])this.edges.clone();
        face.n_edges = this.n_edges;
        face.surface_lines = new LinkedList();
        face.normal = this.normal;
        face.front_facing = this.front_facing;
        face.index = this.index;
        face.patch = this.patch;
        face.target_edge_length = this.target_edge_length;
        this.child = face;
        return face;
    }

    public void renew_network() {
        int i = 0;
        while (i < this.n_edges) {
            this.edges[i] = this.edges[i].child;
            if (this.edges[i] == null) {
                System.out.println("null in Face.renew_network");
            }
            ++i;
        }
    }

    public double area() {
        Vector2 vec0 = this.edges[0].vector2();
        Vector2 vec1 = this.edges[1].vector2();
        return Vector2.cross_product(vec0, vec1) / 2.0;
    }

    public void set_area() {
        this.area = this.area();
    }

    private void add_edge(int i, Edge2D e, Edge2D next_edge) {
        this.edges[i] = e;
        if (next_edge.contains(e.end)) {
            e.left_face = this;
        } else {
            e.right_face = this;
        }
    }

    public Vertex2D get_vertex(int i) {
        return this.edges(i - 1).get_common_vertex(this.edges(i));
    }

    public Edge2D edges(int i) {
        return this.edges[Util.mod(i, this.edges.length)];
    }

    public Edge2D get_opposite_edge(Vertex2D v) {
        int i = 0;
        while (i < 3) {
            if (!this.edges[i].contains(v)) {
                return this.edges[i];
            }
            ++i;
        }
        return null;
    }

    public Vertex2D get_opposite_vertex(Edge2D edge) {
        int i = 0;
        while (i < 3) {
            Vertex2D v = this.get_vertex(i);
            if (!edge.contains(v)) {
                return v;
            }
            ++i;
        }
        return null;
    }

    public int get_edge_index(Edge2D e) {
        int i = 0;
        while (i < this.edges.length) {
            if (this.edges[i] == e) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Vertex2D get_center() {
        Vertex2D center = new Vertex2D();
        int i = 0;
        while (i < 3) {
            Vertex2D vertex = this.get_vertex(i);
            center.add(vertex);
            ++i;
        }
        center.multiply(0.3333333333333333);
        return center;
    }

    public void replace_edge(Edge2D old_edge, Edge2D new_edge) {
        int i = 0;
        while (i < 3) {
            if (this.edges[i] == old_edge) {
                this.edges[i] = new_edge;
            }
            ++i;
        }
    }

    public Edge2D get_next_edge(Edge2D edge) {
        int i = 0;
        while (i < 3) {
            if (this.edges[i] == edge) {
                return this.edges(i + 1);
            }
            ++i;
        }
        return null;
    }

    public Edge2D get_prev_edge(Edge2D edge) {
        int i = 0;
        while (i < 3) {
            if (this.edges[i] == edge) {
                return this.edges(i - 1);
            }
            ++i;
        }
        return null;
    }

    public boolean reversed(Edge2D edge) {
        return this.get_next_edge(edge).get_common_vertex(edge) == edge.start;
    }

    public double get_area() {
        Vertex2D v0 = this.get_vertex(0);
        Vertex2D v1 = this.get_vertex(1);
        Vertex2D v2 = this.get_vertex(2);
        Vector2 vec0 = new Vector2(v0, v1);
        Vector2 vec1 = new Vector2(v0, v2);
        return Vector2.cross_product(vec0, vec1) / 2.0;
    }

    public boolean contains(Vertex2D vertex) {
        int i = 0;
        while (i < this.edges.length) {
            if (this.edges[i].contains(vertex)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean contains(Edge2D edge) {
        int i = 0;
        while (i < this.edges.length) {
            if (this.edges[i] == edge) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

