/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.util.List;
import teddy.Edge;
import teddy.LinkedList;
import teddy.Polyhedron;
import teddy.Util;
import teddy.Vector3;
import teddy.Vertex;

public class Face {
    public int index;
    public Polyhedron patch;
    public Face parent_face;
    public Edge[] edges;
    public Vector3 normal;
    public int n_edges = 3;
    public LinkedList surface_lines;
    boolean front_facing;
    Face duplicated_child;
    double radius;
    public boolean disposed;
    public transient Face child;
    public double target_edge_length;
    public double area;
    double cloth_length_vec0;
    double cloth_length_vec1;
    double cloth_length_vec2;
    double cloth_average_edge_length;
    double angle0_to_1_cos;
    double angle0_to_1_sin;
    double angle0_to_2_cos;
    double angle0_to_2_sin;
    double cloth_vertex0_angle;
    double cloth_vertex1_angle;
    double cloth_vertex2_angle;
    public double original_area;

    Face() {
    }

    public Face(Edge edge0, Edge edge1, Edge edge2) {
        this.edges = new Edge[3];
        this.add_edge(0, edge0, edge1);
        this.add_edge(1, edge1, edge2);
        this.add_edge(2, edge2, edge0);
        this.set_normal();
    }

    Face(List _edges) {
        this.edges = new Edge[_edges.size()];
        int i = 0;
        while (i < _edges.size()) {
            this.add_edge(i, (Edge)_edges.get(i), (Edge)_edges.get(Util.mod(i + 1, _edges.size())));
            ++i;
        }
        this.set_normal();
    }

    Face(LinkedList _edges) {
        this.edges = new Edge[_edges.size()];
        int i = 0;
        while (i < _edges.size()) {
            this.add_edge(i, (Edge)_edges.nextElement(), (Edge)_edges.nextElement());
            ++i;
        }
        this.set_normal();
    }

    public Face(Edge edge0, Edge edge1, Edge edge2, Polyhedron _patch) {
        this.edges = new Edge[3];
        this.add_edge(0, edge0, edge1);
        this.add_edge(1, edge1, edge2);
        this.add_edge(2, edge2, edge0);
        this.patch = _patch;
        this.set_normal();
    }

    public Face copy() {
        Face face = new Face();
        face.edges = (Edge[])this.edges.clone();
        face.n_edges = this.n_edges;
        face.surface_lines = new LinkedList();
        face.normal = this.normal;
        face.front_facing = this.front_facing;
        face.index = this.index;
        face.patch = this.patch;
        face.area = this.area;
        face.disposed = this.disposed;
        face.target_edge_length = this.target_edge_length;
        face.parent_face = this.parent_face;
        this.child = face;
        return face;
    }

    public void renew_network() {
        int i = 0;
        while (i < this.n_edges) {
            this.edges[i] = this.edges[i].child;
            if (this.edges[i] == null) {
                System.out.println("null in Face.renew_network");
            }
            ++i;
        }
    }

    public void set_normal() {
        Vertex v0 = this.get_vertex(0);
        Vertex v1 = this.get_vertex(1);
        Vertex v2 = this.get_vertex(2);
        if (v0 == null || v1 == null || v2 == null) {
            System.err.println("don't set normal in Face.java");
            return;
        }
        Vector3 vec0 = new Vector3(v0, v1);
        Vector3 vec1 = new Vector3(v0, v2);
        this.normal = Vector3.cross_product(vec0, vec1);
        this.normal.normalize();
        this.radius = this.edges[0].length() * 4.0;
    }

    public double area() {
        Vector3 vec0 = this.edges[0].vector3();
        Vector3 vec1 = this.edges[1].vector3();
        return Vector3.cross_product(vec0, vec1).length() / 2.0;
    }

    public void set_area() {
        this.area = this.area();
    }

    private void add_edge(int i, Edge e, Edge next_edge) {
        this.edges[i] = e;
        if (next_edge.contains(e.end)) {
            e.left_face = this;
        } else {
            e.right_face = this;
        }
    }

    public Vertex get_vertex(int i) {
        return this.edges(i - 1).get_common_vertex(this.edges(i));
    }

    public Edge edges(int i) {
        return this.edges[Util.mod(i, this.edges.length)];
    }

    public Edge get_opposite_edge(Vertex v) {
        int i = 0;
        while (i < 3) {
            if (!this.edges[i].contains(v)) {
                return this.edges[i];
            }
            ++i;
        }
        return null;
    }

    public Vertex get_opposite_vertex(Edge edge) {
        int i = 0;
        while (i < 3) {
            Vertex v = this.get_vertex(i);
            if (!edge.contains(v)) {
                return v;
            }
            ++i;
        }
        return null;
    }

    public int get_edge_index(Edge e) {
        int i = 0;
        while (i < this.edges.length) {
            if (this.edges[i] == e) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Vertex get_center() {
        Vertex center = new Vertex();
        double u = 0.0;
        double v = 0.0;
        int i = 0;
        while (i < 3) {
            Vertex vertex = this.get_vertex(i);
            center.add(vertex);
            u += vertex.u;
            v += vertex.v;
            ++i;
        }
        center.multiply(0.3333333333333333);
        center.u = u / 3.0;
        center.v = v / 3.0;
        return center;
    }

    public void replace_edge(Edge old_edge, Edge new_edge) {
        int i = 0;
        while (i < 3) {
            if (this.edges[i] == old_edge) {
                this.edges[i] = new_edge;
            }
            ++i;
        }
    }

    public Edge get_next_edge(Edge edge) {
        int i = 0;
        while (i < 3) {
            if (this.edges[i] == edge) {
                return this.edges(Util.mod(i + 1, 3));
            }
            ++i;
        }
        return null;
    }

    public Edge get_prev_edge(Edge edge) {
        int i = 0;
        while (i < 3) {
            if (this.edges[i] == edge) {
                return this.edges(Util.mod(i - 1, 3));
            }
            ++i;
        }
        System.out.println("get_prev_edge null");
        return null;
    }

    public boolean reversed(Edge edge) {
        return this.get_next_edge(edge).get_common_vertex(edge) == edge.start;
    }

    Vector3 cloth_rotate_vec1_to_vec0(Vector3 vec1, Vector3 normal) {
        return Vector3.rotate(vec1, normal, this.angle0_to_1_cos, -this.angle0_to_1_sin);
    }

    Vector3 cloth_rotate_vec2_to_vec0(Vector3 vec2, Vector3 normal) {
        return Vector3.rotate(vec2, normal, this.angle0_to_2_cos, -this.angle0_to_2_sin);
    }

    Vector3 cloth_rotate_vec0_to_vec1(Vector3 vec0, Vector3 normal) {
        return Vector3.rotate(vec0, normal, this.angle0_to_1_cos, this.angle0_to_1_sin);
    }

    Vector3 cloth_rotate_vec0_to_vec2(Vector3 vec0, Vector3 normal) {
        return Vector3.rotate(vec0, normal, this.angle0_to_2_cos, this.angle0_to_2_sin);
    }

    public double get_area() {
        Vertex v0 = this.get_vertex(0);
        Vertex v1 = this.get_vertex(1);
        Vertex v2 = this.get_vertex(2);
        Vector3 vec0 = new Vector3(v0, v1);
        Vector3 vec1 = new Vector3(v0, v2);
        return Vector3.cross_product(vec0, vec1).length() / 2.0;
    }

    public double distance(Vertex v) {
        Vector3 vector = new Vector3(this.get_vertex(0), v);
        return Math.abs(Vector3.dot_product(this.normal, vector));
    }

    public boolean contains(Vertex vertex) {
        int i = 0;
        while (i < this.edges.length) {
            if (this.edges[i].contains(vertex)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean on_polygon(Vertex v) {
        this.set_normal();
        double total_angle = 0.0;
        Vertex base = v;
        Vector3 prev_vector = new Vector3(base, this.get_vertex(0));
        int i = 1;
        while (i < this.edges.length + 1) {
            Vector3 next_vector = new Vector3(base, this.get_vertex(i));
            double angle = prev_vector.get_relative_angle(next_vector);
            if (this.normal.dot_product(prev_vector.cross_product(next_vector)) < 0.0) {
                angle *= -1.0;
            }
            total_angle += angle;
            prev_vector = next_vector;
            ++i;
        }
        return total_angle > Math.PI;
    }

    public boolean contains(Edge edge) {
        int i = 0;
        while (i < this.edges.length) {
            if (this.edges[i] == edge) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean inSide(Vertex v) {
        Vector3 vec = Vector3.subtract(v, this.get_center());
        double angle = vec.get_relative_angle(this.normal);
        return !(angle < 1.5707963267948966);
    }

    public void move(Vector3 vec) {
        int i = 0;
        while (i < this.edges.length) {
            Edge edge = this.edges[i];
            edge.move(vec);
            ++i;
        }
    }
}

