/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.awt.Point;
import java.util.ArrayList;
import pattern.Seam;
import teddy.Edge;
import teddy.Face2D;
import teddy.Line2D;
import teddy.Vector2;
import teddy.Vector3;
import teddy.Vertex2D;

public class Edge2D {
    public Vertex2D start;
    public Vertex2D end;
    public Face2D left_face;
    public Face2D right_face;
    public Edge common_edge;
    public boolean seam;
    double original_length;
    int split_level = 0;
    double parent_original_length;
    boolean disposed = false;
    public int index;
    Edge2D child;
    public boolean concave;
    public boolean delaunay_edge = false;
    public boolean check = false;
    public Edge parent_edge = null;
    public ArrayList child_edges = new ArrayList();
    public Seam include_seam = null;
    public boolean sharp = false;

    Edge2D() {
        this.start = new Vertex2D();
        this.end = new Vertex2D();
        this.left_face = null;
        this.right_face = null;
    }

    public Edge2D(Vertex2D _start, Vertex2D _end) {
        this.start = _start;
        this.end = _end;
        this.left_face = null;
        this.right_face = null;
        this.start.edges.add(this);
        this.end.edges.add(this);
    }

    public Edge2D(Vertex2D _start, Vertex2D _end, Face2D _left_face, Face2D _right_face) {
        this.start = _start;
        this.end = _end;
        this.left_face = _left_face;
        this.right_face = _right_face;
        this.start.edges.add(this);
        this.end.edges.add(this);
    }

    Edge2D(Point _start, Point _end) {
        this.start = new Vertex2D(_start);
        this.end = new Vertex2D(_end);
        this.left_face = null;
        this.right_face = null;
    }

    public Vertex2D get_the_other_vertex(Vertex2D v) {
        if (v == this.start) {
            return this.end;
        }
        return this.start;
    }

    public boolean cross(Edge2D e) {
        return Edge2D.cross(this.start.x, this.start.y, this.end.x, this.end.y, e.start.x, e.start.y, e.end.x, e.end.y);
    }

    public static boolean cross(double x1, double y1, double x2, double y2, double xx1, double yy1, double xx2, double yy2) {
        double a0 = y1 - y2;
        double b0 = x2 - x1;
        double c0 = y2 * x1 - x2 * y1;
        double a1 = yy1 - yy2;
        double b1 = xx2 - xx1;
        double c1 = yy2 * xx1 - xx2 * yy1;
        return (a0 * xx1 + b0 * yy1 + c0) * (a0 * xx2 + b0 * yy2 + c0) <= 0.0 && (a1 * x1 + b1 * y1 + c1) * (a1 * x2 + b1 * y2 + c1) <= 0.0;
    }

    public static Vertex2D cross_point(double x1, double y1, double x2, double y2, double xx1, double yy1, double xx2, double yy2) {
        double a0 = y1 - y2;
        double b0 = x2 - x1;
        double c0 = y2 * x1 - x2 * y1;
        double a1 = yy1 - yy2;
        double b1 = xx2 - xx1;
        double c1 = yy2 * xx1 - xx2 * yy1;
        if (Math.abs(a0 * b1 - a1 * b0) < 1.0E-5) {
            return null;
        }
        double x = (b0 * c1 - b1 * c0) / (a0 * b1 - a1 * b0);
        double y = (a0 * c1 - a1 * c0) / (a1 * b0 - a0 * b1);
        return new Vertex2D(x, y);
    }

    public boolean right_side_of_edge(double x1, double y1, double x2, double y2, double x, double y) {
        double a0 = y1 - y2;
        double b0 = x2 - x1;
        double c0 = y2 * x1 - x2 * y1;
        return a0 * x + b0 * y + c0 < 0.0;
    }

    public boolean equals(Vertex2D v0, Vertex2D v1) {
        return v0 == this.start && v1 == this.end || v1 == this.start && v0 == this.end;
    }

    public boolean contains(Vertex2D v) {
        return v == this.start || v == this.end;
    }

    public Vector2 vector2() {
        return new Vector2(this.start, this.end);
    }

    public Vertex2D mid_point() {
        return new Vertex2D((this.start.x + this.end.x) / 2.0, (this.start.y + this.end.y) / 2.0);
    }

    public double length() {
        return Vertex2D.distance(this.start, this.end);
    }

    public double length_from_pattern_to_3D() {
        return this.length() / 150.0;
    }

    public Vertex2D get_common_vertex(Edge2D edge) {
        if (this.start == edge.start || this.start == edge.end) {
            return this.start;
        }
        return this.end;
    }

    public double distance(Vertex2D v) {
        double a = this.end.x - this.start.x;
        double b = this.end.y - this.start.y;
        double bunbo = Math.sqrt(a * a + b * b);
        double bunshi = a * (v.y - this.start.y) - b * (v.x - this.start.x);
        if (bunbo == 0.0) {
            System.out.println("Error in Edge2D.distance");
            return 0.0;
        }
        return Math.abs(bunshi / bunbo);
    }

    public double distance_as_a_segment(Vertex2D node) {
        Vector2 vec0 = new Vector2(this.start, this.end);
        Vector2 vec1 = new Vector2(this.start, node);
        if (Vector2.dot_product(vec0, vec1) < 0.0) {
            return Vector2.distance(node, this.start);
        }
        vec1 = new Vector2(this.end, node);
        if (Vector2.dot_product(vec0, vec1) > 0.0) {
            return Vector2.distance(node, this.end);
        }
        return this.distance(node);
    }

    public Face2D get_opposite_face(Face2D face) {
        if (face == this.left_face) {
            return this.right_face;
        }
        if (face == this.right_face) {
            return this.left_face;
        }
        return null;
    }

    public Face2D get_remaining_face() {
        if (this.left_face == null && this.right_face != null) {
            return this.right_face;
        }
        if (this.left_face != null && this.right_face == null) {
            return this.left_face;
        }
        System.out.println("Error in Edge.get_remaining_face()");
        return null;
    }

    public Vertex2D get_opposite_vertex(Vertex2D v) {
        if (this.start == v) {
            return this.end;
        }
        if (this.end == v) {
            return this.start;
        }
        return null;
    }

    public Vector3 get_normal() {
        Vector3 normal = Vector3.add(this.left_face.normal, this.right_face.normal);
        normal.normalize();
        return normal;
    }

    public Vertex2D mid_vertex() {
        return Vertex2D.mid_vertex(this.start, this.end);
    }

    public void remove_face(Face2D p) {
        if (this.left_face == p) {
            this.left_face = null;
        } else if (this.right_face == p) {
            this.right_face = null;
        }
    }

    public Face2D get_common_face(Edge2D edge) {
        if (this.left_face != null && (this.left_face == edge.left_face || this.left_face == edge.right_face)) {
            return this.left_face;
        }
        if (this.right_face != null && (this.right_face == edge.left_face || this.right_face == edge.right_face)) {
            return this.right_face;
        }
        return null;
    }

    public void set_sharp() {
        this.sharp = true;
    }

    public void set_sharp(boolean _sharp) {
        this.sharp = _sharp;
    }

    public boolean on_edge(Vertex2D v) {
        if (v == this.start || v == this.end) {
            return true;
        }
        Vector2 vec0 = new Vector2(v, this.start);
        Vector2 vec1 = new Vector2(v, this.end);
        return Vector2.cos(vec0, vec1) < -0.9;
    }

    public Edge2D copy() {
        Edge2D clone = new Edge2D();
        clone.start = this.start;
        clone.end = this.end;
        clone.left_face = this.left_face;
        clone.right_face = this.right_face;
        clone.seam = this.seam;
        clone.sharp = this.sharp;
        clone.original_length = this.original_length;
        clone.concave = this.concave;
        clone.index = this.index;
        this.child = clone;
        return clone;
    }

    public void renew_network() {
        this.start = this.start.child;
        this.end = this.end.child;
        if (this.left_face != null) {
            this.left_face = this.left_face.child;
        }
        if (this.right_face != null) {
            this.right_face = this.right_face.child;
        }
    }

    public boolean isCross(Edge2D edge) {
        Line2D line0 = new Line2D(this.start, new Vector2(this.start, this.end));
        Line2D line1 = new Line2D(edge.start, new Vector2(edge.start, edge.end));
        Vertex2D cross_point = Line2D.cross_point(line0, line1);
        if (cross_point == null) {
            return false;
        }
        return edge.on_edge(cross_point) && this.on_edge(cross_point);
    }
}

