/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.util.ArrayList;
import pattern.Seam;
import teddy.Edge2D;
import teddy.Face;
import teddy.Vector3;
import teddy.Vertex;

public class Edge {
    public int index;
    public Vertex start;
    public Vertex end;
    public Face left_face;
    public Face right_face;
    public Edge2D common_edge2D;
    public boolean seam;
    double target_length;
    int split_level = 0;
    double parent_target_length;
    public boolean disposed = false;
    Edge duplicated_child;
    public boolean concave;
    public transient Edge child;
    public boolean delaunay_edge = false;
    public Edge parent_edge = null;
    public ArrayList child_edges = new ArrayList();
    public Seam include_seam = null;
    public boolean sharp = false;

    Edge() {
        this.start = new Vertex();
        this.end = new Vertex();
        this.left_face = null;
        this.right_face = null;
    }

    Edge(Vertex _start, Vertex _end, boolean sharp) {
        this(_start, _end);
        this.sharp = sharp;
    }

    public Edge(Vertex start, Vertex end) {
        this.start = start;
        this.end = end;
        start.edges.add(this);
        end.edges.add(this);
    }

    public Vector3 vector3() {
        return new Vector3(this.start, this.end);
    }

    public double length() {
        return this.vector3().length();
    }

    public boolean contains(Vertex v) {
        return v == this.start || v == this.end;
    }

    public Face get_opposite_face(Face face) {
        if (face == this.left_face) {
            return this.right_face;
        }
        if (face == this.right_face) {
            return this.left_face;
        }
        return null;
    }

    public Face get_remaining_face() {
        if (this.left_face == null && this.right_face != null) {
            return this.right_face;
        }
        if (this.left_face != null && this.right_face == null) {
            return this.left_face;
        }
        return null;
    }

    public Vertex get_common_vertex(Edge edge) {
        if (this.start == edge.start || this.start == edge.end) {
            return this.start;
        }
        if (this.end == edge.start || this.end == edge.end) {
            return this.end;
        }
        return null;
    }

    public Vertex get_opposite_vertex(Vertex v) {
        if (this.start == v) {
            return this.end;
        }
        if (this.end == v) {
            return this.start;
        }
        return null;
    }

    public Vector3 get_normal() {
        Vector3 normal = Vector3.add(this.left_face.normal, this.right_face.normal);
        normal.normalize();
        return normal;
    }

    public Vertex mid_vertex() {
        return Vertex.mid_vertex(this.start, this.end);
    }

    public void remove_face(Face p) {
        if (this.left_face == p) {
            this.left_face = null;
        } else if (this.right_face == p) {
            this.right_face = null;
        }
    }

    public Face get_common_face(Edge edge) {
        if (this.left_face != null && (this.left_face == edge.left_face || this.left_face == edge.right_face)) {
            return this.left_face;
        }
        if (this.right_face != null && (this.right_face == edge.left_face || this.right_face == edge.right_face)) {
            return this.right_face;
        }
        return null;
    }

    public double distance_as_line(Vertex v) {
        Vector3 normal = Vector3.normalize(this.vector3());
        return Vector3.cross_product(normal, new Vector3(this.start, v)).length();
    }

    public Edge get_common_edge() {
        Edge parent = this.parent_edge;
        if (parent.child_edges.size() != 2) {
            return null;
        }
        Edge e = (Edge)parent.child_edges.get(0);
        if (e.equals(this) && (e = (Edge)parent.child_edges.get(1)) == null) {
            return null;
        }
        return e;
    }

    public void set_sharp() {
        this.sharp = true;
    }

    public void set_sharp(boolean _sharp) {
        this.sharp = _sharp;
    }

    public boolean on_edge(Vertex v) {
        if (v == this.start || v == this.end) {
            return true;
        }
        Vector3 vec0 = new Vector3(v, this.start);
        Vector3 vec1 = new Vector3(v, this.end);
        return vec0.cos(vec1) < -0.9;
    }

    public void remove() {
        Edge edge;
        int i = 0;
        while (i < this.start.edges.size()) {
            edge = (Edge)this.start.edges.get(i);
            if (edge == this) {
                this.start.edges.remove(this);
            }
            ++i;
        }
        i = 0;
        while (i < this.end.edges.size()) {
            edge = (Edge)this.end.edges.get(i);
            if (edge == this) {
                this.end.edges.remove(this);
            }
            ++i;
        }
    }

    public Edge copy() {
        Edge clone = new Edge();
        clone.start = this.start;
        clone.end = this.end;
        clone.left_face = this.left_face;
        clone.right_face = this.right_face;
        clone.seam = this.seam;
        clone.sharp = this.sharp;
        clone.target_length = this.target_length;
        clone.concave = this.concave;
        clone.index = this.index;
        clone.parent_edge = this.parent_edge;
        clone.child_edges = this.child_edges;
        this.child = clone;
        return clone;
    }

    public void renew_network() {
        this.start = this.start.child;
        this.end = this.end.child;
        if (this.left_face != null) {
            this.left_face = this.left_face.child;
        }
        if (this.right_face != null) {
            this.right_face = this.right_face.child;
        }
    }

    public void move(Vector3 vec) {
        this.start.add(vec);
        this.end.add(vec);
    }
}

