/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import teddy.Delaunay;
import teddy.Edge;
import teddy.Face;
import teddy.Polyhedron;
import teddy.Sort;
import teddy.SurfacePath;
import teddy.Util;
import teddy.Vector3;
import teddy.Vertex;
import teddy.Vertex2D;

public class Cut {
    public static Polyhedron h;

    public static void cut(Polyhedron _h, SurfacePath surfacePath) {
        h = _h;
        Object[] result = Cut.remesh(surfacePath);
        List boundary_edges = (List)result[0];
        List patch_faces = (List)result[1];
        List section_edges = Cut.remesh_section(surfacePath, boundary_edges, patch_faces);
    }

    private static double get_unit_length(SurfacePath surfacePath) {
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        int i = 0;
        while (i < surfacePath.size()) {
            if (surfacePath.onFace(i)) {
                vertices.add(surfacePath.getVertex(i));
            }
            ++i;
        }
        double total_length = 0.0;
        Vertex prev = (Vertex)vertices.get(vertices.size() - 1);
        int i2 = 0;
        while (i2 < vertices.size()) {
            Vertex next = (Vertex)vertices.get(i2);
            total_length += Vertex.distance(prev, next);
            prev = next;
            ++i2;
        }
        if (vertices.size() > 16) {
            return total_length / (double)vertices.size();
        }
        return total_length / 16.0;
    }

    private static List remesh_section(SurfacePath surfacePath, List boundary_edges, List patch_faces) {
        int i = 0;
        while (i < patch_faces.size()) {
            Face face = (Face)patch_faces.get(i);
            h.remove(face);
            ++i;
        }
        Hashtable<Vertex, Edge> section_edges = new Hashtable<Vertex, Edge>();
        Hashtable<Edge, Vector3> cameraLays = new Hashtable<Edge, Vector3>();
        ArrayList<Edge> section_edge_list = new ArrayList<Edge>();
        Enumeration e = surfacePath.crosssection.elements();
        while (e.hasMoreElements()) {
            List vs = (List)e.nextElement();
            Vector3 cameraLay = (Vector3)vs.get(0);
            ArrayList<Vertex> objects = new ArrayList<Vertex>();
            ArrayList<Double> values = new ArrayList<Double>();
            int i2 = 1;
            while (i2 < vs.size()) {
                Vertex v = (Vertex)vs.get(i2);
                objects.add(v);
                values.add(new Double(Vector3.dot_product(cameraLay, v)));
                ++i2;
            }
            vs = Sort.sort(objects, values);
            i2 = 0;
            while (i2 < vs.size()) {
                Vertex v0 = (Vertex)vs.get(i2);
                Vertex v1 = (Vertex)vs.get(i2 + 1);
                Edge edge = new Edge(v0, v1);
                h.add(edge);
                section_edges.put(v0, edge);
                section_edges.put(v1, edge);
                cameraLays.put(edge, cameraLay);
                section_edge_list.add(edge);
                i2 += 2;
            }
        }
        ArrayList<Edge> visited = new ArrayList<Edge>();
        int i3 = 0;
        while (i3 < boundary_edges.size()) {
            Edge edge = (Edge)boundary_edges.get(i3);
            if (!visited.contains(edge)) {
                List loop = new ArrayList<Edge>();
                Vector3 cameraLay = null;
                int index = i3;
                Edge start_edge = edge;
                block5: do {
                    visited.add(edge);
                    loop.add(edge);
                    Vertex next_vertex = edge.end;
                    Edge section_edge = (Edge)section_edges.get(next_vertex);
                    if (section_edge != null) {
                        loop.add(section_edge);
                        cameraLay = (Vector3)cameraLays.get(section_edge);
                        next_vertex = section_edge.get_opposite_vertex(next_vertex);
                        int j = 0;
                        while (j < boundary_edges.size()) {
                            edge = (Edge)boundary_edges.get(j);
                            if (edge.start == next_vertex) {
                                index = j;
                                continue block5;
                            }
                            ++j;
                        }
                    } else {
                        if (++index == boundary_edges.size()) {
                            index = 0;
                        }
                        edge = (Edge)boundary_edges.get(index);
                    }
                } while (edge != start_edge);
                Vector3 x_vec = Vector3.normalize(cameraLay);
                Vector3 y_vec0 = ((Edge)loop.get(0)).vector3();
                Vector3 normal = Vector3.cross_product(y_vec0, x_vec);
                Vector3 y_vec = Vector3.normalize(Vector3.cross_product(normal, x_vec));
                loop = Util.reverse(loop);
                ArrayList<Vertex> loop_vertices = new ArrayList<Vertex>();
                Vertex v = ((Edge)loop.get(0)).get_common_vertex((Edge)loop.get(loop.size() - 1));
                int j = 0;
                while (j < loop.size()) {
                    loop_vertices.add(v);
                    Edge _edge = (Edge)loop.get(j);
                    v = _edge.get_opposite_vertex(v);
                    ++j;
                }
                ArrayList<Vertex2D> loop_vertices2D = new ArrayList<Vertex2D>();
                int j2 = 0;
                while (j2 < loop_vertices.size()) {
                    Vertex v0 = (Vertex)loop_vertices.get(j2);
                    double x = Vector3.dot_product(x_vec, v0);
                    double y = Vector3.dot_product(y_vec, v0);
                    Vertex2D u = new Vertex2D(x, y);
                    loop_vertices2D.add(u);
                    ++j2;
                }
                List[] result = Delaunay.triangulate(loop_vertices2D);
                List delaunay_edges = result[0];
                List delaunay_triangles = result[1];
                ArrayList<Edge> edges = new ArrayList<Edge>();
                int j3 = 0;
                while (j3 < delaunay_edges.size()) {
                    Vertex end;
                    int[] delaunay_edge = (int[])delaunay_edges.get(j3);
                    Vertex start = (Vertex)loop_vertices.get(delaunay_edge[0]);
                    Edge _edge = start.get_common_edge(end = (Vertex)loop_vertices.get(delaunay_edge[1]));
                    if (_edge == null) {
                        _edge = new Edge(start, end);
                        h.add(_edge);
                    }
                    edges.add(_edge);
                    ++j3;
                }
                j3 = 0;
                while (j3 < delaunay_triangles.size()) {
                    int[] delaunay_triangle = (int[])delaunay_triangles.get(j3);
                    Edge edge0 = (Edge)edges.get(delaunay_triangle[0]);
                    Edge edge1 = (Edge)edges.get(delaunay_triangle[1]);
                    Edge edge2 = (Edge)edges.get(delaunay_triangle[2]);
                    h.add(new Face(edge0, edge1, edge2));
                    ++j3;
                }
            }
            ++i3;
        }
        h.set_parameters();
        return section_edge_list;
    }

    public static Object[] remesh(SurfacePath surfacePath) {
        ArrayList<Edge> dead_edges = new ArrayList<Edge>();
        Hashtable vertices_on_edge = new Hashtable();
        int i = 0;
        while (i < surfacePath.size()) {
            if (surfacePath.onEdge(i)) {
                Edge edge = surfacePath.getEdge(i);
                Vertex vertex = surfacePath.getVertex(i);
                List<Vertex> vs = new ArrayList();
                if (vertices_on_edge.containsKey(edge)) {
                    vs = (List)vertices_on_edge.get(edge);
                } else {
                    vertices_on_edge.put(edge, vs);
                    dead_edges.add(edge);
                }
                vs.add(vertex);
            }
            ++i;
        }
        ArrayList<Vertex> fixed_vertices = new ArrayList<Vertex>();
        ArrayList<Face> faces = new ArrayList<Face>();
        Face face = surfacePath.getFace(0);
        ArrayList<Edge> boundary_edges = new ArrayList<Edge>();
        Vertex prev_vertex = surfacePath.getVertex(surfacePath.size() - 1);
        Hashtable edges_on_face = new Hashtable();
        int i2 = 0;
        while (i2 < surfacePath.size()) {
            Vertex vertex = surfacePath.getVertex(i2);
            h.add(vertex);
            Edge edge = new Edge(prev_vertex, vertex);
            h.add(edge);
            List<Edge> vs = new ArrayList();
            if (edges_on_face.containsKey(face)) {
                vs = (List)edges_on_face.get(face);
            } else {
                edges_on_face.put(face, vs);
            }
            vs.add(edge);
            if (surfacePath.onEdge(i2)) {
                face = surfacePath.getEdge(i2).get_opposite_face(face);
                if (!faces.contains(face)) {
                    faces.add(face);
                }
                if (surfacePath.getEdge((int)i2).seam) {
                    fixed_vertices.add(vertex);
                }
            }
            boundary_edges.add(edge);
            prev_vertex = vertex;
            ++i2;
        }
        Enumeration e = vertices_on_edge.keys();
        while (e.hasMoreElements()) {
            Edge edge = (Edge)e.nextElement();
            List vs = (List)vertices_on_edge.get(edge);
            vs = Cut.sort_vertices_on_edge(vs, edge.start);
            vs.add(edge.end);
            prev_vertex = edge.start;
            ArrayList<Edge> newEdges = new ArrayList<Edge>();
            int i3 = 0;
            while (i3 < vs.size()) {
                Vertex next_vertex = (Vertex)vs.get(i3);
                Edge newEdge = new Edge(prev_vertex, next_vertex);
                newEdges.add(newEdge);
                newEdge.seam = edge.seam;
                h.add(newEdge);
                prev_vertex = next_vertex;
                ++i3;
            }
            vertices_on_edge.put(edge, newEdges);
        }
        i = 0;
        while (i < faces.size()) {
            face = (Face)faces.get(i);
            List newEdges = new ArrayList<Edge>();
            int j = 0;
            while (j < 3) {
                Edge edge = face.edges[j];
                if (vertices_on_edge.containsKey(edge)) {
                    List vs = (List)vertices_on_edge.get(edge);
                    if (edge.left_face != face) {
                        vs = Util.reverse(vs);
                    }
                    newEdges = Util.connect(newEdges, vs);
                } else {
                    newEdges.add(edge);
                }
                ++j;
            }
            List possibleEdges = (List)edges_on_face.get(face);
            possibleEdges = Util.connect(possibleEdges, possibleEdges);
            possibleEdges = Util.connect(possibleEdges, newEdges);
            ArrayList<List> loops = new ArrayList<List>();
            ArrayList visited = new ArrayList();
            int j2 = 0;
            while (j2 < newEdges.size()) {
                Edge edge = (Edge)newEdges.get(j2);
                Edge nextEdge = (Edge)newEdges.get(Util.mod(j2 + 1, newEdges.size()));
                if (!visited.contains(edge)) {
                    loops.add(Cut.find_loop(edge, edge.get_common_vertex(nextEdge), face.normal, visited, dead_edges, possibleEdges));
                }
                ++j2;
            }
            j2 = 0;
            while (j2 < loops.size()) {
                List loop = (List)loops.get(j2);
                if (loop.size() == 3) {
                    h.add(new Face((Edge)loop.get(0), (Edge)loop.get(1), (Edge)loop.get(2)));
                } else {
                    Cut.triangulate(loop, face);
                }
                ++j2;
            }
            h.remove(face);
            ++i;
        }
        h.set_parameters();
        ArrayList patch_faces = new ArrayList();
        Edge start_edge = (Edge)boundary_edges.get(0);
        Face start_face = start_edge.right_face;
        Cut.propagate_patch(start_face, start_edge, boundary_edges, patch_faces);
        int i4 = 0;
        while (i4 < fixed_vertices.size()) {
            ((Vertex)fixed_vertices.get((int)i4)).fixed = true;
            ++i4;
        }
        Object[] result = new Object[]{boundary_edges, patch_faces};
        return result;
    }

    static void propagate_patch(Face face, Edge base_edge, List boundary_edges, List patch_faces) {
        Hashtable face_visited = new Hashtable();
        Cut.propagate_patch(face, base_edge, boundary_edges, patch_faces, face_visited);
        System.out.println("patch faces " + patch_faces.size());
    }

    static void propagate_patch(Face face, Edge base_edge, List boundary_edges, List patch_faces, Hashtable face_visited) {
        face_visited.put(face, face);
        patch_faces.add(face);
        int i = 0;
        while (i < 3) {
            Edge edge = face.edges[i];
            if (edge != base_edge && !boundary_edges.contains(edge)) {
                edge.seam = false;
                edge.start.fixed = false;
                edge.end.fixed = false;
                Face next_face = edge.get_opposite_face(face);
                if (next_face != null && face_visited.get(next_face) == null) {
                    Cut.propagate_patch(next_face, edge, boundary_edges, patch_faces, face_visited);
                }
            }
            ++i;
        }
    }

    static List sort_vertices_on_edge(List vs, Vertex base) {
        ArrayList<Double> values = new ArrayList<Double>();
        int i = 0;
        while (i < vs.size()) {
            Vertex v = (Vertex)vs.get(i);
            values.add(new Double(Vertex.distance(base, v)));
            ++i;
        }
        return Sort.sort(vs, values);
    }

    static List find_loop(Edge base_edge, Vertex vertex, Vector3 normal, List visited, List dead_edges, List possibleEdges) {
        ArrayList<Edge> loop = new ArrayList<Edge>();
        Edge edge = base_edge;
        while (true) {
            loop.add(edge);
            visited.add(edge);
            possibleEdges.remove(edge);
            edge = Cut.find_next_edge(edge, vertex, normal, dead_edges, possibleEdges);
            if (edge == base_edge || edge == null) {
                return loop;
            }
            vertex = edge.get_opposite_vertex(vertex);
        }
    }

    static Edge find_next_edge(Edge prev_edge, Vertex vertex, Vector3 normal, List dead_edges, List possibleEdges) {
        Vector3 vec0 = new Vector3(vertex, prev_edge.get_opposite_vertex(vertex));
        double max_angle = 0.0;
        Edge result = null;
        int i = 0;
        while (i < vertex.edges.size()) {
            Vector3 vec1;
            double angle;
            Edge edge = (Edge)vertex.edges.get(i);
            if (edge != prev_edge && !dead_edges.contains(edge) && possibleEdges.contains(edge) && (angle = Vector3.get_angle_360(vec0, vec1 = new Vector3(vertex, edge.get_opposite_vertex(vertex)), normal)) > max_angle) {
                max_angle = angle;
                result = edge;
            }
            ++i;
        }
        return result;
    }

    static void triangulate(List loop, Face face) {
        Vector3 normal = face.normal;
        Vector3 y_axis = new Vector3(normal.y, normal.z, normal.x);
        Vector3 x_axis = Vector3.cross_product(y_axis, normal);
        y_axis = Vector3.cross_product(normal, x_axis);
        x_axis.normalize();
        y_axis.normalize();
        Edge prev_edge = (Edge)loop.get(loop.size() - 1);
        ArrayList<Vertex> vertices3D = new ArrayList<Vertex>();
        ArrayList<Vertex2D> vertices2D = new ArrayList<Vertex2D>();
        int i = 0;
        while (i < loop.size()) {
            Edge next_edge = (Edge)loop.get(i);
            Vertex vertex = prev_edge.get_common_vertex(next_edge);
            vertices3D.add(vertex);
            Vertex2D v = new Vertex2D(Vector3.dot_product(x_axis, vertex), Vector3.dot_product(y_axis, vertex));
            v.index = i++;
            vertices2D.add(v);
            prev_edge = next_edge;
        }
        List[] delaunay_result = Delaunay.triangulate(vertices2D);
        List delaunay_edges = delaunay_result[0];
        List delaunay_triangles = delaunay_result[1];
        ArrayList<Edge> edges = new ArrayList<Edge>();
        int i2 = 0;
        while (i2 < delaunay_edges.size()) {
            Vertex end;
            int[] delaunay_edge = (int[])delaunay_edges.get(i2);
            Vertex start = (Vertex)vertices3D.get(delaunay_edge[0]);
            Edge edge = start.get_common_edge(end = (Vertex)vertices3D.get(delaunay_edge[1]));
            if (edge == null) {
                edge = new Edge(start, end);
                h.add(edge);
            }
            edges.add(edge);
            ++i2;
        }
        i2 = 0;
        while (i2 < delaunay_triangles.size()) {
            int[] delaunay_triangle = (int[])delaunay_triangles.get(i2);
            Edge edge0 = (Edge)edges.get(delaunay_triangle[0]);
            Edge edge1 = (Edge)edges.get(delaunay_triangle[1]);
            Edge edge2 = (Edge)edges.get(delaunay_triangle[2]);
            h.add(new Face(edge0, edge1, edge2));
            ++i2;
        }
    }

    public static void cut_for_seam(Polyhedron _h, SurfacePath surfacePath) {
        h = _h;
        Object[] result = Cut.remesh_for_seam(surfacePath);
    }

    public static Object[] remesh_for_seam(SurfacePath surfacePath) {
        ArrayList<Edge> dead_edges = new ArrayList<Edge>();
        Hashtable vertices_on_edge = new Hashtable();
        int i = 0;
        while (i < surfacePath.size()) {
            if (surfacePath.onEdge(i)) {
                Edge edge = surfacePath.getEdge(i);
                Vertex vertex = surfacePath.getVertex(i);
                List<Vertex> vs = new ArrayList();
                if (vertices_on_edge.containsKey(edge)) {
                    vs = (List)vertices_on_edge.get(edge);
                } else {
                    vertices_on_edge.put(edge, vs);
                    dead_edges.add(edge);
                }
                vs.add(vertex);
            }
            ++i;
        }
        ArrayList<Vertex> fixed_vertices = new ArrayList<Vertex>();
        ArrayList<Face> faces = new ArrayList<Face>();
        Face face = surfacePath.getFace(0);
        ArrayList<Edge> boundary_edges = new ArrayList<Edge>();
        Vertex prev_vertex = surfacePath.getVertex(0);
        Hashtable edges_on_face = new Hashtable();
        int i2 = 1;
        while (i2 < surfacePath.size()) {
            Vertex vertex = surfacePath.getVertex(i2);
            h.add(vertex);
            Edge edge = new Edge(prev_vertex, vertex);
            h.add(edge);
            List<Edge> vs = new ArrayList();
            if (edges_on_face.containsKey(face)) {
                vs = (List)edges_on_face.get(face);
            } else {
                edges_on_face.put(face, vs);
            }
            vs.add(edge);
            if (surfacePath.onEdge(i2)) {
                face = surfacePath.getEdge(i2).get_opposite_face(face);
                if (!faces.contains(face)) {
                    faces.add(face);
                }
                if (surfacePath.getEdge((int)i2).seam) {
                    fixed_vertices.add(vertex);
                }
            }
            boundary_edges.add(edge);
            prev_vertex = vertex;
            ++i2;
        }
        Enumeration e = vertices_on_edge.keys();
        while (e.hasMoreElements()) {
            Edge edge = (Edge)e.nextElement();
            List vs = (List)vertices_on_edge.get(edge);
            vs = Cut.sort_vertices_on_edge(vs, edge.start);
            vs.add(edge.end);
            prev_vertex = edge.start;
            ArrayList<Edge> newEdges = new ArrayList<Edge>();
            int i3 = 0;
            while (i3 < vs.size()) {
                Vertex next_vertex = (Vertex)vs.get(i3);
                Edge newEdge = new Edge(prev_vertex, next_vertex);
                newEdges.add(newEdge);
                newEdge.seam = edge.seam;
                h.add(newEdge);
                prev_vertex = next_vertex;
                ++i3;
            }
            vertices_on_edge.put(edge, newEdges);
        }
        i = 0;
        while (i < faces.size()) {
            face = (Face)faces.get(i);
            List newEdges = new ArrayList<Edge>();
            int j = 0;
            while (j < 3) {
                Edge edge = face.edges[j];
                if (vertices_on_edge.containsKey(edge)) {
                    List vs = (List)vertices_on_edge.get(edge);
                    if (edge.left_face != face) {
                        vs = Util.reverse(vs);
                    }
                    newEdges = Util.connect(newEdges, vs);
                } else {
                    newEdges.add(edge);
                }
                ++j;
            }
            List possibleEdges = (List)edges_on_face.get(face);
            System.out.println("possibleEdges" + possibleEdges);
            if (possibleEdges != null) {
                ArrayList<List> loops = new ArrayList<List>();
                ArrayList visited = new ArrayList();
                int j2 = 0;
                while (j2 < newEdges.size()) {
                    Edge edge = (Edge)newEdges.get(j2);
                    Edge nextEdge = (Edge)newEdges.get(Util.mod(j2 + 1, newEdges.size()));
                    if (!visited.contains(edge)) {
                        loops.add(Cut.find_loop(edge, edge.get_common_vertex(nextEdge), face.normal, visited, dead_edges, possibleEdges));
                    }
                    ++j2;
                }
                j2 = 0;
                while (j2 < loops.size()) {
                    List loop = (List)loops.get(j2);
                    if (loop.size() == 3) {
                        Edge loop0 = (Edge)loop.get(0);
                        Edge loop1 = (Edge)loop.get(1);
                        Edge loop2 = (Edge)loop.get(2);
                        h.add(new Face((Edge)loop.get(0), (Edge)loop.get(1), (Edge)loop.get(2)));
                    } else if (loop.size() > 3) {
                        Cut.triangulate(loop, face);
                    }
                    ++j2;
                }
            }
            h.remove(face);
            ++i;
        }
        h.set_parameters();
        ArrayList patch_faces = new ArrayList();
        Object[] result = new Object[]{boundary_edges, patch_faces};
        return result;
    }

    public static Object[] remesh_no_loop(SurfacePath surfacePath) {
        ArrayList<Edge> dead_edges = new ArrayList<Edge>();
        Hashtable vertices_on_edge = new Hashtable();
        int i = 0;
        while (i < surfacePath.size()) {
            if (surfacePath.onEdge(i)) {
                Edge edge = surfacePath.getEdge(i);
                Vertex vertex = surfacePath.getVertex(i);
                List<Vertex> vs = new ArrayList();
                if (vertices_on_edge.containsKey(edge)) {
                    vs = (List)vertices_on_edge.get(edge);
                } else {
                    vertices_on_edge.put(edge, vs);
                    dead_edges.add(edge);
                }
                vs.add(vertex);
            }
            ++i;
        }
        ArrayList<Vertex> fixed_vertices = new ArrayList<Vertex>();
        ArrayList<Face> faces = new ArrayList<Face>();
        Face face = surfacePath.getFace(0);
        ArrayList<Edge> boundary_edges = new ArrayList<Edge>();
        Vertex prev_vertex = surfacePath.getVertex(0);
        faces.add(face);
        h.add(prev_vertex);
        Hashtable edges_on_polygon = new Hashtable();
        int i2 = 1;
        while (i2 < surfacePath.size()) {
            Vertex vertex = surfacePath.getVertex(i2);
            h.add(vertex);
            Edge edge = new Edge(prev_vertex, vertex);
            h.add(edge);
            List<Edge> vs = new ArrayList();
            if (edges_on_polygon.containsKey(face)) {
                vs = (List)edges_on_polygon.get(face);
            } else {
                edges_on_polygon.put(face, vs);
            }
            vs.add(edge);
            if (surfacePath.onEdge(i2)) {
                face = surfacePath.getEdge(i2).get_opposite_face(face);
                if (!faces.contains(face)) {
                    faces.add(face);
                }
                if (surfacePath.getEdge((int)i2).seam) {
                    fixed_vertices.add(vertex);
                }
            }
            boundary_edges.add(edge);
            prev_vertex = vertex;
            ++i2;
        }
        Enumeration e = vertices_on_edge.keys();
        while (e.hasMoreElements()) {
            Edge edge = (Edge)e.nextElement();
            List vs = (List)vertices_on_edge.get(edge);
            vs = Cut.sort_vertices_on_edge(vs, edge.start);
            vs.add(edge.end);
            prev_vertex = edge.start;
            ArrayList<Edge> newEdges = new ArrayList<Edge>();
            int i3 = 0;
            while (i3 < vs.size()) {
                Vertex next_vertex = (Vertex)vs.get(i3);
                Edge newEdge = new Edge(prev_vertex, next_vertex);
                newEdges.add(newEdge);
                newEdge.seam = edge.seam;
                newEdge.sharp = edge.sharp;
                h.add(newEdge);
                prev_vertex = next_vertex;
                ++i3;
            }
            vertices_on_edge.put(edge, newEdges);
        }
        i = 0;
        while (i < faces.size()) {
            face = (Face)faces.get(i);
            List newEdges = new ArrayList<Edge>();
            int j = 0;
            while (j < 3) {
                Edge edge = face.edges[j];
                if (vertices_on_edge.containsKey(edge)) {
                    List vs = (List)vertices_on_edge.get(edge);
                    if (edge.left_face != face) {
                        vs = Util.reverse(vs);
                    }
                    newEdges = Util.connect(newEdges, vs);
                } else {
                    newEdges.add(edge);
                }
                ++j;
            }
            List possibleEdges = (List)edges_on_polygon.get(face);
            ArrayList<List> loops = new ArrayList<List>();
            ArrayList visited = new ArrayList();
            int j2 = 0;
            while (j2 < newEdges.size()) {
                Edge edge = (Edge)newEdges.get(j2);
                Edge nextEdge = (Edge)newEdges.get(Util.mod(j2 + 1, newEdges.size()));
                if (!visited.contains(edge)) {
                    loops.add(Cut.find_loop(edge, edge.get_common_vertex(nextEdge), face.normal, visited, dead_edges, possibleEdges, newEdges));
                }
                ++j2;
            }
            j2 = 0;
            while (j2 < loops.size()) {
                List loop = (List)loops.get(j2);
                if (loop.size() == 3) {
                    h.add(new Face((Edge)loop.get(0), (Edge)loop.get(1), (Edge)loop.get(2), face.patch));
                } else {
                    Cut.triangulate(loop, face);
                }
                ++j2;
            }
            h.remove(face);
            ++i;
        }
        h.set_parameters();
        ArrayList patch_polygons = new ArrayList();
        Object[] result = new Object[]{boundary_edges, patch_polygons};
        return result;
    }

    static List find_loop(Edge base_edge, Vertex vertex, Vector3 normal, List visited, List dead_edges, List possibleEdges, List outside_edges) {
        ArrayList<Edge> loop = new ArrayList<Edge>();
        Edge edge = base_edge;
        while (true) {
            loop.add(edge);
            visited.add(edge);
            possibleEdges.remove(edge);
            edge = Cut.find_next_edge(edge, vertex, normal, dead_edges, possibleEdges, outside_edges);
            if (edge == base_edge || edge == null) {
                return loop;
            }
            vertex = edge.get_opposite_vertex(vertex);
        }
    }

    static Edge find_next_edge(Edge prev_edge, Vertex vertex, Vector3 normal, List dead_edges, List possibleEdges, List outside_edges) {
        ArrayList<Edge> outlets = new ArrayList<Edge>();
        int i = 0;
        while (i < vertex.edges.size()) {
            Edge edge = (Edge)vertex.edges.get(i);
            if (edge != prev_edge && !dead_edges.contains(edge) && possibleEdges.contains(edge)) {
                outlets.add(edge);
            }
            ++i;
        }
        if (outlets.size() == 0 && possibleEdges.contains(prev_edge)) {
            return prev_edge;
        }
        if (outlets.size() == 0) {
            return null;
        }
        if (outlets.size() == 1) {
            return (Edge)outlets.get(0);
        }
        if (outlets.size() > 2) {
            System.out.println("too many outlets in Pop.find_next_edge");
        }
        Edge edge0 = (Edge)outlets.get(0);
        Edge edge1 = (Edge)outlets.get(1);
        if (outside_edges.contains(prev_edge)) {
            if (outside_edges.contains(edge0)) {
                return edge1;
            }
            return edge0;
        }
        if (outside_edges.indexOf(edge1) == Util.mod(outside_edges.indexOf(edge0) + 1, outside_edges.size())) {
            return edge1;
        }
        return edge0;
    }
}

