/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.util.ArrayList;
import java.util.List;
import teddy.Vertex;

public class CleanStroke3D {
    public static List resample(List stroke) {
        int n = stroke.size() - 1;
        stroke = CleanStroke3D.resample(stroke, n);
        return stroke;
    }

    public static List resample_loop(List stroke, int n) {
        stroke.add(stroke.get(stroke.size() - 1));
        stroke = CleanStroke3D.resample(stroke, n);
        stroke.remove(stroke.size() - 1);
        return stroke;
    }

    public static List resample_by_length_loop(List stroke, double unit_length) {
        stroke.add(stroke.get(stroke.size() - 1));
        double length = CleanStroke3D.get_length(stroke);
        int n = 1 + (int)(length / unit_length);
        List resampled = CleanStroke3D.resample_by_number(stroke, n);
        resampled.remove(resampled.size() - 1);
        stroke.remove(stroke.size() - 1);
        return resampled;
    }

    public static List resample(List stroke, int n) {
        if (stroke.size() <= 1) {
            return stroke;
        }
        double length = CleanStroke3D.get_length(stroke);
        double unit = length / (double)n;
        Vertex v0 = (Vertex)stroke.get(0);
        Vertex v1 = (Vertex)stroke.get(stroke.size() - 1);
        ArrayList<Vertex> resampled = new ArrayList<Vertex>();
        resampled.add(v0);
        double total = 0.0;
        double prev_total = 0.0;
        Vertex prev = v0;
        double next_spot = unit;
        int count = 0;
        for (int index = 1; index != stroke.size(); ++index) {
            Vertex next = (Vertex)stroke.get(index);
            total += Vertex.distance(prev, next);
            while (total >= next_spot) {
                Vertex new_vertex = Vertex.interpolate(prev, next, (next_spot - prev_total) / (total - prev_total));
                resampled.add(new_vertex);
                next_spot += unit;
                if (++count == n - 1) break;
            }
            if (count == n - 1) break;
            prev = next;
            prev_total = total;
        }
        resampled.add(v1);
        return resampled;
    }

    public static List resample_by_length_with_fixes_loop(List stroke, double unit_length) {
        stroke.add(stroke.get(stroke.size() - 1));
        List resampled = CleanStroke3D.resample_by_length_with_fixes(stroke, unit_length);
        resampled.remove(resampled.size() - 1);
        stroke.remove(stroke.size() - 1);
        return resampled;
    }

    public static List resample_by_length_with_fixes(List stroke, double unit_length) {
        if (stroke.size() <= 1) {
            return stroke;
        }
        ArrayList<Vertex> resampled = new ArrayList<Vertex>();
        resampled.add((Vertex)stroke.get(0));
        int index0 = 0;
        while (true) {
            int index1 = CleanStroke3D.find_next_fixed_vertex(stroke, index0);
            resampled.addAll(CleanStroke3D.resample_by_length_sub(stroke, index0, index1, unit_length));
            if (index1 == stroke.size() - 1) break;
            index0 = index1;
        }
        return resampled;
    }

    private static int find_next_fixed_vertex(List stroke, int index) {
        int i = index + 1;
        while (i < stroke.size()) {
            if (((Vertex)stroke.get((int)i)).fixed) {
                System.out.println(" " + i + " " + stroke.size());
                return i;
            }
            ++i;
        }
        return stroke.size() - 1;
    }

    public static List resample_by_length_sub(List stroke, int start_index, int end_index, double unit_length) {
        double length = CleanStroke3D.get_length(stroke, start_index, end_index);
        int n = 1 + (int)(length / unit_length);
        Vertex v0 = (Vertex)stroke.get(start_index);
        Vertex v1 = (Vertex)stroke.get(end_index);
        ArrayList<Vertex> resampled = new ArrayList<Vertex>();
        if (length < unit_length) {
            resampled.add(v1);
            return resampled;
        }
        double total = 0.0;
        double prev_total = 0.0;
        Vertex prev = v0;
        double next_spot = unit_length;
        int index = start_index + 1;
        int count = 0;
        do {
            Vertex next = (Vertex)stroke.get(index);
            total += Vertex.distance(prev, next);
            while (total >= next_spot) {
                Vertex new_vertex = Vertex.interpolate(prev, next, (next_spot - prev_total) / (total - prev_total));
                resampled.add(new_vertex);
                next_spot += unit_length;
                if (++count == n - 1) break;
            }
            if (count == n - 1) break;
            prev = next;
            prev_total = total;
        } while (++index != end_index);
        resampled.add(v1);
        return resampled;
    }

    public static List resample_by_number(List stroke, int n) {
        if (stroke.size() <= 1) {
            return stroke;
        }
        double length = CleanStroke3D.get_length(stroke);
        double unit = length / (double)n;
        Vertex v0 = (Vertex)stroke.get(0);
        Vertex v1 = (Vertex)stroke.get(stroke.size() - 1);
        ArrayList<Vertex> resampled = new ArrayList<Vertex>();
        resampled.add(v0);
        double total = 0.0;
        double prev_total = 0.0;
        Vertex prev = v0;
        double next_spot = unit;
        int count = 0;
        for (int index = 1; index != stroke.size(); ++index) {
            Vertex next = (Vertex)stroke.get(index);
            total += Vertex.distance(prev, next);
            while (total >= next_spot) {
                Vertex new_vertex = Vertex.interpolate(prev, next, (next_spot - prev_total) / (total - prev_total));
                resampled.add(new_vertex);
                next_spot += unit;
                if (++count == n - 1) break;
            }
            if (count == n - 1) break;
            prev = next;
            prev_total = total;
        }
        resampled.add(v1);
        return resampled;
    }

    public static double get_length(List stroke) {
        double length = 0.0;
        int i = 0;
        while (i < stroke.size() - 1) {
            Vertex p = (Vertex)stroke.get(i);
            Vertex q = (Vertex)stroke.get(i + 1);
            length += Vertex.distance(p, q);
            ++i;
        }
        return length;
    }

    public static double get_length(List stroke, int start_index, int end_index) {
        double length = 0.0;
        int i = start_index;
        while (i < end_index) {
            Vertex p = (Vertex)stroke.get(i);
            Vertex q = (Vertex)stroke.get(i + 1);
            length += Vertex.distance(p, q);
            ++i;
        }
        return length;
    }
}

