/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import VisualNumerics.math.DoubleMatrix;
import java.util.ArrayList;
import java.util.List;
import teddy.ConjugateGradient;
import teddy.Edge;
import teddy.Polyhedron;
import teddy.Vector2;
import teddy.Vector3;
import teddy.Vertex;

public class BoundarySmooth {
    public static void smooth(Polyhedron h, List internal_vertices, List boundary_vertices) {
        ArrayList Ms = new ArrayList();
        double[] Hi = BoundarySmooth.compute_curvatures(internal_vertices, Ms);
        double[] Hb = BoundarySmooth.compute_curvatures(boundary_vertices, null);
        double[] Hi_new = BoundarySmooth.update_curvatures(Hi, Hb, internal_vertices, boundary_vertices);
        BoundarySmooth.update_vertices(Hi_new, internal_vertices, Hi, Ms);
    }

    public static Vector3 compute_normal(Vertex v) {
        Vector3 normal = new Vector3();
        List edges = v.get_edges_sorted_clockwise((Edge)v.edges.get(0));
        Edge edge = (Edge)edges.get(edges.size() - 1);
        Vector3 vec0 = new Vector3(v, edge.get_opposite_vertex(v));
        int i = 0;
        while (i < edges.size()) {
            edge = (Edge)edges.get(i);
            Vector3 vec1 = new Vector3(v, edge.get_opposite_vertex(v));
            normal.add(Vector3.cross_product(vec0, vec1));
            vec0 = vec1;
            ++i;
        }
        normal.normalize();
        return normal;
    }

    public static double[] compute_curvatures(List vertices, List Ms) {
        double[] H = new double[vertices.size()];
        int i = 0;
        while (i < vertices.size()) {
            H[i] = BoundarySmooth.compute_curvature((Vertex)vertices.get(i), Ms);
            ++i;
        }
        return H;
    }

    public static double compute_curvature(Vertex v, List Ms) {
        v.normal = BoundarySmooth.compute_normal(v);
        List vs = v.get_surrounding_vertices();
        double[][] A = new double[vs.size()][3];
        double[] b = new double[vs.size()];
        int i = 0;
        while (i < vs.size()) {
            Vertex u = (Vertex)vs.get(i);
            Vector3 vec = new Vector3(v, u);
            Vector3 n = v.normal;
            Vector3 b0 = new Vector3(n.y - n.z, n.z - n.x, n.x - n.y);
            b0.normalize();
            Vector3 b1 = Vector3.cross_product(n, b0);
            b1.normalize();
            Vector2 t = new Vector2(Vector3.dot_product(b0, vec), Vector3.dot_product(b1, vec));
            t.normalize();
            A[i][0] = t.x * t.x;
            A[i][1] = t.x * t.y;
            A[i][2] = t.y * t.y;
            b[i] = 2.0 * (Vector3.dot_product(vec, n) / Vector3.dot_product(vec, vec));
            if (Double.isNaN(b[i])) {
                System.out.println("isNaN " + vec.length());
            }
            ++i;
        }
        double[][] At = DoubleMatrix.transpose((double[][])A);
        double[][] AtA = DoubleMatrix.multiply((double[][])At, (double[][])A);
        try {
            AtA = DoubleMatrix.inverse((double[][])AtA);
        }
        catch (Exception e) {
            System.out.println("" + e);
        }
        double[][] M = DoubleMatrix.multiply((double[][])AtA, (double[][])At);
        double[] x = DoubleMatrix.multiply((double[][])M, (double[])b);
        if (Ms != null) {
            Ms.add(M);
        }
        return (x[0] + x[2]) / 2.0;
    }

    public static double[] update_curvatures(double[] Hi, double[] Hb, List internal_vertices, List boundary_vertices) {
        int n = internal_vertices.size();
        double[][] S = new double[n][n];
        double[] b = new double[n];
        int i = 0;
        while (i < n) {
            double cot;
            Vertex u;
            Edge edge;
            Vertex v = (Vertex)internal_vertices.get(i);
            int j = 0;
            while (j < n) {
                if (j != i && (edge = v.get_common_edge(u = (Vertex)internal_vertices.get(j))) != null) {
                    cot = BoundarySmooth.cot(edge);
                    double[] dArray = S[i];
                    int n2 = i;
                    dArray[n2] = dArray[n2] + cot;
                    S[i][j] = -cot;
                }
                ++j;
            }
            j = 0;
            while (j < boundary_vertices.size()) {
                u = (Vertex)boundary_vertices.get(j);
                edge = v.get_common_edge(u);
                if (edge != null) {
                    cot = BoundarySmooth.cot(edge);
                    int n3 = i;
                    b[n3] = b[n3] + cot * Hb[j];
                    double[] dArray = S[i];
                    int n4 = i;
                    dArray[n4] = dArray[n4] + cot;
                }
                ++j;
            }
            ++i;
        }
        double[] Hi_new = ConjugateGradient.solve(S, b, Hi);
        return Hi_new;
    }

    public static double _cot(Edge edge) {
        return 1.0;
    }

    public static double cot(Edge edge) {
        Vertex v0 = edge.left_face.get_opposite_vertex(edge);
        Vertex v1 = edge.right_face.get_opposite_vertex(edge);
        return BoundarySmooth.cot(new Vector3(v0, edge.start), new Vector3(v0, edge.end)) + BoundarySmooth.cot(new Vector3(v1, edge.start), new Vector3(v1, edge.end));
    }

    public static double cot(Vector3 v, Vector3 u) {
        return Vector3.dot_product(v, u) / Vector3.cross_product(v, u).length();
    }

    public static void update_vertices(double[] Hi_new, List internal_vertices, double[] Hi_old, List Ms) {
        Vertex v;
        Vector3[] translations = new Vector3[internal_vertices.size()];
        int i = 0;
        while (i < internal_vertices.size()) {
            v = (Vertex)internal_vertices.get(i);
            double[][] M = (double[][])Ms.get(i);
            List vs = v.get_surrounding_vertices();
            double[] bi = new double[vs.size()];
            Vertex centroid = new Vertex();
            int j = 0;
            while (j < vs.size()) {
                Vertex u = (Vertex)vs.get(j);
                Vector3 vec = new Vector3(v, u);
                bi[j] = -2.0 / Vector3.dot_product(vec, vec);
                centroid.add(u);
                ++j;
            }
            double[] Mbi = DoubleMatrix.multiply((double[][])M, (double[])bi);
            double dH = (Mbi[0] + Mbi[2]) / 2.0;
            double t = (Hi_new[i] - Hi_old[i]) / dH;
            translations[i] = Vector3.multiply(v.normal, t);
            centroid.multiply(1.0 / (double)vs.size());
            Vector3 laplacian = new Vector3(v, centroid);
            Vector3 in_plane_displacement = Vector3.subtract(laplacian, Vector3.multiply(v.normal, Vector3.dot_product(laplacian, v.normal)));
            translations[i].add(in_plane_displacement);
            ++i;
        }
        i = 0;
        while (i < internal_vertices.size()) {
            v = (Vertex)internal_vertices.get(i);
            v.add(translations[i]);
            ++i;
        }
    }
}

