/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import teddy.Face;
import teddy.Polyhedron;
import teddy.Vector2;
import teddy.Vertex;
import teddy.Vertex2D;

public class AdjustPatchScale {
    public static void adjust(Polyhedron mesh) {
        double total_area = 0.0;
        double total_flattened_area = 0.0;
        int i = 0;
        while (i < mesh.faces.size()) {
            Face face = (Face)mesh.faces.get(i);
            total_area += face.get_area();
            total_flattened_area += AdjustPatchScale.get_flattened_area(face);
            ++i;
        }
        double scale = Math.sqrt(total_area / total_flattened_area);
        int i2 = 0;
        while (i2 < mesh.vertices.size()) {
            Vertex v = (Vertex)mesh.vertices.get(i2);
            v.u *= scale;
            v.v *= scale;
            v.setTextureCoord(v.u, v.v);
            ++i2;
        }
    }

    public static double get_flattened_area(Face face) {
        Vertex2D v0 = new Vertex2D(face.get_vertex((int)0).u, face.get_vertex((int)0).v);
        Vertex2D v1 = new Vertex2D(face.get_vertex((int)1).u, face.get_vertex((int)1).v);
        Vertex2D v2 = new Vertex2D(face.get_vertex((int)2).u, face.get_vertex((int)2).v);
        return Math.abs(Vector2.cross_product(new Vector2(v0, v1), new Vector2(v0, v2))) / 2.0;
    }
}

